/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DSA;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.ECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECGOST3410Signer
implements DSA {
    ECKeyParameters a;
    SecureRandom b;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
                this.b = parametersWithRandom.getRandom();
                this.a = (ECPrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                this.b = CryptoServicesRegistrar.getSecureRandom();
                this.a = (ECPrivateKeyParameters)param;
            }
        } else {
            this.a = (ECPublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger bigInteger;
        ECPoint eCPoint;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        byte[] byArray = new byte[message.length];
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            byArray[i2] = message[byArray.length - 1 - i2];
        }
        BigInteger bigInteger4 = new BigInteger(1, byArray);
        ECDomainParameters eCDomainParameters = this.a.getParameters();
        BigInteger bigInteger5 = eCDomainParameters.getN();
        BigInteger bigInteger6 = ((ECPrivateKeyParameters)this.a).getD();
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        while ((bigInteger3 = new BigInteger(bigInteger5.bitLength(), this.b)).equals(ECConstants.ZERO) || (bigInteger2 = (eCPoint = eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger3).normalize()).getAffineXCoord().toBigInteger().mod(bigInteger5)).equals(ECConstants.ZERO) || (bigInteger = bigInteger3.multiply(bigInteger4).add(bigInteger6.multiply(bigInteger2)).mod(bigInteger5)).equals(ECConstants.ZERO)) {
        }
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r2, BigInteger s2) {
        ECPoint eCPoint;
        byte[] byArray = new byte[message.length];
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            byArray[i2] = message[byArray.length - 1 - i2];
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = this.a.getParameters().getN();
        if (r2.compareTo(ECConstants.ONE) < 0 || r2.compareTo(bigInteger2) >= 0) {
            return false;
        }
        if (s2.compareTo(ECConstants.ONE) < 0 || s2.compareTo(bigInteger2) >= 0) {
            return false;
        }
        BigInteger bigInteger3 = bigInteger.modInverse(bigInteger2);
        BigInteger bigInteger4 = s2.multiply(bigInteger3).mod(bigInteger2);
        BigInteger bigInteger5 = bigInteger2.subtract(r2).multiply(bigInteger3).mod(bigInteger2);
        ECPoint eCPoint2 = this.a.getParameters().getG();
        ECPoint eCPoint3 = ECAlgorithms.sumOfTwoMultiplies(eCPoint2, bigInteger4, eCPoint = ((ECPublicKeyParameters)this.a).getQ(), bigInteger5).normalize();
        if (eCPoint3.isInfinity()) {
            return false;
        }
        BigInteger bigInteger6 = eCPoint3.getAffineXCoord().toBigInteger().mod(bigInteger2);
        return bigInteger6.equals(r2);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

