/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.crypto.AsymmetricBlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoException;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.Signer;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.util.Arrays;

public class GenericSigner
implements Signer {
    private final AsymmetricBlockCipher a;
    private final Digest b;
    private boolean c;

    public GenericSigner(AsymmetricBlockCipher engine, Digest digest) {
        this.a = engine;
        this.b = digest;
    }

    @Override
    public void init(boolean forSigning, CipherParameters parameters) {
        this.c = forSigning;
        AsymmetricKeyParameter asymmetricKeyParameter = parameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)parameters).getParameters() : (AsymmetricKeyParameter)parameters;
        if (forSigning && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("signing requires private key");
        }
        if (!forSigning && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("verification requires public key");
        }
        this.reset();
        this.a.init(forSigning, parameters);
    }

    @Override
    public void update(byte input) {
        this.b.update(input);
    }

    @Override
    public void update(byte[] input, int inOff, int length) {
        this.b.update(input, inOff, length);
    }

    @Override
    public byte[] generateSignature() throws CryptoException, DataLengthException {
        if (!this.c) {
            throw new IllegalStateException("GenericSigner not initialised for signature generation.");
        }
        byte[] byArray = new byte[this.b.getDigestSize()];
        this.b.doFinal(byArray, 0);
        return this.a.processBlock(byArray, 0, byArray.length);
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        if (this.c) {
            throw new IllegalStateException("GenericSigner not initialised for verification");
        }
        byte[] byArray = new byte[this.b.getDigestSize()];
        this.b.doFinal(byArray, 0);
        try {
            byte[] byArray2 = this.a.processBlock(signature, 0, signature.length);
            if (byArray2.length < byArray.length) {
                byte[] byArray3 = new byte[byArray.length];
                System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
                byArray2 = byArray3;
            }
            return Arrays.constantTimeAreEqual(byArray2, byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void reset() {
        this.b.reset();
    }
}

