/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.crypto.AsymmetricBlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoException;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.Signer;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.params.RSABlindingParameters;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import java.security.SecureRandom;

public class PSSSigner
implements Signer {
    public static final byte TRAILER_IMPLICIT = -68;
    private Digest a;
    private Digest b;
    private AsymmetricBlockCipher c;
    private SecureRandom d;
    private int e;
    private int f;
    private boolean g;
    private int h;
    private int i;
    private byte[] j;
    private byte[] k;
    private byte[] l;
    private byte m;

    public PSSSigner(AsymmetricBlockCipher cipher, Digest digest, int sLen) {
        this(cipher, digest, sLen, -68);
    }

    public PSSSigner(AsymmetricBlockCipher cipher, Digest contentDigest, Digest mgfDigest, int sLen) {
        this(cipher, contentDigest, mgfDigest, sLen, -68);
    }

    public PSSSigner(AsymmetricBlockCipher cipher, Digest digest, int sLen, byte trailer) {
        this(cipher, digest, digest, sLen, trailer);
    }

    public PSSSigner(AsymmetricBlockCipher cipher, Digest contentDigest, Digest mgfDigest, int sLen, byte trailer) {
        this.c = cipher;
        this.a = contentDigest;
        this.b = mgfDigest;
        this.e = contentDigest.getDigestSize();
        this.f = mgfDigest.getDigestSize();
        this.g = false;
        this.h = sLen;
        this.j = new byte[sLen];
        this.k = new byte[8 + sLen + this.e];
        this.m = trailer;
    }

    public PSSSigner(AsymmetricBlockCipher cipher, Digest digest, byte[] salt) {
        this(cipher, digest, digest, salt, -68);
    }

    public PSSSigner(AsymmetricBlockCipher cipher, Digest contentDigest, Digest mgfDigest, byte[] salt) {
        this(cipher, contentDigest, mgfDigest, salt, -68);
    }

    public PSSSigner(AsymmetricBlockCipher cipher, Digest contentDigest, Digest mgfDigest, byte[] salt, byte trailer) {
        this.c = cipher;
        this.a = contentDigest;
        this.b = mgfDigest;
        this.e = contentDigest.getDigestSize();
        this.f = mgfDigest.getDigestSize();
        this.g = true;
        this.h = salt.length;
        this.j = salt;
        this.k = new byte[8 + this.h + this.e];
        this.m = trailer;
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        CipherParameters cipherParameters;
        CipherParameters cipherParameters2;
        if (param instanceof ParametersWithRandom) {
            cipherParameters2 = (ParametersWithRandom)param;
            cipherParameters = ((ParametersWithRandom)cipherParameters2).getParameters();
            this.d = ((ParametersWithRandom)cipherParameters2).getRandom();
        } else {
            cipherParameters = param;
            if (forSigning) {
                this.d = CryptoServicesRegistrar.getSecureRandom();
            }
        }
        if (cipherParameters instanceof RSABlindingParameters) {
            cipherParameters2 = ((RSABlindingParameters)cipherParameters).getPublicKey();
            this.c.init(forSigning, param);
        } else {
            cipherParameters2 = (RSAKeyParameters)cipherParameters;
            this.c.init(forSigning, cipherParameters);
        }
        this.i = ((RSAKeyParameters)cipherParameters2).getModulus().bitLength() - 1;
        if (this.i < 8 * this.e + 8 * this.h + 9) {
            throw new IllegalArgumentException("key too small for specified hash and salt lengths");
        }
        this.l = new byte[(this.i + 7) / 8];
        this.reset();
    }

    private void a(byte[] byArray) {
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            byArray[i2] = 0;
        }
    }

    @Override
    public void update(byte b2) {
        this.a.update(b2);
    }

    @Override
    public void update(byte[] in, int off, int len) {
        this.a.update(in, off, len);
    }

    @Override
    public void reset() {
        this.a.reset();
    }

    @Override
    public byte[] generateSignature() throws CryptoException, DataLengthException {
        this.a.doFinal(this.k, this.k.length - this.e - this.h);
        if (this.h != 0) {
            if (!this.g) {
                this.d.nextBytes(this.j);
            }
            System.arraycopy(this.j, 0, this.k, this.k.length - this.h, this.h);
        }
        byte[] byArray = new byte[this.e];
        this.a.update(this.k, 0, this.k.length);
        this.a.doFinal(byArray, 0);
        this.l[this.l.length - this.h - 1 - this.e - 1] = 1;
        System.arraycopy(this.j, 0, this.l, this.l.length - this.h - this.e - 1, this.h);
        byte[] byArray2 = this.a(byArray, 0, byArray.length, this.l.length - this.e - 1);
        for (int i2 = 0; i2 != byArray2.length; ++i2) {
            int n2 = i2;
            this.l[n2] = (byte)(this.l[n2] ^ byArray2[i2]);
        }
        this.l[0] = (byte)(this.l[0] & 255 >> this.l.length * 8 - this.i);
        System.arraycopy(byArray, 0, this.l, this.l.length - this.e - 1, this.e);
        this.l[this.l.length - 1] = this.m;
        byte[] byArray3 = this.c.processBlock(this.l, 0, this.l.length);
        this.a(this.l);
        return byArray3;
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        int n2;
        byte[] byArray;
        this.a.doFinal(this.k, this.k.length - this.e - this.h);
        try {
            byArray = this.c.processBlock(signature, 0, signature.length);
            System.arraycopy(byArray, 0, this.l, this.l.length - byArray.length, byArray.length);
        }
        catch (Exception exception) {
            return false;
        }
        if (this.l[this.l.length - 1] != this.m) {
            this.a(this.l);
            return false;
        }
        byArray = this.a(this.l, this.l.length - this.e - 1, this.e, this.l.length - this.e - 1);
        for (n2 = 0; n2 != byArray.length; ++n2) {
            int n3 = n2;
            this.l[n3] = (byte)(this.l[n3] ^ byArray[n2]);
        }
        this.l[0] = (byte)(this.l[0] & 255 >> this.l.length * 8 - this.i);
        for (n2 = 0; n2 != this.l.length - this.e - this.h - 2; ++n2) {
            if (this.l[n2] == 0) continue;
            this.a(this.l);
            return false;
        }
        if (this.l[this.l.length - this.e - this.h - 2] != 1) {
            this.a(this.l);
            return false;
        }
        if (this.g) {
            System.arraycopy(this.j, 0, this.k, this.k.length - this.h, this.h);
        } else {
            System.arraycopy(this.l, this.l.length - this.h - this.e - 1, this.k, this.k.length - this.h, this.h);
        }
        this.a.update(this.k, 0, this.k.length);
        this.a.doFinal(this.k, this.k.length - this.e);
        n2 = this.l.length - this.e - 1;
        for (int i2 = this.k.length - this.e; i2 != this.k.length; ++i2) {
            if ((this.l[n2] ^ this.k[i2]) != 0) {
                this.a(this.k);
                this.a(this.l);
                return false;
            }
            ++n2;
        }
        this.a(this.k);
        this.a(this.l);
        return true;
    }

    private void a(int n2, byte[] byArray) {
        byArray[0] = (byte)(n2 >>> 24);
        byArray[1] = (byte)(n2 >>> 16);
        byArray[2] = (byte)(n2 >>> 8);
        byArray[3] = (byte)(n2 >>> 0);
    }

    private byte[] a(byte[] byArray, int n2, int n3, int n4) {
        int n5;
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[this.f];
        byte[] byArray4 = new byte[4];
        this.b.reset();
        for (n5 = 0; n5 < n4 / this.f; ++n5) {
            this.a(n5, byArray4);
            this.b.update(byArray, n2, n3);
            this.b.update(byArray4, 0, byArray4.length);
            this.b.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n5 * this.f, this.f);
        }
        if (n5 * this.f < n4) {
            this.a(n5, byArray4);
            this.b.update(byArray, n2, n3);
            this.b.update(byArray4, 0, byArray4.length);
            this.b.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n5 * this.f, byArray2.length - n5 * this.f);
        }
        return byArray2;
    }
}

