/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ByteQueue {
    private byte[] a;
    private int b = 0;
    private int c = 0;
    private boolean d = false;

    public static int nextTwoPow(int i2) {
        i2 |= i2 >> 1;
        i2 |= i2 >> 2;
        i2 |= i2 >> 4;
        i2 |= i2 >> 8;
        i2 |= i2 >> 16;
        return i2 + 1;
    }

    public ByteQueue() {
        this(1024);
    }

    public ByteQueue(int capacity) {
        this.a = capacity == 0 ? TlsUtils.EMPTY_BYTES : new byte[capacity];
    }

    public ByteQueue(byte[] buf, int off, int len) {
        this.a = buf;
        this.b = off;
        this.c = len;
        this.d = true;
    }

    public void addData(byte[] buf, int off, int len) {
        if (this.d) {
            throw new IllegalStateException("Cannot add data to read-only buffer");
        }
        if (this.b + this.c + len > this.a.length) {
            int n2 = ByteQueue.nextTwoPow(this.c + len);
            if (n2 > this.a.length) {
                byte[] byArray = new byte[n2];
                System.arraycopy(this.a, this.b, byArray, 0, this.c);
                this.a = byArray;
            } else {
                System.arraycopy(this.a, this.b, this.a, 0, this.c);
            }
            this.b = 0;
        }
        System.arraycopy(buf, off, this.a, this.b + this.c, len);
        this.c += len;
    }

    public int available() {
        return this.c;
    }

    public void copyTo(OutputStream output, int length) throws IOException {
        if (length > this.c) {
            throw new IllegalStateException("Cannot copy " + length + " bytes, only got " + this.c);
        }
        output.write(this.a, this.b, length);
    }

    public void read(byte[] buf, int offset, int len, int skip) {
        if (buf.length - offset < len) {
            throw new IllegalArgumentException("Buffer size of " + buf.length + " is too small for a read of " + len + " bytes");
        }
        if (this.c - skip < len) {
            throw new IllegalStateException("Not enough data to read");
        }
        System.arraycopy(this.a, this.b + skip, buf, offset, len);
    }

    public ByteArrayInputStream readFrom(int length) {
        if (length > this.c) {
            throw new IllegalStateException("Cannot read " + length + " bytes, only got " + this.c);
        }
        int n2 = this.b;
        this.c -= length;
        this.b += length;
        return new ByteArrayInputStream(this.a, n2, length);
    }

    public void removeData(int i2) {
        if (i2 > this.c) {
            throw new IllegalStateException("Cannot remove " + i2 + " bytes, only got " + this.c);
        }
        this.c -= i2;
        this.b += i2;
    }

    public void removeData(byte[] buf, int off, int len, int skip) {
        this.read(buf, off, len, skip);
        this.removeData(skip + len);
    }

    public byte[] removeData(int len, int skip) {
        byte[] byArray = new byte[len];
        this.removeData(byArray, 0, len, skip);
        return byArray;
    }

    public void shrink() {
        if (this.c == 0) {
            this.a = TlsUtils.EMPTY_BYTES;
            this.b = 0;
        } else {
            int n2 = ByteQueue.nextTwoPow(this.c);
            if (n2 < this.a.length) {
                byte[] byArray = new byte[n2];
                System.arraycopy(this.a, this.b, byArray, 0, this.c);
                this.a = byArray;
                this.b = 0;
            }
        }
    }
}

