/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class Certificate {
    public static final Certificate EMPTY_CHAIN = new Certificate(new com.enterprisedt.bouncycastle.asn1.x509.Certificate[0]);
    protected com.enterprisedt.bouncycastle.asn1.x509.Certificate[] certificateList;

    public Certificate(com.enterprisedt.bouncycastle.asn1.x509.Certificate[] certificateList) {
        if (certificateList == null) {
            throw new IllegalArgumentException("'certificateList' cannot be null");
        }
        this.certificateList = certificateList;
    }

    public com.enterprisedt.bouncycastle.asn1.x509.Certificate[] getCertificateList() {
        return this.cloneCertificateList();
    }

    public com.enterprisedt.bouncycastle.asn1.x509.Certificate getCertificateAt(int index) {
        return this.certificateList[index];
    }

    public int getLength() {
        return this.certificateList.length;
    }

    public boolean isEmpty() {
        return this.certificateList.length == 0;
    }

    public void encode(OutputStream output) throws IOException {
        byte[] byArray;
        int n2;
        Vector<byte[]> vector = new Vector<byte[]>(this.certificateList.length);
        int n3 = 0;
        for (n2 = 0; n2 < this.certificateList.length; ++n2) {
            byArray = this.certificateList[n2].getEncoded("DER");
            vector.addElement(byArray);
            n3 += byArray.length + 3;
        }
        TlsUtils.checkUint24(n3);
        TlsUtils.writeUint24(n3, output);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            byArray = (byte[])vector.elementAt(n2);
            TlsUtils.writeOpaque24(byArray, output);
        }
    }

    public static Certificate parse(InputStream input) throws IOException {
        Object[] objectArray;
        int n2 = TlsUtils.readUint24(input);
        if (n2 == 0) {
            return EMPTY_CHAIN;
        }
        byte[] byArray = TlsUtils.readFully(n2, input);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector<com.enterprisedt.bouncycastle.asn1.x509.Certificate> vector = new Vector<com.enterprisedt.bouncycastle.asn1.x509.Certificate>();
        while (byteArrayInputStream.available() > 0) {
            objectArray = TlsUtils.readOpaque24(byteArrayInputStream);
            ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object(objectArray);
            vector.addElement(com.enterprisedt.bouncycastle.asn1.x509.Certificate.getInstance(aSN1Primitive));
        }
        objectArray = new com.enterprisedt.bouncycastle.asn1.x509.Certificate[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            objectArray[i2] = (byte)((com.enterprisedt.bouncycastle.asn1.x509.Certificate)vector.elementAt(i2));
        }
        return new Certificate((com.enterprisedt.bouncycastle.asn1.x509.Certificate[])objectArray);
    }

    protected com.enterprisedt.bouncycastle.asn1.x509.Certificate[] cloneCertificateList() {
        com.enterprisedt.bouncycastle.asn1.x509.Certificate[] certificateArray = new com.enterprisedt.bouncycastle.asn1.x509.Certificate[this.certificateList.length];
        System.arraycopy(this.certificateList, 0, certificateArray, 0, certificateArray.length);
        return certificateArray;
    }
}

