/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.tls.Certificate;
import com.enterprisedt.bouncycastle.crypto.tls.CertificateRequest;
import com.enterprisedt.bouncycastle.crypto.tls.CertificateStatus;
import com.enterprisedt.bouncycastle.crypto.tls.CipherSuite;
import com.enterprisedt.bouncycastle.crypto.tls.DTLSProtocol;
import com.enterprisedt.bouncycastle.crypto.tls.DTLSTransport;
import com.enterprisedt.bouncycastle.crypto.tls.DatagramTransport;
import com.enterprisedt.bouncycastle.crypto.tls.DigitallySigned;
import com.enterprisedt.bouncycastle.crypto.tls.NewSessionTicket;
import com.enterprisedt.bouncycastle.crypto.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.crypto.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.crypto.tls.SessionParameters;
import com.enterprisedt.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.crypto.tls.TlsAuthentication;
import com.enterprisedt.bouncycastle.crypto.tls.TlsClient;
import com.enterprisedt.bouncycastle.crypto.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.crypto.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.crypto.tls.TlsHandshakeHash;
import com.enterprisedt.bouncycastle.crypto.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.crypto.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.crypto.tls.TlsSession;
import com.enterprisedt.bouncycastle.crypto.tls.TlsSignerCredentials;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import com.enterprisedt.bouncycastle.crypto.tls.f;
import com.enterprisedt.bouncycastle.crypto.tls.g;
import com.enterprisedt.bouncycastle.crypto.tls.m;
import com.enterprisedt.bouncycastle.crypto.tls.q;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Vector;

public class DTLSClientProtocol
extends DTLSProtocol {
    public DTLSClientProtocol(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public DTLSTransport connect(TlsClient client, DatagramTransport transport) throws IOException {
        Object object;
        if (client == null) {
            throw new IllegalArgumentException("'client' cannot be null");
        }
        if (transport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        SecurityParameters securityParameters = new SecurityParameters();
        securityParameters.a = 1;
        ClientHandshakeState clientHandshakeState = new ClientHandshakeState();
        clientHandshakeState.a = client;
        clientHandshakeState.b = new m(this.secureRandom, securityParameters);
        securityParameters.g = TlsProtocol.createRandomBlock(client.shouldUseGMTUnixTime(), clientHandshakeState.b.getNonceRandomGenerator());
        client.init(clientHandshakeState.b);
        f f2 = new f(transport, clientHandshakeState.b, client, 22);
        TlsSession tlsSession = clientHandshakeState.a.getSessionToResume();
        if (tlsSession != null && tlsSession.isResumable() && (object = tlsSession.exportSessionParameters()) != null) {
            clientHandshakeState.c = tlsSession;
            clientHandshakeState.d = object;
        }
        try {
            object = this.clientHandshake(clientHandshakeState, f2);
            return object;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.abortClientHandshake(clientHandshakeState, f2, tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.abortClientHandshake(clientHandshakeState, f2, (short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortClientHandshake(clientHandshakeState, f2, (short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        finally {
            securityParameters.a();
        }
    }

    protected void abortClientHandshake(ClientHandshakeState state, f recordLayer, short alertDescription) {
        recordLayer.a(alertDescription);
        this.invalidateSession(state);
    }

    protected DTLSTransport clientHandshake(ClientHandshakeState state, f recordLayer) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        SecurityParameters securityParameters = state.b.getSecurityParameters();
        g g2 = new g(state.b, recordLayer);
        byte[] byArray = this.generateClientHello(state, state.a);
        recordLayer.b(ProtocolVersion.DTLSv10);
        g2.a((short)1, byArray);
        g.a a2 = g2.d();
        while (a2.b() == 3) {
            object6 = recordLayer.b();
            if (!((ProtocolVersion)object6).isEqualOrEarlierVersionOf((ProtocolVersion)(object5 = state.b.getClientVersion()))) {
                throw new TlsFatalAlert(47);
            }
            recordLayer.a((ProtocolVersion)null);
            object4 = this.processHelloVerifyRequest(state, a2.c());
            object3 = DTLSClientProtocol.patchClientHelloWithCookie(byArray, object4);
            g2.f();
            g2.a((short)1, (byte[])object3);
            a2 = g2.d();
        }
        if (a2.b() != 2) {
            throw new TlsFatalAlert(10);
        }
        object6 = recordLayer.b();
        this.reportServerVersion(state, (ProtocolVersion)object6);
        recordLayer.b((ProtocolVersion)object6);
        this.processServerHello(state, a2.c());
        g2.a();
        DTLSClientProtocol.applyMaxFragmentLengthExtension(recordLayer, securityParameters.l);
        if (state.k) {
            securityParameters.f = Arrays.clone(state.d.getMasterSecret());
            recordLayer.a(state.a.getCipher());
            object6 = TlsUtils.a(state.b, "server finished", TlsProtocol.getCurrentPRFHash(state.b, g2.b(), null));
            this.processFinished(g2.a((short)20), (byte[])object6);
            object5 = TlsUtils.a(state.b, "client finished", TlsProtocol.getCurrentPRFHash(state.b, g2.b(), null));
            g2.a((short)20, (byte[])object5);
            g2.e();
            state.b.a(state.c);
            state.a.notifyHandshakeComplete();
            return new DTLSTransport(recordLayer);
        }
        this.invalidateSession(state);
        if (state.j.length > 0) {
            state.c = new q(state.j, null);
        }
        if ((a2 = g2.d()).b() == 23) {
            this.processServerSupplementalData(state, a2.c());
            a2 = g2.d();
        } else {
            state.a.processServerSupplementalData(null);
        }
        state.o = state.a.getKeyExchange();
        state.o.init(state.b);
        object6 = null;
        if (a2.b() == 11) {
            object6 = this.processServerCertificate(state, a2.c());
            a2 = g2.d();
        } else {
            state.o.skipServerCredentials();
        }
        if (object6 == null || ((Certificate)object6).isEmpty()) {
            state.m = false;
        }
        if (a2.b() == 22) {
            this.processCertificateStatus(state, a2.c());
            a2 = g2.d();
        }
        if (a2.b() == 12) {
            this.processServerKeyExchange(state, a2.c());
            a2 = g2.d();
        } else {
            state.o.skipServerKeyExchange();
        }
        if (a2.b() == 13) {
            this.processCertificateRequest(state, a2.c());
            TlsUtils.a(g2.b(), state.r.getSupportedSignatureAlgorithms());
            a2 = g2.d();
        }
        if (a2.b() == 14) {
            if (a2.c().length != 0) {
                throw new TlsFatalAlert(50);
            }
        } else {
            throw new TlsFatalAlert(10);
        }
        g2.b().sealHashAlgorithms();
        object5 = state.a.getClientSupplementalData();
        if (object5 != null) {
            object4 = DTLSClientProtocol.generateSupplementalData((Vector)object5);
            g2.a((short)23, (byte[])object4);
        }
        if (state.r != null) {
            state.s = state.p.getClientCredentials(state.r);
            object4 = null;
            if (state.s != null) {
                object4 = state.s.getCertificate();
            }
            if (object4 == null) {
                object4 = Certificate.EMPTY_CHAIN;
            }
            object3 = DTLSClientProtocol.generateCertificate((Certificate)object4);
            g2.a((short)11, (byte[])object3);
        }
        if (state.s != null) {
            state.o.processClientCredentials(state.s);
        } else {
            state.o.skipClientCredentials();
        }
        object4 = this.generateClientKeyExchange(state);
        g2.a((short)16, (byte[])object4);
        object3 = g2.c();
        securityParameters.i = TlsProtocol.getCurrentPRFHash(state.b, (TlsHandshakeHash)object3, null);
        TlsProtocol.establishMasterSecret(state.b, state.o);
        recordLayer.a(state.a.getCipher());
        if (state.s != null && state.s instanceof TlsSignerCredentials) {
            object2 = (TlsSignerCredentials)state.s;
            object = TlsUtils.getSignatureAndHashAlgorithm(state.b, (TlsSignerCredentials)object2);
            byte[] byArray2 = object == null ? securityParameters.getSessionHash() : object3.getFinalHash(((SignatureAndHashAlgorithm)object).getHash());
            byte[] byArray3 = object2.generateCertificateSignature(byArray2);
            DigitallySigned digitallySigned = new DigitallySigned((SignatureAndHashAlgorithm)object, byArray3);
            byte[] byArray4 = this.generateCertificateVerify(state, digitallySigned);
            g2.a((short)15, byArray4);
        }
        object2 = TlsUtils.a(state.b, "client finished", TlsProtocol.getCurrentPRFHash(state.b, g2.b(), null));
        g2.a((short)20, (byte[])object2);
        if (state.n) {
            a2 = g2.d();
            if (a2.b() == 4) {
                this.processNewSessionTicket(state, a2.c());
            } else {
                throw new TlsFatalAlert(10);
            }
        }
        object = TlsUtils.a(state.b, "server finished", TlsProtocol.getCurrentPRFHash(state.b, g2.b(), null));
        this.processFinished(g2.a((short)20), (byte[])object);
        g2.e();
        if (state.c != null) {
            state.d = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setCompressionAlgorithm(securityParameters.getCompressionAlgorithm()).setMasterSecret(securityParameters.getMasterSecret()).setPeerCertificate((Certificate)object6).setPSKIdentity(securityParameters.getPSKIdentity()).setSRPIdentity(securityParameters.getSRPIdentity()).setServerExtensions(state.i).build();
            state.c = TlsUtils.importSession(state.c.getSessionID(), state.d);
            state.b.a(state.c);
        }
        state.a.notifyHandshakeComplete();
        return new DTLSTransport(recordLayer);
    }

    protected byte[] generateCertificateVerify(ClientHandshakeState state, DigitallySigned certificateVerify) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateVerify.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateClientHello(ClientHandshakeState state, TlsClient client) throws IOException {
        boolean bl;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ProtocolVersion protocolVersion = client.getClientVersion();
        if (!protocolVersion.isDTLS()) {
            throw new TlsFatalAlert(80);
        }
        m m2 = state.b;
        m2.a(protocolVersion);
        TlsUtils.writeVersion(protocolVersion, byteArrayOutputStream);
        SecurityParameters securityParameters = m2.getSecurityParameters();
        byteArrayOutputStream.write(securityParameters.getClientRandom());
        byte[] byArray = TlsUtils.EMPTY_BYTES;
        if (state.c != null && ((byArray = state.c.getSessionID()) == null || byArray.length > 32)) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        TlsUtils.writeOpaque8(byArray, byteArrayOutputStream);
        TlsUtils.writeOpaque8(TlsUtils.EMPTY_BYTES, byteArrayOutputStream);
        boolean bl2 = client.isFallback();
        state.f = client.getCipherSuites();
        state.h = client.getClientExtensions();
        byte[] byArray2 = TlsUtils.getExtensionData(state.h, TlsProtocol.EXT_RenegotiationInfo);
        boolean bl3 = null == byArray2;
        boolean bl4 = bl = !Arrays.contains(state.f, 255);
        if (bl3 && bl) {
            state.f = Arrays.append(state.f, 255);
        }
        if (bl2 && !Arrays.contains(state.f, 22016)) {
            state.f = Arrays.append(state.f, 22016);
        }
        TlsUtils.writeUint16ArrayWithUint16Length(state.f, byteArrayOutputStream);
        state.g = new short[]{0};
        TlsUtils.writeUint8ArrayWithUint8Length(state.g, byteArrayOutputStream);
        if (state.h != null) {
            TlsProtocol.writeExtensions(byteArrayOutputStream, state.h);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateClientKeyExchange(ClientHandshakeState state) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        state.o.generateClientKeyExchange(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected void invalidateSession(ClientHandshakeState state) {
        if (state.d != null) {
            state.d.clear();
            state.d = null;
        }
        if (state.c != null) {
            state.c.invalidate();
            state.c = null;
        }
    }

    protected void processCertificateRequest(ClientHandshakeState state, byte[] body) throws IOException {
        if (state.p == null) {
            throw new TlsFatalAlert(40);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        state.r = CertificateRequest.parse(state.b, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        state.o.validateCertificateRequest(state.r);
    }

    protected void processCertificateStatus(ClientHandshakeState state, byte[] body) throws IOException {
        if (!state.m) {
            throw new TlsFatalAlert(10);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        state.q = CertificateStatus.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected byte[] processHelloVerifyRequest(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        byte[] byArray = TlsUtils.readOpaque8(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (!protocolVersion.isEqualOrEarlierVersionOf(state.b.getClientVersion())) {
            throw new TlsFatalAlert(47);
        }
        if (!ProtocolVersion.DTLSv12.isEqualOrEarlierVersionOf(protocolVersion) && byArray.length > 32) {
            throw new TlsFatalAlert(47);
        }
        return byArray;
    }

    protected void processNewSessionTicket(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        state.a.notifyNewSessionTicket(newSessionTicket);
    }

    protected Certificate processServerCertificate(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        Certificate certificate = Certificate.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        state.o.processServerCertificate(certificate);
        state.p = state.a.getAuthentication();
        state.p.notifyServerCertificate(certificate);
        return certificate;
    }

    protected void processServerHello(ClientHandshakeState state, byte[] body) throws IOException {
        Serializable serializable;
        Object object;
        SecurityParameters securityParameters = state.b.getSecurityParameters();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        this.reportServerVersion(state, protocolVersion);
        securityParameters.h = TlsUtils.readFully(32, (InputStream)byteArrayInputStream);
        state.j = TlsUtils.readOpaque8(byteArrayInputStream);
        if (state.j.length > 32) {
            throw new TlsFatalAlert(47);
        }
        state.a.notifySessionID(state.j);
        state.k = state.j.length > 0 && state.c != null && Arrays.areEqual(state.j, state.c.getSessionID());
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (!Arrays.contains(state.f, n2) || n2 == 0 || CipherSuite.isSCSV(n2) || !TlsUtils.isValidCipherSuiteForVersion(n2, state.b.getServerVersion())) {
            throw new TlsFatalAlert(47);
        }
        DTLSClientProtocol.validateSelectedCipherSuite(n2, (short)47);
        state.a.notifySelectedCipherSuite(n2);
        short s2 = TlsUtils.readUint8(byteArrayInputStream);
        if (!Arrays.contains(state.g, s2)) {
            throw new TlsFatalAlert(47);
        }
        state.a.notifySelectedCompressionMethod(s2);
        state.i = TlsProtocol.readExtensions(byteArrayInputStream);
        if (state.i != null) {
            object = state.i.keys();
            while (object.hasMoreElements()) {
                serializable = (Integer)object.nextElement();
                if (serializable.equals(TlsProtocol.EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData(state.h, serializable)) {
                    throw new TlsFatalAlert(110);
                }
                if (!state.k) continue;
            }
        }
        if ((object = (Object)TlsUtils.getExtensionData(state.i, TlsProtocol.EXT_RenegotiationInfo)) != null) {
            state.l = true;
            if (!Arrays.constantTimeAreEqual((byte[])object, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        state.a.notifySecureRenegotiation(state.l);
        object = state.h;
        serializable = state.i;
        if (state.k) {
            if (n2 != state.d.getCipherSuite() || s2 != state.d.getCompressionAlgorithm()) {
                throw new TlsFatalAlert(47);
            }
            object = null;
            serializable = state.d.readServerExtensions();
        }
        securityParameters.b = n2;
        securityParameters.c = s2;
        if (serializable != null) {
            boolean bl = TlsExtensionsUtils.hasEncryptThenMACExtension((Hashtable)serializable);
            if (bl && !TlsUtils.isBlockCipherSuite(securityParameters.getCipherSuite())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.n = bl;
            securityParameters.o = TlsExtensionsUtils.hasExtendedMasterSecretExtension((Hashtable)serializable);
            securityParameters.l = DTLSClientProtocol.evaluateMaxFragmentLengthExtension(state.k, (Hashtable)object, (Hashtable)serializable, (short)47);
            securityParameters.m = TlsExtensionsUtils.hasTruncatedHMacExtension((Hashtable)serializable);
            state.m = !state.k && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)serializable, TlsExtensionsUtils.EXT_status_request, (short)47);
            boolean bl2 = state.n = !state.k && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)serializable, TlsProtocol.EXT_SessionTicket, (short)47);
        }
        if (object != null) {
            state.a.processServerExtensions((Hashtable)serializable);
        }
        securityParameters.d = TlsProtocol.getPRFAlgorithm(state.b, securityParameters.getCipherSuite());
        securityParameters.e = 12;
    }

    protected void processServerKeyExchange(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        state.o.processServerKeyExchange(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected void processServerSupplementalData(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        Vector vector = TlsProtocol.readSupplementalDataMessage(byteArrayInputStream);
        state.a.processServerSupplementalData(vector);
    }

    protected void reportServerVersion(ClientHandshakeState state, ProtocolVersion server_version) throws IOException {
        m m2 = state.b;
        ProtocolVersion protocolVersion = m2.getServerVersion();
        if (null == protocolVersion) {
            m2.b(server_version);
            state.a.notifyServerVersion(server_version);
        } else if (!protocolVersion.equals(server_version)) {
            throw new TlsFatalAlert(47);
        }
    }

    protected static byte[] patchClientHelloWithCookie(byte[] clientHelloBody, byte[] cookie) throws IOException {
        int n2 = 34;
        short s2 = TlsUtils.readUint8(clientHelloBody, n2);
        int n3 = n2 + 1 + s2;
        int n4 = n3 + 1;
        byte[] byArray = new byte[clientHelloBody.length + cookie.length];
        System.arraycopy(clientHelloBody, 0, byArray, 0, n3);
        TlsUtils.checkUint8(cookie.length);
        TlsUtils.writeUint8(cookie.length, byArray, n3);
        System.arraycopy(cookie, 0, byArray, n4, cookie.length);
        System.arraycopy(clientHelloBody, n4, byArray, n4 + cookie.length, clientHelloBody.length - n4);
        return byArray;
    }

    protected static class ClientHandshakeState {
        TlsClient a = null;
        m b = null;
        TlsSession c = null;
        SessionParameters d = null;
        SessionParameters.Builder e = null;
        int[] f = null;
        short[] g = null;
        Hashtable h = null;
        Hashtable i = null;
        byte[] j = null;
        boolean k = false;
        boolean l = false;
        boolean m = false;
        boolean n = false;
        TlsKeyExchange o = null;
        TlsAuthentication p = null;
        CertificateStatus q = null;
        CertificateRequest r = null;
        TlsCredentials s = null;

        protected ClientHandshakeState() {
        }
    }
}

