/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.tls.Certificate;
import com.enterprisedt.bouncycastle.crypto.tls.CertificateRequest;
import com.enterprisedt.bouncycastle.crypto.tls.CertificateStatus;
import com.enterprisedt.bouncycastle.crypto.tls.CipherSuite;
import com.enterprisedt.bouncycastle.crypto.tls.DTLSProtocol;
import com.enterprisedt.bouncycastle.crypto.tls.DTLSTransport;
import com.enterprisedt.bouncycastle.crypto.tls.DatagramTransport;
import com.enterprisedt.bouncycastle.crypto.tls.DigitallySigned;
import com.enterprisedt.bouncycastle.crypto.tls.NewSessionTicket;
import com.enterprisedt.bouncycastle.crypto.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.crypto.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.crypto.tls.SessionParameters;
import com.enterprisedt.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.crypto.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.crypto.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.crypto.tls.TlsHandshakeHash;
import com.enterprisedt.bouncycastle.crypto.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.crypto.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.crypto.tls.TlsServer;
import com.enterprisedt.bouncycastle.crypto.tls.TlsSession;
import com.enterprisedt.bouncycastle.crypto.tls.TlsSigner;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import com.enterprisedt.bouncycastle.crypto.tls.f;
import com.enterprisedt.bouncycastle.crypto.tls.g;
import com.enterprisedt.bouncycastle.crypto.tls.p;
import com.enterprisedt.bouncycastle.crypto.util.PublicKeyFactory;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Vector;

public class DTLSServerProtocol
extends DTLSProtocol {
    protected boolean verifyRequests = true;

    public DTLSServerProtocol(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public boolean getVerifyRequests() {
        return this.verifyRequests;
    }

    public void setVerifyRequests(boolean verifyRequests) {
        this.verifyRequests = verifyRequests;
    }

    public DTLSTransport accept(TlsServer server, DatagramTransport transport) throws IOException {
        if (server == null) {
            throw new IllegalArgumentException("'server' cannot be null");
        }
        if (transport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        SecurityParameters securityParameters = new SecurityParameters();
        securityParameters.a = 0;
        ServerHandshakeState serverHandshakeState = new ServerHandshakeState();
        serverHandshakeState.a = server;
        serverHandshakeState.b = new p(this.secureRandom, securityParameters);
        securityParameters.h = TlsProtocol.createRandomBlock(server.shouldUseGMTUnixTime(), serverHandshakeState.b.getNonceRandomGenerator());
        server.init(serverHandshakeState.b);
        f f2 = new f(transport, serverHandshakeState.b, server, 22);
        try {
            DTLSTransport dTLSTransport = this.serverHandshake(serverHandshakeState, f2);
            return dTLSTransport;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.abortServerHandshake(serverHandshakeState, f2, tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.abortServerHandshake(serverHandshakeState, f2, (short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortServerHandshake(serverHandshakeState, f2, (short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        finally {
            securityParameters.a();
        }
    }

    protected void abortServerHandshake(ServerHandshakeState state, f recordLayer, short alertDescription) {
        recordLayer.a(alertDescription);
        this.invalidateSession(state);
    }

    protected DTLSTransport serverHandshake(ServerHandshakeState state, f recordLayer) throws IOException {
        Object object;
        byte[] byArray;
        Object object2;
        Object object3;
        SecurityParameters securityParameters = state.b.getSecurityParameters();
        g g2 = new g(state.b, recordLayer);
        g.a a2 = g2.d();
        if (a2.b() != 1) {
            throw new TlsFatalAlert(10);
        }
        this.processClientHello(state, a2.c());
        Object object4 = this.generateServerHello(state);
        DTLSServerProtocol.applyMaxFragmentLengthExtension(recordLayer, securityParameters.l);
        Object object5 = state.b.getServerVersion();
        recordLayer.a((ProtocolVersion)object5);
        recordLayer.b((ProtocolVersion)object5);
        g2.a((short)2, (byte[])object4);
        g2.a();
        object4 = state.a.getServerSupplementalData();
        if (object4 != null) {
            object5 = DTLSServerProtocol.generateSupplementalData((Vector)object4);
            g2.a((short)23, (byte[])object5);
        }
        state.n = state.a.getKeyExchange();
        state.n.init(state.b);
        state.o = state.a.getCredentials();
        object5 = null;
        if (state.o == null) {
            state.n.skipServerCredentials();
        } else {
            state.n.processServerCredentials(state.o);
            object5 = state.o.getCertificate();
            object3 = DTLSServerProtocol.generateCertificate((Certificate)object5);
            g2.a((short)11, (byte[])object3);
        }
        if (object5 == null || ((Certificate)object5).isEmpty()) {
            state.l = false;
        }
        if (state.l && (object3 = (Object)state.a.getCertificateStatus()) != null) {
            object2 = this.generateCertificateStatus(state, (CertificateStatus)object3);
            g2.a((short)22, (byte[])object2);
        }
        if ((object3 = state.n.generateServerKeyExchange()) != null) {
            g2.a((short)12, (byte[])object3);
        }
        if (state.o != null) {
            state.p = state.a.getCertificateRequest();
            if (state.p != null) {
                if (TlsUtils.isTLSv12(state.b) != (state.p.getSupportedSignatureAlgorithms() != null)) {
                    throw new TlsFatalAlert(80);
                }
                state.n.validateCertificateRequest(state.p);
                object2 = this.generateCertificateRequest(state, state.p);
                g2.a((short)13, (byte[])object2);
                TlsUtils.a(g2.b(), state.p.getSupportedSignatureAlgorithms());
            }
        }
        g2.a((short)14, TlsUtils.EMPTY_BYTES);
        g2.b().sealHashAlgorithms();
        a2 = g2.d();
        if (a2.b() == 23) {
            this.processClientSupplementalData(state, a2.c());
            a2 = g2.d();
        } else {
            state.a.processClientSupplementalData(null);
        }
        if (state.p == null) {
            state.n.skipClientCredentials();
        } else if (a2.b() == 11) {
            this.processClientCertificate(state, a2.c());
            a2 = g2.d();
        } else {
            if (TlsUtils.isTLSv12(state.b)) {
                throw new TlsFatalAlert(10);
            }
            this.notifyClientCertificate(state, Certificate.EMPTY_CHAIN);
        }
        if (a2.b() != 16) {
            throw new TlsFatalAlert(10);
        }
        this.processClientKeyExchange(state, a2.c());
        object2 = g2.c();
        securityParameters.i = TlsProtocol.getCurrentPRFHash(state.b, (TlsHandshakeHash)object2, null);
        TlsProtocol.establishMasterSecret(state.b, state.n);
        recordLayer.a(state.a.getCipher());
        if (this.expectCertificateVerifyMessage(state)) {
            byArray = g2.a((short)15);
            this.processCertificateVerify(state, byArray, (TlsHandshakeHash)object2);
        }
        byArray = TlsUtils.a(state.b, "client finished", TlsProtocol.getCurrentPRFHash(state.b, g2.b(), null));
        this.processFinished(g2.a((short)20), byArray);
        if (state.m) {
            object = state.a.getNewSessionTicket();
            byte[] byArray2 = this.generateNewSessionTicket(state, (NewSessionTicket)object);
            g2.a((short)4, byArray2);
        }
        object = TlsUtils.a(state.b, "server finished", TlsProtocol.getCurrentPRFHash(state.b, g2.b(), null));
        g2.a((short)20, (byte[])object);
        g2.e();
        state.a.notifyHandshakeComplete();
        return new DTLSTransport(recordLayer);
    }

    protected byte[] generateCertificateRequest(ServerHandshakeState state, CertificateRequest certificateRequest) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateCertificateStatus(ServerHandshakeState state, CertificateStatus certificateStatus) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateStatus.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateNewSessionTicket(ServerHandshakeState state, NewSessionTicket newSessionTicket) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        newSessionTicket.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateServerHello(ServerHandshakeState state) throws IOException {
        SecurityParameters securityParameters = state.b.getSecurityParameters();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ProtocolVersion protocolVersion = state.a.getServerVersion();
        if (!protocolVersion.isEqualOrEarlierVersionOf(state.b.getClientVersion())) {
            throw new TlsFatalAlert(80);
        }
        state.b.b(protocolVersion);
        TlsUtils.writeVersion(state.b.getServerVersion(), byteArrayOutputStream);
        byteArrayOutputStream.write(securityParameters.getServerRandom());
        TlsUtils.writeOpaque8(TlsUtils.EMPTY_BYTES, byteArrayOutputStream);
        int n2 = state.a.getSelectedCipherSuite();
        if (!Arrays.contains(state.f, n2) || n2 == 0 || CipherSuite.isSCSV(n2) || !TlsUtils.isValidCipherSuiteForVersion(n2, state.b.getServerVersion())) {
            throw new TlsFatalAlert(80);
        }
        DTLSServerProtocol.validateSelectedCipherSuite(n2, (short)80);
        securityParameters.b = n2;
        short s2 = state.a.getSelectedCompressionMethod();
        if (!Arrays.contains(state.g, s2)) {
            throw new TlsFatalAlert(80);
        }
        securityParameters.c = s2;
        TlsUtils.writeUint16(n2, byteArrayOutputStream);
        TlsUtils.writeUint8(s2, (OutputStream)byteArrayOutputStream);
        state.i = state.a.getServerExtensions();
        if (state.k) {
            boolean bl;
            byte[] byArray = TlsUtils.getExtensionData(state.i, TlsProtocol.EXT_RenegotiationInfo);
            boolean bl2 = bl = null == byArray;
            if (bl) {
                state.i = TlsExtensionsUtils.ensureExtensionsInitialised(state.i);
                state.i.put(TlsProtocol.EXT_RenegotiationInfo, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        if (securityParameters.o) {
            state.i = TlsExtensionsUtils.ensureExtensionsInitialised(state.i);
            TlsExtensionsUtils.addExtendedMasterSecretExtension(state.i);
        }
        if (state.i != null) {
            securityParameters.n = TlsExtensionsUtils.hasEncryptThenMACExtension(state.i);
            securityParameters.l = DTLSServerProtocol.evaluateMaxFragmentLengthExtension(state.j, state.h, state.i, (short)80);
            securityParameters.m = TlsExtensionsUtils.hasTruncatedHMacExtension(state.i);
            state.l = !state.j && TlsUtils.hasExpectedEmptyExtensionData(state.i, TlsExtensionsUtils.EXT_status_request, (short)80);
            state.m = !state.j && TlsUtils.hasExpectedEmptyExtensionData(state.i, TlsProtocol.EXT_SessionTicket, (short)80);
            TlsProtocol.writeExtensions(byteArrayOutputStream, state.i);
        }
        securityParameters.d = TlsProtocol.getPRFAlgorithm(state.b, securityParameters.getCipherSuite());
        securityParameters.e = 12;
        return byteArrayOutputStream.toByteArray();
    }

    protected void invalidateSession(ServerHandshakeState state) {
        if (state.d != null) {
            state.d.clear();
            state.d = null;
        }
        if (state.c != null) {
            state.c.invalidate();
            state.c = null;
        }
    }

    protected void notifyClientCertificate(ServerHandshakeState state, Certificate clientCertificate) throws IOException {
        if (state.p == null) {
            throw new IllegalStateException();
        }
        if (state.r != null) {
            throw new TlsFatalAlert(10);
        }
        state.r = clientCertificate;
        if (clientCertificate.isEmpty()) {
            state.n.skipClientCredentials();
        } else {
            state.q = TlsUtils.a(clientCertificate, state.o.getCertificate());
            state.n.processClientCertificate(clientCertificate);
        }
        state.a.notifyClientCertificate(clientCertificate);
    }

    protected void processClientCertificate(ServerHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        Certificate certificate = Certificate.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        this.notifyClientCertificate(state, certificate);
    }

    protected void processCertificateVerify(ServerHandshakeState state, byte[] body, TlsHandshakeHash prepareFinishHash) throws IOException {
        if (state.p == null) {
            throw new IllegalStateException();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        p p2 = state.b;
        DigitallySigned digitallySigned = DigitallySigned.parse(p2, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        try {
            byte[] byArray;
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
            if (TlsUtils.isTLSv12(p2)) {
                TlsUtils.verifySupportedSignatureAlgorithm(state.p.getSupportedSignatureAlgorithms(), signatureAndHashAlgorithm);
                byArray = prepareFinishHash.getFinalHash(signatureAndHashAlgorithm.getHash());
            } else {
                byArray = p2.getSecurityParameters().getSessionHash();
            }
            com.enterprisedt.bouncycastle.asn1.x509.Certificate certificate = state.r.getCertificateAt(0);
            SubjectPublicKeyInfo subjectPublicKeyInfo = certificate.getSubjectPublicKeyInfo();
            AsymmetricKeyParameter asymmetricKeyParameter = PublicKeyFactory.createKey(subjectPublicKeyInfo);
            TlsSigner tlsSigner = TlsUtils.createTlsSigner(state.q);
            tlsSigner.init(p2);
            if (!tlsSigner.verifyRawSignature(signatureAndHashAlgorithm, digitallySigned.getSignature(), asymmetricKeyParameter, byArray)) {
                throw new TlsFatalAlert(51);
            }
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            throw tlsFatalAlert;
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(51, (Throwable)exception);
        }
    }

    protected void processClientHello(ServerHandshakeState state, byte[] body) throws IOException {
        byte[] byArray;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        if (!protocolVersion.isDTLS()) {
            throw new TlsFatalAlert(47);
        }
        byte[] byArray2 = TlsUtils.readFully(32, (InputStream)byteArrayInputStream);
        byte[] byArray3 = TlsUtils.readOpaque8(byteArrayInputStream);
        if (byArray3.length > 32) {
            throw new TlsFatalAlert(47);
        }
        byte[] byArray4 = TlsUtils.readOpaque8(byteArrayInputStream);
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (n2 < 2 || (n2 & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        state.f = TlsUtils.readUint16Array(n2 / 2, byteArrayInputStream);
        short s2 = TlsUtils.readUint8(byteArrayInputStream);
        if (s2 < 1) {
            throw new TlsFatalAlert(47);
        }
        state.g = TlsUtils.readUint8Array(s2, byteArrayInputStream);
        state.h = TlsProtocol.readExtensions(byteArrayInputStream);
        p p2 = state.b;
        SecurityParameters securityParameters = p2.getSecurityParameters();
        securityParameters.o = TlsExtensionsUtils.hasExtendedMasterSecretExtension(state.h);
        p2.a(protocolVersion);
        state.a.notifyClientVersion(protocolVersion);
        state.a.notifyFallback(Arrays.contains(state.f, 22016));
        securityParameters.g = byArray2;
        state.a.notifyOfferedCipherSuites(state.f);
        state.a.notifyOfferedCompressionMethods(state.g);
        if (Arrays.contains(state.f, 255)) {
            state.k = true;
        }
        if ((byArray = TlsUtils.getExtensionData(state.h, TlsProtocol.EXT_RenegotiationInfo)) != null) {
            state.k = true;
            if (!Arrays.constantTimeAreEqual(byArray, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        state.a.notifySecureRenegotiation(state.k);
        if (state.h != null) {
            TlsExtensionsUtils.getPaddingExtension(state.h);
            state.a.processClientExtensions(state.h);
        }
    }

    protected void processClientKeyExchange(ServerHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        state.n.processClientKeyExchange(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected void processClientSupplementalData(ServerHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        Vector vector = TlsProtocol.readSupplementalDataMessage(byteArrayInputStream);
        state.a.processClientSupplementalData(vector);
    }

    protected boolean expectCertificateVerifyMessage(ServerHandshakeState state) {
        return state.q >= 0 && TlsUtils.hasSigningCapability(state.q);
    }

    protected static class ServerHandshakeState {
        TlsServer a = null;
        p b = null;
        TlsSession c = null;
        SessionParameters d = null;
        SessionParameters.Builder e = null;
        int[] f = null;
        short[] g = null;
        Hashtable h = null;
        Hashtable i = null;
        boolean j = false;
        boolean k = false;
        boolean l = false;
        boolean m = false;
        TlsKeyExchange n = null;
        TlsCredentials o = null;
        CertificateRequest p = null;
        short q = (short)-1;
        Certificate r = null;

        protected ServerHandshakeState() {
        }
    }
}

