/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.tls.AbstractTlsClient;
import com.enterprisedt.bouncycastle.crypto.tls.TlsCipherFactory;
import com.enterprisedt.bouncycastle.crypto.tls.TlsDHEKeyExchange;
import com.enterprisedt.bouncycastle.crypto.tls.TlsDHKeyExchange;
import com.enterprisedt.bouncycastle.crypto.tls.TlsECDHEKeyExchange;
import com.enterprisedt.bouncycastle.crypto.tls.TlsECDHKeyExchange;
import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.crypto.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.crypto.tls.TlsRSAKeyExchange;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import java.io.IOException;

public abstract class DefaultTlsClient
extends AbstractTlsClient {
    public DefaultTlsClient() {
    }

    public DefaultTlsClient(TlsCipherFactory cipherFactory) {
        super(cipherFactory);
    }

    @Override
    public int[] getCipherSuites() {
        return new int[]{49195, 49187, 49161, 49199, 49191, 49171, 162, 64, 50, 158, 103, 51, 156, 60, 47};
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n2) {
            case 7: 
            case 9: 
            case 11: {
                return this.createDHKeyExchange(n2);
            }
            case 3: 
            case 5: {
                return this.createDHEKeyExchange(n2);
            }
            case 16: 
            case 18: 
            case 20: {
                return this.createECDHKeyExchange(n2);
            }
            case 17: 
            case 19: {
                return this.createECDHEKeyExchange(n2);
            }
            case 1: {
                return this.createRSAKeyExchange();
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createDHKeyExchange(int keyExchange) {
        return new TlsDHKeyExchange(keyExchange, this.supportedSignatureAlgorithms, null);
    }

    protected TlsKeyExchange createDHEKeyExchange(int keyExchange) {
        return new TlsDHEKeyExchange(keyExchange, this.supportedSignatureAlgorithms, null);
    }

    protected TlsKeyExchange createECDHKeyExchange(int keyExchange) {
        return new TlsECDHKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }

    protected TlsKeyExchange createECDHEKeyExchange(int keyExchange) {
        return new TlsECDHEKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }

    protected TlsKeyExchange createRSAKeyExchange() {
        return new TlsRSAKeyExchange(this.supportedSignatureAlgorithms);
    }
}

