/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.tls.HeartbeatMessageType;
import com.enterprisedt.bouncycastle.crypto.tls.TlsContext;
import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HeartbeatMessage {
    protected short type;
    protected byte[] payload;
    protected int paddingLength;

    public HeartbeatMessage(short type, byte[] payload, int paddingLength) {
        if (!HeartbeatMessageType.isValid(type)) {
            throw new IllegalArgumentException("'type' is not a valid HeartbeatMessageType value");
        }
        if (payload == null || payload.length >= 65536) {
            throw new IllegalArgumentException("'payload' must have length < 2^16");
        }
        if (paddingLength < 16) {
            throw new IllegalArgumentException("'paddingLength' must be at least 16");
        }
        this.type = type;
        this.payload = payload;
        this.paddingLength = paddingLength;
    }

    public void encode(TlsContext context, OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.type, output);
        TlsUtils.checkUint16(this.payload.length);
        TlsUtils.writeUint16(this.payload.length, output);
        output.write(this.payload);
        byte[] byArray = new byte[this.paddingLength];
        context.getNonceRandomGenerator().nextBytes(byArray);
        output.write(byArray);
    }

    public static HeartbeatMessage parse(InputStream input) throws IOException {
        short s2 = TlsUtils.readUint8(input);
        if (!HeartbeatMessageType.isValid(s2)) {
            throw new TlsFatalAlert(47);
        }
        int n2 = TlsUtils.readUint16(input);
        a a2 = new a();
        Streams.pipeAll(input, a2);
        byte[] byArray = a2.a(n2);
        if (byArray == null) {
            return null;
        }
        int n3 = a2.size() - byArray.length;
        return new HeartbeatMessage(s2, byArray, n3);
    }

    static class a
    extends ByteArrayOutputStream {
        a() {
        }

        byte[] a(int n2) {
            int n3 = n2 + 16;
            if (this.count < n3) {
                return null;
            }
            return Arrays.copyOf(this.buf, n2);
        }
    }
}

