/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Strings;
import java.io.IOException;

public final class ProtocolVersion {
    public static final ProtocolVersion SSLv3 = new ProtocolVersion(768, "SSL 3.0");
    public static final ProtocolVersion TLSv10 = new ProtocolVersion(769, "TLS 1.0");
    public static final ProtocolVersion TLSv11 = new ProtocolVersion(770, "TLS 1.1");
    public static final ProtocolVersion TLSv12 = new ProtocolVersion(771, "TLS 1.2");
    public static final ProtocolVersion DTLSv10 = new ProtocolVersion(65279, "DTLS 1.0");
    public static final ProtocolVersion DTLSv12 = new ProtocolVersion(65277, "DTLS 1.2");
    private int a;
    private String b;

    private ProtocolVersion(int v2, String name) {
        this.a = v2 & 0xFFFF;
        this.b = name;
    }

    public int getFullVersion() {
        return this.a;
    }

    public int getMajorVersion() {
        return this.a >> 8;
    }

    public int getMinorVersion() {
        return this.a & 0xFF;
    }

    public boolean isDTLS() {
        return this.getMajorVersion() == 254;
    }

    public boolean isSSL() {
        return this == SSLv3;
    }

    public boolean isTLS() {
        return this.getMajorVersion() == 3;
    }

    public ProtocolVersion getEquivalentTLSVersion() {
        if (!this.isDTLS()) {
            return this;
        }
        if (this == DTLSv10) {
            return TLSv11;
        }
        return TLSv12;
    }

    public boolean isEqualOrEarlierVersionOf(ProtocolVersion version) {
        if (this.getMajorVersion() != version.getMajorVersion()) {
            return false;
        }
        int n2 = version.getMinorVersion() - this.getMinorVersion();
        return this.isDTLS() ? n2 <= 0 : n2 >= 0;
    }

    public boolean isLaterVersionOf(ProtocolVersion version) {
        if (this.getMajorVersion() != version.getMajorVersion()) {
            return false;
        }
        int n2 = version.getMinorVersion() - this.getMinorVersion();
        return this.isDTLS() ? n2 > 0 : n2 < 0;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof ProtocolVersion && this.equals((ProtocolVersion)other);
    }

    public boolean equals(ProtocolVersion other) {
        return other != null && this.a == other.a;
    }

    public int hashCode() {
        return this.a;
    }

    public static ProtocolVersion get(int major, int minor) throws IOException {
        switch (major) {
            case 3: {
                switch (minor) {
                    case 0: {
                        return SSLv3;
                    }
                    case 1: {
                        return TLSv10;
                    }
                    case 2: {
                        return TLSv11;
                    }
                    case 3: {
                        return TLSv12;
                    }
                }
                return ProtocolVersion.a(major, minor, "TLS");
            }
            case 254: {
                switch (minor) {
                    case 255: {
                        return DTLSv10;
                    }
                    case 254: {
                        throw new TlsFatalAlert(47);
                    }
                    case 253: {
                        return DTLSv12;
                    }
                }
                return ProtocolVersion.a(major, minor, "DTLS");
            }
        }
        throw new TlsFatalAlert(47);
    }

    public String toString() {
        return this.b;
    }

    private static ProtocolVersion a(int n2, int n3, String string) throws IOException {
        TlsUtils.checkUint8(n2);
        TlsUtils.checkUint8(n3);
        int n4 = n2 << 8 | n3;
        String string2 = Strings.toUpperCase(Integer.toHexString(0x10000 | n4).substring(1));
        return new ProtocolVersion(n4, string + " 0x" + string2);
    }
}

