/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.params.DHParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.tls.TlsDHUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class ServerDHParams {
    protected DHPublicKeyParameters publicKey;

    public ServerDHParams(DHPublicKeyParameters publicKey) {
        if (publicKey == null) {
            throw new IllegalArgumentException("'publicKey' cannot be null");
        }
        this.publicKey = publicKey;
    }

    public DHPublicKeyParameters getPublicKey() {
        return this.publicKey;
    }

    public void encode(OutputStream output) throws IOException {
        DHParameters dHParameters = this.publicKey.getParameters();
        BigInteger bigInteger = this.publicKey.getY();
        TlsDHUtils.writeDHParameter(dHParameters.getP(), output);
        TlsDHUtils.writeDHParameter(dHParameters.getG(), output);
        TlsDHUtils.writeDHParameter(bigInteger, output);
    }

    public static ServerDHParams parse(InputStream input) throws IOException {
        BigInteger bigInteger = TlsDHUtils.readDHParameter(input);
        BigInteger bigInteger2 = TlsDHUtils.readDHParameter(input);
        BigInteger bigInteger3 = TlsDHUtils.readDHParameter(input);
        return new ServerDHParams(TlsDHUtils.validateDHPublicKey(new DHPublicKeyParameters(bigInteger3, new DHParameters(bigInteger, bigInteger2))));
    }
}

