/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ServerName {
    protected short nameType;
    protected Object name;

    public ServerName(short nameType, Object name) {
        if (!ServerName.isCorrectType(nameType, name)) {
            throw new IllegalArgumentException("'name' is not an instance of the correct type");
        }
        this.nameType = nameType;
        this.name = name;
    }

    public short getNameType() {
        return this.nameType;
    }

    public Object getName() {
        return this.name;
    }

    public String getHostName() {
        if (!ServerName.isCorrectType((short)0, this.name)) {
            throw new IllegalStateException("'name' is not a HostName string");
        }
        return (String)this.name;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.nameType, output);
        switch (this.nameType) {
            case 0: {
                byte[] byArray = ((String)this.name).getBytes("ASCII");
                if (byArray.length < 1) {
                    throw new TlsFatalAlert(80);
                }
                TlsUtils.writeOpaque16(byArray, output);
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
    }

    public static ServerName parse(InputStream input) throws IOException {
        String string;
        short s2 = TlsUtils.readUint8(input);
        switch (s2) {
            case 0: {
                byte[] byArray = TlsUtils.readOpaque16(input);
                if (byArray.length < 1) {
                    throw new TlsFatalAlert(50);
                }
                string = new String(byArray, "ASCII");
                break;
            }
            default: {
                throw new TlsFatalAlert(50);
            }
        }
        return new ServerName(s2, string);
    }

    protected static boolean isCorrectType(short nameType, Object name) {
        switch (nameType) {
            case 0: {
                return name instanceof String;
            }
        }
        throw new IllegalArgumentException("'nameType' is an unsupported NameType");
    }
}

