/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.agreement.srp.SRP6VerifierGenerator;
import com.enterprisedt.bouncycastle.crypto.macs.HMac;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.SRP6GroupParameters;
import com.enterprisedt.bouncycastle.crypto.tls.TlsSRPIdentityManager;
import com.enterprisedt.bouncycastle.crypto.tls.TlsSRPLoginParameters;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Strings;
import java.math.BigInteger;

public class SimulatedTlsSRPIdentityManager
implements TlsSRPIdentityManager {
    private static final byte[] a = Strings.toByteArray("password");
    private static final byte[] b = Strings.toByteArray("salt");
    protected SRP6GroupParameters group;
    protected SRP6VerifierGenerator verifierGenerator;
    protected Mac mac;

    public static SimulatedTlsSRPIdentityManager getRFC5054Default(SRP6GroupParameters group, byte[] seedKey) {
        SRP6VerifierGenerator sRP6VerifierGenerator = new SRP6VerifierGenerator();
        sRP6VerifierGenerator.init(group, TlsUtils.createHash((short)2));
        HMac hMac = new HMac(TlsUtils.createHash((short)2));
        hMac.init(new KeyParameter(seedKey));
        return new SimulatedTlsSRPIdentityManager(group, sRP6VerifierGenerator, hMac);
    }

    public SimulatedTlsSRPIdentityManager(SRP6GroupParameters group, SRP6VerifierGenerator verifierGenerator, Mac mac) {
        this.group = group;
        this.verifierGenerator = verifierGenerator;
        this.mac = mac;
    }

    @Override
    public TlsSRPLoginParameters getLoginParameters(byte[] identity) {
        this.mac.update(b, 0, b.length);
        this.mac.update(identity, 0, identity.length);
        byte[] byArray = new byte[this.mac.getMacSize()];
        this.mac.doFinal(byArray, 0);
        this.mac.update(a, 0, a.length);
        this.mac.update(identity, 0, identity.length);
        byte[] byArray2 = new byte[this.mac.getMacSize()];
        this.mac.doFinal(byArray2, 0);
        BigInteger bigInteger = this.verifierGenerator.generateVerifier(byArray, identity, byArray2);
        return new TlsSRPLoginParameters(this.group, bigInteger, byArray);
    }
}

