/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.modes.AEADBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.AEADParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.tls.TlsCipher;
import com.enterprisedt.bouncycastle.crypto.tls.TlsContext;
import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;

public class TlsAEADCipher
implements TlsCipher {
    public static final int NONCE_RFC5288 = 1;
    protected TlsContext context;
    protected int macSize;
    protected int record_iv_length;
    protected AEADBlockCipher encryptCipher;
    protected AEADBlockCipher decryptCipher;
    protected byte[] encryptImplicitNonce;
    protected byte[] decryptImplicitNonce;
    protected int nonceMode;

    public TlsAEADCipher(TlsContext context, AEADBlockCipher clientWriteCipher, AEADBlockCipher serverWriteCipher, int cipherKeySize, int macSize) throws IOException {
        this(context, clientWriteCipher, serverWriteCipher, cipherKeySize, macSize, 1);
    }

    TlsAEADCipher(TlsContext context, AEADBlockCipher clientWriteCipher, AEADBlockCipher serverWriteCipher, int cipherKeySize, int macSize, int nonceMode) throws IOException {
        KeyParameter keyParameter;
        KeyParameter keyParameter2;
        int n2;
        if (!TlsUtils.isTLSv12(context)) {
            throw new TlsFatalAlert(80);
        }
        this.nonceMode = nonceMode;
        switch (nonceMode) {
            case 1: {
                n2 = 4;
                this.record_iv_length = 8;
                break;
            }
            case 2: {
                n2 = 12;
                this.record_iv_length = 0;
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        this.context = context;
        this.macSize = macSize;
        int n3 = 2 * cipherKeySize + 2 * n2;
        byte[] byArray = TlsUtils.a(context, n3);
        int n4 = 0;
        KeyParameter keyParameter3 = new KeyParameter(byArray, n4, cipherKeySize);
        KeyParameter keyParameter4 = new KeyParameter(byArray, n4 += cipherKeySize, cipherKeySize);
        byte[] byArray2 = Arrays.copyOfRange(byArray, n4 += cipherKeySize, n4 + n2);
        byte[] byArray3 = Arrays.copyOfRange(byArray, n4 += n2, n4 + n2);
        if ((n4 += n2) != n3) {
            throw new TlsFatalAlert(80);
        }
        if (context.isServer()) {
            this.encryptCipher = serverWriteCipher;
            this.decryptCipher = clientWriteCipher;
            this.encryptImplicitNonce = byArray3;
            this.decryptImplicitNonce = byArray2;
            keyParameter2 = keyParameter4;
            keyParameter = keyParameter3;
        } else {
            this.encryptCipher = clientWriteCipher;
            this.decryptCipher = serverWriteCipher;
            this.encryptImplicitNonce = byArray2;
            this.decryptImplicitNonce = byArray3;
            keyParameter2 = keyParameter3;
            keyParameter = keyParameter4;
        }
        byte[] byArray4 = new byte[n2 + this.record_iv_length];
        this.encryptCipher.init(true, new AEADParameters(keyParameter2, 8 * macSize, byArray4));
        this.decryptCipher.init(false, new AEADParameters(keyParameter, 8 * macSize, byArray4));
    }

    @Override
    public int getPlaintextLimit(int ciphertextLimit) {
        return ciphertextLimit - this.macSize - this.record_iv_length;
    }

    @Override
    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) throws IOException {
        int n2;
        byte[] byArray = new byte[this.encryptImplicitNonce.length + this.record_iv_length];
        switch (this.nonceMode) {
            case 1: {
                System.arraycopy(this.encryptImplicitNonce, 0, byArray, 0, this.encryptImplicitNonce.length);
                TlsUtils.writeUint64(seqNo, byArray, this.encryptImplicitNonce.length);
                break;
            }
            case 2: {
                TlsUtils.writeUint64(seqNo, byArray, byArray.length - 8);
                for (n2 = 0; n2 < this.encryptImplicitNonce.length; ++n2) {
                    int n3 = n2;
                    byArray[n3] = (byte)(byArray[n3] ^ this.encryptImplicitNonce[n2]);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        n2 = offset;
        int n4 = len;
        int n5 = this.encryptCipher.getOutputSize(n4);
        byte[] byArray2 = new byte[this.record_iv_length + n5];
        if (this.record_iv_length != 0) {
            System.arraycopy(byArray, byArray.length - this.record_iv_length, byArray2, 0, this.record_iv_length);
        }
        int n6 = this.record_iv_length;
        byte[] byArray3 = this.getAdditionalData(seqNo, type, n4);
        AEADParameters aEADParameters = new AEADParameters(null, 8 * this.macSize, byArray, byArray3);
        try {
            this.encryptCipher.init(true, aEADParameters);
            n6 += this.encryptCipher.processBytes(plaintext, n2, n4, byArray2, n6);
            n6 += this.encryptCipher.doFinal(byArray2, n6);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(80, (Throwable)exception);
        }
        if (n6 != byArray2.length) {
            throw new TlsFatalAlert(80);
        }
        return byArray2;
    }

    @Override
    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        int n2;
        if (this.getPlaintextLimit(len) < 0) {
            throw new TlsFatalAlert(50);
        }
        byte[] byArray = new byte[this.decryptImplicitNonce.length + this.record_iv_length];
        switch (this.nonceMode) {
            case 1: {
                System.arraycopy(this.decryptImplicitNonce, 0, byArray, 0, this.decryptImplicitNonce.length);
                System.arraycopy(ciphertext, offset, byArray, byArray.length - this.record_iv_length, this.record_iv_length);
                break;
            }
            case 2: {
                TlsUtils.writeUint64(seqNo, byArray, byArray.length - 8);
                for (n2 = 0; n2 < this.decryptImplicitNonce.length; ++n2) {
                    int n3 = n2;
                    byArray[n3] = (byte)(byArray[n3] ^ this.decryptImplicitNonce[n2]);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        n2 = offset + this.record_iv_length;
        int n4 = len - this.record_iv_length;
        int n5 = this.decryptCipher.getOutputSize(n4);
        byte[] byArray2 = new byte[n5];
        int n6 = 0;
        byte[] byArray3 = this.getAdditionalData(seqNo, type, n5);
        AEADParameters aEADParameters = new AEADParameters(null, 8 * this.macSize, byArray, byArray3);
        try {
            this.decryptCipher.init(false, aEADParameters);
            n6 += this.decryptCipher.processBytes(ciphertext, n2, n4, byArray2, n6);
            n6 += this.decryptCipher.doFinal(byArray2, n6);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(20, (Throwable)exception);
        }
        if (n6 != byArray2.length) {
            throw new TlsFatalAlert(80);
        }
        return byArray2;
    }

    protected byte[] getAdditionalData(long seqNo, short type, int len) throws IOException {
        byte[] byArray = new byte[13];
        TlsUtils.writeUint64(seqNo, byArray, 0);
        TlsUtils.writeUint8(type, byArray, 8);
        TlsUtils.writeVersion(this.context.getServerVersion(), byArray, 9);
        TlsUtils.writeUint16(len, byArray, 11);
        return byArray;
    }
}

