/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.crypto.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.crypto.tls.TlsCipher;
import com.enterprisedt.bouncycastle.crypto.tls.TlsContext;
import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.crypto.tls.TlsMac;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.SecureRandom;

public class TlsBlockCipher
implements TlsCipher {
    protected TlsContext context;
    protected byte[] randomData;
    protected boolean useExplicitIV;
    protected boolean encryptThenMAC;
    protected BlockCipher encryptCipher;
    protected BlockCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsMac getWriteMac() {
        return this.writeMac;
    }

    public TlsMac getReadMac() {
        return this.readMac;
    }

    public TlsBlockCipher(TlsContext context, BlockCipher clientWriteCipher, BlockCipher serverWriteCipher, Digest clientWriteDigest, Digest serverWriteDigest, int cipherKeySize) throws IOException {
        ParametersWithIV parametersWithIV;
        ParametersWithIV parametersWithIV2;
        byte[] byArray;
        byte[] byArray2;
        this.context = context;
        this.randomData = new byte[256];
        context.getNonceRandomGenerator().nextBytes(this.randomData);
        this.useExplicitIV = TlsUtils.isTLSv11(context);
        this.encryptThenMAC = context.getSecurityParameters().n;
        int n2 = 2 * cipherKeySize + clientWriteDigest.getDigestSize() + serverWriteDigest.getDigestSize();
        if (!this.useExplicitIV) {
            n2 += clientWriteCipher.getBlockSize() + serverWriteCipher.getBlockSize();
        }
        byte[] byArray3 = TlsUtils.a(context, n2);
        int n3 = 0;
        TlsMac tlsMac = new TlsMac(context, clientWriteDigest, byArray3, n3, clientWriteDigest.getDigestSize());
        TlsMac tlsMac2 = new TlsMac(context, serverWriteDigest, byArray3, n3 += clientWriteDigest.getDigestSize(), serverWriteDigest.getDigestSize());
        KeyParameter keyParameter = new KeyParameter(byArray3, n3 += serverWriteDigest.getDigestSize(), cipherKeySize);
        KeyParameter keyParameter2 = new KeyParameter(byArray3, n3 += cipherKeySize, cipherKeySize);
        n3 += cipherKeySize;
        if (this.useExplicitIV) {
            byArray2 = new byte[clientWriteCipher.getBlockSize()];
            byArray = new byte[serverWriteCipher.getBlockSize()];
        } else {
            byArray2 = Arrays.copyOfRange(byArray3, n3, n3 + clientWriteCipher.getBlockSize());
            byArray = Arrays.copyOfRange(byArray3, n3 += clientWriteCipher.getBlockSize(), n3 + serverWriteCipher.getBlockSize());
            n3 += serverWriteCipher.getBlockSize();
        }
        if (n3 != n2) {
            throw new TlsFatalAlert(80);
        }
        if (context.isServer()) {
            this.writeMac = tlsMac2;
            this.readMac = tlsMac;
            this.encryptCipher = serverWriteCipher;
            this.decryptCipher = clientWriteCipher;
            parametersWithIV2 = new ParametersWithIV(keyParameter2, byArray);
            parametersWithIV = new ParametersWithIV(keyParameter, byArray2);
        } else {
            this.writeMac = tlsMac;
            this.readMac = tlsMac2;
            this.encryptCipher = clientWriteCipher;
            this.decryptCipher = serverWriteCipher;
            parametersWithIV2 = new ParametersWithIV(keyParameter, byArray2);
            parametersWithIV = new ParametersWithIV(keyParameter2, byArray);
        }
        this.encryptCipher.init(true, parametersWithIV2);
        this.decryptCipher.init(false, parametersWithIV);
    }

    @Override
    public int getPlaintextLimit(int ciphertextLimit) {
        int n2 = this.encryptCipher.getBlockSize();
        int n3 = this.writeMac.getSize();
        int n4 = ciphertextLimit;
        if (this.useExplicitIV) {
            n4 -= n2;
        }
        if (this.encryptThenMAC) {
            n4 -= n3;
            n4 -= n4 % n2;
        } else {
            n4 -= n4 % n2;
            n4 -= n3;
        }
        return --n4;
    }

    @Override
    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) {
        int n2;
        int n3;
        int n4 = this.encryptCipher.getBlockSize();
        int n5 = this.writeMac.getSize();
        ProtocolVersion protocolVersion = this.context.getServerVersion();
        int n6 = len;
        if (!this.encryptThenMAC) {
            n6 += n5;
        }
        int n7 = n4 - 1 - n6 % n4;
        if (!(!this.encryptThenMAC && this.context.getSecurityParameters().m || protocolVersion.isDTLS() || protocolVersion.isSSL())) {
            n3 = (255 - n7) / n4;
            int n8 = this.chooseExtraPadBlocks(this.context.getSecureRandom(), n3);
            n7 += n8 * n4;
        }
        n3 = len + n5 + n7 + 1;
        if (this.useExplicitIV) {
            n3 += n4;
        }
        byte[] byArray = new byte[n3];
        int n9 = 0;
        if (this.useExplicitIV) {
            byte[] byArray2 = new byte[n4];
            this.context.getNonceRandomGenerator().nextBytes(byArray2);
            this.encryptCipher.init(true, new ParametersWithIV(null, byArray2));
            System.arraycopy(byArray2, 0, byArray, n9, n4);
            n9 += n4;
        }
        int n10 = n9;
        System.arraycopy(plaintext, offset, byArray, n9, len);
        n9 += len;
        if (!this.encryptThenMAC) {
            byte[] byArray3 = this.writeMac.calculateMac(seqNo, type, plaintext, offset, len);
            System.arraycopy(byArray3, 0, byArray, n9, byArray3.length);
            n9 += byArray3.length;
        }
        for (n2 = 0; n2 <= n7; ++n2) {
            byArray[n9++] = (byte)n7;
        }
        for (n2 = n10; n2 < n9; n2 += n4) {
            this.encryptCipher.processBlock(byArray, n2, byArray, n2);
        }
        if (this.encryptThenMAC) {
            byte[] byArray4 = this.writeMac.calculateMac(seqNo, type, byArray, 0, n9);
            System.arraycopy(byArray4, 0, byArray, n9, byArray4.length);
            n9 += byArray4.length;
        }
        return byArray;
    }

    @Override
    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        int n2;
        int n3;
        int n4 = this.decryptCipher.getBlockSize();
        int n5 = this.readMac.getSize();
        int n6 = n4;
        n6 = this.encryptThenMAC ? (n6 += n5) : Math.max(n6, n5 + 1);
        if (this.useExplicitIV) {
            n6 += n4;
        }
        if (len < n6) {
            throw new TlsFatalAlert(50);
        }
        int n7 = len;
        if (this.encryptThenMAC) {
            n7 -= n5;
        }
        if (n7 % n4 != 0) {
            throw new TlsFatalAlert(21);
        }
        if (this.encryptThenMAC) {
            n3 = offset + len;
            byte[] byArray = Arrays.copyOfRange(ciphertext, n3 - n5, n3);
            byte[] byArray2 = this.readMac.calculateMac(seqNo, type, ciphertext, offset, len - n5);
            int n8 = n2 = !Arrays.constantTimeAreEqual(byArray2, byArray) ? 1 : 0;
            if (n2 != 0) {
                throw new TlsFatalAlert(20);
            }
        }
        if (this.useExplicitIV) {
            this.decryptCipher.init(false, new ParametersWithIV(null, ciphertext, offset, n4));
            offset += n4;
            n7 -= n4;
        }
        for (n3 = 0; n3 < n7; n3 += n4) {
            this.decryptCipher.processBlock(ciphertext, offset + n3, ciphertext, offset + n3);
        }
        n3 = this.checkPaddingConstantTime(ciphertext, offset, n7, n4, this.encryptThenMAC ? 0 : n5);
        boolean bl = n3 == 0;
        int n9 = n7 - n3;
        if (!this.encryptThenMAC) {
            n2 = n9 -= n5;
            int n10 = offset + n2;
            byte[] byArray = Arrays.copyOfRange(ciphertext, n10, n10 + n5);
            byte[] byArray3 = this.readMac.calculateMacConstantTime(seqNo, type, ciphertext, offset, n2, n7 - n5, this.randomData);
            bl |= !Arrays.constantTimeAreEqual(byArray3, byArray);
        }
        if (bl) {
            throw new TlsFatalAlert(20);
        }
        return Arrays.copyOfRange(ciphertext, offset, offset + n9);
    }

    protected int checkPaddingConstantTime(byte[] buf, int off, int len, int blockSize, int macSize) {
        int n2 = off + len;
        byte by = buf[n2 - 1];
        int n3 = by & 0xFF;
        int n4 = n3 + 1;
        int n5 = 0;
        int n6 = 0;
        if (TlsUtils.isSSL(this.context) && n4 > blockSize || macSize + n4 > len) {
            n4 = 0;
        } else {
            int n7 = n2 - n4;
            do {
                n6 = (byte)(n6 | buf[n7++] ^ by);
            } while (n7 < n2);
            n5 = n4;
            if (n6 != 0) {
                n4 = 0;
            }
        }
        byte[] byArray = this.randomData;
        while (n5 < 256) {
            n6 = (byte)(n6 | byArray[n5++] ^ by);
        }
        byArray[0] = (byte)(byArray[0] ^ n6);
        return n4;
    }

    protected int chooseExtraPadBlocks(SecureRandom r2, int max) {
        int n2 = r2.nextInt();
        int n3 = this.lowestBitSet(n2);
        return Math.min(n3, max);
    }

    protected int lowestBitSet(int x2) {
        if (x2 == 0) {
            return 32;
        }
        int n2 = 0;
        while ((x2 & 1) == 0) {
            ++n2;
            x2 >>= 1;
        }
        return n2;
    }
}

