/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.asn1.ASN1InputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.KeyUsage;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.digests.MD5Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA1Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA224Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA256Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA384Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA512Digest;
import com.enterprisedt.bouncycastle.crypto.macs.HMac;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.crypto.tls.Certificate;
import com.enterprisedt.bouncycastle.crypto.tls.HashAlgorithm;
import com.enterprisedt.bouncycastle.crypto.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.crypto.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.crypto.tls.SessionParameters;
import com.enterprisedt.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.crypto.tls.TlsContext;
import com.enterprisedt.bouncycastle.crypto.tls.TlsDSSSigner;
import com.enterprisedt.bouncycastle.crypto.tls.TlsECDSASigner;
import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.crypto.tls.TlsHandshakeHash;
import com.enterprisedt.bouncycastle.crypto.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.crypto.tls.TlsRSASigner;
import com.enterprisedt.bouncycastle.crypto.tls.TlsSession;
import com.enterprisedt.bouncycastle.crypto.tls.TlsSigner;
import com.enterprisedt.bouncycastle.crypto.tls.TlsSignerCredentials;
import com.enterprisedt.bouncycastle.crypto.tls.b;
import com.enterprisedt.bouncycastle.crypto.tls.q;
import com.enterprisedt.bouncycastle.crypto.util.PublicKeyFactory;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Integers;
import com.enterprisedt.bouncycastle.util.Shorts;
import com.enterprisedt.bouncycastle.util.Strings;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

public class TlsUtils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final short[] EMPTY_SHORTS = new short[0];
    public static final int[] EMPTY_INTS = new int[0];
    public static final long[] EMPTY_LONGS = new long[0];
    public static final Integer EXT_signature_algorithms = Integers.valueOf(13);
    static final byte[] a = new byte[]{67, 76, 78, 84};
    static final byte[] b = new byte[]{83, 82, 86, 82};
    static final byte[][] c = TlsUtils.a();

    public static void checkUint8(short i2) throws IOException {
        if (!TlsUtils.isValidUint8(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint8(int i2) throws IOException {
        if (!TlsUtils.isValidUint8(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint8(long i2) throws IOException {
        if (!TlsUtils.isValidUint8(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint16(int i2) throws IOException {
        if (!TlsUtils.isValidUint16(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint16(long i2) throws IOException {
        if (!TlsUtils.isValidUint16(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint24(int i2) throws IOException {
        if (!TlsUtils.isValidUint24(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint24(long i2) throws IOException {
        if (!TlsUtils.isValidUint24(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint32(long i2) throws IOException {
        if (!TlsUtils.isValidUint32(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint48(long i2) throws IOException {
        if (!TlsUtils.isValidUint48(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint64(long i2) throws IOException {
        if (!TlsUtils.isValidUint64(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static boolean isValidUint8(short i2) {
        return (i2 & 0xFF) == i2;
    }

    public static boolean isValidUint8(int i2) {
        return (i2 & 0xFF) == i2;
    }

    public static boolean isValidUint8(long i2) {
        return (i2 & 0xFFL) == i2;
    }

    public static boolean isValidUint16(int i2) {
        return (i2 & 0xFFFF) == i2;
    }

    public static boolean isValidUint16(long i2) {
        return (i2 & 0xFFFFL) == i2;
    }

    public static boolean isValidUint24(int i2) {
        return (i2 & 0xFFFFFF) == i2;
    }

    public static boolean isValidUint24(long i2) {
        return (i2 & 0xFFFFFFL) == i2;
    }

    public static boolean isValidUint32(long i2) {
        return (i2 & 0xFFFFFFFFL) == i2;
    }

    public static boolean isValidUint48(long i2) {
        return (i2 & 0xFFFFFFFFFFFFL) == i2;
    }

    public static boolean isValidUint64(long i2) {
        return true;
    }

    public static boolean isSSL(TlsContext context) {
        return context.getServerVersion().isSSL();
    }

    public static boolean isTLSv11(ProtocolVersion version) {
        return ProtocolVersion.TLSv11.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isTLSv11(TlsContext context) {
        return TlsUtils.isTLSv11(context.getServerVersion());
    }

    public static boolean isTLSv12(ProtocolVersion version) {
        return ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isTLSv12(TlsContext context) {
        return TlsUtils.isTLSv12(context.getServerVersion());
    }

    public static void writeUint8(short i2, OutputStream output) throws IOException {
        output.write(i2);
    }

    public static void writeUint8(int i2, OutputStream output) throws IOException {
        output.write(i2);
    }

    public static void writeUint8(short i2, byte[] buf, int offset) {
        buf[offset] = (byte)i2;
    }

    public static void writeUint8(int i2, byte[] buf, int offset) {
        buf[offset] = (byte)i2;
    }

    public static void writeUint16(int i2, OutputStream output) throws IOException {
        output.write(i2 >>> 8);
        output.write(i2);
    }

    public static void writeUint16(int i2, byte[] buf, int offset) {
        buf[offset] = (byte)(i2 >>> 8);
        buf[offset + 1] = (byte)i2;
    }

    public static void writeUint24(int i2, OutputStream output) throws IOException {
        output.write((byte)(i2 >>> 16));
        output.write((byte)(i2 >>> 8));
        output.write((byte)i2);
    }

    public static void writeUint24(int i2, byte[] buf, int offset) {
        buf[offset] = (byte)(i2 >>> 16);
        buf[offset + 1] = (byte)(i2 >>> 8);
        buf[offset + 2] = (byte)i2;
    }

    public static void writeUint32(long i2, OutputStream output) throws IOException {
        output.write((byte)(i2 >>> 24));
        output.write((byte)(i2 >>> 16));
        output.write((byte)(i2 >>> 8));
        output.write((byte)i2);
    }

    public static void writeUint32(long i2, byte[] buf, int offset) {
        buf[offset] = (byte)(i2 >>> 24);
        buf[offset + 1] = (byte)(i2 >>> 16);
        buf[offset + 2] = (byte)(i2 >>> 8);
        buf[offset + 3] = (byte)i2;
    }

    public static void writeUint48(long i2, OutputStream output) throws IOException {
        output.write((byte)(i2 >>> 40));
        output.write((byte)(i2 >>> 32));
        output.write((byte)(i2 >>> 24));
        output.write((byte)(i2 >>> 16));
        output.write((byte)(i2 >>> 8));
        output.write((byte)i2);
    }

    public static void writeUint48(long i2, byte[] buf, int offset) {
        buf[offset] = (byte)(i2 >>> 40);
        buf[offset + 1] = (byte)(i2 >>> 32);
        buf[offset + 2] = (byte)(i2 >>> 24);
        buf[offset + 3] = (byte)(i2 >>> 16);
        buf[offset + 4] = (byte)(i2 >>> 8);
        buf[offset + 5] = (byte)i2;
    }

    public static void writeUint64(long i2, OutputStream output) throws IOException {
        output.write((byte)(i2 >>> 56));
        output.write((byte)(i2 >>> 48));
        output.write((byte)(i2 >>> 40));
        output.write((byte)(i2 >>> 32));
        output.write((byte)(i2 >>> 24));
        output.write((byte)(i2 >>> 16));
        output.write((byte)(i2 >>> 8));
        output.write((byte)i2);
    }

    public static void writeUint64(long i2, byte[] buf, int offset) {
        buf[offset] = (byte)(i2 >>> 56);
        buf[offset + 1] = (byte)(i2 >>> 48);
        buf[offset + 2] = (byte)(i2 >>> 40);
        buf[offset + 3] = (byte)(i2 >>> 32);
        buf[offset + 4] = (byte)(i2 >>> 24);
        buf[offset + 5] = (byte)(i2 >>> 16);
        buf[offset + 6] = (byte)(i2 >>> 8);
        buf[offset + 7] = (byte)i2;
    }

    public static void writeOpaque8(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint8(buf.length);
        TlsUtils.writeUint8(buf.length, output);
        output.write(buf);
    }

    public static void writeOpaque16(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint16(buf.length);
        TlsUtils.writeUint16(buf.length, output);
        output.write(buf);
    }

    public static void writeOpaque24(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint24(buf.length);
        TlsUtils.writeUint24(buf.length, output);
        output.write(buf);
    }

    public static void writeUint8Array(short[] uints, OutputStream output) throws IOException {
        for (int i2 = 0; i2 < uints.length; ++i2) {
            TlsUtils.writeUint8(uints[i2], output);
        }
    }

    public static void writeUint8Array(short[] uints, byte[] buf, int offset) throws IOException {
        for (int i2 = 0; i2 < uints.length; ++i2) {
            TlsUtils.writeUint8(uints[i2], buf, offset);
            ++offset;
        }
    }

    public static void writeUint8ArrayWithUint8Length(short[] uints, OutputStream output) throws IOException {
        TlsUtils.checkUint8(uints.length);
        TlsUtils.writeUint8(uints.length, output);
        TlsUtils.writeUint8Array(uints, output);
    }

    public static void writeUint8ArrayWithUint8Length(short[] uints, byte[] buf, int offset) throws IOException {
        TlsUtils.checkUint8(uints.length);
        TlsUtils.writeUint8(uints.length, buf, offset);
        TlsUtils.writeUint8Array(uints, buf, offset + 1);
    }

    public static void writeUint16Array(int[] uints, OutputStream output) throws IOException {
        for (int i2 = 0; i2 < uints.length; ++i2) {
            TlsUtils.writeUint16(uints[i2], output);
        }
    }

    public static void writeUint16Array(int[] uints, byte[] buf, int offset) throws IOException {
        for (int i2 = 0; i2 < uints.length; ++i2) {
            TlsUtils.writeUint16(uints[i2], buf, offset);
            offset += 2;
        }
    }

    public static void writeUint16ArrayWithUint16Length(int[] uints, OutputStream output) throws IOException {
        int n2 = 2 * uints.length;
        TlsUtils.checkUint16(n2);
        TlsUtils.writeUint16(n2, output);
        TlsUtils.writeUint16Array(uints, output);
    }

    public static void writeUint16ArrayWithUint16Length(int[] uints, byte[] buf, int offset) throws IOException {
        int n2 = 2 * uints.length;
        TlsUtils.checkUint16(n2);
        TlsUtils.writeUint16(n2, buf, offset);
        TlsUtils.writeUint16Array(uints, buf, offset + 2);
    }

    public static byte[] encodeOpaque8(byte[] buf) throws IOException {
        TlsUtils.checkUint8(buf.length);
        return Arrays.prepend(buf, (byte)buf.length);
    }

    public static byte[] encodeUint8ArrayWithUint8Length(short[] uints) throws IOException {
        byte[] byArray = new byte[1 + uints.length];
        TlsUtils.writeUint8ArrayWithUint8Length(uints, byArray, 0);
        return byArray;
    }

    public static byte[] encodeUint16ArrayWithUint16Length(int[] uints) throws IOException {
        int n2 = 2 * uints.length;
        byte[] byArray = new byte[2 + n2];
        TlsUtils.writeUint16ArrayWithUint16Length(uints, byArray, 0);
        return byArray;
    }

    public static short readUint8(InputStream input) throws IOException {
        int n2 = input.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (short)n2;
    }

    public static short readUint8(byte[] buf, int offset) {
        return (short)(buf[offset] & 0xFF);
    }

    public static int readUint16(InputStream input) throws IOException {
        int n2 = input.read();
        int n3 = input.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return n2 << 8 | n3;
    }

    public static int readUint16(byte[] buf, int offset) {
        int n2 = (buf[offset] & 0xFF) << 8;
        return n2 |= buf[++offset] & 0xFF;
    }

    public static int readUint24(InputStream input) throws IOException {
        int n2 = input.read();
        int n3 = input.read();
        int n4 = input.read();
        if (n4 < 0) {
            throw new EOFException();
        }
        return n2 << 16 | n3 << 8 | n4;
    }

    public static int readUint24(byte[] buf, int offset) {
        int n2 = (buf[offset] & 0xFF) << 16;
        n2 |= (buf[++offset] & 0xFF) << 8;
        return n2 |= buf[++offset] & 0xFF;
    }

    public static long readUint32(InputStream input) throws IOException {
        int n2 = input.read();
        int n3 = input.read();
        int n4 = input.read();
        int n5 = input.read();
        if (n5 < 0) {
            throw new EOFException();
        }
        return (long)(n2 << 24 | n3 << 16 | n4 << 8 | n5) & 0xFFFFFFFFL;
    }

    public static long readUint32(byte[] buf, int offset) {
        int n2 = (buf[offset] & 0xFF) << 24;
        n2 |= (buf[++offset] & 0xFF) << 16;
        n2 |= (buf[++offset] & 0xFF) << 8;
        return (long)(n2 |= buf[++offset] & 0xFF) & 0xFFFFFFFFL;
    }

    public static long readUint48(InputStream input) throws IOException {
        int n2 = TlsUtils.readUint24(input);
        int n3 = TlsUtils.readUint24(input);
        return ((long)n2 & 0xFFFFFFFFL) << 24 | (long)n3 & 0xFFFFFFFFL;
    }

    public static long readUint48(byte[] buf, int offset) {
        int n2 = TlsUtils.readUint24(buf, offset);
        int n3 = TlsUtils.readUint24(buf, offset + 3);
        return ((long)n2 & 0xFFFFFFFFL) << 24 | (long)n3 & 0xFFFFFFFFL;
    }

    public static byte[] readAllOrNothing(int length, InputStream input) throws IOException {
        if (length < 1) {
            return EMPTY_BYTES;
        }
        byte[] byArray = new byte[length];
        int n2 = Streams.readFully(input, byArray);
        if (n2 == 0) {
            return null;
        }
        if (n2 != length) {
            throw new EOFException();
        }
        return byArray;
    }

    public static byte[] readFully(int length, InputStream input) throws IOException {
        if (length < 1) {
            return EMPTY_BYTES;
        }
        byte[] byArray = new byte[length];
        if (length != Streams.readFully(input, byArray)) {
            throw new EOFException();
        }
        return byArray;
    }

    public static void readFully(byte[] buf, InputStream input) throws IOException {
        int n2 = buf.length;
        if (n2 > 0 && n2 != Streams.readFully(input, buf)) {
            throw new EOFException();
        }
    }

    public static byte[] readOpaque8(InputStream input) throws IOException {
        short s2 = TlsUtils.readUint8(input);
        return TlsUtils.readFully(s2, input);
    }

    public static byte[] readOpaque16(InputStream input) throws IOException {
        int n2 = TlsUtils.readUint16(input);
        return TlsUtils.readFully(n2, input);
    }

    public static byte[] readOpaque24(InputStream input) throws IOException {
        int n2 = TlsUtils.readUint24(input);
        return TlsUtils.readFully(n2, input);
    }

    public static short[] readUint8Array(int count, InputStream input) throws IOException {
        short[] sArray = new short[count];
        for (int i2 = 0; i2 < count; ++i2) {
            sArray[i2] = TlsUtils.readUint8(input);
        }
        return sArray;
    }

    public static int[] readUint16Array(int count, InputStream input) throws IOException {
        int[] nArray = new int[count];
        for (int i2 = 0; i2 < count; ++i2) {
            nArray[i2] = TlsUtils.readUint16(input);
        }
        return nArray;
    }

    public static ProtocolVersion readVersion(byte[] buf, int offset) throws IOException {
        return ProtocolVersion.get(buf[offset] & 0xFF, buf[offset + 1] & 0xFF);
    }

    public static ProtocolVersion readVersion(InputStream input) throws IOException {
        int n2 = input.read();
        int n3 = input.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return ProtocolVersion.get(n2, n3);
    }

    public static int readVersionRaw(byte[] buf, int offset) throws IOException {
        return buf[offset] << 8 | buf[offset + 1];
    }

    public static int readVersionRaw(InputStream input) throws IOException {
        int n2 = input.read();
        int n3 = input.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return n2 << 8 | n3;
    }

    public static ASN1Primitive readASN1Object(byte[] encoding) throws IOException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(encoding);
        ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
        if (null == aSN1Primitive) {
            throw new TlsFatalAlert(50);
        }
        if (null != aSN1InputStream.readObject()) {
            throw new TlsFatalAlert(50);
        }
        return aSN1Primitive;
    }

    public static ASN1Primitive readDERObject(byte[] encoding) throws IOException {
        ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object(encoding);
        byte[] byArray = aSN1Primitive.getEncoded("DER");
        if (!Arrays.areEqual(byArray, encoding)) {
            throw new TlsFatalAlert(50);
        }
        return aSN1Primitive;
    }

    public static void writeGMTUnixTime(byte[] buf, int offset) {
        int n2 = (int)(System.currentTimeMillis() / 1000L);
        buf[offset] = (byte)(n2 >>> 24);
        buf[offset + 1] = (byte)(n2 >>> 16);
        buf[offset + 2] = (byte)(n2 >>> 8);
        buf[offset + 3] = (byte)n2;
    }

    public static void writeVersion(ProtocolVersion version, OutputStream output) throws IOException {
        output.write(version.getMajorVersion());
        output.write(version.getMinorVersion());
    }

    public static void writeVersion(ProtocolVersion version, byte[] buf, int offset) {
        buf[offset] = (byte)version.getMajorVersion();
        buf[offset + 1] = (byte)version.getMinorVersion();
    }

    public static Vector getAllSignatureAlgorithms() {
        Vector<Short> vector = new Vector<Short>(4);
        vector.addElement(Shorts.valueOf((short)0));
        vector.addElement(Shorts.valueOf((short)1));
        vector.addElement(Shorts.valueOf((short)2));
        vector.addElement(Shorts.valueOf((short)3));
        return vector;
    }

    public static Vector getDefaultDSSSignatureAlgorithms() {
        return TlsUtils.a(new SignatureAndHashAlgorithm(2, 2));
    }

    public static Vector getDefaultECDSASignatureAlgorithms() {
        return TlsUtils.a(new SignatureAndHashAlgorithm(2, 3));
    }

    public static Vector getDefaultRSASignatureAlgorithms() {
        return TlsUtils.a(new SignatureAndHashAlgorithm(2, 1));
    }

    public static Vector getDefaultSupportedSignatureAlgorithms() {
        short[] sArray = new short[]{2, 3, 4, 5, 6};
        short[] sArray2 = new short[]{1, 2, 3};
        Vector<SignatureAndHashAlgorithm> vector = new Vector<SignatureAndHashAlgorithm>();
        for (int i2 = 0; i2 < sArray2.length; ++i2) {
            for (int i3 = 0; i3 < sArray.length; ++i3) {
                vector.addElement(new SignatureAndHashAlgorithm(sArray[i3], sArray2[i2]));
            }
        }
        return vector;
    }

    public static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(TlsContext context, TlsSignerCredentials signerCredentials) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        if (TlsUtils.isTLSv12(context) && (signatureAndHashAlgorithm = signerCredentials.getSignatureAndHashAlgorithm()) == null) {
            throw new TlsFatalAlert(80);
        }
        return signatureAndHashAlgorithm;
    }

    public static byte[] getExtensionData(Hashtable extensions, Integer extensionType) {
        return extensions == null ? null : (byte[])extensions.get(extensionType);
    }

    public static boolean hasExpectedEmptyExtensionData(Hashtable extensions, Integer extensionType, short alertDescription) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, extensionType);
        if (byArray == null) {
            return false;
        }
        if (byArray.length != 0) {
            throw new TlsFatalAlert(alertDescription);
        }
        return true;
    }

    public static TlsSession importSession(byte[] sessionID, SessionParameters sessionParameters) {
        return new q(sessionID, sessionParameters);
    }

    public static boolean isSignatureAlgorithmsExtensionAllowed(ProtocolVersion clientVersion) {
        return ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(clientVersion.getEquivalentTLSVersion());
    }

    public static void addSignatureAlgorithmsExtension(Hashtable extensions, Vector supportedSignatureAlgorithms) throws IOException {
        extensions.put(EXT_signature_algorithms, TlsUtils.createSignatureAlgorithmsExtension(supportedSignatureAlgorithms));
    }

    public static Vector getSignatureAlgorithmsExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_signature_algorithms);
        return byArray == null ? null : TlsUtils.readSignatureAlgorithmsExtension(byArray);
    }

    public static byte[] createSignatureAlgorithmsExtension(Vector supportedSignatureAlgorithms) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.encodeSupportedSignatureAlgorithms(supportedSignatureAlgorithms, false, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Vector readSignatureAlgorithmsExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        Vector vector = TlsUtils.parseSupportedSignatureAlgorithms(false, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return vector;
    }

    public static void encodeSupportedSignatureAlgorithms(Vector supportedSignatureAlgorithms, boolean allowAnonymous, OutputStream output) throws IOException {
        if (supportedSignatureAlgorithms == null || supportedSignatureAlgorithms.size() < 1 || supportedSignatureAlgorithms.size() >= 32768) {
            throw new IllegalArgumentException("'supportedSignatureAlgorithms' must have length from 1 to (2^15 - 1)");
        }
        int n2 = 2 * supportedSignatureAlgorithms.size();
        TlsUtils.checkUint16(n2);
        TlsUtils.writeUint16(n2, output);
        for (int i2 = 0; i2 < supportedSignatureAlgorithms.size(); ++i2) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i2);
            if (!allowAnonymous && signatureAndHashAlgorithm.getSignature() == 0) {
                throw new IllegalArgumentException("SignatureAlgorithm.anonymous MUST NOT appear in the signature_algorithms extension");
            }
            signatureAndHashAlgorithm.encode(output);
        }
    }

    public static Vector parseSupportedSignatureAlgorithms(boolean allowAnonymous, InputStream input) throws IOException {
        int n2 = TlsUtils.readUint16(input);
        if (n2 < 2 || (n2 & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int n3 = n2 / 2;
        Vector<SignatureAndHashAlgorithm> vector = new Vector<SignatureAndHashAlgorithm>(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = SignatureAndHashAlgorithm.parse(input);
            if (!allowAnonymous && signatureAndHashAlgorithm.getSignature() == 0) {
                throw new TlsFatalAlert(47);
            }
            vector.addElement(signatureAndHashAlgorithm);
        }
        return vector;
    }

    public static void verifySupportedSignatureAlgorithm(Vector supportedSignatureAlgorithms, SignatureAndHashAlgorithm signatureAlgorithm) throws IOException {
        if (supportedSignatureAlgorithms == null || supportedSignatureAlgorithms.size() < 1 || supportedSignatureAlgorithms.size() >= 32768) {
            throw new IllegalArgumentException("'supportedSignatureAlgorithms' must have length from 1 to (2^15 - 1)");
        }
        if (signatureAlgorithm == null) {
            throw new IllegalArgumentException("'signatureAlgorithm' cannot be null");
        }
        if (signatureAlgorithm.getSignature() != 0) {
            for (int i2 = 0; i2 < supportedSignatureAlgorithms.size(); ++i2) {
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i2);
                if (signatureAndHashAlgorithm.getHash() != signatureAlgorithm.getHash() || signatureAndHashAlgorithm.getSignature() != signatureAlgorithm.getSignature()) continue;
                return;
            }
        }
        throw new TlsFatalAlert(47);
    }

    public static byte[] PRF(TlsContext context, byte[] secret, String asciiLabel, byte[] seed, int size) {
        ProtocolVersion protocolVersion = context.getServerVersion();
        if (protocolVersion.isSSL()) {
            throw new IllegalStateException("No PRF available for SSLv3 session");
        }
        byte[] byArray = Strings.toByteArray(asciiLabel);
        byte[] byArray2 = TlsUtils.a(byArray, seed);
        int n2 = context.getSecurityParameters().getPrfAlgorithm();
        if (n2 == 0) {
            return TlsUtils.a(secret, byArray, byArray2, size);
        }
        Digest digest = TlsUtils.createPRFHash(n2);
        byte[] byArray3 = new byte[size];
        TlsUtils.a(digest, secret, byArray2, byArray3);
        return byArray3;
    }

    public static byte[] PRF_legacy(byte[] secret, String asciiLabel, byte[] seed, int size) {
        byte[] byArray = Strings.toByteArray(asciiLabel);
        byte[] byArray2 = TlsUtils.a(byArray, seed);
        return TlsUtils.a(secret, byArray, byArray2, size);
    }

    static byte[] a(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        int n3 = (byArray.length + 1) / 2;
        byte[] byArray4 = new byte[n3];
        byte[] byArray5 = new byte[n3];
        System.arraycopy(byArray, 0, byArray4, 0, n3);
        System.arraycopy(byArray, byArray.length - n3, byArray5, 0, n3);
        byte[] byArray6 = new byte[n2];
        byte[] byArray7 = new byte[n2];
        TlsUtils.a(TlsUtils.createHash((short)1), byArray4, byArray3, byArray6);
        TlsUtils.a(TlsUtils.createHash((short)2), byArray5, byArray3, byArray7);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = i2;
            byArray6[n4] = (byte)(byArray6[n4] ^ byArray7[i2]);
        }
        return byArray6;
    }

    static byte[] a(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    static void a(Digest digest, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        HMac hMac = new HMac(digest);
        hMac.init(new KeyParameter(byArray));
        byte[] byArray4 = byArray2;
        int n2 = digest.getDigestSize();
        int n3 = (byArray3.length + n2 - 1) / n2;
        byte[] byArray5 = new byte[hMac.getMacSize()];
        byte[] byArray6 = new byte[hMac.getMacSize()];
        for (int i2 = 0; i2 < n3; ++i2) {
            hMac.update(byArray4, 0, byArray4.length);
            hMac.doFinal(byArray5, 0);
            byArray4 = byArray5;
            hMac.update(byArray4, 0, byArray4.length);
            hMac.update(byArray2, 0, byArray2.length);
            hMac.doFinal(byArray6, 0);
            System.arraycopy(byArray6, 0, byArray3, n2 * i2, Math.min(n2, byArray3.length - n2 * i2));
        }
    }

    static void a(com.enterprisedt.bouncycastle.asn1.x509.Certificate certificate, int n2) throws IOException {
        int n3;
        KeyUsage keyUsage;
        Extensions extensions = certificate.getTBSCertificate().getExtensions();
        if (extensions != null && (keyUsage = KeyUsage.fromExtensions(extensions)) != null && ((n3 = keyUsage.getBytes()[0] & 0xFF) & n2) != n2) {
            throw new TlsFatalAlert(46);
        }
    }

    static byte[] a(TlsContext tlsContext, int n2) {
        SecurityParameters securityParameters = tlsContext.getSecurityParameters();
        byte[] byArray = securityParameters.getMasterSecret();
        byte[] byArray2 = TlsUtils.a(securityParameters.getServerRandom(), securityParameters.getClientRandom());
        if (TlsUtils.isSSL(tlsContext)) {
            return TlsUtils.a(byArray, byArray2, n2);
        }
        return TlsUtils.PRF(tlsContext, byArray, "key expansion", byArray2, n2);
    }

    static byte[] a(byte[] byArray, byte[] byArray2, int n2) {
        Digest digest = TlsUtils.createHash((short)1);
        Digest digest2 = TlsUtils.createHash((short)2);
        int n3 = digest.getDigestSize();
        byte[] byArray3 = new byte[digest2.getDigestSize()];
        byte[] byArray4 = new byte[n2 + n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            byte[] byArray5 = c[n4];
            digest2.update(byArray5, 0, byArray5.length);
            digest2.update(byArray, 0, byArray.length);
            digest2.update(byArray2, 0, byArray2.length);
            digest2.doFinal(byArray3, 0);
            digest.update(byArray, 0, byArray.length);
            digest.update(byArray3, 0, byArray3.length);
            digest.doFinal(byArray4, n5);
            n5 += n3;
            ++n4;
        }
        return Arrays.copyOfRange(byArray4, 0, n2);
    }

    static byte[] a(TlsContext tlsContext, byte[] byArray) {
        SecurityParameters securityParameters = tlsContext.getSecurityParameters();
        byte[] byArray2 = securityParameters.o ? securityParameters.getSessionHash() : TlsUtils.a(securityParameters.getClientRandom(), securityParameters.getServerRandom());
        if (TlsUtils.isSSL(tlsContext)) {
            return TlsUtils.b(byArray, byArray2);
        }
        String string = securityParameters.o ? "extended master secret" : "master secret";
        return TlsUtils.PRF(tlsContext, byArray, string, byArray2, 48);
    }

    static byte[] b(byte[] byArray, byte[] byArray2) {
        Digest digest = TlsUtils.createHash((short)1);
        Digest digest2 = TlsUtils.createHash((short)2);
        int n2 = digest.getDigestSize();
        byte[] byArray3 = new byte[digest2.getDigestSize()];
        byte[] byArray4 = new byte[n2 * 3];
        int n3 = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            byte[] byArray5 = c[i2];
            digest2.update(byArray5, 0, byArray5.length);
            digest2.update(byArray, 0, byArray.length);
            digest2.update(byArray2, 0, byArray2.length);
            digest2.doFinal(byArray3, 0);
            digest.update(byArray, 0, byArray.length);
            digest.update(byArray3, 0, byArray3.length);
            digest.doFinal(byArray4, n3);
            n3 += n2;
        }
        return byArray4;
    }

    static byte[] a(TlsContext tlsContext, String string, byte[] byArray) {
        if (TlsUtils.isSSL(tlsContext)) {
            return byArray;
        }
        SecurityParameters securityParameters = tlsContext.getSecurityParameters();
        byte[] byArray2 = securityParameters.getMasterSecret();
        int n2 = securityParameters.getVerifyDataLength();
        return TlsUtils.PRF(tlsContext, byArray2, string, byArray, n2);
    }

    public static Digest createHash(short hashAlgorithm) {
        switch (hashAlgorithm) {
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA224Digest();
            }
            case 4: {
                return new SHA256Digest();
            }
            case 5: {
                return new SHA384Digest();
            }
            case 6: {
                return new SHA512Digest();
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm");
    }

    public static Digest createHash(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        return signatureAndHashAlgorithm == null ? new b() : TlsUtils.createHash(signatureAndHashAlgorithm.getHash());
    }

    public static Digest cloneHash(short hashAlgorithm, Digest hash) {
        switch (hashAlgorithm) {
            case 1: {
                return new MD5Digest((MD5Digest)hash);
            }
            case 2: {
                return new SHA1Digest((SHA1Digest)hash);
            }
            case 3: {
                return new SHA224Digest((SHA224Digest)hash);
            }
            case 4: {
                return new SHA256Digest((SHA256Digest)hash);
            }
            case 5: {
                return new SHA384Digest((SHA384Digest)hash);
            }
            case 6: {
                return new SHA512Digest((SHA512Digest)hash);
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm");
    }

    public static Digest createPRFHash(int prfAlgorithm) {
        switch (prfAlgorithm) {
            case 0: {
                return new b();
            }
        }
        return TlsUtils.createHash(TlsUtils.getHashAlgorithmForPRFAlgorithm(prfAlgorithm));
    }

    public static Digest clonePRFHash(int prfAlgorithm, Digest hash) {
        switch (prfAlgorithm) {
            case 0: {
                return new b((b)hash);
            }
        }
        return TlsUtils.cloneHash(TlsUtils.getHashAlgorithmForPRFAlgorithm(prfAlgorithm), hash);
    }

    public static short getHashAlgorithmForPRFAlgorithm(int prfAlgorithm) {
        switch (prfAlgorithm) {
            case 0: {
                throw new IllegalArgumentException("legacy PRF not a valid algorithm");
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
        }
        throw new IllegalArgumentException("unknown PRFAlgorithm");
    }

    public static ASN1ObjectIdentifier getOIDForHashAlgorithm(short hashAlgorithm) {
        switch (hashAlgorithm) {
            case 1: {
                return PKCSObjectIdentifiers.md5;
            }
            case 2: {
                return X509ObjectIdentifiers.id_SHA1;
            }
            case 3: {
                return NISTObjectIdentifiers.id_sha224;
            }
            case 4: {
                return NISTObjectIdentifiers.id_sha256;
            }
            case 5: {
                return NISTObjectIdentifiers.id_sha384;
            }
            case 6: {
                return NISTObjectIdentifiers.id_sha512;
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm");
    }

    static short a(Certificate certificate, Certificate certificate2) throws IOException {
        if (certificate.isEmpty()) {
            return -1;
        }
        com.enterprisedt.bouncycastle.asn1.x509.Certificate certificate3 = certificate.getCertificateAt(0);
        SubjectPublicKeyInfo subjectPublicKeyInfo = certificate3.getSubjectPublicKeyInfo();
        try {
            AsymmetricKeyParameter asymmetricKeyParameter = PublicKeyFactory.createKey(subjectPublicKeyInfo);
            if (asymmetricKeyParameter.isPrivate()) {
                throw new TlsFatalAlert(80);
            }
            if (asymmetricKeyParameter instanceof RSAKeyParameters) {
                TlsUtils.a(certificate3, 128);
                return 1;
            }
            if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
                TlsUtils.a(certificate3, 128);
                return 2;
            }
            if (asymmetricKeyParameter instanceof ECPublicKeyParameters) {
                TlsUtils.a(certificate3, 128);
                return 64;
            }
            throw new TlsFatalAlert(43);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(43, (Throwable)exception);
        }
    }

    static void a(TlsHandshakeHash tlsHandshakeHash, Vector vector) {
        if (vector != null) {
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)vector.elementAt(i2);
                short s2 = signatureAndHashAlgorithm.getHash();
                if (HashAlgorithm.isPrivate(s2)) continue;
                tlsHandshakeHash.trackHashAlgorithm(s2);
            }
        }
    }

    public static boolean hasSigningCapability(short clientCertificateType) {
        switch (clientCertificateType) {
            case 1: 
            case 2: 
            case 64: {
                return true;
            }
        }
        return false;
    }

    public static TlsSigner createTlsSigner(short clientCertificateType) {
        switch (clientCertificateType) {
            case 2: {
                return new TlsDSSSigner();
            }
            case 64: {
                return new TlsECDSASigner();
            }
            case 1: {
                return new TlsRSASigner();
            }
        }
        throw new IllegalArgumentException("'clientCertificateType' is not a type with signing capability");
    }

    private static byte[][] a() {
        int n2 = 10;
        byte[][] byArrayArray = new byte[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            byte[] byArray = new byte[i2 + 1];
            Arrays.fill(byArray, (byte)(65 + i2));
            byArrayArray[i2] = byArray;
        }
        return byArrayArray;
    }

    private static Vector a(Object object) {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(object);
        return vector;
    }

    public static int getCipherType(int ciphersuite) throws IOException {
        switch (TlsUtils.getEncryptionAlgorithm(ciphersuite)) {
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 103: 
            case 104: {
                return 2;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                return 1;
            }
            case 0: 
            case 1: 
            case 2: {
                return 0;
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static int getEncryptionAlgorithm(int ciphersuite) throws IOException {
        switch (ciphersuite) {
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 139: 
            case 143: 
            case 147: 
            case 49155: 
            case 49160: 
            case 49165: 
            case 49170: 
            case 49175: 
            case 49178: 
            case 49179: 
            case 49180: 
            case 49204: {
                return 7;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 108: 
            case 140: 
            case 144: 
            case 148: 
            case 174: 
            case 178: 
            case 182: 
            case 49156: 
            case 49161: 
            case 49166: 
            case 49171: 
            case 49176: 
            case 49181: 
            case 49182: 
            case 49183: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49205: 
            case 49207: {
                return 8;
            }
            case 49308: 
            case 49310: 
            case 49316: 
            case 49318: 
            case 49324: {
                return 15;
            }
            case 49312: 
            case 49314: 
            case 49320: 
            case 49322: 
            case 49326: {
                return 16;
            }
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 166: 
            case 168: 
            case 170: 
            case 172: 
            case 49195: 
            case 49197: 
            case 49199: 
            case 49201: {
                return 10;
            }
            case 65280: 
            case 65282: 
            case 65284: 
            case 65296: 
            case 65298: 
            case 65300: {
                return 103;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 141: 
            case 145: 
            case 149: 
            case 175: 
            case 179: 
            case 183: 
            case 49157: 
            case 49162: 
            case 49167: 
            case 49172: 
            case 49177: 
            case 49184: 
            case 49185: 
            case 49186: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49206: 
            case 49208: {
                return 9;
            }
            case 49309: 
            case 49311: 
            case 49317: 
            case 49319: 
            case 49325: {
                return 17;
            }
            case 49313: 
            case 49315: 
            case 49321: 
            case 49323: 
            case 49327: {
                return 18;
            }
            case 157: 
            case 159: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 169: 
            case 171: 
            case 173: 
            case 49196: 
            case 49198: 
            case 49200: 
            case 49202: {
                return 11;
            }
            case 65281: 
            case 65283: 
            case 65285: 
            case 65297: 
            case 65299: 
            case 65301: {
                return 104;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49300: 
            case 49302: 
            case 49304: 
            case 49306: {
                return 12;
            }
            case 49274: 
            case 49276: 
            case 49278: 
            case 49280: 
            case 49282: 
            case 49284: 
            case 49286: 
            case 49288: 
            case 49290: 
            case 49292: 
            case 49294: 
            case 49296: 
            case 49298: {
                return 19;
            }
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                return 13;
            }
            case 49275: 
            case 49277: 
            case 49279: 
            case 49281: 
            case 49283: 
            case 49285: 
            case 49287: 
            case 49289: 
            case 49291: 
            case 49293: 
            case 49295: 
            case 49297: 
            case 49299: {
                return 20;
            }
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: {
                return 21;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 44: 
            case 45: 
            case 46: 
            case 49153: 
            case 49158: 
            case 49163: 
            case 49168: 
            case 49173: 
            case 49209: {
                return 0;
            }
            case 59: 
            case 176: 
            case 180: 
            case 184: 
            case 49210: {
                return 0;
            }
            case 177: 
            case 181: 
            case 185: 
            case 49211: {
                return 0;
            }
            case 4: 
            case 24: {
                return 2;
            }
            case 5: 
            case 138: 
            case 142: 
            case 146: 
            case 49154: 
            case 49159: 
            case 49164: 
            case 49169: 
            case 49174: 
            case 49203: {
                return 2;
            }
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: {
                return 14;
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static int getKeyExchangeAlgorithm(int ciphersuite) throws IOException {
        switch (ciphersuite) {
            case 24: 
            case 27: 
            case 52: 
            case 58: 
            case 70: 
            case 108: 
            case 109: 
            case 137: 
            case 155: 
            case 166: 
            case 167: 
            case 191: 
            case 197: 
            case 49284: 
            case 49285: {
                return 11;
            }
            case 13: 
            case 48: 
            case 54: 
            case 62: 
            case 66: 
            case 104: 
            case 133: 
            case 151: 
            case 164: 
            case 165: 
            case 187: 
            case 193: 
            case 49282: 
            case 49283: {
                return 7;
            }
            case 16: 
            case 49: 
            case 55: 
            case 63: 
            case 67: 
            case 105: 
            case 134: 
            case 152: 
            case 160: 
            case 161: 
            case 188: 
            case 194: 
            case 49278: 
            case 49279: {
                return 9;
            }
            case 19: 
            case 50: 
            case 56: 
            case 64: 
            case 68: 
            case 106: 
            case 135: 
            case 153: 
            case 162: 
            case 163: 
            case 189: 
            case 195: 
            case 49280: 
            case 49281: {
                return 3;
            }
            case 45: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 170: 
            case 171: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 49296: 
            case 49297: 
            case 49302: 
            case 49303: 
            case 49318: 
            case 49319: 
            case 49322: 
            case 49323: 
            case 52397: 
            case 65298: 
            case 65299: {
                return 14;
            }
            case 22: 
            case 51: 
            case 57: 
            case 69: 
            case 103: 
            case 107: 
            case 136: 
            case 154: 
            case 158: 
            case 159: 
            case 190: 
            case 196: 
            case 49276: 
            case 49277: 
            case 49310: 
            case 49311: 
            case 49314: 
            case 49315: 
            case 52394: 
            case 65280: 
            case 65281: {
                return 5;
            }
            case 49173: 
            case 49174: 
            case 49175: 
            case 49176: 
            case 49177: {
                return 20;
            }
            case 49153: 
            case 49154: 
            case 49155: 
            case 49156: 
            case 49157: 
            case 49189: 
            case 49190: 
            case 49197: 
            case 49198: 
            case 49268: 
            case 49269: 
            case 49288: 
            case 49289: {
                return 16;
            }
            case 49163: 
            case 49164: 
            case 49165: 
            case 49166: 
            case 49167: 
            case 49193: 
            case 49194: 
            case 49201: 
            case 49202: 
            case 49272: 
            case 49273: 
            case 49292: 
            case 49293: {
                return 18;
            }
            case 49158: 
            case 49159: 
            case 49160: 
            case 49161: 
            case 49162: 
            case 49187: 
            case 49188: 
            case 49195: 
            case 49196: 
            case 49266: 
            case 49267: 
            case 49286: 
            case 49287: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52393: 
            case 65284: 
            case 65285: {
                return 17;
            }
            case 49203: 
            case 49204: 
            case 49205: 
            case 49206: 
            case 49207: 
            case 49208: 
            case 49209: 
            case 49210: 
            case 49211: 
            case 49306: 
            case 49307: 
            case 52396: 
            case 65300: 
            case 65301: {
                return 24;
            }
            case 49168: 
            case 49169: 
            case 49170: 
            case 49171: 
            case 49172: 
            case 49191: 
            case 49192: 
            case 49199: 
            case 49200: 
            case 49270: 
            case 49271: 
            case 49290: 
            case 49291: 
            case 52392: 
            case 65282: 
            case 65283: {
                return 19;
            }
            case 44: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 168: 
            case 169: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 49294: 
            case 49295: 
            case 49300: 
            case 49301: 
            case 49316: 
            case 49317: 
            case 49320: 
            case 49321: 
            case 52395: 
            case 65296: 
            case 65297: {
                return 13;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 47: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 132: 
            case 150: 
            case 156: 
            case 157: 
            case 186: 
            case 192: 
            case 49274: 
            case 49275: 
            case 49308: 
            case 49309: 
            case 49312: 
            case 49313: {
                return 1;
            }
            case 46: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 172: 
            case 173: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 49298: 
            case 49299: 
            case 49304: 
            case 49305: 
            case 52398: {
                return 15;
            }
            case 49178: 
            case 49181: 
            case 49184: {
                return 21;
            }
            case 49180: 
            case 49183: 
            case 49186: {
                return 22;
            }
            case 49179: 
            case 49182: 
            case 49185: {
                return 23;
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static int getMACAlgorithm(int ciphersuite) throws IOException {
        switch (ciphersuite) {
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 49195: 
            case 49196: 
            case 49197: 
            case 49198: 
            case 49199: 
            case 49200: 
            case 49201: 
            case 49202: 
            case 49274: 
            case 49275: 
            case 49276: 
            case 49277: 
            case 49278: 
            case 49279: 
            case 49280: 
            case 49281: 
            case 49282: 
            case 49283: 
            case 49284: 
            case 49285: 
            case 49286: 
            case 49287: 
            case 49288: 
            case 49289: 
            case 49290: 
            case 49291: 
            case 49292: 
            case 49293: 
            case 49294: 
            case 49295: 
            case 49296: 
            case 49297: 
            case 49298: 
            case 49299: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: 
            case 65280: 
            case 65281: 
            case 65282: 
            case 65283: 
            case 65284: 
            case 65285: 
            case 65296: 
            case 65297: 
            case 65298: 
            case 65299: 
            case 65300: 
            case 65301: {
                return 0;
            }
            case 1: 
            case 4: 
            case 24: {
                return 1;
            }
            case 2: 
            case 5: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 49153: 
            case 49154: 
            case 49155: 
            case 49156: 
            case 49157: 
            case 49158: 
            case 49159: 
            case 49160: 
            case 49161: 
            case 49162: 
            case 49163: 
            case 49164: 
            case 49165: 
            case 49166: 
            case 49167: 
            case 49168: 
            case 49169: 
            case 49170: 
            case 49171: 
            case 49172: 
            case 49173: 
            case 49174: 
            case 49175: 
            case 49176: 
            case 49177: 
            case 49178: 
            case 49179: 
            case 49180: 
            case 49181: 
            case 49182: 
            case 49183: 
            case 49184: 
            case 49185: 
            case 49186: 
            case 49203: 
            case 49204: 
            case 49205: 
            case 49206: 
            case 49209: {
                return 2;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 174: 
            case 176: 
            case 178: 
            case 180: 
            case 182: 
            case 184: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49207: 
            case 49210: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49300: 
            case 49302: 
            case 49304: 
            case 49306: {
                return 3;
            }
            case 175: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49208: 
            case 49211: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                return 4;
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static ProtocolVersion getMinimumVersion(int ciphersuite) {
        switch (ciphersuite) {
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49188: 
            case 49189: 
            case 49190: 
            case 49191: 
            case 49192: 
            case 49193: 
            case 49194: 
            case 49195: 
            case 49196: 
            case 49197: 
            case 49198: 
            case 49199: 
            case 49200: 
            case 49201: 
            case 49202: 
            case 49266: 
            case 49267: 
            case 49268: 
            case 49269: 
            case 49270: 
            case 49271: 
            case 49272: 
            case 49273: 
            case 49274: 
            case 49275: 
            case 49276: 
            case 49277: 
            case 49278: 
            case 49279: 
            case 49280: 
            case 49281: 
            case 49282: 
            case 49283: 
            case 49284: 
            case 49285: 
            case 49286: 
            case 49287: 
            case 49288: 
            case 49289: 
            case 49290: 
            case 49291: 
            case 49292: 
            case 49293: 
            case 49294: 
            case 49295: 
            case 49296: 
            case 49297: 
            case 49298: 
            case 49299: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: 
            case 65280: 
            case 65281: 
            case 65282: 
            case 65283: 
            case 65284: 
            case 65285: 
            case 65296: 
            case 65297: 
            case 65298: 
            case 65299: 
            case 65300: 
            case 65301: {
                return ProtocolVersion.TLSv12;
            }
        }
        return ProtocolVersion.SSLv3;
    }

    public static boolean isAEADCipherSuite(int ciphersuite) throws IOException {
        return 2 == TlsUtils.getCipherType(ciphersuite);
    }

    public static boolean isBlockCipherSuite(int ciphersuite) throws IOException {
        return 1 == TlsUtils.getCipherType(ciphersuite);
    }

    public static boolean isStreamCipherSuite(int ciphersuite) throws IOException {
        return 0 == TlsUtils.getCipherType(ciphersuite);
    }

    public static boolean isValidCipherSuiteForSignatureAlgorithms(int cipherSuite, Vector sigAlgs) {
        int n2;
        try {
            n2 = TlsUtils.getKeyExchangeAlgorithm(cipherSuite);
        }
        catch (IOException iOException) {
            return true;
        }
        switch (n2) {
            case 11: 
            case 12: 
            case 20: {
                return sigAlgs.contains(Shorts.valueOf((short)0));
            }
            case 5: 
            case 6: 
            case 19: 
            case 23: {
                return sigAlgs.contains(Shorts.valueOf((short)1));
            }
            case 3: 
            case 4: 
            case 22: {
                return sigAlgs.contains(Shorts.valueOf((short)2));
            }
            case 17: {
                return sigAlgs.contains(Shorts.valueOf((short)3));
            }
        }
        return true;
    }

    public static boolean isValidCipherSuiteForVersion(int cipherSuite, ProtocolVersion serverVersion) {
        return TlsUtils.getMinimumVersion(cipherSuite).isEqualOrEarlierVersionOf(serverVersion.getEquivalentTLSVersion());
    }

    public static Vector getUsableSignatureAlgorithms(Vector sigHashAlgs) {
        if (sigHashAlgs == null) {
            return TlsUtils.getAllSignatureAlgorithms();
        }
        Vector<Short> vector = new Vector<Short>(4);
        vector.addElement(Shorts.valueOf((short)0));
        for (int i2 = 0; i2 < sigHashAlgs.size(); ++i2) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)sigHashAlgs.elementAt(i2);
            Short s2 = Shorts.valueOf(signatureAndHashAlgorithm.getSignature());
            if (vector.contains(s2)) continue;
            vector.addElement(s2);
        }
        return vector;
    }
}

