/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.util;

import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.DERNull;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.RSAPublicKey;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.DSAParameter;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.asn1.x9.X962Parameters;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECPoint;
import com.enterprisedt.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.DSAParameters;
import com.enterprisedt.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import java.io.IOException;

public class SubjectPublicKeyInfoFactory {
    private SubjectPublicKeyInfoFactory() {
    }

    public static SubjectPublicKeyInfo createSubjectPublicKeyInfo(AsymmetricKeyParameter publicKey) throws IOException {
        if (publicKey instanceof RSAKeyParameters) {
            RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)publicKey;
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new RSAPublicKey(rSAKeyParameters.getModulus(), rSAKeyParameters.getExponent()));
        }
        if (publicKey instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters dSAPublicKeyParameters = (DSAPublicKeyParameters)publicKey;
            DSAParameter dSAParameter = null;
            DSAParameters dSAParameters = dSAPublicKeyParameters.getParameters();
            if (dSAParameters != null) {
                dSAParameter = new DSAParameter(dSAParameters.getP(), dSAParameters.getQ(), dSAParameters.getG());
            }
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, dSAParameter), new ASN1Integer(dSAPublicKeyParameters.getY()));
        }
        if (publicKey instanceof ECPublicKeyParameters) {
            ASN1Object aSN1Object;
            X962Parameters x962Parameters;
            ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)publicKey;
            ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
            if (eCDomainParameters == null) {
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
            } else if (eCDomainParameters instanceof ECNamedDomainParameters) {
                x962Parameters = new X962Parameters(((ECNamedDomainParameters)eCDomainParameters).getName());
            } else {
                aSN1Object = new X9ECParameters(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
                x962Parameters = new X962Parameters((X9ECParameters)aSN1Object);
            }
            aSN1Object = (ASN1OctetString)new X9ECPoint(eCPublicKeyParameters.getQ()).toASN1Primitive();
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), ((ASN1OctetString)aSN1Object).getOctets());
        }
        throw new IOException("key parameters not recognised.");
    }
}

