/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.i18n;

import com.enterprisedt.bouncycastle.i18n.LocaleString;
import com.enterprisedt.bouncycastle.i18n.MissingEntryException;
import com.enterprisedt.bouncycastle.i18n.filter.Filter;
import com.enterprisedt.bouncycastle.i18n.filter.TrustedInput;
import com.enterprisedt.bouncycastle.i18n.filter.UntrustedInput;
import com.enterprisedt.bouncycastle.i18n.filter.UntrustedUrlInput;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class LocalizedMessage {
    protected final String id;
    protected final String resource;
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    protected String encoding = "ISO-8859-1";
    protected FilteredArguments arguments;
    protected FilteredArguments extraArgs = null;
    protected Filter filter = null;
    protected ClassLoader loader = null;

    public LocalizedMessage(String resource, String id) throws NullPointerException {
        if (resource == null || id == null) {
            throw new NullPointerException();
        }
        this.id = id;
        this.resource = resource;
        this.arguments = new FilteredArguments();
    }

    public LocalizedMessage(String resource, String id, String encoding) throws NullPointerException, UnsupportedEncodingException {
        if (resource == null || id == null) {
            throw new NullPointerException();
        }
        this.id = id;
        this.resource = resource;
        this.arguments = new FilteredArguments();
        if (!Charset.isSupported(encoding)) {
            throw new UnsupportedEncodingException("The encoding \"" + encoding + "\" is not supported.");
        }
        this.encoding = encoding;
    }

    public LocalizedMessage(String resource, String id, Object[] arguments) throws NullPointerException {
        if (resource == null || id == null || arguments == null) {
            throw new NullPointerException();
        }
        this.id = id;
        this.resource = resource;
        this.arguments = new FilteredArguments(arguments);
    }

    public LocalizedMessage(String resource, String id, String encoding, Object[] arguments) throws NullPointerException, UnsupportedEncodingException {
        if (resource == null || id == null || arguments == null) {
            throw new NullPointerException();
        }
        this.id = id;
        this.resource = resource;
        this.arguments = new FilteredArguments(arguments);
        if (!Charset.isSupported(encoding)) {
            throw new UnsupportedEncodingException("The encoding \"" + encoding + "\" is not supported.");
        }
        this.encoding = encoding;
    }

    public String getEntry(String key, Locale loc, TimeZone timezone) throws MissingEntryException {
        String string = this.id;
        if (key != null) {
            string = string + "." + key;
        }
        try {
            ResourceBundle resourceBundle = this.loader == null ? ResourceBundle.getBundle(this.resource, loc) : ResourceBundle.getBundle(this.resource, loc, this.loader);
            String string2 = resourceBundle.getString(string);
            if (!this.encoding.equals(DEFAULT_ENCODING)) {
                string2 = new String(string2.getBytes(DEFAULT_ENCODING), this.encoding);
            }
            if (!this.arguments.isEmpty()) {
                string2 = this.formatWithTimeZone(string2, this.arguments.getFilteredArgs(loc), loc, timezone);
            }
            string2 = this.addExtraArgs(string2, loc);
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            throw new MissingEntryException("Can't find entry " + string + " in resource file " + this.resource + ".", this.resource, string, loc, this.loader != null ? this.loader : this.getClassLoader());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    protected String formatWithTimeZone(String template, Object[] arguments, Locale locale, TimeZone timezone) {
        MessageFormat messageFormat = new MessageFormat(" ");
        messageFormat.setLocale(locale);
        messageFormat.applyPattern(template);
        if (!timezone.equals(TimeZone.getDefault())) {
            Format[] formatArray = messageFormat.getFormats();
            for (int i2 = 0; i2 < formatArray.length; ++i2) {
                if (!(formatArray[i2] instanceof DateFormat)) continue;
                DateFormat dateFormat = (DateFormat)formatArray[i2];
                dateFormat.setTimeZone(timezone);
                messageFormat.setFormat(i2, dateFormat);
            }
        }
        return messageFormat.format(arguments);
    }

    protected String addExtraArgs(String msg, Locale locale) {
        if (this.extraArgs != null) {
            StringBuffer stringBuffer = new StringBuffer(msg);
            Object[] objectArray = this.extraArgs.getFilteredArgs(locale);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                stringBuffer.append(objectArray[i2]);
            }
            msg = stringBuffer.toString();
        }
        return msg;
    }

    public void setFilter(Filter filter) {
        this.arguments.setFilter(filter);
        if (this.extraArgs != null) {
            this.extraArgs.setFilter(filter);
        }
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String getId() {
        return this.id;
    }

    public String getResource() {
        return this.resource;
    }

    public Object[] getArguments() {
        return this.arguments.getArguments();
    }

    public void setExtraArgument(Object extraArg) {
        this.setExtraArguments(new Object[]{extraArg});
    }

    public void setExtraArguments(Object[] extraArgs) {
        if (extraArgs != null) {
            this.extraArgs = new FilteredArguments(extraArgs);
            this.extraArgs.setFilter(this.filter);
        } else {
            this.extraArgs = null;
        }
    }

    public Object[] getExtraArgs() {
        return this.extraArgs == null ? null : this.extraArgs.getArguments();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Resource: \"").append(this.resource);
        stringBuffer.append("\" Id: \"").append(this.id).append("\"");
        stringBuffer.append(" Arguments: ").append(this.arguments.getArguments().length).append(" normal");
        if (this.extraArgs != null && this.extraArgs.getArguments().length > 0) {
            stringBuffer.append(", ").append(this.extraArgs.getArguments().length).append(" extra");
        }
        stringBuffer.append(" Encoding: ").append(this.encoding);
        stringBuffer.append(" ClassLoader: ").append(this.loader);
        return stringBuffer.toString();
    }

    protected class FilteredArguments {
        protected static final int NO_FILTER = 0;
        protected static final int FILTER = 1;
        protected static final int FILTER_URL = 2;
        protected Filter filter = null;
        protected boolean[] isLocaleSpecific;
        protected int[] argFilterType;
        protected Object[] arguments;
        protected Object[] unpackedArgs;
        protected Object[] filteredArgs;

        FilteredArguments() {
            this(new Object[0]);
        }

        FilteredArguments(Object[] args) {
            this.arguments = args;
            this.unpackedArgs = new Object[args.length];
            this.filteredArgs = new Object[args.length];
            this.isLocaleSpecific = new boolean[args.length];
            this.argFilterType = new int[args.length];
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (args[i2] instanceof TrustedInput) {
                    this.unpackedArgs[i2] = ((TrustedInput)args[i2]).getInput();
                    this.argFilterType[i2] = 0;
                } else if (args[i2] instanceof UntrustedInput) {
                    this.unpackedArgs[i2] = ((UntrustedInput)args[i2]).getInput();
                    this.argFilterType[i2] = args[i2] instanceof UntrustedUrlInput ? 2 : 1;
                } else {
                    this.unpackedArgs[i2] = args[i2];
                    this.argFilterType[i2] = 1;
                }
                this.isLocaleSpecific[i2] = this.unpackedArgs[i2] instanceof LocaleString;
            }
        }

        public boolean isEmpty() {
            return this.unpackedArgs.length == 0;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public Object[] getFilteredArgs(Locale locale) {
            Object[] objectArray = new Object[this.unpackedArgs.length];
            for (int i2 = 0; i2 < this.unpackedArgs.length; ++i2) {
                Object object;
                if (this.filteredArgs[i2] != null) {
                    object = this.filteredArgs[i2];
                } else {
                    object = this.unpackedArgs[i2];
                    if (this.isLocaleSpecific[i2]) {
                        object = ((LocaleString)object).getLocaleString(locale);
                        object = this.a(this.argFilterType[i2], object);
                    } else {
                        this.filteredArgs[i2] = object = this.a(this.argFilterType[i2], object);
                    }
                }
                objectArray[i2] = object;
            }
            return objectArray;
        }

        private Object a(int n2, Object object) {
            if (this.filter != null) {
                Object object2 = null == object ? "null" : object;
                switch (n2) {
                    case 0: {
                        return object2;
                    }
                    case 1: {
                        return this.filter.doFilter(object2.toString());
                    }
                    case 2: {
                        return this.filter.doFilterUrl(object2.toString());
                    }
                }
                return null;
            }
            return object;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public void setFilter(Filter filter) {
            if (filter != this.filter) {
                for (int i2 = 0; i2 < this.unpackedArgs.length; ++i2) {
                    this.filteredArgs[i2] = null;
                }
            }
            this.filter = filter;
        }
    }
}

