/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec;

import com.enterprisedt.bouncycastle.math.ec.AbstractECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.WNafUtil;
import java.math.BigInteger;

public class NafR2LMultiplier
extends AbstractECMultiplier {
    @Override
    protected ECPoint multiplyPositive(ECPoint p2, BigInteger k2) {
        int[] nArray = WNafUtil.generateCompactNaf(k2);
        ECPoint eCPoint = p2.getCurve().getInfinity();
        ECPoint eCPoint2 = p2;
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = nArray[i2];
            int n4 = n3 >> 16;
            eCPoint2 = eCPoint2.timesPow2(n2 += n3 & 0xFFFF);
            eCPoint = eCPoint.add(n4 < 0 ? eCPoint2.negate() : eCPoint2);
            n2 = 1;
        }
        return eCPoint;
    }
}

