/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec;

import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.ECPointMap;
import com.enterprisedt.bouncycastle.math.ec.PreCompCallback;
import com.enterprisedt.bouncycastle.math.ec.PreCompInfo;
import com.enterprisedt.bouncycastle.math.ec.WNafPreCompInfo;
import java.math.BigInteger;

public abstract class WNafUtil {
    public static final String PRECOMP_NAME = "bc_wnaf";
    private static final int[] a = new int[]{13, 41, 121, 337, 897, 2305};
    private static final byte[] b = new byte[0];
    private static final int[] c = new int[0];
    private static final ECPoint[] d = new ECPoint[0];

    public static int[] generateCompactNaf(BigInteger k2) {
        if (k2.bitLength() >>> 16 != 0) {
            throw new IllegalArgumentException("'k' must have bitlength < 2^16");
        }
        if (k2.signum() == 0) {
            return c;
        }
        BigInteger bigInteger = k2.shiftLeft(1).add(k2);
        int n2 = bigInteger.bitLength();
        int[] nArray = new int[n2 >> 1];
        BigInteger bigInteger2 = bigInteger.xor(k2);
        int n3 = n2 - 1;
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 1; i2 < n3; ++i2) {
            if (!bigInteger2.testBit(i2)) {
                ++n5;
                continue;
            }
            int n6 = k2.testBit(i2) ? -1 : 1;
            nArray[n4++] = n6 << 16 | n5;
            n5 = 1;
            ++i2;
        }
        nArray[n4++] = 0x10000 | n5;
        if (nArray.length > n4) {
            nArray = WNafUtil.a(nArray, n4);
        }
        return nArray;
    }

    public static int[] generateCompactWindowNaf(int width, BigInteger k2) {
        if (width == 2) {
            return WNafUtil.generateCompactNaf(k2);
        }
        if (width < 2 || width > 16) {
            throw new IllegalArgumentException("'width' must be in the range [2, 16]");
        }
        if (k2.bitLength() >>> 16 != 0) {
            throw new IllegalArgumentException("'k' must have bitlength < 2^16");
        }
        if (k2.signum() == 0) {
            return c;
        }
        int[] nArray = new int[k2.bitLength() / width + 1];
        int n2 = 1 << width;
        int n3 = n2 - 1;
        int n4 = n2 >>> 1;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        while (n6 <= k2.bitLength()) {
            if (k2.testBit(n6) == bl) {
                ++n6;
                continue;
            }
            k2 = k2.shiftRight(n6);
            int n7 = k2.intValue() & n3;
            if (bl) {
                ++n7;
            }
            boolean bl2 = bl = (n7 & n4) != 0;
            if (bl) {
                n7 -= n2;
            }
            int n8 = n5 > 0 ? n6 - 1 : n6;
            nArray[n5++] = n7 << 16 | n8;
            n6 = width;
        }
        if (nArray.length > n5) {
            nArray = WNafUtil.a(nArray, n5);
        }
        return nArray;
    }

    public static byte[] generateJSF(BigInteger g2, BigInteger h2) {
        int n2 = Math.max(g2.bitLength(), h2.bitLength()) + 1;
        byte[] byArray = new byte[n2];
        BigInteger bigInteger = g2;
        BigInteger bigInteger2 = h2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n4 | n5 || bigInteger.bitLength() > n6 || bigInteger2.bitLength() > n6) {
            int n7;
            int n8 = (bigInteger.intValue() >>> n6) + n4 & 7;
            int n9 = (bigInteger2.intValue() >>> n6) + n5 & 7;
            int n10 = n8 & 1;
            if (n10 != 0 && n8 + (n10 -= n8 & 2) == 4 && (n9 & 3) == 2) {
                n10 = -n10;
            }
            if ((n7 = n9 & 1) != 0 && n9 + (n7 -= n9 & 2) == 4 && (n8 & 3) == 2) {
                n7 = -n7;
            }
            if (n4 << 1 == 1 + n10) {
                n4 ^= 1;
            }
            if (n5 << 1 == 1 + n7) {
                n5 ^= 1;
            }
            if (++n6 == 30) {
                n6 = 0;
                bigInteger = bigInteger.shiftRight(30);
                bigInteger2 = bigInteger2.shiftRight(30);
            }
            byArray[n3++] = (byte)(n10 << 4 | n7 & 0xF);
        }
        if (byArray.length > n3) {
            byArray = WNafUtil.a(byArray, n3);
        }
        return byArray;
    }

    public static byte[] generateNaf(BigInteger k2) {
        if (k2.signum() == 0) {
            return b;
        }
        BigInteger bigInteger = k2.shiftLeft(1).add(k2);
        int n2 = bigInteger.bitLength() - 1;
        byte[] byArray = new byte[n2];
        BigInteger bigInteger2 = bigInteger.xor(k2);
        for (int i2 = 1; i2 < n2; ++i2) {
            if (!bigInteger2.testBit(i2)) continue;
            byArray[i2 - 1] = (byte)(k2.testBit(i2) ? -1 : 1);
            ++i2;
        }
        byArray[n2 - 1] = 1;
        return byArray;
    }

    public static byte[] generateWindowNaf(int width, BigInteger k2) {
        if (width == 2) {
            return WNafUtil.generateNaf(k2);
        }
        if (width < 2 || width > 8) {
            throw new IllegalArgumentException("'width' must be in the range [2, 8]");
        }
        if (k2.signum() == 0) {
            return b;
        }
        byte[] byArray = new byte[k2.bitLength() + 1];
        int n2 = 1 << width;
        int n3 = n2 - 1;
        int n4 = n2 >>> 1;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        while (n6 <= k2.bitLength()) {
            if (k2.testBit(n6) == bl) {
                ++n6;
                continue;
            }
            k2 = k2.shiftRight(n6);
            int n7 = k2.intValue() & n3;
            if (bl) {
                ++n7;
            }
            boolean bl2 = bl = (n7 & n4) != 0;
            if (bl) {
                n7 -= n2;
            }
            n5 += n5 > 0 ? n6 - 1 : n6;
            byArray[n5++] = (byte)n7;
            n6 = width;
        }
        if (byArray.length > n5) {
            byArray = WNafUtil.a(byArray, n5);
        }
        return byArray;
    }

    public static int getNafWeight(BigInteger k2) {
        if (k2.signum() == 0) {
            return 0;
        }
        BigInteger bigInteger = k2.shiftLeft(1).add(k2);
        BigInteger bigInteger2 = bigInteger.xor(k2);
        return bigInteger2.bitCount();
    }

    public static WNafPreCompInfo getWNafPreCompInfo(ECPoint p2) {
        return WNafUtil.getWNafPreCompInfo(p2.getCurve().getPreCompInfo(p2, PRECOMP_NAME));
    }

    public static WNafPreCompInfo getWNafPreCompInfo(PreCompInfo preCompInfo) {
        return preCompInfo instanceof WNafPreCompInfo ? (WNafPreCompInfo)preCompInfo : null;
    }

    public static int getWindowSize(int bits) {
        return WNafUtil.getWindowSize(bits, a);
    }

    public static int getWindowSize(int bits, int[] windowSizeCutoffs) {
        int n2;
        for (n2 = 0; n2 < windowSizeCutoffs.length && bits >= windowSizeCutoffs[n2]; ++n2) {
        }
        return n2 + 2;
    }

    public static ECPoint mapPointWithPrecomp(ECPoint p2, int width, final boolean includeNegated, final ECPointMap pointMap) {
        ECCurve eCCurve = p2.getCurve();
        final WNafPreCompInfo wNafPreCompInfo = WNafUtil.precompute(p2, width, includeNegated);
        ECPoint eCPoint = pointMap.map(p2);
        eCCurve.precompute(eCPoint, PRECOMP_NAME, new PreCompCallback(){

            @Override
            public PreCompInfo precompute(PreCompInfo existing) {
                Object object;
                WNafPreCompInfo wNafPreCompInfo2 = new WNafPreCompInfo();
                ECPoint eCPoint = wNafPreCompInfo.getTwice();
                if (eCPoint != null) {
                    object = pointMap.map(eCPoint);
                    wNafPreCompInfo2.setTwice((ECPoint)object);
                }
                object = wNafPreCompInfo.getPreComp();
                ECPoint[] eCPointArray = new ECPoint[((ECPoint[])object).length];
                for (int i2 = 0; i2 < ((ECPoint[])object).length; ++i2) {
                    eCPointArray[i2] = pointMap.map(object[i2]);
                }
                wNafPreCompInfo2.setPreComp(eCPointArray);
                if (includeNegated) {
                    ECPoint[] eCPointArray2 = new ECPoint[eCPointArray.length];
                    for (int i3 = 0; i3 < eCPointArray2.length; ++i3) {
                        eCPointArray2[i3] = eCPointArray[i3].negate();
                    }
                    wNafPreCompInfo2.setPreCompNeg(eCPointArray2);
                }
                return wNafPreCompInfo2;
            }
        });
        return eCPoint;
    }

    public static WNafPreCompInfo precompute(final ECPoint p2, final int width, final boolean includeNegated) {
        final ECCurve eCCurve = p2.getCurve();
        return (WNafPreCompInfo)eCCurve.precompute(p2, PRECOMP_NAME, new PreCompCallback(){

            @Override
            public PreCompInfo precompute(PreCompInfo existing) {
                int n2;
                int n3;
                WNafPreCompInfo wNafPreCompInfo = existing instanceof WNafPreCompInfo ? (WNafPreCompInfo)existing : null;
                if (this.a(wNafPreCompInfo, n3 = 1 << Math.max(0, width - 2), includeNegated)) {
                    return wNafPreCompInfo;
                }
                ECPoint[] eCPointArray = null;
                ECPoint[] eCPointArray2 = null;
                ECPoint eCPoint = null;
                if (wNafPreCompInfo != null) {
                    eCPointArray = wNafPreCompInfo.getPreComp();
                    eCPointArray2 = wNafPreCompInfo.getPreCompNeg();
                    eCPoint = wNafPreCompInfo.getTwice();
                }
                int n4 = 0;
                if (eCPointArray == null) {
                    eCPointArray = d;
                } else {
                    n4 = eCPointArray.length;
                }
                if (n4 < n3) {
                    eCPointArray = WNafUtil.b(eCPointArray, n3);
                    if (n3 == 1) {
                        eCPointArray[0] = p2.normalize();
                    } else {
                        n2 = n4;
                        if (n2 == 0) {
                            eCPointArray[0] = p2;
                            n2 = 1;
                        }
                        ECFieldElement eCFieldElement = null;
                        if (n3 == 2) {
                            eCPointArray[1] = p2.threeTimes();
                        } else {
                            ECPoint eCPoint2 = eCPoint;
                            ECPoint eCPoint3 = eCPointArray[n2 - 1];
                            if (eCPoint2 == null && !(eCPoint = (eCPoint2 = eCPointArray[0].twice())).isInfinity() && ECAlgorithms.isFpCurve(eCCurve) && eCCurve.getFieldSize() >= 64) {
                                switch (eCCurve.getCoordinateSystem()) {
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        eCFieldElement = eCPoint.getZCoord(0);
                                        eCPoint2 = eCCurve.createPoint(eCPoint.getXCoord().toBigInteger(), eCPoint.getYCoord().toBigInteger());
                                        ECFieldElement eCFieldElement2 = eCFieldElement.square();
                                        ECFieldElement eCFieldElement3 = eCFieldElement2.multiply(eCFieldElement);
                                        eCPoint3 = eCPoint3.scaleX(eCFieldElement2).scaleY(eCFieldElement3);
                                        if (n4 != 0) break;
                                        eCPointArray[0] = eCPoint3;
                                        break;
                                    }
                                }
                            }
                            while (n2 < n3) {
                                eCPointArray[n2++] = eCPoint3 = eCPoint3.add(eCPoint2);
                            }
                        }
                        eCCurve.normalizeAll(eCPointArray, n4, n3 - n4, eCFieldElement);
                    }
                }
                if (includeNegated) {
                    if (eCPointArray2 == null) {
                        n2 = 0;
                        eCPointArray2 = new ECPoint[n3];
                    } else {
                        n2 = eCPointArray2.length;
                        if (n2 < n3) {
                            eCPointArray2 = WNafUtil.b(eCPointArray2, n3);
                        }
                    }
                    while (n2 < n3) {
                        eCPointArray2[n2] = eCPointArray[n2].negate();
                        ++n2;
                    }
                }
                WNafPreCompInfo wNafPreCompInfo2 = new WNafPreCompInfo();
                wNafPreCompInfo2.setPreComp(eCPointArray);
                wNafPreCompInfo2.setPreCompNeg(eCPointArray2);
                wNafPreCompInfo2.setTwice(eCPoint);
                return wNafPreCompInfo2;
            }

            private boolean a(WNafPreCompInfo wNafPreCompInfo, int n2, boolean bl) {
                return wNafPreCompInfo != null && this.a(wNafPreCompInfo.getPreComp(), n2) && (!bl || this.a(wNafPreCompInfo.getPreCompNeg(), n2));
            }

            private boolean a(ECPoint[] eCPointArray, int n2) {
                return eCPointArray != null && eCPointArray.length >= n2;
            }
        });
    }

    private static byte[] a(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private static int[] a(int[] nArray, int n2) {
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        return nArray2;
    }

    private static ECPoint[] b(ECPoint[] eCPointArray, int n2) {
        ECPoint[] eCPointArray2 = new ECPoint[n2];
        System.arraycopy(eCPointArray, 0, eCPointArray2, 0, eCPointArray.length);
        return eCPointArray2;
    }
}

