/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.djb;

import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat256;
import java.math.BigInteger;

public class Curve25519Field {
    static final int[] a = new int[]{-19, -1, -1, -1, -1, -1, -1, Integer.MAX_VALUE};
    private static final int[] b = new int[]{361, 0, 0, 0, 0, 0, 0, 0, -19, -1, -1, -1, -1, -1, -1, 0x3FFFFFFF};

    public static void add(int[] x2, int[] y2, int[] z2) {
        Nat256.add(x2, y2, z2);
        if (Nat256.gte(z2, a)) {
            Curve25519Field.c(z2);
        }
    }

    public static void addExt(int[] xx, int[] yy, int[] zz) {
        Nat.add(16, xx, yy, zz);
        if (Nat.gte(16, zz, b)) {
            Curve25519Field.d(zz);
        }
    }

    public static void addOne(int[] x2, int[] z2) {
        Nat.inc(8, x2, z2);
        if (Nat256.gte(z2, a)) {
            Curve25519Field.c(z2);
        }
    }

    public static int[] fromBigInteger(BigInteger x2) {
        int[] nArray = Nat256.fromBigInteger(x2);
        while (Nat256.gte(nArray, a)) {
            Nat256.subFrom(a, nArray);
        }
        return nArray;
    }

    public static void half(int[] x2, int[] z2) {
        if ((x2[0] & 1) == 0) {
            Nat.shiftDownBit(8, x2, 0, z2);
        } else {
            Nat256.add(x2, a, z2);
            Nat.shiftDownBit(8, z2, 0);
        }
    }

    public static void multiply(int[] x2, int[] y2, int[] z2) {
        int[] nArray = Nat256.createExt();
        Nat256.mul(x2, y2, nArray);
        Curve25519Field.reduce(nArray, z2);
    }

    public static void multiplyAddToExt(int[] x2, int[] y2, int[] zz) {
        Nat256.mulAddTo(x2, y2, zz);
        if (Nat.gte(16, zz, b)) {
            Curve25519Field.d(zz);
        }
    }

    public static void negate(int[] x2, int[] z2) {
        if (Nat256.isZero(x2)) {
            Nat256.zero(z2);
        } else {
            Nat256.sub(a, x2, z2);
        }
    }

    public static void reduce(int[] xx, int[] z2) {
        int n2 = xx[7];
        Nat.shiftUpBit(8, xx, 8, n2, z2, 0);
        int n3 = Nat256.mulByWordAddTo(19, xx, z2) << 1;
        int n4 = z2[7];
        n3 += (n4 >>> 31) - (n2 >>> 31);
        n4 &= Integer.MAX_VALUE;
        z2[7] = n4 += Nat.addWordTo(7, n3 * 19, z2);
        if (Nat256.gte(z2, a)) {
            Curve25519Field.c(z2);
        }
    }

    public static void reduce27(int x2, int[] z2) {
        int n2 = z2[7];
        int n3 = x2 << 1 | n2 >>> 31;
        n2 &= Integer.MAX_VALUE;
        z2[7] = n2 += Nat.addWordTo(7, n3 * 19, z2);
        if (Nat256.gte(z2, a)) {
            Curve25519Field.c(z2);
        }
    }

    public static void square(int[] x2, int[] z2) {
        int[] nArray = Nat256.createExt();
        Nat256.square(x2, nArray);
        Curve25519Field.reduce(nArray, z2);
    }

    public static void squareN(int[] x2, int n2, int[] z2) {
        int[] nArray = Nat256.createExt();
        Nat256.square(x2, nArray);
        Curve25519Field.reduce(nArray, z2);
        while (--n2 > 0) {
            Nat256.square(z2, nArray);
            Curve25519Field.reduce(nArray, z2);
        }
    }

    public static void subtract(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat256.sub(x2, y2, z2);
        if (n2 != 0) {
            Curve25519Field.a(z2);
        }
    }

    public static void subtractExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.sub(16, xx, yy, zz);
        if (n2 != 0) {
            Curve25519Field.b(zz);
        }
    }

    public static void twice(int[] x2, int[] z2) {
        Nat.shiftUpBit(8, x2, 0, z2);
        if (Nat256.gte(z2, a)) {
            Curve25519Field.c(z2);
        }
    }

    private static int a(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) - 19L;
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            l2 = Nat.decAt(7, nArray, 1);
        }
        nArray[7] = (int)(l2 += ((long)nArray[7] & 0xFFFFFFFFL) + 0x80000000L);
        return (int)(l2 >>= 32);
    }

    private static int b(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)b[0] & 0xFFFFFFFFL);
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            l2 = Nat.incAt(8, nArray, 1);
        }
        nArray[8] = (int)(l2 += ((long)nArray[8] & 0xFFFFFFFFL) - 19L);
        if ((l2 >>= 32) != 0L) {
            l2 = Nat.decAt(15, nArray, 9);
        }
        nArray[15] = (int)(l2 += ((long)nArray[15] & 0xFFFFFFFFL) + ((long)(b[15] + 1) & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    private static int c(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) + 19L;
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            l2 = Nat.incAt(7, nArray, 1);
        }
        nArray[7] = (int)(l2 += ((long)nArray[7] & 0xFFFFFFFFL) - 0x80000000L);
        return (int)(l2 >>= 32);
    }

    private static int d(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) - ((long)b[0] & 0xFFFFFFFFL);
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            l2 = Nat.decAt(8, nArray, 1);
        }
        nArray[8] = (int)(l2 += ((long)nArray[8] & 0xFFFFFFFFL) + 19L);
        if ((l2 >>= 32) != 0L) {
            l2 = Nat.incAt(15, nArray, 9);
        }
        nArray[15] = (int)(l2 += ((long)nArray[15] & 0xFFFFFFFFL) - ((long)(b[15] + 1) & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }
}

