/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP128R1FieldElement;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP128R1Point;
import com.enterprisedt.bouncycastle.math.raw.Nat128;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP128R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = new BigInteger(1, Hex.decode("FFFFFFFDFFFFFFFFFFFFFFFFFFFFFFFF"));
    protected SecP128R1Point infinity = new SecP128R1Point(this, null, null);

    public SecP128R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("FFFFFFFDFFFFFFFFFFFFFFFFFFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("E87579C11079F43DD824993C2CEE5ED3")));
        this.order = new BigInteger(1, Hex.decode("FFFFFFFE0000000075A30D1B9038A115"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecP128R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger x2) {
        return new SecP128R1FieldElement(x2);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x2, ECFieldElement y2, boolean withCompression) {
        return new SecP128R1Point((ECCurve)this, x2, y2, withCompression);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x2, ECFieldElement y2, ECFieldElement[] zs, boolean withCompression) {
        return new SecP128R1Point(this, x2, y2, zs, withCompression);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int n2 = 4;
        final int[] nArray = new int[len * 4 * 2];
        int n3 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            ECPoint eCPoint = points[off + i2];
            Nat128.copy(((SecP128R1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat128.copy(((SecP128R1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 4);
            n3 += 4;
        }
        return new ECLookupTable(){

            @Override
            public int getSize() {
                return len;
            }

            @Override
            public ECPoint lookup(int index) {
                int[] nArray3 = Nat128.create();
                int[] nArray2 = Nat128.create();
                int n2 = 0;
                for (int i2 = 0; i2 < len; ++i2) {
                    int n3 = (i2 ^ index) - 1 >> 31;
                    for (int i3 = 0; i3 < 4; ++i3) {
                        int n4 = i3;
                        nArray3[n4] = nArray3[n4] ^ nArray[n2 + i3] & n3;
                        int n5 = i3;
                        nArray2[n5] = nArray2[n5] ^ nArray[n2 + 4 + i3] & n3;
                    }
                    n2 += 8;
                }
                return SecP128R1Curve.this.createRawPoint(new SecP128R1FieldElement(nArray3), new SecP128R1FieldElement(nArray2), false);
            }
        };
    }
}

