/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat128;
import com.enterprisedt.bouncycastle.math.raw.Nat256;
import java.math.BigInteger;

public class SecP128R1Field {
    static final int[] a = new int[]{-1, -1, -1, -3};
    static final int[] b = new int[]{1, 0, 0, 4, -2, -1, 3, -4};
    private static final int[] c = new int[]{-1, -1, -1, -5, 1, 0, -4, 3};

    public static void add(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat128.add(x2, y2, z2);
        if (n2 != 0 || z2[3] >>> 1 >= 0x7FFFFFFE && Nat128.gte(z2, a)) {
            SecP128R1Field.a(z2);
        }
    }

    public static void addExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat256.add(xx, yy, zz);
        if (n2 != 0 || zz[7] >>> 1 >= 0x7FFFFFFE && Nat256.gte(zz, b)) {
            Nat.addTo(c.length, c, zz);
        }
    }

    public static void addOne(int[] x2, int[] z2) {
        int n2 = Nat.inc(4, x2, z2);
        if (n2 != 0 || z2[3] >>> 1 >= 0x7FFFFFFE && Nat128.gte(z2, a)) {
            SecP128R1Field.a(z2);
        }
    }

    public static int[] fromBigInteger(BigInteger x2) {
        int[] nArray = Nat128.fromBigInteger(x2);
        if (nArray[3] >>> 1 >= 0x7FFFFFFE && Nat128.gte(nArray, a)) {
            Nat128.subFrom(a, nArray);
        }
        return nArray;
    }

    public static void half(int[] x2, int[] z2) {
        if ((x2[0] & 1) == 0) {
            Nat.shiftDownBit(4, x2, 0, z2);
        } else {
            int n2 = Nat128.add(x2, a, z2);
            Nat.shiftDownBit(4, z2, n2);
        }
    }

    public static void multiply(int[] x2, int[] y2, int[] z2) {
        int[] nArray = Nat128.createExt();
        Nat128.mul(x2, y2, nArray);
        SecP128R1Field.reduce(nArray, z2);
    }

    public static void multiplyAddToExt(int[] x2, int[] y2, int[] zz) {
        int n2 = Nat128.mulAddTo(x2, y2, zz);
        if (n2 != 0 || zz[7] >>> 1 >= 0x7FFFFFFE && Nat256.gte(zz, b)) {
            Nat.addTo(c.length, c, zz);
        }
    }

    public static void negate(int[] x2, int[] z2) {
        if (Nat128.isZero(x2)) {
            Nat128.zero(z2);
        } else {
            Nat128.sub(a, x2, z2);
        }
    }

    public static void reduce(int[] xx, int[] z2) {
        long l2 = (long)xx[0] & 0xFFFFFFFFL;
        long l3 = (long)xx[1] & 0xFFFFFFFFL;
        long l4 = (long)xx[2] & 0xFFFFFFFFL;
        long l5 = (long)xx[3] & 0xFFFFFFFFL;
        long l6 = (long)xx[4] & 0xFFFFFFFFL;
        long l7 = (long)xx[5] & 0xFFFFFFFFL;
        long l8 = (long)xx[6] & 0xFFFFFFFFL;
        long l9 = (long)xx[7] & 0xFFFFFFFFL;
        l5 += l9;
        l4 += (l8 += l9 << 1);
        l3 += (l7 += l8 << 1);
        l5 += l6 << 1;
        z2[0] = (int)(l2 += (l6 += l7 << 1));
        z2[1] = (int)(l3 += l2 >>> 32);
        z2[2] = (int)(l4 += l3 >>> 32);
        z2[3] = (int)(l5 += l4 >>> 32);
        SecP128R1Field.reduce32((int)(l5 >>> 32), z2);
    }

    public static void reduce32(int x2, int[] z2) {
        while (x2 != 0) {
            long l2 = (long)x2 & 0xFFFFFFFFL;
            long l3 = ((long)z2[0] & 0xFFFFFFFFL) + l2;
            z2[0] = (int)l3;
            if ((l3 >>= 32) != 0L) {
                z2[1] = (int)(l3 += (long)z2[1] & 0xFFFFFFFFL);
                l3 >>= 32;
                z2[2] = (int)(l3 += (long)z2[2] & 0xFFFFFFFFL);
                l3 >>= 32;
            }
            z2[3] = (int)(l3 += ((long)z2[3] & 0xFFFFFFFFL) + (l2 << 1));
            x2 = (int)(l3 >>= 32);
        }
    }

    public static void square(int[] x2, int[] z2) {
        int[] nArray = Nat128.createExt();
        Nat128.square(x2, nArray);
        SecP128R1Field.reduce(nArray, z2);
    }

    public static void squareN(int[] x2, int n2, int[] z2) {
        int[] nArray = Nat128.createExt();
        Nat128.square(x2, nArray);
        SecP128R1Field.reduce(nArray, z2);
        while (--n2 > 0) {
            Nat128.square(z2, nArray);
            SecP128R1Field.reduce(nArray, z2);
        }
    }

    public static void subtract(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat128.sub(x2, y2, z2);
        if (n2 != 0) {
            SecP128R1Field.b(z2);
        }
    }

    public static void subtractExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.sub(10, xx, yy, zz);
        if (n2 != 0) {
            Nat.subFrom(c.length, c, zz);
        }
    }

    public static void twice(int[] x2, int[] z2) {
        int n2 = Nat.shiftUpBit(4, x2, 0, z2);
        if (n2 != 0 || z2[3] >>> 1 >= 0x7FFFFFFE && Nat128.gte(z2, a)) {
            SecP128R1Field.a(z2);
        }
    }

    private static void a(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) + 1L;
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            nArray[1] = (int)(l2 += (long)nArray[1] & 0xFFFFFFFFL);
            l2 >>= 32;
            nArray[2] = (int)(l2 += (long)nArray[2] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        nArray[3] = (int)(l2 += ((long)nArray[3] & 0xFFFFFFFFL) + 2L);
    }

    private static void b(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) - 1L;
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            nArray[1] = (int)(l2 += (long)nArray[1] & 0xFFFFFFFFL);
            l2 >>= 32;
            nArray[2] = (int)(l2 += (long)nArray[2] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        nArray[3] = (int)(l2 += ((long)nArray[3] & 0xFFFFFFFFL) - 2L);
    }
}

