/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat160;
import java.math.BigInteger;

public class SecP160R1Field {
    static final int[] a = new int[]{Integer.MAX_VALUE, -1, -1, -1, -1};
    static final int[] b = new int[]{1, 0x40000001, 0, 0, 0, -2, -2, -1, -1, -1};
    private static final int[] c = new int[]{-1, -1073741826, -1, -1, -1, 1, 1};

    public static void add(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat160.add(x2, y2, z2);
        if (n2 != 0 || z2[4] == -1 && Nat160.gte(z2, a)) {
            Nat.addWordTo(5, -2147483647, z2);
        }
    }

    public static void addExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.add(10, xx, yy, zz);
        if ((n2 != 0 || zz[9] == -1 && Nat.gte(10, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(10, zz, c.length);
        }
    }

    public static void addOne(int[] x2, int[] z2) {
        int n2 = Nat.inc(5, x2, z2);
        if (n2 != 0 || z2[4] == -1 && Nat160.gte(z2, a)) {
            Nat.addWordTo(5, -2147483647, z2);
        }
    }

    public static int[] fromBigInteger(BigInteger x2) {
        int[] nArray = Nat160.fromBigInteger(x2);
        if (nArray[4] == -1 && Nat160.gte(nArray, a)) {
            Nat160.subFrom(a, nArray);
        }
        return nArray;
    }

    public static void half(int[] x2, int[] z2) {
        if ((x2[0] & 1) == 0) {
            Nat.shiftDownBit(5, x2, 0, z2);
        } else {
            int n2 = Nat160.add(x2, a, z2);
            Nat.shiftDownBit(5, z2, n2);
        }
    }

    public static void multiply(int[] x2, int[] y2, int[] z2) {
        int[] nArray = Nat160.createExt();
        Nat160.mul(x2, y2, nArray);
        SecP160R1Field.reduce(nArray, z2);
    }

    public static void multiplyAddToExt(int[] x2, int[] y2, int[] zz) {
        int n2 = Nat160.mulAddTo(x2, y2, zz);
        if ((n2 != 0 || zz[9] == -1 && Nat.gte(10, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(10, zz, c.length);
        }
    }

    public static void negate(int[] x2, int[] z2) {
        if (Nat160.isZero(x2)) {
            Nat160.zero(z2);
        } else {
            Nat160.sub(a, x2, z2);
        }
    }

    public static void reduce(int[] xx, int[] z2) {
        long l2 = (long)xx[5] & 0xFFFFFFFFL;
        long l3 = (long)xx[6] & 0xFFFFFFFFL;
        long l4 = (long)xx[7] & 0xFFFFFFFFL;
        long l5 = (long)xx[8] & 0xFFFFFFFFL;
        long l6 = (long)xx[9] & 0xFFFFFFFFL;
        long l7 = 0L;
        z2[0] = (int)(l7 += ((long)xx[0] & 0xFFFFFFFFL) + l2 + (l2 << 31));
        l7 >>>= 32;
        z2[1] = (int)(l7 += ((long)xx[1] & 0xFFFFFFFFL) + l3 + (l3 << 31));
        l7 >>>= 32;
        z2[2] = (int)(l7 += ((long)xx[2] & 0xFFFFFFFFL) + l4 + (l4 << 31));
        l7 >>>= 32;
        z2[3] = (int)(l7 += ((long)xx[3] & 0xFFFFFFFFL) + l5 + (l5 << 31));
        l7 >>>= 32;
        z2[4] = (int)(l7 += ((long)xx[4] & 0xFFFFFFFFL) + l6 + (l6 << 31));
        SecP160R1Field.reduce32((int)(l7 >>>= 32), z2);
    }

    public static void reduce32(int x2, int[] z2) {
        if (x2 != 0 && Nat160.mulWordsAdd(-2147483647, x2, z2, 0) != 0 || z2[4] == -1 && Nat160.gte(z2, a)) {
            Nat.addWordTo(5, -2147483647, z2);
        }
    }

    public static void square(int[] x2, int[] z2) {
        int[] nArray = Nat160.createExt();
        Nat160.square(x2, nArray);
        SecP160R1Field.reduce(nArray, z2);
    }

    public static void squareN(int[] x2, int n2, int[] z2) {
        int[] nArray = Nat160.createExt();
        Nat160.square(x2, nArray);
        SecP160R1Field.reduce(nArray, z2);
        while (--n2 > 0) {
            Nat160.square(z2, nArray);
            SecP160R1Field.reduce(nArray, z2);
        }
    }

    public static void subtract(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat160.sub(x2, y2, z2);
        if (n2 != 0) {
            Nat.subWordFrom(5, -2147483647, z2);
        }
    }

    public static void subtractExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.sub(10, xx, yy, zz);
        if (n2 != 0 && Nat.subFrom(c.length, c, zz) != 0) {
            Nat.decAt(10, zz, c.length);
        }
    }

    public static void twice(int[] x2, int[] z2) {
        int n2 = Nat.shiftUpBit(5, x2, 0, z2);
        if (n2 != 0 || z2[4] == -1 && Nat160.gte(z2, a)) {
            Nat.addWordTo(5, -2147483647, z2);
        }
    }
}

