/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat192;
import java.math.BigInteger;

public class SecP192R1Field {
    static final int[] a = new int[]{-1, -1, -2, -1, -1, -1};
    static final int[] b = new int[]{1, 0, 2, 0, 1, 0, -2, -1, -3, -1, -1, -1};
    private static final int[] c = new int[]{-1, -1, -3, -1, -2, -1, 1, 0, 2};

    public static void add(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat192.add(x2, y2, z2);
        if (n2 != 0 || z2[5] == -1 && Nat192.gte(z2, a)) {
            SecP192R1Field.a(z2);
        }
    }

    public static void addExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.add(12, xx, yy, zz);
        if ((n2 != 0 || zz[11] == -1 && Nat.gte(12, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(12, zz, c.length);
        }
    }

    public static void addOne(int[] x2, int[] z2) {
        int n2 = Nat.inc(6, x2, z2);
        if (n2 != 0 || z2[5] == -1 && Nat192.gte(z2, a)) {
            SecP192R1Field.a(z2);
        }
    }

    public static int[] fromBigInteger(BigInteger x2) {
        int[] nArray = Nat192.fromBigInteger(x2);
        if (nArray[5] == -1 && Nat192.gte(nArray, a)) {
            Nat192.subFrom(a, nArray);
        }
        return nArray;
    }

    public static void half(int[] x2, int[] z2) {
        if ((x2[0] & 1) == 0) {
            Nat.shiftDownBit(6, x2, 0, z2);
        } else {
            int n2 = Nat192.add(x2, a, z2);
            Nat.shiftDownBit(6, z2, n2);
        }
    }

    public static void multiply(int[] x2, int[] y2, int[] z2) {
        int[] nArray = Nat192.createExt();
        Nat192.mul(x2, y2, nArray);
        SecP192R1Field.reduce(nArray, z2);
    }

    public static void multiplyAddToExt(int[] x2, int[] y2, int[] zz) {
        int n2 = Nat192.mulAddTo(x2, y2, zz);
        if ((n2 != 0 || zz[11] == -1 && Nat.gte(12, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(12, zz, c.length);
        }
    }

    public static void negate(int[] x2, int[] z2) {
        if (Nat192.isZero(x2)) {
            Nat192.zero(z2);
        } else {
            Nat192.sub(a, x2, z2);
        }
    }

    public static void reduce(int[] xx, int[] z2) {
        long l2 = (long)xx[6] & 0xFFFFFFFFL;
        long l3 = (long)xx[7] & 0xFFFFFFFFL;
        long l4 = (long)xx[8] & 0xFFFFFFFFL;
        long l5 = (long)xx[9] & 0xFFFFFFFFL;
        long l6 = (long)xx[10] & 0xFFFFFFFFL;
        long l7 = (long)xx[11] & 0xFFFFFFFFL;
        long l8 = l2 + l6;
        long l9 = l3 + l7;
        long l10 = 0L;
        int n2 = (int)(l10 += ((long)xx[0] & 0xFFFFFFFFL) + l8);
        l10 >>= 32;
        z2[1] = (int)(l10 += ((long)xx[1] & 0xFFFFFFFFL) + l9);
        l10 >>= 32;
        long l11 = (l10 += ((long)xx[2] & 0xFFFFFFFFL) + (l8 += l4)) & 0xFFFFFFFFL;
        l10 >>= 32;
        z2[3] = (int)(l10 += ((long)xx[3] & 0xFFFFFFFFL) + (l9 += l5));
        l10 >>= 32;
        z2[4] = (int)(l10 += ((long)xx[4] & 0xFFFFFFFFL) + (l8 -= l2));
        l10 >>= 32;
        z2[5] = (int)(l10 += ((long)xx[5] & 0xFFFFFFFFL) + (l9 -= l3));
        l11 += (l10 >>= 32);
        z2[0] = (int)(l10 += (long)n2 & 0xFFFFFFFFL);
        if ((l10 >>= 32) != 0L) {
            z2[1] = (int)(l10 += (long)z2[1] & 0xFFFFFFFFL);
            l11 += l10 >> 32;
        }
        z2[2] = (int)l11;
        l10 = l11 >> 32;
        if (l10 != 0L && Nat.incAt(6, z2, 3) != 0 || z2[5] == -1 && Nat192.gte(z2, a)) {
            SecP192R1Field.a(z2);
        }
    }

    public static void reduce32(int x2, int[] z2) {
        long l2 = 0L;
        if (x2 != 0) {
            long l3 = (long)x2 & 0xFFFFFFFFL;
            z2[0] = (int)(l2 += ((long)z2[0] & 0xFFFFFFFFL) + l3);
            if ((l2 >>= 32) != 0L) {
                z2[1] = (int)(l2 += (long)z2[1] & 0xFFFFFFFFL);
                l2 >>= 32;
            }
            z2[2] = (int)(l2 += ((long)z2[2] & 0xFFFFFFFFL) + l3);
            l2 >>= 32;
        }
        if (l2 != 0L && Nat.incAt(6, z2, 3) != 0 || z2[5] == -1 && Nat192.gte(z2, a)) {
            SecP192R1Field.a(z2);
        }
    }

    public static void square(int[] x2, int[] z2) {
        int[] nArray = Nat192.createExt();
        Nat192.square(x2, nArray);
        SecP192R1Field.reduce(nArray, z2);
    }

    public static void squareN(int[] x2, int n2, int[] z2) {
        int[] nArray = Nat192.createExt();
        Nat192.square(x2, nArray);
        SecP192R1Field.reduce(nArray, z2);
        while (--n2 > 0) {
            Nat192.square(z2, nArray);
            SecP192R1Field.reduce(nArray, z2);
        }
    }

    public static void subtract(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat192.sub(x2, y2, z2);
        if (n2 != 0) {
            SecP192R1Field.b(z2);
        }
    }

    public static void subtractExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.sub(12, xx, yy, zz);
        if (n2 != 0 && Nat.subFrom(c.length, c, zz) != 0) {
            Nat.decAt(12, zz, c.length);
        }
    }

    public static void twice(int[] x2, int[] z2) {
        int n2 = Nat.shiftUpBit(6, x2, 0, z2);
        if (n2 != 0 || z2[5] == -1 && Nat192.gte(z2, a)) {
            SecP192R1Field.a(z2);
        }
    }

    private static void a(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) + 1L;
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            nArray[1] = (int)(l2 += (long)nArray[1] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        nArray[2] = (int)(l2 += ((long)nArray[2] & 0xFFFFFFFFL) + 1L);
        if ((l2 >>= 32) != 0L) {
            Nat.incAt(6, nArray, 3);
        }
    }

    private static void b(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) - 1L;
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            nArray[1] = (int)(l2 += (long)nArray[1] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        nArray[2] = (int)(l2 += ((long)nArray[2] & 0xFFFFFFFFL) - 1L);
        if ((l2 >>= 32) != 0L) {
            Nat.decAt(6, nArray, 3);
        }
    }
}

