/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat224;
import java.math.BigInteger;

public class SecP224K1Field {
    static final int[] a = new int[]{-6803, -2, -1, -1, -1, -1, -1};
    static final int[] b = new int[]{46280809, 13606, 1, 0, 0, 0, 0, -13606, -3, -1, -1, -1, -1, -1};
    private static final int[] c = new int[]{-46280809, -13607, -2, -1, -1, -1, -1, 13605, 2};

    public static void add(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat224.add(x2, y2, z2);
        if (n2 != 0 || z2[6] == -1 && Nat224.gte(z2, a)) {
            Nat.add33To(7, 6803, z2);
        }
    }

    public static void addExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.add(14, xx, yy, zz);
        if ((n2 != 0 || zz[13] == -1 && Nat.gte(14, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(14, zz, c.length);
        }
    }

    public static void addOne(int[] x2, int[] z2) {
        int n2 = Nat.inc(7, x2, z2);
        if (n2 != 0 || z2[6] == -1 && Nat224.gte(z2, a)) {
            Nat.add33To(7, 6803, z2);
        }
    }

    public static int[] fromBigInteger(BigInteger x2) {
        int[] nArray = Nat224.fromBigInteger(x2);
        if (nArray[6] == -1 && Nat224.gte(nArray, a)) {
            Nat.add33To(7, 6803, nArray);
        }
        return nArray;
    }

    public static void half(int[] x2, int[] z2) {
        if ((x2[0] & 1) == 0) {
            Nat.shiftDownBit(7, x2, 0, z2);
        } else {
            int n2 = Nat224.add(x2, a, z2);
            Nat.shiftDownBit(7, z2, n2);
        }
    }

    public static void multiply(int[] x2, int[] y2, int[] z2) {
        int[] nArray = Nat224.createExt();
        Nat224.mul(x2, y2, nArray);
        SecP224K1Field.reduce(nArray, z2);
    }

    public static void multiplyAddToExt(int[] x2, int[] y2, int[] zz) {
        int n2 = Nat224.mulAddTo(x2, y2, zz);
        if ((n2 != 0 || zz[13] == -1 && Nat.gte(14, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(14, zz, c.length);
        }
    }

    public static void negate(int[] x2, int[] z2) {
        if (Nat224.isZero(x2)) {
            Nat224.zero(z2);
        } else {
            Nat224.sub(a, x2, z2);
        }
    }

    public static void reduce(int[] xx, int[] z2) {
        long l2 = Nat224.mul33Add(6803, xx, 7, xx, 0, z2, 0);
        int n2 = Nat224.mul33DWordAdd(6803, l2, z2, 0);
        if (n2 != 0 || z2[6] == -1 && Nat224.gte(z2, a)) {
            Nat.add33To(7, 6803, z2);
        }
    }

    public static void reduce32(int x2, int[] z2) {
        if (x2 != 0 && Nat224.mul33WordAdd(6803, x2, z2, 0) != 0 || z2[6] == -1 && Nat224.gte(z2, a)) {
            Nat.add33To(7, 6803, z2);
        }
    }

    public static void square(int[] x2, int[] z2) {
        int[] nArray = Nat224.createExt();
        Nat224.square(x2, nArray);
        SecP224K1Field.reduce(nArray, z2);
    }

    public static void squareN(int[] x2, int n2, int[] z2) {
        int[] nArray = Nat224.createExt();
        Nat224.square(x2, nArray);
        SecP224K1Field.reduce(nArray, z2);
        while (--n2 > 0) {
            Nat224.square(z2, nArray);
            SecP224K1Field.reduce(nArray, z2);
        }
    }

    public static void subtract(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat224.sub(x2, y2, z2);
        if (n2 != 0) {
            Nat.sub33From(7, 6803, z2);
        }
    }

    public static void subtractExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.sub(14, xx, yy, zz);
        if (n2 != 0 && Nat.subFrom(c.length, c, zz) != 0) {
            Nat.decAt(14, zz, c.length);
        }
    }

    public static void twice(int[] x2, int[] z2) {
        int n2 = Nat.shiftUpBit(7, x2, 0, z2);
        if (n2 != 0 || z2[6] == -1 && Nat224.gte(z2, a)) {
            Nat.add33To(7, 6803, z2);
        }
    }
}

