/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP256K1FieldElement;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP256K1Point;
import com.enterprisedt.bouncycastle.math.raw.Nat256;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP256K1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFC2F"));
    protected SecP256K1Point infinity = new SecP256K1Point(this, null, null);

    public SecP256K1Curve() {
        super(q);
        this.a = this.fromBigInteger(ECConstants.ZERO);
        this.b = this.fromBigInteger(BigInteger.valueOf(7L));
        this.order = new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecP256K1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger x2) {
        return new SecP256K1FieldElement(x2);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x2, ECFieldElement y2, boolean withCompression) {
        return new SecP256K1Point((ECCurve)this, x2, y2, withCompression);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x2, ECFieldElement y2, ECFieldElement[] zs, boolean withCompression) {
        return new SecP256K1Point(this, x2, y2, zs, withCompression);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int n2 = 8;
        final int[] nArray = new int[len * 8 * 2];
        int n3 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            ECPoint eCPoint = points[off + i2];
            Nat256.copy(((SecP256K1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat256.copy(((SecP256K1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 8);
            n3 += 8;
        }
        return new ECLookupTable(){

            @Override
            public int getSize() {
                return len;
            }

            @Override
            public ECPoint lookup(int index) {
                int[] nArray3 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n2 = 0;
                for (int i2 = 0; i2 < len; ++i2) {
                    int n3 = (i2 ^ index) - 1 >> 31;
                    for (int i3 = 0; i3 < 8; ++i3) {
                        int n4 = i3;
                        nArray3[n4] = nArray3[n4] ^ nArray[n2 + i3] & n3;
                        int n5 = i3;
                        nArray2[n5] = nArray2[n5] ^ nArray[n2 + 8 + i3] & n3;
                    }
                    n2 += 16;
                }
                return SecP256K1Curve.this.createRawPoint(new SecP256K1FieldElement(nArray3), new SecP256K1FieldElement(nArray2), false);
            }
        };
    }
}

