/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat256;
import java.math.BigInteger;

public class SecP256K1Field {
    static final int[] a = new int[]{-977, -2, -1, -1, -1, -1, -1, -1};
    static final int[] b = new int[]{954529, 1954, 1, 0, 0, 0, 0, 0, -1954, -3, -1, -1, -1, -1, -1, -1};
    private static final int[] c = new int[]{-954529, -1955, -2, -1, -1, -1, -1, -1, 1953, 2};

    public static void add(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat256.add(x2, y2, z2);
        if (n2 != 0 || z2[7] == -1 && Nat256.gte(z2, a)) {
            Nat.add33To(8, 977, z2);
        }
    }

    public static void addExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.add(16, xx, yy, zz);
        if ((n2 != 0 || zz[15] == -1 && Nat.gte(16, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(16, zz, c.length);
        }
    }

    public static void addOne(int[] x2, int[] z2) {
        int n2 = Nat.inc(8, x2, z2);
        if (n2 != 0 || z2[7] == -1 && Nat256.gte(z2, a)) {
            Nat.add33To(8, 977, z2);
        }
    }

    public static int[] fromBigInteger(BigInteger x2) {
        int[] nArray = Nat256.fromBigInteger(x2);
        if (nArray[7] == -1 && Nat256.gte(nArray, a)) {
            Nat256.subFrom(a, nArray);
        }
        return nArray;
    }

    public static void half(int[] x2, int[] z2) {
        if ((x2[0] & 1) == 0) {
            Nat.shiftDownBit(8, x2, 0, z2);
        } else {
            int n2 = Nat256.add(x2, a, z2);
            Nat.shiftDownBit(8, z2, n2);
        }
    }

    public static void multiply(int[] x2, int[] y2, int[] z2) {
        int[] nArray = Nat256.createExt();
        Nat256.mul(x2, y2, nArray);
        SecP256K1Field.reduce(nArray, z2);
    }

    public static void multiplyAddToExt(int[] x2, int[] y2, int[] zz) {
        int n2 = Nat256.mulAddTo(x2, y2, zz);
        if ((n2 != 0 || zz[15] == -1 && Nat.gte(16, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(16, zz, c.length);
        }
    }

    public static void negate(int[] x2, int[] z2) {
        if (Nat256.isZero(x2)) {
            Nat256.zero(z2);
        } else {
            Nat256.sub(a, x2, z2);
        }
    }

    public static void reduce(int[] xx, int[] z2) {
        long l2 = Nat256.mul33Add(977, xx, 8, xx, 0, z2, 0);
        int n2 = Nat256.mul33DWordAdd(977, l2, z2, 0);
        if (n2 != 0 || z2[7] == -1 && Nat256.gte(z2, a)) {
            Nat.add33To(8, 977, z2);
        }
    }

    public static void reduce32(int x2, int[] z2) {
        if (x2 != 0 && Nat256.mul33WordAdd(977, x2, z2, 0) != 0 || z2[7] == -1 && Nat256.gte(z2, a)) {
            Nat.add33To(8, 977, z2);
        }
    }

    public static void square(int[] x2, int[] z2) {
        int[] nArray = Nat256.createExt();
        Nat256.square(x2, nArray);
        SecP256K1Field.reduce(nArray, z2);
    }

    public static void squareN(int[] x2, int n2, int[] z2) {
        int[] nArray = Nat256.createExt();
        Nat256.square(x2, nArray);
        SecP256K1Field.reduce(nArray, z2);
        while (--n2 > 0) {
            Nat256.square(z2, nArray);
            SecP256K1Field.reduce(nArray, z2);
        }
    }

    public static void subtract(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat256.sub(x2, y2, z2);
        if (n2 != 0) {
            Nat.sub33From(8, 977, z2);
        }
    }

    public static void subtractExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.sub(16, xx, yy, zz);
        if (n2 != 0 && Nat.subFrom(c.length, c, zz) != 0) {
            Nat.decAt(16, zz, c.length);
        }
    }

    public static void twice(int[] x2, int[] z2) {
        int n2 = Nat.shiftUpBit(8, x2, 0, z2);
        if (n2 != 0 || z2[7] == -1 && Nat256.gte(z2, a)) {
            Nat.add33To(8, 977, z2);
        }
    }
}

