/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat384;
import java.math.BigInteger;

public class SecP384R1Field {
    static final int[] a = new int[]{-1, 0, 0, -1, -2, -1, -1, -1, -1, -1, -1, -1};
    static final int[] b = new int[]{1, -2, 0, 2, 0, -2, 0, 2, 1, 0, 0, 0, -2, 1, 0, -2, -3, -1, -1, -1, -1, -1, -1, -1};
    private static final int[] c = new int[]{-1, 1, -1, -3, -1, 1, -1, -3, -2, -1, -1, -1, 1, -2, -1, 1, 2};

    public static void add(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat.add(12, x2, y2, z2);
        if (n2 != 0 || z2[11] == -1 && Nat.gte(12, z2, a)) {
            SecP384R1Field.a(z2);
        }
    }

    public static void addExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.add(24, xx, yy, zz);
        if ((n2 != 0 || zz[23] == -1 && Nat.gte(24, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(24, zz, c.length);
        }
    }

    public static void addOne(int[] x2, int[] z2) {
        int n2 = Nat.inc(12, x2, z2);
        if (n2 != 0 || z2[11] == -1 && Nat.gte(12, z2, a)) {
            SecP384R1Field.a(z2);
        }
    }

    public static int[] fromBigInteger(BigInteger x2) {
        int[] nArray = Nat.fromBigInteger(384, x2);
        if (nArray[11] == -1 && Nat.gte(12, nArray, a)) {
            Nat.subFrom(12, a, nArray);
        }
        return nArray;
    }

    public static void half(int[] x2, int[] z2) {
        if ((x2[0] & 1) == 0) {
            Nat.shiftDownBit(12, x2, 0, z2);
        } else {
            int n2 = Nat.add(12, x2, a, z2);
            Nat.shiftDownBit(12, z2, n2);
        }
    }

    public static void multiply(int[] x2, int[] y2, int[] z2) {
        int[] nArray = Nat.create(24);
        Nat384.mul(x2, y2, nArray);
        SecP384R1Field.reduce(nArray, z2);
    }

    public static void negate(int[] x2, int[] z2) {
        if (Nat.isZero(12, x2)) {
            Nat.zero(12, z2);
        } else {
            Nat.sub(12, a, x2, z2);
        }
    }

    public static void reduce(int[] xx, int[] z2) {
        long l2 = (long)xx[16] & 0xFFFFFFFFL;
        long l3 = (long)xx[17] & 0xFFFFFFFFL;
        long l4 = (long)xx[18] & 0xFFFFFFFFL;
        long l5 = (long)xx[19] & 0xFFFFFFFFL;
        long l6 = (long)xx[20] & 0xFFFFFFFFL;
        long l7 = (long)xx[21] & 0xFFFFFFFFL;
        long l8 = (long)xx[22] & 0xFFFFFFFFL;
        long l9 = (long)xx[23] & 0xFFFFFFFFL;
        long l10 = 1L;
        long l11 = ((long)xx[12] & 0xFFFFFFFFL) + l6 - 1L;
        long l12 = ((long)xx[13] & 0xFFFFFFFFL) + l8;
        long l13 = ((long)xx[14] & 0xFFFFFFFFL) + l8 + l9;
        long l14 = ((long)xx[15] & 0xFFFFFFFFL) + l9;
        long l15 = l3 + l7;
        long l16 = l7 - l9;
        long l17 = l8 - l9;
        long l18 = l11 + l16;
        long l19 = 0L;
        z2[0] = (int)(l19 += ((long)xx[0] & 0xFFFFFFFFL) + l18);
        l19 >>= 32;
        z2[1] = (int)(l19 += ((long)xx[1] & 0xFFFFFFFFL) + l9 - l11 + l12);
        l19 >>= 32;
        z2[2] = (int)(l19 += ((long)xx[2] & 0xFFFFFFFFL) - l7 - l12 + l13);
        l19 >>= 32;
        z2[3] = (int)(l19 += ((long)xx[3] & 0xFFFFFFFFL) - l13 + l14 + l18);
        l19 >>= 32;
        z2[4] = (int)(l19 += ((long)xx[4] & 0xFFFFFFFFL) + l2 + l7 + l12 - l14 + l18);
        l19 >>= 32;
        z2[5] = (int)(l19 += ((long)xx[5] & 0xFFFFFFFFL) - l2 + l12 + l13 + l15);
        l19 >>= 32;
        z2[6] = (int)(l19 += ((long)xx[6] & 0xFFFFFFFFL) + l4 - l3 + l13 + l14);
        l19 >>= 32;
        z2[7] = (int)(l19 += ((long)xx[7] & 0xFFFFFFFFL) + l2 + l5 - l4 + l14);
        l19 >>= 32;
        z2[8] = (int)(l19 += ((long)xx[8] & 0xFFFFFFFFL) + l2 + l3 + l6 - l5);
        l19 >>= 32;
        z2[9] = (int)(l19 += ((long)xx[9] & 0xFFFFFFFFL) + l4 - l6 + l15);
        l19 >>= 32;
        z2[10] = (int)(l19 += ((long)xx[10] & 0xFFFFFFFFL) + l4 + l5 - l16 + l17);
        l19 >>= 32;
        z2[11] = (int)(l19 += ((long)xx[11] & 0xFFFFFFFFL) + l5 + l6 - l17);
        l19 >>= 32;
        SecP384R1Field.reduce32((int)(++l19), z2);
    }

    public static void reduce32(int x2, int[] z2) {
        long l2 = 0L;
        if (x2 != 0) {
            long l3 = (long)x2 & 0xFFFFFFFFL;
            z2[0] = (int)(l2 += ((long)z2[0] & 0xFFFFFFFFL) + l3);
            l2 >>= 32;
            z2[1] = (int)(l2 += ((long)z2[1] & 0xFFFFFFFFL) - l3);
            if ((l2 >>= 32) != 0L) {
                z2[2] = (int)(l2 += (long)z2[2] & 0xFFFFFFFFL);
                l2 >>= 32;
            }
            z2[3] = (int)(l2 += ((long)z2[3] & 0xFFFFFFFFL) + l3);
            l2 >>= 32;
            z2[4] = (int)(l2 += ((long)z2[4] & 0xFFFFFFFFL) + l3);
            l2 >>= 32;
        }
        if (l2 != 0L && Nat.incAt(12, z2, 5) != 0 || z2[11] == -1 && Nat.gte(12, z2, a)) {
            SecP384R1Field.a(z2);
        }
    }

    public static void square(int[] x2, int[] z2) {
        int[] nArray = Nat.create(24);
        Nat384.square(x2, nArray);
        SecP384R1Field.reduce(nArray, z2);
    }

    public static void squareN(int[] x2, int n2, int[] z2) {
        int[] nArray = Nat.create(24);
        Nat384.square(x2, nArray);
        SecP384R1Field.reduce(nArray, z2);
        while (--n2 > 0) {
            Nat384.square(z2, nArray);
            SecP384R1Field.reduce(nArray, z2);
        }
    }

    public static void subtract(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat.sub(12, x2, y2, z2);
        if (n2 != 0) {
            SecP384R1Field.b(z2);
        }
    }

    public static void subtractExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.sub(24, xx, yy, zz);
        if (n2 != 0 && Nat.subFrom(c.length, c, zz) != 0) {
            Nat.decAt(24, zz, c.length);
        }
    }

    public static void twice(int[] x2, int[] z2) {
        int n2 = Nat.shiftUpBit(12, x2, 0, z2);
        if (n2 != 0 || z2[11] == -1 && Nat.gte(12, z2, a)) {
            SecP384R1Field.a(z2);
        }
    }

    private static void a(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) + 1L;
        nArray[0] = (int)l2;
        l2 >>= 32;
        nArray[1] = (int)(l2 += ((long)nArray[1] & 0xFFFFFFFFL) - 1L);
        if ((l2 >>= 32) != 0L) {
            nArray[2] = (int)(l2 += (long)nArray[2] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        nArray[3] = (int)(l2 += ((long)nArray[3] & 0xFFFFFFFFL) + 1L);
        l2 >>= 32;
        nArray[4] = (int)(l2 += ((long)nArray[4] & 0xFFFFFFFFL) + 1L);
        if ((l2 >>= 32) != 0L) {
            Nat.incAt(12, nArray, 5);
        }
    }

    private static void b(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) - 1L;
        nArray[0] = (int)l2;
        l2 >>= 32;
        nArray[1] = (int)(l2 += ((long)nArray[1] & 0xFFFFFFFFL) + 1L);
        if ((l2 >>= 32) != 0L) {
            nArray[2] = (int)(l2 += (long)nArray[2] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        nArray[3] = (int)(l2 += ((long)nArray[3] & 0xFFFFFFFFL) - 1L);
        l2 >>= 32;
        nArray[4] = (int)(l2 += ((long)nArray[4] & 0xFFFFFFFFL) - 1L);
        if ((l2 >>= 32) != 0L) {
            Nat.decAt(12, nArray, 5);
        }
    }
}

