/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Interleave;
import com.enterprisedt.bouncycastle.math.raw.Nat128;
import java.math.BigInteger;

public class SecT113Field {
    public static void add(long[] x2, long[] y2, long[] z2) {
        z2[0] = x2[0] ^ y2[0];
        z2[1] = x2[1] ^ y2[1];
    }

    public static void addExt(long[] xx, long[] yy, long[] zz) {
        zz[0] = xx[0] ^ yy[0];
        zz[1] = xx[1] ^ yy[1];
        zz[2] = xx[2] ^ yy[2];
        zz[3] = xx[3] ^ yy[3];
    }

    public static void addOne(long[] x2, long[] z2) {
        z2[0] = x2[0] ^ 1L;
        z2[1] = x2[1];
    }

    public static long[] fromBigInteger(BigInteger x2) {
        long[] lArray = Nat128.fromBigInteger64(x2);
        SecT113Field.reduce15(lArray, 0);
        return lArray;
    }

    public static void invert(long[] x2, long[] z2) {
        if (Nat128.isZero64(x2)) {
            throw new IllegalStateException();
        }
        long[] lArray = Nat128.create64();
        long[] lArray2 = Nat128.create64();
        SecT113Field.square(x2, lArray);
        SecT113Field.multiply(lArray, x2, lArray);
        SecT113Field.square(lArray, lArray);
        SecT113Field.multiply(lArray, x2, lArray);
        SecT113Field.squareN(lArray, 3, lArray2);
        SecT113Field.multiply(lArray2, lArray, lArray2);
        SecT113Field.square(lArray2, lArray2);
        SecT113Field.multiply(lArray2, x2, lArray2);
        SecT113Field.squareN(lArray2, 7, lArray);
        SecT113Field.multiply(lArray, lArray2, lArray);
        SecT113Field.squareN(lArray, 14, lArray2);
        SecT113Field.multiply(lArray2, lArray, lArray2);
        SecT113Field.squareN(lArray2, 28, lArray);
        SecT113Field.multiply(lArray, lArray2, lArray);
        SecT113Field.squareN(lArray, 56, lArray2);
        SecT113Field.multiply(lArray2, lArray, lArray2);
        SecT113Field.square(lArray2, z2);
    }

    public static void multiply(long[] x2, long[] y2, long[] z2) {
        long[] lArray = Nat128.createExt64();
        SecT113Field.implMultiply(x2, y2, lArray);
        SecT113Field.reduce(lArray, z2);
    }

    public static void multiplyAddToExt(long[] x2, long[] y2, long[] zz) {
        long[] lArray = Nat128.createExt64();
        SecT113Field.implMultiply(x2, y2, lArray);
        SecT113Field.addExt(zz, lArray, zz);
    }

    public static void reduce(long[] xx, long[] z2) {
        long l2 = xx[0];
        long l3 = xx[1];
        long l4 = xx[2];
        long l5 = xx[3];
        l3 ^= l5 << 15 ^ l5 << 24;
        long l6 = (l3 ^= l4 >>> 49 ^ l4 >>> 40) >>> 49;
        z2[0] = (l2 ^= (l4 ^= l5 >>> 49 ^ l5 >>> 40) << 15 ^ l4 << 24) ^ l6 ^ l6 << 9;
        z2[1] = l3 & 0x1FFFFFFFFFFFFL;
    }

    public static void reduce15(long[] z2, int zOff) {
        long l2 = z2[zOff + 1];
        long l3 = l2 >>> 49;
        int n2 = zOff;
        z2[n2] = z2[n2] ^ (l3 ^ l3 << 9);
        z2[zOff + 1] = l2 & 0x1FFFFFFFFFFFFL;
    }

    public static void sqrt(long[] x2, long[] z2) {
        long l2 = Interleave.unshuffle(x2[0]);
        long l3 = Interleave.unshuffle(x2[1]);
        long l4 = l2 & 0xFFFFFFFFL | l3 << 32;
        long l5 = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        z2[0] = l4 ^ l5 << 57 ^ l5 << 5;
        z2[1] = l5 >>> 7 ^ l5 >>> 59;
    }

    public static void square(long[] x2, long[] z2) {
        long[] lArray = Nat128.createExt64();
        SecT113Field.implSquare(x2, lArray);
        SecT113Field.reduce(lArray, z2);
    }

    public static void squareAddToExt(long[] x2, long[] zz) {
        long[] lArray = Nat128.createExt64();
        SecT113Field.implSquare(x2, lArray);
        SecT113Field.addExt(zz, lArray, zz);
    }

    public static void squareN(long[] x2, int n2, long[] z2) {
        long[] lArray = Nat128.createExt64();
        SecT113Field.implSquare(x2, lArray);
        SecT113Field.reduce(lArray, z2);
        while (--n2 > 0) {
            SecT113Field.implSquare(z2, lArray);
            SecT113Field.reduce(lArray, z2);
        }
    }

    public static int trace(long[] x2) {
        return (int)x2[0] & 1;
    }

    protected static void implMultiply(long[] x2, long[] y2, long[] zz) {
        long l2 = x2[0];
        long l3 = x2[1];
        l3 = (l2 >>> 57 ^ l3 << 7) & 0x1FFFFFFFFFFFFFFL;
        long l4 = y2[0];
        long l5 = y2[1];
        l5 = (l4 >>> 57 ^ l5 << 7) & 0x1FFFFFFFFFFFFFFL;
        long[] lArray = new long[6];
        SecT113Field.implMulw(l2 &= 0x1FFFFFFFFFFFFFFL, l4 &= 0x1FFFFFFFFFFFFFFL, lArray, 0);
        SecT113Field.implMulw(l3, l5, lArray, 2);
        SecT113Field.implMulw(l2 ^ l3, l4 ^ l5, lArray, 4);
        long l6 = lArray[1] ^ lArray[2];
        long l7 = lArray[0];
        long l8 = lArray[3];
        long l9 = lArray[4] ^ l7 ^ l6;
        long l10 = lArray[5] ^ l8 ^ l6;
        zz[0] = l7 ^ l9 << 57;
        zz[1] = l9 >>> 7 ^ l10 << 50;
        zz[2] = l10 >>> 14 ^ l8 << 43;
        zz[3] = l8 >>> 21;
    }

    protected static void implMulw(long x2, long y2, long[] z2, int zOff) {
        long[] lArray = new long[8];
        lArray[1] = y2;
        lArray[2] = lArray[1] << 1;
        lArray[3] = lArray[2] ^ y2;
        lArray[4] = lArray[2] << 1;
        lArray[5] = lArray[4] ^ y2;
        lArray[6] = lArray[3] << 1;
        lArray[7] = lArray[6] ^ y2;
        int n2 = (int)x2;
        long l2 = 0L;
        long l3 = lArray[n2 & 7];
        int n3 = 48;
        do {
            n2 = (int)(x2 >>> n3);
            long l4 = lArray[n2 & 7] ^ lArray[n2 >>> 3 & 7] << 3 ^ lArray[n2 >>> 6 & 7] << 6;
            l3 ^= l4 << n3;
            l2 ^= l4 >>> -n3;
        } while ((n3 -= 9) > 0);
        z2[zOff] = l3 & 0x1FFFFFFFFFFFFFFL;
        z2[zOff + 1] = l3 >>> 57 ^ (l2 ^= (x2 & 0x100804020100800L & y2 << 7 >> 63) >>> 8) << 7;
    }

    protected static void implSquare(long[] x2, long[] zz) {
        Interleave.expand64To128(x2[0], zz, 0);
        Interleave.expand64To128(x2[1], zz, 2);
    }
}

