/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Interleave;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat192;
import java.math.BigInteger;

public class SecT131Field {
    private static final long[] a = new long[]{2791191049453778211L, 2791191049453778402L, 6L};

    public static void add(long[] x2, long[] y2, long[] z2) {
        z2[0] = x2[0] ^ y2[0];
        z2[1] = x2[1] ^ y2[1];
        z2[2] = x2[2] ^ y2[2];
    }

    public static void addExt(long[] xx, long[] yy, long[] zz) {
        zz[0] = xx[0] ^ yy[0];
        zz[1] = xx[1] ^ yy[1];
        zz[2] = xx[2] ^ yy[2];
        zz[3] = xx[3] ^ yy[3];
        zz[4] = xx[4] ^ yy[4];
    }

    public static void addOne(long[] x2, long[] z2) {
        z2[0] = x2[0] ^ 1L;
        z2[1] = x2[1];
        z2[2] = x2[2];
    }

    public static long[] fromBigInteger(BigInteger x2) {
        long[] lArray = Nat192.fromBigInteger64(x2);
        SecT131Field.reduce61(lArray, 0);
        return lArray;
    }

    public static void invert(long[] x2, long[] z2) {
        if (Nat192.isZero64(x2)) {
            throw new IllegalStateException();
        }
        long[] lArray = Nat192.create64();
        long[] lArray2 = Nat192.create64();
        SecT131Field.square(x2, lArray);
        SecT131Field.multiply(lArray, x2, lArray);
        SecT131Field.squareN(lArray, 2, lArray2);
        SecT131Field.multiply(lArray2, lArray, lArray2);
        SecT131Field.squareN(lArray2, 4, lArray);
        SecT131Field.multiply(lArray, lArray2, lArray);
        SecT131Field.squareN(lArray, 8, lArray2);
        SecT131Field.multiply(lArray2, lArray, lArray2);
        SecT131Field.squareN(lArray2, 16, lArray);
        SecT131Field.multiply(lArray, lArray2, lArray);
        SecT131Field.squareN(lArray, 32, lArray2);
        SecT131Field.multiply(lArray2, lArray, lArray2);
        SecT131Field.square(lArray2, lArray2);
        SecT131Field.multiply(lArray2, x2, lArray2);
        SecT131Field.squareN(lArray2, 65, lArray);
        SecT131Field.multiply(lArray, lArray2, lArray);
        SecT131Field.square(lArray, z2);
    }

    public static void multiply(long[] x2, long[] y2, long[] z2) {
        long[] lArray = Nat192.createExt64();
        SecT131Field.implMultiply(x2, y2, lArray);
        SecT131Field.reduce(lArray, z2);
    }

    public static void multiplyAddToExt(long[] x2, long[] y2, long[] zz) {
        long[] lArray = Nat192.createExt64();
        SecT131Field.implMultiply(x2, y2, lArray);
        SecT131Field.addExt(zz, lArray, zz);
    }

    public static void reduce(long[] xx, long[] z2) {
        long l2 = xx[0];
        long l3 = xx[1];
        long l4 = xx[2];
        long l5 = xx[3];
        long l6 = xx[4];
        l3 ^= l6 << 61 ^ l6 << 63;
        l4 ^= l6 >>> 3 ^ l6 >>> 1 ^ l6 ^ l6 << 5;
        long l7 = (l4 ^= l5 >>> 59) >>> 3;
        z2[0] = (l2 ^= (l5 ^= l6 >>> 59) << 61 ^ l5 << 63) ^ l7 ^ l7 << 2 ^ l7 << 3 ^ l7 << 8;
        z2[1] = (l3 ^= l5 >>> 3 ^ l5 >>> 1 ^ l5 ^ l5 << 5) ^ l7 >>> 56;
        z2[2] = l4 & 7L;
    }

    public static void reduce61(long[] z2, int zOff) {
        long l2 = z2[zOff + 2];
        long l3 = l2 >>> 3;
        int n2 = zOff;
        z2[n2] = z2[n2] ^ (l3 ^ l3 << 2 ^ l3 << 3 ^ l3 << 8);
        int n3 = zOff + 1;
        z2[n3] = z2[n3] ^ l3 >>> 56;
        z2[zOff + 2] = l2 & 7L;
    }

    public static void sqrt(long[] x2, long[] z2) {
        long[] lArray = Nat192.create64();
        long l2 = Interleave.unshuffle(x2[0]);
        long l3 = Interleave.unshuffle(x2[1]);
        long l4 = l2 & 0xFFFFFFFFL | l3 << 32;
        lArray[0] = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        l2 = Interleave.unshuffle(x2[2]);
        long l5 = l2 & 0xFFFFFFFFL;
        lArray[1] = l2 >>> 32;
        SecT131Field.multiply(lArray, a, z2);
        z2[0] = z2[0] ^ l4;
        z2[1] = z2[1] ^ l5;
    }

    public static void square(long[] x2, long[] z2) {
        long[] lArray = Nat.create64(5);
        SecT131Field.implSquare(x2, lArray);
        SecT131Field.reduce(lArray, z2);
    }

    public static void squareAddToExt(long[] x2, long[] zz) {
        long[] lArray = Nat.create64(5);
        SecT131Field.implSquare(x2, lArray);
        SecT131Field.addExt(zz, lArray, zz);
    }

    public static void squareN(long[] x2, int n2, long[] z2) {
        long[] lArray = Nat.create64(5);
        SecT131Field.implSquare(x2, lArray);
        SecT131Field.reduce(lArray, z2);
        while (--n2 > 0) {
            SecT131Field.implSquare(z2, lArray);
            SecT131Field.reduce(lArray, z2);
        }
    }

    public static int trace(long[] x2) {
        return (int)(x2[0] ^ x2[1] >>> 59 ^ x2[2] >>> 1) & 1;
    }

    protected static void implCompactExt(long[] zz) {
        long l2 = zz[0];
        long l3 = zz[1];
        long l4 = zz[2];
        long l5 = zz[3];
        long l6 = zz[4];
        long l7 = zz[5];
        zz[0] = l2 ^ l3 << 44;
        zz[1] = l3 >>> 20 ^ l4 << 24;
        zz[2] = l4 >>> 40 ^ l5 << 4 ^ l6 << 48;
        zz[3] = l5 >>> 60 ^ l7 << 28 ^ l6 >>> 16;
        zz[4] = l7 >>> 36;
        zz[5] = 0L;
    }

    protected static void implMultiply(long[] x2, long[] y2, long[] zz) {
        long l2 = x2[0];
        long l3 = x2[1];
        long l4 = x2[2];
        l4 = (l3 >>> 24 ^ l4 << 40) & 0xFFFFFFFFFFFL;
        l3 = (l2 >>> 44 ^ l3 << 20) & 0xFFFFFFFFFFFL;
        l2 &= 0xFFFFFFFFFFFL;
        long l5 = y2[0];
        long l6 = y2[1];
        long l7 = y2[2];
        l7 = (l6 >>> 24 ^ l7 << 40) & 0xFFFFFFFFFFFL;
        l6 = (l5 >>> 44 ^ l6 << 20) & 0xFFFFFFFFFFFL;
        long[] lArray = new long[10];
        SecT131Field.implMulw(l2, l5 &= 0xFFFFFFFFFFFL, lArray, 0);
        SecT131Field.implMulw(l4, l7, lArray, 2);
        long l8 = l2 ^ l3 ^ l4;
        long l9 = l5 ^ l6 ^ l7;
        SecT131Field.implMulw(l8, l9, lArray, 4);
        long l10 = l3 << 1 ^ l4 << 2;
        long l11 = l6 << 1 ^ l7 << 2;
        SecT131Field.implMulw(l2 ^ l10, l5 ^ l11, lArray, 6);
        SecT131Field.implMulw(l8 ^ l10, l9 ^ l11, lArray, 8);
        long l12 = lArray[6] ^ lArray[8];
        long l13 = lArray[7] ^ lArray[9];
        long l14 = l12 << 1 ^ lArray[6];
        long l15 = l12 ^ l13 << 1 ^ lArray[7];
        long l16 = l13;
        long l17 = lArray[0];
        long l18 = lArray[1] ^ lArray[0] ^ lArray[4];
        long l19 = lArray[1] ^ lArray[5];
        long l20 = l17 ^ l14 ^ lArray[2] << 4 ^ lArray[2] << 1;
        long l21 = l18 ^ l15 ^ lArray[3] << 4 ^ lArray[3] << 1;
        long l22 = l19 ^ l16;
        l21 ^= l20 >>> 44;
        l20 &= 0xFFFFFFFFFFFL;
        l22 ^= l21 >>> 44;
        l20 = l20 >>> 1 ^ ((l21 &= 0xFFFFFFFFFFFL) & 1L) << 43;
        l21 = l21 >>> 1 ^ (l22 & 1L) << 43;
        l22 >>>= 1;
        l20 ^= l20 << 1;
        l20 ^= l20 << 2;
        l20 ^= l20 << 4;
        l20 ^= l20 << 8;
        l20 ^= l20 << 16;
        l20 ^= l20 << 32;
        l21 ^= (l20 &= 0xFFFFFFFFFFFL) >>> 43;
        l21 ^= l21 << 1;
        l21 ^= l21 << 2;
        l21 ^= l21 << 4;
        l21 ^= l21 << 8;
        l21 ^= l21 << 16;
        l21 ^= l21 << 32;
        l22 ^= (l21 &= 0xFFFFFFFFFFFL) >>> 43;
        l22 ^= l22 << 1;
        l22 ^= l22 << 2;
        l22 ^= l22 << 4;
        l22 ^= l22 << 8;
        l22 ^= l22 << 16;
        l22 ^= l22 << 32;
        zz[0] = l17;
        zz[1] = l18 ^ l20 ^ lArray[2];
        zz[2] = l19 ^ l21 ^ l20 ^ lArray[3];
        zz[3] = l22 ^ l21;
        zz[4] = l22 ^ lArray[2];
        zz[5] = lArray[3];
        SecT131Field.implCompactExt(zz);
    }

    protected static void implMulw(long x2, long y2, long[] z2, int zOff) {
        long[] lArray = new long[8];
        lArray[1] = y2;
        lArray[2] = lArray[1] << 1;
        lArray[3] = lArray[2] ^ y2;
        lArray[4] = lArray[2] << 1;
        lArray[5] = lArray[4] ^ y2;
        lArray[6] = lArray[3] << 1;
        lArray[7] = lArray[6] ^ y2;
        int n2 = (int)x2;
        long l2 = 0L;
        long l3 = lArray[n2 & 7] ^ lArray[n2 >>> 3 & 7] << 3 ^ lArray[n2 >>> 6 & 7] << 6;
        int n3 = 33;
        do {
            n2 = (int)(x2 >>> n3);
            long l4 = lArray[n2 & 7] ^ lArray[n2 >>> 3 & 7] << 3 ^ lArray[n2 >>> 6 & 7] << 6 ^ lArray[n2 >>> 9 & 7] << 9;
            l3 ^= l4 << n3;
            l2 ^= l4 >>> -n3;
        } while ((n3 -= 12) > 0);
        z2[zOff] = l3 & 0xFFFFFFFFFFFL;
        z2[zOff + 1] = l3 >>> 44 ^ l2 << 20;
    }

    protected static void implSquare(long[] x2, long[] zz) {
        Interleave.expand64To128(x2[0], zz, 0);
        Interleave.expand64To128(x2[1], zz, 2);
        zz[4] = (long)Interleave.expand8to16((int)x2[2]) & 0xFFFFFFFFL;
    }
}

