/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Interleave;
import com.enterprisedt.bouncycastle.math.raw.Nat256;
import java.math.BigInteger;

public class SecT193Field {
    public static void add(long[] x2, long[] y2, long[] z2) {
        z2[0] = x2[0] ^ y2[0];
        z2[1] = x2[1] ^ y2[1];
        z2[2] = x2[2] ^ y2[2];
        z2[3] = x2[3] ^ y2[3];
    }

    public static void addExt(long[] xx, long[] yy, long[] zz) {
        zz[0] = xx[0] ^ yy[0];
        zz[1] = xx[1] ^ yy[1];
        zz[2] = xx[2] ^ yy[2];
        zz[3] = xx[3] ^ yy[3];
        zz[4] = xx[4] ^ yy[4];
        zz[5] = xx[5] ^ yy[5];
        zz[6] = xx[6] ^ yy[6];
    }

    public static void addOne(long[] x2, long[] z2) {
        z2[0] = x2[0] ^ 1L;
        z2[1] = x2[1];
        z2[2] = x2[2];
        z2[3] = x2[3];
    }

    public static long[] fromBigInteger(BigInteger x2) {
        long[] lArray = Nat256.fromBigInteger64(x2);
        SecT193Field.reduce63(lArray, 0);
        return lArray;
    }

    public static void invert(long[] x2, long[] z2) {
        if (Nat256.isZero64(x2)) {
            throw new IllegalStateException();
        }
        long[] lArray = Nat256.create64();
        long[] lArray2 = Nat256.create64();
        SecT193Field.square(x2, lArray);
        SecT193Field.squareN(lArray, 1, lArray2);
        SecT193Field.multiply(lArray, lArray2, lArray);
        SecT193Field.squareN(lArray2, 1, lArray2);
        SecT193Field.multiply(lArray, lArray2, lArray);
        SecT193Field.squareN(lArray, 3, lArray2);
        SecT193Field.multiply(lArray, lArray2, lArray);
        SecT193Field.squareN(lArray, 6, lArray2);
        SecT193Field.multiply(lArray, lArray2, lArray);
        SecT193Field.squareN(lArray, 12, lArray2);
        SecT193Field.multiply(lArray, lArray2, lArray);
        SecT193Field.squareN(lArray, 24, lArray2);
        SecT193Field.multiply(lArray, lArray2, lArray);
        SecT193Field.squareN(lArray, 48, lArray2);
        SecT193Field.multiply(lArray, lArray2, lArray);
        SecT193Field.squareN(lArray, 96, lArray2);
        SecT193Field.multiply(lArray, lArray2, z2);
    }

    public static void multiply(long[] x2, long[] y2, long[] z2) {
        long[] lArray = Nat256.createExt64();
        SecT193Field.implMultiply(x2, y2, lArray);
        SecT193Field.reduce(lArray, z2);
    }

    public static void multiplyAddToExt(long[] x2, long[] y2, long[] zz) {
        long[] lArray = Nat256.createExt64();
        SecT193Field.implMultiply(x2, y2, lArray);
        SecT193Field.addExt(zz, lArray, zz);
    }

    public static void reduce(long[] xx, long[] z2) {
        long l2 = xx[0];
        long l3 = xx[1];
        long l4 = xx[2];
        long l5 = xx[3];
        long l6 = xx[4];
        long l7 = xx[5];
        long l8 = xx[6];
        l4 ^= l8 << 63;
        l5 ^= l8 >>> 1 ^ l8 << 14;
        l3 ^= l7 << 63;
        l4 ^= l7 >>> 1 ^ l7 << 14;
        long l9 = (l5 ^= l7 >>> 50) >>> 1;
        z2[0] = (l2 ^= (l6 ^= l8 >>> 50) << 63) ^ l9 ^ l9 << 15;
        z2[1] = (l3 ^= l6 >>> 1 ^ l6 << 14) ^ l9 >>> 49;
        z2[2] = l4 ^= l6 >>> 50;
        z2[3] = l5 & 1L;
    }

    public static void reduce63(long[] z2, int zOff) {
        long l2 = z2[zOff + 3];
        long l3 = l2 >>> 1;
        int n2 = zOff;
        z2[n2] = z2[n2] ^ (l3 ^ l3 << 15);
        int n3 = zOff + 1;
        z2[n3] = z2[n3] ^ l3 >>> 49;
        z2[zOff + 3] = l2 & 1L;
    }

    public static void sqrt(long[] x2, long[] z2) {
        long l2 = Interleave.unshuffle(x2[0]);
        long l3 = Interleave.unshuffle(x2[1]);
        long l4 = l2 & 0xFFFFFFFFL | l3 << 32;
        long l5 = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        l2 = Interleave.unshuffle(x2[2]);
        long l6 = l2 & 0xFFFFFFFFL ^ x2[3] << 32;
        long l7 = l2 >>> 32;
        z2[0] = l4 ^ l5 << 8;
        z2[1] = l6 ^ l7 << 8 ^ l5 >>> 56 ^ l5 << 33;
        z2[2] = l7 >>> 56 ^ l7 << 33 ^ l5 >>> 31;
        z2[3] = l7 >>> 31;
    }

    public static void square(long[] x2, long[] z2) {
        long[] lArray = Nat256.createExt64();
        SecT193Field.implSquare(x2, lArray);
        SecT193Field.reduce(lArray, z2);
    }

    public static void squareAddToExt(long[] x2, long[] zz) {
        long[] lArray = Nat256.createExt64();
        SecT193Field.implSquare(x2, lArray);
        SecT193Field.addExt(zz, lArray, zz);
    }

    public static void squareN(long[] x2, int n2, long[] z2) {
        long[] lArray = Nat256.createExt64();
        SecT193Field.implSquare(x2, lArray);
        SecT193Field.reduce(lArray, z2);
        while (--n2 > 0) {
            SecT193Field.implSquare(z2, lArray);
            SecT193Field.reduce(lArray, z2);
        }
    }

    public static int trace(long[] x2) {
        return (int)x2[0] & 1;
    }

    protected static void implCompactExt(long[] zz) {
        long l2 = zz[0];
        long l3 = zz[1];
        long l4 = zz[2];
        long l5 = zz[3];
        long l6 = zz[4];
        long l7 = zz[5];
        long l8 = zz[6];
        long l9 = zz[7];
        zz[0] = l2 ^ l3 << 49;
        zz[1] = l3 >>> 15 ^ l4 << 34;
        zz[2] = l4 >>> 30 ^ l5 << 19;
        zz[3] = l5 >>> 45 ^ l6 << 4 ^ l7 << 53;
        zz[4] = l6 >>> 60 ^ l8 << 38 ^ l7 >>> 11;
        zz[5] = l8 >>> 26 ^ l9 << 23;
        zz[6] = l9 >>> 41;
        zz[7] = 0L;
    }

    protected static void implExpand(long[] x2, long[] z2) {
        long l2 = x2[0];
        long l3 = x2[1];
        long l4 = x2[2];
        long l5 = x2[3];
        z2[0] = l2 & 0x1FFFFFFFFFFFFL;
        z2[1] = (l2 >>> 49 ^ l3 << 15) & 0x1FFFFFFFFFFFFL;
        z2[2] = (l3 >>> 34 ^ l4 << 30) & 0x1FFFFFFFFFFFFL;
        z2[3] = l4 >>> 19 ^ l5 << 45;
    }

    protected static void implMultiply(long[] x2, long[] y2, long[] zz) {
        int n2;
        long[] lArray = new long[4];
        long[] lArray2 = new long[4];
        SecT193Field.implExpand(x2, lArray);
        SecT193Field.implExpand(y2, lArray2);
        SecT193Field.implMulwAcc(lArray[0], lArray2[0], zz, 0);
        SecT193Field.implMulwAcc(lArray[1], lArray2[1], zz, 1);
        SecT193Field.implMulwAcc(lArray[2], lArray2[2], zz, 2);
        SecT193Field.implMulwAcc(lArray[3], lArray2[3], zz, 3);
        for (n2 = 5; n2 > 0; --n2) {
            int n3 = n2;
            zz[n3] = zz[n3] ^ zz[n2 - 1];
        }
        SecT193Field.implMulwAcc(lArray[0] ^ lArray[1], lArray2[0] ^ lArray2[1], zz, 1);
        SecT193Field.implMulwAcc(lArray[2] ^ lArray[3], lArray2[2] ^ lArray2[3], zz, 3);
        for (n2 = 7; n2 > 1; --n2) {
            int n4 = n2;
            zz[n4] = zz[n4] ^ zz[n2 - 2];
        }
        long l2 = lArray[0] ^ lArray[2];
        long l3 = lArray[1] ^ lArray[3];
        long l4 = lArray2[0] ^ lArray2[2];
        long l5 = lArray2[1] ^ lArray2[3];
        SecT193Field.implMulwAcc(l2 ^ l3, l4 ^ l5, zz, 3);
        long[] lArray3 = new long[3];
        SecT193Field.implMulwAcc(l2, l4, lArray3, 0);
        SecT193Field.implMulwAcc(l3, l5, lArray3, 1);
        long l6 = lArray3[0];
        long l7 = lArray3[1];
        long l8 = lArray3[2];
        zz[2] = zz[2] ^ l6;
        zz[3] = zz[3] ^ (l6 ^ l7);
        zz[4] = zz[4] ^ (l8 ^ l7);
        zz[5] = zz[5] ^ l8;
        SecT193Field.implCompactExt(zz);
    }

    protected static void implMulwAcc(long x2, long y2, long[] z2, int zOff) {
        long[] lArray = new long[8];
        lArray[1] = y2;
        lArray[2] = lArray[1] << 1;
        lArray[3] = lArray[2] ^ y2;
        lArray[4] = lArray[2] << 1;
        lArray[5] = lArray[4] ^ y2;
        lArray[6] = lArray[3] << 1;
        lArray[7] = lArray[6] ^ y2;
        int n2 = (int)x2;
        long l2 = 0L;
        long l3 = lArray[n2 & 7] ^ lArray[n2 >>> 3 & 7] << 3;
        int n3 = 36;
        do {
            n2 = (int)(x2 >>> n3);
            long l4 = lArray[n2 & 7] ^ lArray[n2 >>> 3 & 7] << 3 ^ lArray[n2 >>> 6 & 7] << 6 ^ lArray[n2 >>> 9 & 7] << 9 ^ lArray[n2 >>> 12 & 7] << 12;
            l3 ^= l4 << n3;
            l2 ^= l4 >>> -n3;
        } while ((n3 -= 15) > 0);
        int n4 = zOff;
        z2[n4] = z2[n4] ^ l3 & 0x1FFFFFFFFFFFFL;
        int n5 = zOff + 1;
        z2[n5] = z2[n5] ^ (l3 >>> 49 ^ l2 << 15);
    }

    protected static void implSquare(long[] x2, long[] zz) {
        Interleave.expand64To128(x2[0], zz, 0);
        Interleave.expand64To128(x2[1], zz, 2);
        Interleave.expand64To128(x2[2], zz, 4);
        zz[6] = x2[3] & 1L;
    }
}

