/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Interleave;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat448;
import java.math.BigInteger;

public class SecT409Field {
    public static void add(long[] x2, long[] y2, long[] z2) {
        z2[0] = x2[0] ^ y2[0];
        z2[1] = x2[1] ^ y2[1];
        z2[2] = x2[2] ^ y2[2];
        z2[3] = x2[3] ^ y2[3];
        z2[4] = x2[4] ^ y2[4];
        z2[5] = x2[5] ^ y2[5];
        z2[6] = x2[6] ^ y2[6];
    }

    public static void addExt(long[] xx, long[] yy, long[] zz) {
        for (int i2 = 0; i2 < 13; ++i2) {
            zz[i2] = xx[i2] ^ yy[i2];
        }
    }

    public static void addOne(long[] x2, long[] z2) {
        z2[0] = x2[0] ^ 1L;
        z2[1] = x2[1];
        z2[2] = x2[2];
        z2[3] = x2[3];
        z2[4] = x2[4];
        z2[5] = x2[5];
        z2[6] = x2[6];
    }

    public static long[] fromBigInteger(BigInteger x2) {
        long[] lArray = Nat448.fromBigInteger64(x2);
        SecT409Field.reduce39(lArray, 0);
        return lArray;
    }

    public static void invert(long[] x2, long[] z2) {
        if (Nat448.isZero64(x2)) {
            throw new IllegalStateException();
        }
        long[] lArray = Nat448.create64();
        long[] lArray2 = Nat448.create64();
        long[] lArray3 = Nat448.create64();
        SecT409Field.square(x2, lArray);
        SecT409Field.squareN(lArray, 1, lArray2);
        SecT409Field.multiply(lArray, lArray2, lArray);
        SecT409Field.squareN(lArray2, 1, lArray2);
        SecT409Field.multiply(lArray, lArray2, lArray);
        SecT409Field.squareN(lArray, 3, lArray2);
        SecT409Field.multiply(lArray, lArray2, lArray);
        SecT409Field.squareN(lArray, 6, lArray2);
        SecT409Field.multiply(lArray, lArray2, lArray);
        SecT409Field.squareN(lArray, 12, lArray2);
        SecT409Field.multiply(lArray, lArray2, lArray3);
        SecT409Field.squareN(lArray3, 24, lArray);
        SecT409Field.squareN(lArray, 24, lArray2);
        SecT409Field.multiply(lArray, lArray2, lArray);
        SecT409Field.squareN(lArray, 48, lArray2);
        SecT409Field.multiply(lArray, lArray2, lArray);
        SecT409Field.squareN(lArray, 96, lArray2);
        SecT409Field.multiply(lArray, lArray2, lArray);
        SecT409Field.squareN(lArray, 192, lArray2);
        SecT409Field.multiply(lArray, lArray2, lArray);
        SecT409Field.multiply(lArray, lArray3, z2);
    }

    public static void multiply(long[] x2, long[] y2, long[] z2) {
        long[] lArray = Nat448.createExt64();
        SecT409Field.implMultiply(x2, y2, lArray);
        SecT409Field.reduce(lArray, z2);
    }

    public static void multiplyAddToExt(long[] x2, long[] y2, long[] zz) {
        long[] lArray = Nat448.createExt64();
        SecT409Field.implMultiply(x2, y2, lArray);
        SecT409Field.addExt(zz, lArray, zz);
    }

    public static void reduce(long[] xx, long[] z2) {
        long l2 = xx[0];
        long l3 = xx[1];
        long l4 = xx[2];
        long l5 = xx[3];
        long l6 = xx[4];
        long l7 = xx[5];
        long l8 = xx[6];
        long l9 = xx[7];
        long l10 = xx[12];
        l7 ^= l10 << 39;
        l8 ^= l10 >>> 25 ^ l10 << 62;
        l9 ^= l10 >>> 2;
        l10 = xx[11];
        l6 ^= l10 << 39;
        l7 ^= l10 >>> 25 ^ l10 << 62;
        l8 ^= l10 >>> 2;
        l10 = xx[10];
        l5 ^= l10 << 39;
        l6 ^= l10 >>> 25 ^ l10 << 62;
        l7 ^= l10 >>> 2;
        l10 = xx[9];
        l4 ^= l10 << 39;
        l5 ^= l10 >>> 25 ^ l10 << 62;
        l6 ^= l10 >>> 2;
        l10 = xx[8];
        l3 ^= l10 << 39;
        l4 ^= l10 >>> 25 ^ l10 << 62;
        l5 ^= l10 >>> 2;
        l10 = l9;
        long l11 = l8 >>> 25;
        z2[0] = (l2 ^= l10 << 39) ^ l11;
        z2[1] = (l3 ^= l10 >>> 25 ^ l10 << 62) ^ l11 << 23;
        z2[2] = l4 ^= l10 >>> 2;
        z2[3] = l5;
        z2[4] = l6;
        z2[5] = l7;
        z2[6] = l8 & 0x1FFFFFFL;
    }

    public static void reduce39(long[] z2, int zOff) {
        long l2 = z2[zOff + 6];
        long l3 = l2 >>> 25;
        int n2 = zOff;
        z2[n2] = z2[n2] ^ l3;
        int n3 = zOff + 1;
        z2[n3] = z2[n3] ^ l3 << 23;
        z2[zOff + 6] = l2 & 0x1FFFFFFL;
    }

    public static void sqrt(long[] x2, long[] z2) {
        long l2 = Interleave.unshuffle(x2[0]);
        long l3 = Interleave.unshuffle(x2[1]);
        long l4 = l2 & 0xFFFFFFFFL | l3 << 32;
        long l5 = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        l2 = Interleave.unshuffle(x2[2]);
        l3 = Interleave.unshuffle(x2[3]);
        long l6 = l2 & 0xFFFFFFFFL | l3 << 32;
        long l7 = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        l2 = Interleave.unshuffle(x2[4]);
        l3 = Interleave.unshuffle(x2[5]);
        long l8 = l2 & 0xFFFFFFFFL | l3 << 32;
        long l9 = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        l2 = Interleave.unshuffle(x2[6]);
        long l10 = l2 & 0xFFFFFFFFL;
        long l11 = l2 >>> 32;
        z2[0] = l4 ^ l5 << 44;
        z2[1] = l6 ^ l7 << 44 ^ l5 >>> 20;
        z2[2] = l8 ^ l9 << 44 ^ l7 >>> 20;
        z2[3] = l10 ^ l11 << 44 ^ l9 >>> 20 ^ l5 << 13;
        z2[4] = l11 >>> 20 ^ l7 << 13 ^ l5 >>> 51;
        z2[5] = l9 << 13 ^ l7 >>> 51;
        z2[6] = l11 << 13 ^ l9 >>> 51;
    }

    public static void square(long[] x2, long[] z2) {
        long[] lArray = Nat.create64(13);
        SecT409Field.implSquare(x2, lArray);
        SecT409Field.reduce(lArray, z2);
    }

    public static void squareAddToExt(long[] x2, long[] zz) {
        long[] lArray = Nat.create64(13);
        SecT409Field.implSquare(x2, lArray);
        SecT409Field.addExt(zz, lArray, zz);
    }

    public static void squareN(long[] x2, int n2, long[] z2) {
        long[] lArray = Nat.create64(13);
        SecT409Field.implSquare(x2, lArray);
        SecT409Field.reduce(lArray, z2);
        while (--n2 > 0) {
            SecT409Field.implSquare(z2, lArray);
            SecT409Field.reduce(lArray, z2);
        }
    }

    public static int trace(long[] x2) {
        return (int)x2[0] & 1;
    }

    protected static void implCompactExt(long[] zz) {
        long l2 = zz[0];
        long l3 = zz[1];
        long l4 = zz[2];
        long l5 = zz[3];
        long l6 = zz[4];
        long l7 = zz[5];
        long l8 = zz[6];
        long l9 = zz[7];
        long l10 = zz[8];
        long l11 = zz[9];
        long l12 = zz[10];
        long l13 = zz[11];
        long l14 = zz[12];
        long l15 = zz[13];
        zz[0] = l2 ^ l3 << 59;
        zz[1] = l3 >>> 5 ^ l4 << 54;
        zz[2] = l4 >>> 10 ^ l5 << 49;
        zz[3] = l5 >>> 15 ^ l6 << 44;
        zz[4] = l6 >>> 20 ^ l7 << 39;
        zz[5] = l7 >>> 25 ^ l8 << 34;
        zz[6] = l8 >>> 30 ^ l9 << 29;
        zz[7] = l9 >>> 35 ^ l10 << 24;
        zz[8] = l10 >>> 40 ^ l11 << 19;
        zz[9] = l11 >>> 45 ^ l12 << 14;
        zz[10] = l12 >>> 50 ^ l13 << 9;
        zz[11] = l13 >>> 55 ^ l14 << 4 ^ l15 << 63;
        zz[12] = l14 >>> 60 ^ l15 >>> 1;
        zz[13] = 0L;
    }

    protected static void implExpand(long[] x2, long[] z2) {
        long l2 = x2[0];
        long l3 = x2[1];
        long l4 = x2[2];
        long l5 = x2[3];
        long l6 = x2[4];
        long l7 = x2[5];
        long l8 = x2[6];
        z2[0] = l2 & 0x7FFFFFFFFFFFFFFL;
        z2[1] = (l2 >>> 59 ^ l3 << 5) & 0x7FFFFFFFFFFFFFFL;
        z2[2] = (l3 >>> 54 ^ l4 << 10) & 0x7FFFFFFFFFFFFFFL;
        z2[3] = (l4 >>> 49 ^ l5 << 15) & 0x7FFFFFFFFFFFFFFL;
        z2[4] = (l5 >>> 44 ^ l6 << 20) & 0x7FFFFFFFFFFFFFFL;
        z2[5] = (l6 >>> 39 ^ l7 << 25) & 0x7FFFFFFFFFFFFFFL;
        z2[6] = l7 >>> 34 ^ l8 << 30;
    }

    protected static void implMultiply(long[] x2, long[] y2, long[] zz) {
        long[] lArray = new long[7];
        long[] lArray2 = new long[7];
        SecT409Field.implExpand(x2, lArray);
        SecT409Field.implExpand(y2, lArray2);
        for (int i2 = 0; i2 < 7; ++i2) {
            SecT409Field.implMulwAcc(lArray, lArray2[i2], zz, i2);
        }
        SecT409Field.implCompactExt(zz);
    }

    protected static void implMulwAcc(long[] xs, long y2, long[] z2, int zOff) {
        long[] lArray = new long[8];
        lArray[1] = y2;
        lArray[2] = lArray[1] << 1;
        lArray[3] = lArray[2] ^ y2;
        lArray[4] = lArray[2] << 1;
        lArray[5] = lArray[4] ^ y2;
        lArray[6] = lArray[3] << 1;
        lArray[7] = lArray[6] ^ y2;
        for (int i2 = 0; i2 < 7; ++i2) {
            long l2 = xs[i2];
            int n2 = (int)l2;
            long l3 = 0L;
            long l4 = lArray[n2 & 7] ^ lArray[n2 >>> 3 & 7] << 3;
            int n3 = 54;
            do {
                n2 = (int)(l2 >>> n3);
                long l5 = lArray[n2 & 7] ^ lArray[n2 >>> 3 & 7] << 3;
                l4 ^= l5 << n3;
                l3 ^= l5 >>> -n3;
            } while ((n3 -= 6) > 0);
            int n4 = zOff + i2;
            z2[n4] = z2[n4] ^ l4 & 0x7FFFFFFFFFFFFFFL;
            int n5 = zOff + i2 + 1;
            z2[n5] = z2[n5] ^ (l4 >>> 59 ^ l3 << 5);
        }
    }

    protected static void implSquare(long[] x2, long[] zz) {
        for (int i2 = 0; i2 < 6; ++i2) {
            Interleave.expand64To128(x2[i2], zz, i2 << 1);
        }
        zz[12] = Interleave.expand32to64((int)x2[6]);
    }
}

