/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecT409Field;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat448;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class SecT409FieldElement
extends ECFieldElement.AbstractF2m {
    protected long[] x;

    public SecT409FieldElement(BigInteger x2) {
        if (x2 == null || x2.signum() < 0 || x2.bitLength() > 409) {
            throw new IllegalArgumentException("x value invalid for SecT409FieldElement");
        }
        this.x = SecT409Field.fromBigInteger(x2);
    }

    public SecT409FieldElement() {
        this.x = Nat448.create64();
    }

    protected SecT409FieldElement(long[] x2) {
        this.x = x2;
    }

    @Override
    public boolean isOne() {
        return Nat448.isOne64(this.x);
    }

    @Override
    public boolean isZero() {
        return Nat448.isZero64(this.x);
    }

    @Override
    public boolean testBitZero() {
        return (this.x[0] & 1L) != 0L;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat448.toBigInteger64(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecT409Field";
    }

    @Override
    public int getFieldSize() {
        return 409;
    }

    @Override
    public ECFieldElement add(ECFieldElement b2) {
        long[] lArray = Nat448.create64();
        SecT409Field.add(this.x, ((SecT409FieldElement)b2).x, lArray);
        return new SecT409FieldElement(lArray);
    }

    @Override
    public ECFieldElement addOne() {
        long[] lArray = Nat448.create64();
        SecT409Field.addOne(this.x, lArray);
        return new SecT409FieldElement(lArray);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement b2) {
        return this.add(b2);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement b2) {
        long[] lArray = Nat448.create64();
        SecT409Field.multiply(this.x, ((SecT409FieldElement)b2).x, lArray);
        return new SecT409FieldElement(lArray);
    }

    @Override
    public ECFieldElement multiplyMinusProduct(ECFieldElement b2, ECFieldElement x2, ECFieldElement y2) {
        return this.multiplyPlusProduct(b2, x2, y2);
    }

    @Override
    public ECFieldElement multiplyPlusProduct(ECFieldElement b2, ECFieldElement x2, ECFieldElement y2) {
        long[] lArray = this.x;
        long[] lArray2 = ((SecT409FieldElement)b2).x;
        long[] lArray3 = ((SecT409FieldElement)x2).x;
        long[] lArray4 = ((SecT409FieldElement)y2).x;
        long[] lArray5 = Nat.create64(13);
        SecT409Field.multiplyAddToExt(lArray, lArray2, lArray5);
        SecT409Field.multiplyAddToExt(lArray3, lArray4, lArray5);
        long[] lArray6 = Nat448.create64();
        SecT409Field.reduce(lArray5, lArray6);
        return new SecT409FieldElement(lArray6);
    }

    @Override
    public ECFieldElement divide(ECFieldElement b2) {
        return this.multiply(b2.invert());
    }

    @Override
    public ECFieldElement negate() {
        return this;
    }

    @Override
    public ECFieldElement square() {
        long[] lArray = Nat448.create64();
        SecT409Field.square(this.x, lArray);
        return new SecT409FieldElement(lArray);
    }

    @Override
    public ECFieldElement squareMinusProduct(ECFieldElement x2, ECFieldElement y2) {
        return this.squarePlusProduct(x2, y2);
    }

    @Override
    public ECFieldElement squarePlusProduct(ECFieldElement x2, ECFieldElement y2) {
        long[] lArray = this.x;
        long[] lArray2 = ((SecT409FieldElement)x2).x;
        long[] lArray3 = ((SecT409FieldElement)y2).x;
        long[] lArray4 = Nat.create64(13);
        SecT409Field.squareAddToExt(lArray, lArray4);
        SecT409Field.multiplyAddToExt(lArray2, lArray3, lArray4);
        long[] lArray5 = Nat448.create64();
        SecT409Field.reduce(lArray4, lArray5);
        return new SecT409FieldElement(lArray5);
    }

    @Override
    public ECFieldElement squarePow(int pow) {
        if (pow < 1) {
            return this;
        }
        long[] lArray = Nat448.create64();
        SecT409Field.squareN(this.x, pow, lArray);
        return new SecT409FieldElement(lArray);
    }

    @Override
    public int trace() {
        return SecT409Field.trace(this.x);
    }

    @Override
    public ECFieldElement invert() {
        long[] lArray = Nat448.create64();
        SecT409Field.invert(this.x, lArray);
        return new SecT409FieldElement(lArray);
    }

    @Override
    public ECFieldElement sqrt() {
        long[] lArray = Nat448.create64();
        SecT409Field.sqrt(this.x, lArray);
        return new SecT409FieldElement(lArray);
    }

    public int getRepresentation() {
        return 2;
    }

    public int getM() {
        return 409;
    }

    public int getK1() {
        return 87;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SecT409FieldElement)) {
            return false;
        }
        SecT409FieldElement secT409FieldElement = (SecT409FieldElement)other;
        return Nat448.eq64(this.x, secT409FieldElement.x);
    }

    public int hashCode() {
        return 0x3E68E7 ^ Arrays.hashCode(this.x, 0, 7);
    }
}

