/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.rfc7748;

import com.enterprisedt.bouncycastle.math.raw.Nat;

public abstract class X448Field {
    public static final int SIZE = 16;

    private X448Field() {
    }

    public static void add(int[] x2, int[] y2, int[] z2) {
        for (int i2 = 0; i2 < 16; ++i2) {
            z2[i2] = x2[i2] + y2[i2];
        }
    }

    public static void addOne(int[] z2) {
        z2[0] = z2[0] + 1;
    }

    public static void addOne(int[] z2, int zOff) {
        int n2 = zOff;
        z2[n2] = z2[n2] + 1;
    }

    public static void carry(int[] z2) {
        int n2 = z2[0];
        int n3 = z2[1];
        int n4 = z2[2];
        int n5 = z2[3];
        int n6 = z2[4];
        int n7 = z2[5];
        int n8 = z2[6];
        int n9 = z2[7];
        int n10 = z2[8];
        int n11 = z2[9];
        int n12 = z2[10];
        int n13 = z2[11];
        int n14 = z2[12];
        int n15 = z2[13];
        int n16 = z2[14];
        int n17 = z2[15];
        n4 += n3 >>> 28;
        n3 &= 0xFFFFFFF;
        n8 += n7 >>> 28;
        n7 &= 0xFFFFFFF;
        n12 += n11 >>> 28;
        n11 &= 0xFFFFFFF;
        n16 += n15 >>> 28;
        n15 &= 0xFFFFFFF;
        n5 += n4 >>> 28;
        n4 &= 0xFFFFFFF;
        n9 += n8 >>> 28;
        n8 &= 0xFFFFFFF;
        n13 += n12 >>> 28;
        n12 &= 0xFFFFFFF;
        n17 += n16 >>> 28;
        n16 &= 0xFFFFFFF;
        int n18 = n17 >>> 28;
        n17 &= 0xFFFFFFF;
        n2 += n18;
        n10 += n18;
        n6 += n5 >>> 28;
        n5 &= 0xFFFFFFF;
        n10 += n9 >>> 28;
        n9 &= 0xFFFFFFF;
        n14 += n13 >>> 28;
        n13 &= 0xFFFFFFF;
        n3 += n2 >>> 28;
        n2 &= 0xFFFFFFF;
        n7 += n6 >>> 28;
        n6 &= 0xFFFFFFF;
        n11 += n10 >>> 28;
        n10 &= 0xFFFFFFF;
        n15 += n14 >>> 28;
        n14 &= 0xFFFFFFF;
        z2[0] = n2;
        z2[1] = n3;
        z2[2] = n4;
        z2[3] = n5;
        z2[4] = n6;
        z2[5] = n7;
        z2[6] = n8;
        z2[7] = n9;
        z2[8] = n10;
        z2[9] = n11;
        z2[10] = n12;
        z2[11] = n13;
        z2[12] = n14;
        z2[13] = n15;
        z2[14] = n16;
        z2[15] = n17;
    }

    public static void cnegate(int negate, int[] z2) {
        int[] nArray = X448Field.create();
        X448Field.sub(nArray, z2, nArray);
        Nat.cmov(16, negate, nArray, 0, z2, 0);
    }

    public static void copy(int[] x2, int xOff, int[] z2, int zOff) {
        for (int i2 = 0; i2 < 16; ++i2) {
            z2[zOff + i2] = x2[xOff + i2];
        }
    }

    public static int[] create() {
        return new int[16];
    }

    public static int[] createTable(int n2) {
        return new int[16 * n2];
    }

    public static void cswap(int swap, int[] a2, int[] b2) {
        int n2 = 0 - swap;
        for (int i2 = 0; i2 < 16; ++i2) {
            int n3 = a2[i2];
            int n4 = b2[i2];
            int n5 = n2 & (n3 ^ n4);
            a2[i2] = n3 ^ n5;
            b2[i2] = n4 ^ n5;
        }
    }

    public static void decode(byte[] x2, int xOff, int[] z2) {
        X448Field.a(x2, xOff, z2, 0);
        X448Field.a(x2, xOff + 7, z2, 2);
        X448Field.a(x2, xOff + 14, z2, 4);
        X448Field.a(x2, xOff + 21, z2, 6);
        X448Field.a(x2, xOff + 28, z2, 8);
        X448Field.a(x2, xOff + 35, z2, 10);
        X448Field.a(x2, xOff + 42, z2, 12);
        X448Field.a(x2, xOff + 49, z2, 14);
    }

    private static int a(byte[] byArray, int n2) {
        int n3 = byArray[n2] & 0xFF;
        n3 |= (byArray[++n2] & 0xFF) << 8;
        return n3 |= (byArray[++n2] & 0xFF) << 16;
    }

    private static int b(byte[] byArray, int n2) {
        int n3 = byArray[n2] & 0xFF;
        n3 |= (byArray[++n2] & 0xFF) << 8;
        n3 |= (byArray[++n2] & 0xFF) << 16;
        return n3 |= byArray[++n2] << 24;
    }

    private static void a(byte[] byArray, int n2, int[] nArray, int n3) {
        int n4 = X448Field.b(byArray, n2);
        int n5 = X448Field.a(byArray, n2 + 4);
        nArray[n3] = n4 & 0xFFFFFFF;
        nArray[n3 + 1] = n4 >>> 28 | n5 << 4;
    }

    public static void encode(int[] x2, byte[] z2, int zOff) {
        X448Field.a(x2, 0, z2, zOff);
        X448Field.a(x2, 2, z2, zOff + 7);
        X448Field.a(x2, 4, z2, zOff + 14);
        X448Field.a(x2, 6, z2, zOff + 21);
        X448Field.a(x2, 8, z2, zOff + 28);
        X448Field.a(x2, 10, z2, zOff + 35);
        X448Field.a(x2, 12, z2, zOff + 42);
        X448Field.a(x2, 14, z2, zOff + 49);
    }

    private static void a(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)n2;
        byArray[++n3] = (byte)(n2 >>> 8);
        byArray[++n3] = (byte)(n2 >>> 16);
    }

    private static void b(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)n2;
        byArray[++n3] = (byte)(n2 >>> 8);
        byArray[++n3] = (byte)(n2 >>> 16);
        byArray[++n3] = (byte)(n2 >>> 24);
    }

    private static void a(int[] nArray, int n2, byte[] byArray, int n3) {
        int n4 = nArray[n2];
        int n5 = nArray[n2 + 1];
        X448Field.b(n4 | n5 << 28, byArray, n3);
        X448Field.a(n5 >>> 4, byArray, n3 + 4);
    }

    public static void inv(int[] x2, int[] z2) {
        int[] nArray = X448Field.create();
        X448Field.a(x2, nArray);
        X448Field.sqr(nArray, 2, nArray);
        X448Field.mul(nArray, x2, z2);
    }

    public static boolean isZeroVar(int[] x2) {
        int n2 = 0;
        for (int i2 = 0; i2 < 16; ++i2) {
            n2 |= x2[i2];
        }
        return n2 == 0;
    }

    public static void mul(int[] x2, int y2, int[] z2) {
        int n2 = x2[0];
        int n3 = x2[1];
        int n4 = x2[2];
        int n5 = x2[3];
        int n6 = x2[4];
        int n7 = x2[5];
        int n8 = x2[6];
        int n9 = x2[7];
        int n10 = x2[8];
        int n11 = x2[9];
        int n12 = x2[10];
        int n13 = x2[11];
        int n14 = x2[12];
        int n15 = x2[13];
        int n16 = x2[14];
        int n17 = x2[15];
        long l2 = (long)n3 * (long)y2;
        int n18 = (int)l2 & 0xFFFFFFF;
        l2 >>>= 28;
        long l3 = (long)n7 * (long)y2;
        int n19 = (int)l3 & 0xFFFFFFF;
        l3 >>>= 28;
        long l4 = (long)n11 * (long)y2;
        int n20 = (int)l4 & 0xFFFFFFF;
        l4 >>>= 28;
        long l5 = (long)n15 * (long)y2;
        int n21 = (int)l5 & 0xFFFFFFF;
        l5 >>>= 28;
        z2[2] = (int)(l2 += (long)n4 * (long)y2) & 0xFFFFFFF;
        l2 >>>= 28;
        z2[6] = (int)(l3 += (long)n8 * (long)y2) & 0xFFFFFFF;
        l3 >>>= 28;
        z2[10] = (int)(l4 += (long)n12 * (long)y2) & 0xFFFFFFF;
        l4 >>>= 28;
        z2[14] = (int)(l5 += (long)n16 * (long)y2) & 0xFFFFFFF;
        l5 >>>= 28;
        z2[3] = (int)(l2 += (long)n5 * (long)y2) & 0xFFFFFFF;
        l2 >>>= 28;
        z2[7] = (int)(l3 += (long)n9 * (long)y2) & 0xFFFFFFF;
        l3 >>>= 28;
        z2[11] = (int)(l4 += (long)n13 * (long)y2) & 0xFFFFFFF;
        l4 >>>= 28;
        z2[15] = (int)(l5 += (long)n17 * (long)y2) & 0xFFFFFFF;
        l3 += (l5 >>>= 28);
        z2[4] = (int)(l2 += (long)n6 * (long)y2) & 0xFFFFFFF;
        l2 >>>= 28;
        z2[8] = (int)(l3 += (long)n10 * (long)y2) & 0xFFFFFFF;
        z2[12] = (int)(l4 += (long)n14 * (long)y2) & 0xFFFFFFF;
        z2[0] = (int)(l5 += (long)n2 * (long)y2) & 0xFFFFFFF;
        z2[1] = n18 + (int)(l5 >>>= 28);
        z2[5] = n19 + (int)l2;
        z2[9] = n20 + (int)(l3 >>>= 28);
        z2[13] = n21 + (int)(l4 >>>= 28);
    }

    public static void mul(int[] x2, int[] y2, int[] z2) {
        int n2 = x2[0];
        int n3 = x2[1];
        int n4 = x2[2];
        int n5 = x2[3];
        int n6 = x2[4];
        int n7 = x2[5];
        int n8 = x2[6];
        int n9 = x2[7];
        int n10 = x2[8];
        int n11 = x2[9];
        int n12 = x2[10];
        int n13 = x2[11];
        int n14 = x2[12];
        int n15 = x2[13];
        int n16 = x2[14];
        int n17 = x2[15];
        int n18 = y2[0];
        int n19 = y2[1];
        int n20 = y2[2];
        int n21 = y2[3];
        int n22 = y2[4];
        int n23 = y2[5];
        int n24 = y2[6];
        int n25 = y2[7];
        int n26 = y2[8];
        int n27 = y2[9];
        int n28 = y2[10];
        int n29 = y2[11];
        int n30 = y2[12];
        int n31 = y2[13];
        int n32 = y2[14];
        int n33 = y2[15];
        int n34 = n2 + n10;
        int n35 = n3 + n11;
        int n36 = n4 + n12;
        int n37 = n5 + n13;
        int n38 = n6 + n14;
        int n39 = n7 + n15;
        int n40 = n8 + n16;
        int n41 = n9 + n17;
        int n42 = n18 + n26;
        int n43 = n19 + n27;
        int n44 = n20 + n28;
        int n45 = n21 + n29;
        int n46 = n22 + n30;
        int n47 = n23 + n31;
        int n48 = n24 + n32;
        int n49 = n25 + n33;
        long l2 = (long)n2 * (long)n18;
        long l3 = (long)n9 * (long)n19 + (long)n8 * (long)n20 + (long)n7 * (long)n21 + (long)n6 * (long)n22 + (long)n5 * (long)n23 + (long)n4 * (long)n24 + (long)n3 * (long)n25;
        long l4 = (long)n10 * (long)n26;
        long l5 = (long)n17 * (long)n27 + (long)n16 * (long)n28 + (long)n15 * (long)n29 + (long)n14 * (long)n30 + (long)n13 * (long)n31 + (long)n12 * (long)n32 + (long)n11 * (long)n33;
        long l6 = (long)n34 * (long)n42;
        long l7 = (long)n41 * (long)n43 + (long)n40 * (long)n44 + (long)n39 * (long)n45 + (long)n38 * (long)n46 + (long)n37 * (long)n47 + (long)n36 * (long)n48 + (long)n35 * (long)n49;
        long l8 = l2 + l4 + l7 - l3;
        int n50 = (int)l8 & 0xFFFFFFF;
        l8 >>>= 28;
        long l9 = l5 + l6 - l2 + l7;
        int n51 = (int)l9 & 0xFFFFFFF;
        l9 >>>= 28;
        long l10 = (long)n3 * (long)n18 + (long)n2 * (long)n19;
        long l11 = (long)n9 * (long)n20 + (long)n8 * (long)n21 + (long)n7 * (long)n22 + (long)n6 * (long)n23 + (long)n5 * (long)n24 + (long)n4 * (long)n25;
        long l12 = (long)n11 * (long)n26 + (long)n10 * (long)n27;
        long l13 = (long)n17 * (long)n28 + (long)n16 * (long)n29 + (long)n15 * (long)n30 + (long)n14 * (long)n31 + (long)n13 * (long)n32 + (long)n12 * (long)n33;
        long l14 = (long)n35 * (long)n42 + (long)n34 * (long)n43;
        long l15 = (long)n41 * (long)n44 + (long)n40 * (long)n45 + (long)n39 * (long)n46 + (long)n38 * (long)n47 + (long)n37 * (long)n48 + (long)n36 * (long)n49;
        int n52 = (int)(l8 += l10 + l12 + l15 - l11) & 0xFFFFFFF;
        l8 >>>= 28;
        int n53 = (int)(l9 += l13 + l14 - l10 + l15) & 0xFFFFFFF;
        l9 >>>= 28;
        long l16 = (long)n4 * (long)n18 + (long)n3 * (long)n19 + (long)n2 * (long)n20;
        long l17 = (long)n9 * (long)n21 + (long)n8 * (long)n22 + (long)n7 * (long)n23 + (long)n6 * (long)n24 + (long)n5 * (long)n25;
        long l18 = (long)n12 * (long)n26 + (long)n11 * (long)n27 + (long)n10 * (long)n28;
        long l19 = (long)n17 * (long)n29 + (long)n16 * (long)n30 + (long)n15 * (long)n31 + (long)n14 * (long)n32 + (long)n13 * (long)n33;
        long l20 = (long)n36 * (long)n42 + (long)n35 * (long)n43 + (long)n34 * (long)n44;
        long l21 = (long)n41 * (long)n45 + (long)n40 * (long)n46 + (long)n39 * (long)n47 + (long)n38 * (long)n48 + (long)n37 * (long)n49;
        int n54 = (int)(l8 += l16 + l18 + l21 - l17) & 0xFFFFFFF;
        l8 >>>= 28;
        int n55 = (int)(l9 += l19 + l20 - l16 + l21) & 0xFFFFFFF;
        l9 >>>= 28;
        long l22 = (long)n5 * (long)n18 + (long)n4 * (long)n19 + (long)n3 * (long)n20 + (long)n2 * (long)n21;
        long l23 = (long)n9 * (long)n22 + (long)n8 * (long)n23 + (long)n7 * (long)n24 + (long)n6 * (long)n25;
        long l24 = (long)n13 * (long)n26 + (long)n12 * (long)n27 + (long)n11 * (long)n28 + (long)n10 * (long)n29;
        long l25 = (long)n17 * (long)n30 + (long)n16 * (long)n31 + (long)n15 * (long)n32 + (long)n14 * (long)n33;
        long l26 = (long)n37 * (long)n42 + (long)n36 * (long)n43 + (long)n35 * (long)n44 + (long)n34 * (long)n45;
        long l27 = (long)n41 * (long)n46 + (long)n40 * (long)n47 + (long)n39 * (long)n48 + (long)n38 * (long)n49;
        int n56 = (int)(l8 += l22 + l24 + l27 - l23) & 0xFFFFFFF;
        l8 >>>= 28;
        int n57 = (int)(l9 += l25 + l26 - l22 + l27) & 0xFFFFFFF;
        l9 >>>= 28;
        long l28 = (long)n6 * (long)n18 + (long)n5 * (long)n19 + (long)n4 * (long)n20 + (long)n3 * (long)n21 + (long)n2 * (long)n22;
        long l29 = (long)n9 * (long)n23 + (long)n8 * (long)n24 + (long)n7 * (long)n25;
        long l30 = (long)n14 * (long)n26 + (long)n13 * (long)n27 + (long)n12 * (long)n28 + (long)n11 * (long)n29 + (long)n10 * (long)n30;
        long l31 = (long)n17 * (long)n31 + (long)n16 * (long)n32 + (long)n15 * (long)n33;
        long l32 = (long)n38 * (long)n42 + (long)n37 * (long)n43 + (long)n36 * (long)n44 + (long)n35 * (long)n45 + (long)n34 * (long)n46;
        long l33 = (long)n41 * (long)n47 + (long)n40 * (long)n48 + (long)n39 * (long)n49;
        int n58 = (int)(l8 += l28 + l30 + l33 - l29) & 0xFFFFFFF;
        l8 >>>= 28;
        int n59 = (int)(l9 += l31 + l32 - l28 + l33) & 0xFFFFFFF;
        l9 >>>= 28;
        long l34 = (long)n7 * (long)n18 + (long)n6 * (long)n19 + (long)n5 * (long)n20 + (long)n4 * (long)n21 + (long)n3 * (long)n22 + (long)n2 * (long)n23;
        long l35 = (long)n9 * (long)n24 + (long)n8 * (long)n25;
        long l36 = (long)n15 * (long)n26 + (long)n14 * (long)n27 + (long)n13 * (long)n28 + (long)n12 * (long)n29 + (long)n11 * (long)n30 + (long)n10 * (long)n31;
        long l37 = (long)n17 * (long)n32 + (long)n16 * (long)n33;
        long l38 = (long)n39 * (long)n42 + (long)n38 * (long)n43 + (long)n37 * (long)n44 + (long)n36 * (long)n45 + (long)n35 * (long)n46 + (long)n34 * (long)n47;
        long l39 = (long)n41 * (long)n48 + (long)n40 * (long)n49;
        int n60 = (int)(l8 += l34 + l36 + l39 - l35) & 0xFFFFFFF;
        l8 >>>= 28;
        int n61 = (int)(l9 += l37 + l38 - l34 + l39) & 0xFFFFFFF;
        l9 >>>= 28;
        long l40 = (long)n8 * (long)n18 + (long)n7 * (long)n19 + (long)n6 * (long)n20 + (long)n5 * (long)n21 + (long)n4 * (long)n22 + (long)n3 * (long)n23 + (long)n2 * (long)n24;
        long l41 = (long)n9 * (long)n25;
        long l42 = (long)n16 * (long)n26 + (long)n15 * (long)n27 + (long)n14 * (long)n28 + (long)n13 * (long)n29 + (long)n12 * (long)n30 + (long)n11 * (long)n31 + (long)n10 * (long)n32;
        long l43 = (long)n17 * (long)n33;
        long l44 = (long)n40 * (long)n42 + (long)n39 * (long)n43 + (long)n38 * (long)n44 + (long)n37 * (long)n45 + (long)n36 * (long)n46 + (long)n35 * (long)n47 + (long)n34 * (long)n48;
        long l45 = (long)n41 * (long)n49;
        int n62 = (int)(l8 += l40 + l42 + l45 - l41) & 0xFFFFFFF;
        l8 >>>= 28;
        int n63 = (int)(l9 += l43 + l44 - l40 + l45) & 0xFFFFFFF;
        l9 >>>= 28;
        long l46 = (long)n9 * (long)n18 + (long)n8 * (long)n19 + (long)n7 * (long)n20 + (long)n6 * (long)n21 + (long)n5 * (long)n22 + (long)n4 * (long)n23 + (long)n3 * (long)n24 + (long)n2 * (long)n25;
        long l47 = (long)n17 * (long)n26 + (long)n16 * (long)n27 + (long)n15 * (long)n28 + (long)n14 * (long)n29 + (long)n13 * (long)n30 + (long)n12 * (long)n31 + (long)n11 * (long)n32 + (long)n10 * (long)n33;
        long l48 = (long)n41 * (long)n42 + (long)n40 * (long)n43 + (long)n39 * (long)n44 + (long)n38 * (long)n45 + (long)n37 * (long)n46 + (long)n36 * (long)n47 + (long)n35 * (long)n48 + (long)n34 * (long)n49;
        int n64 = (int)(l8 += l46 + l47) & 0xFFFFFFF;
        l8 >>>= 28;
        int n65 = (int)(l9 += l48 - l46) & 0xFFFFFFF;
        l8 += (l9 >>>= 28);
        l8 += (long)n51;
        n51 = (int)l8 & 0xFFFFFFF;
        l9 += (long)n50;
        n50 = (int)l9 & 0xFFFFFFF;
        n53 += (int)(l8 >>>= 28);
        z2[0] = n50;
        z2[1] = n52 += (int)(l9 >>>= 28);
        z2[2] = n54;
        z2[3] = n56;
        z2[4] = n58;
        z2[5] = n60;
        z2[6] = n62;
        z2[7] = n64;
        z2[8] = n51;
        z2[9] = n53;
        z2[10] = n55;
        z2[11] = n57;
        z2[12] = n59;
        z2[13] = n61;
        z2[14] = n63;
        z2[15] = n65;
    }

    public static void negate(int[] x2, int[] z2) {
        int[] nArray = X448Field.create();
        X448Field.sub(nArray, x2, z2);
    }

    public static void normalize(int[] z2) {
        X448Field.a(z2, 1);
        X448Field.a(z2, -1);
    }

    public static void one(int[] z2) {
        z2[0] = 1;
        for (int i2 = 1; i2 < 16; ++i2) {
            z2[i2] = 0;
        }
    }

    private static void a(int[] nArray, int[] nArray2) {
        int[] nArray3 = X448Field.create();
        X448Field.sqr(nArray, nArray3);
        X448Field.mul(nArray, nArray3, nArray3);
        int[] nArray4 = X448Field.create();
        X448Field.sqr(nArray3, nArray4);
        X448Field.mul(nArray, nArray4, nArray4);
        int[] nArray5 = X448Field.create();
        X448Field.sqr(nArray4, 3, nArray5);
        X448Field.mul(nArray4, nArray5, nArray5);
        int[] nArray6 = X448Field.create();
        X448Field.sqr(nArray5, 3, nArray6);
        X448Field.mul(nArray4, nArray6, nArray6);
        int[] nArray7 = X448Field.create();
        X448Field.sqr(nArray6, 9, nArray7);
        X448Field.mul(nArray6, nArray7, nArray7);
        int[] nArray8 = X448Field.create();
        X448Field.sqr(nArray7, nArray8);
        X448Field.mul(nArray, nArray8, nArray8);
        int[] nArray9 = X448Field.create();
        X448Field.sqr(nArray8, 18, nArray9);
        X448Field.mul(nArray7, nArray9, nArray9);
        int[] nArray10 = X448Field.create();
        X448Field.sqr(nArray9, 37, nArray10);
        X448Field.mul(nArray9, nArray10, nArray10);
        int[] nArray11 = X448Field.create();
        X448Field.sqr(nArray10, 37, nArray11);
        X448Field.mul(nArray9, nArray11, nArray11);
        int[] nArray12 = X448Field.create();
        X448Field.sqr(nArray11, 111, nArray12);
        X448Field.mul(nArray11, nArray12, nArray12);
        int[] nArray13 = X448Field.create();
        X448Field.sqr(nArray12, nArray13);
        X448Field.mul(nArray, nArray13, nArray13);
        int[] nArray14 = X448Field.create();
        X448Field.sqr(nArray13, 223, nArray14);
        X448Field.mul(nArray14, nArray12, nArray2);
    }

    private static void a(int[] nArray, int n2) {
        int n3 = nArray[15];
        int n4 = n3 & 0xFFFFFFF;
        n3 = (n3 >> 28) + n2;
        nArray[8] = nArray[8] + n3;
        for (int i2 = 0; i2 < 15; ++i2) {
            nArray[i2] = (n3 += nArray[i2]) & 0xFFFFFFF;
            n3 >>= 28;
        }
        nArray[15] = n4 + n3;
    }

    public static void sqr(int[] x2, int[] z2) {
        int n2 = x2[0];
        int n3 = x2[1];
        int n4 = x2[2];
        int n5 = x2[3];
        int n6 = x2[4];
        int n7 = x2[5];
        int n8 = x2[6];
        int n9 = x2[7];
        int n10 = x2[8];
        int n11 = x2[9];
        int n12 = x2[10];
        int n13 = x2[11];
        int n14 = x2[12];
        int n15 = x2[13];
        int n16 = x2[14];
        int n17 = x2[15];
        int n18 = n2 * 2;
        int n19 = n3 * 2;
        int n20 = n4 * 2;
        int n21 = n5 * 2;
        int n22 = n6 * 2;
        int n23 = n7 * 2;
        int n24 = n8 * 2;
        int n25 = n10 * 2;
        int n26 = n11 * 2;
        int n27 = n12 * 2;
        int n28 = n13 * 2;
        int n29 = n14 * 2;
        int n30 = n15 * 2;
        int n31 = n16 * 2;
        int n32 = n2 + n10;
        int n33 = n3 + n11;
        int n34 = n4 + n12;
        int n35 = n5 + n13;
        int n36 = n6 + n14;
        int n37 = n7 + n15;
        int n38 = n8 + n16;
        int n39 = n9 + n17;
        int n40 = n32 * 2;
        int n41 = n33 * 2;
        int n42 = n34 * 2;
        int n43 = n35 * 2;
        int n44 = n36 * 2;
        int n45 = n37 * 2;
        int n46 = n38 * 2;
        long l2 = (long)n2 * (long)n2;
        long l3 = (long)n9 * (long)n19 + (long)n8 * (long)n20 + (long)n7 * (long)n21 + (long)n6 * (long)n6;
        long l4 = (long)n10 * (long)n10;
        long l5 = (long)n17 * (long)n26 + (long)n16 * (long)n27 + (long)n15 * (long)n28 + (long)n14 * (long)n14;
        long l6 = (long)n32 * (long)n32;
        long l7 = (long)n39 * (long)n41 + (long)n38 * (long)n42 + (long)n37 * (long)n43 + (long)n36 * (long)n36;
        long l8 = l2 + l4 + l7 - l3;
        int n47 = (int)l8 & 0xFFFFFFF;
        l8 >>>= 28;
        long l9 = l5 + l6 - l2 + l7;
        int n48 = (int)l9 & 0xFFFFFFF;
        l9 >>>= 28;
        long l10 = (long)n3 * (long)n18;
        long l11 = (long)n9 * (long)n20 + (long)n8 * (long)n21 + (long)n7 * (long)n22;
        long l12 = (long)n11 * (long)n25;
        long l13 = (long)n17 * (long)n27 + (long)n16 * (long)n28 + (long)n15 * (long)n29;
        long l14 = (long)n33 * (long)n40;
        long l15 = (long)n39 * (long)n42 + (long)n38 * (long)n43 + (long)n37 * (long)n44;
        int n49 = (int)(l8 += l10 + l12 + l15 - l11) & 0xFFFFFFF;
        l8 >>>= 28;
        int n50 = (int)(l9 += l13 + l14 - l10 + l15) & 0xFFFFFFF;
        l9 >>>= 28;
        long l16 = (long)n4 * (long)n18 + (long)n3 * (long)n3;
        long l17 = (long)n9 * (long)n21 + (long)n8 * (long)n22 + (long)n7 * (long)n7;
        long l18 = (long)n12 * (long)n25 + (long)n11 * (long)n11;
        long l19 = (long)n17 * (long)n28 + (long)n16 * (long)n29 + (long)n15 * (long)n15;
        long l20 = (long)n34 * (long)n40 + (long)n33 * (long)n33;
        long l21 = (long)n39 * (long)n43 + (long)n38 * (long)n44 + (long)n37 * (long)n37;
        int n51 = (int)(l8 += l16 + l18 + l21 - l17) & 0xFFFFFFF;
        l8 >>>= 28;
        int n52 = (int)(l9 += l19 + l20 - l16 + l21) & 0xFFFFFFF;
        l9 >>>= 28;
        long l22 = (long)n5 * (long)n18 + (long)n4 * (long)n19;
        long l23 = (long)n9 * (long)n22 + (long)n8 * (long)n23;
        long l24 = (long)n13 * (long)n25 + (long)n12 * (long)n26;
        long l25 = (long)n17 * (long)n29 + (long)n16 * (long)n30;
        long l26 = (long)n35 * (long)n40 + (long)n34 * (long)n41;
        long l27 = (long)n39 * (long)n44 + (long)n38 * (long)n45;
        int n53 = (int)(l8 += l22 + l24 + l27 - l23) & 0xFFFFFFF;
        l8 >>>= 28;
        int n54 = (int)(l9 += l25 + l26 - l22 + l27) & 0xFFFFFFF;
        l9 >>>= 28;
        long l28 = (long)n6 * (long)n18 + (long)n5 * (long)n19 + (long)n4 * (long)n4;
        long l29 = (long)n9 * (long)n23 + (long)n8 * (long)n8;
        long l30 = (long)n14 * (long)n25 + (long)n13 * (long)n26 + (long)n12 * (long)n12;
        long l31 = (long)n17 * (long)n30 + (long)n16 * (long)n16;
        long l32 = (long)n36 * (long)n40 + (long)n35 * (long)n41 + (long)n34 * (long)n34;
        long l33 = (long)n39 * (long)n45 + (long)n38 * (long)n38;
        int n55 = (int)(l8 += l28 + l30 + l33 - l29) & 0xFFFFFFF;
        l8 >>>= 28;
        int n56 = (int)(l9 += l31 + l32 - l28 + l33) & 0xFFFFFFF;
        l9 >>>= 28;
        long l34 = (long)n7 * (long)n18 + (long)n6 * (long)n19 + (long)n5 * (long)n20;
        long l35 = (long)n9 * (long)n24;
        long l36 = (long)n15 * (long)n25 + (long)n14 * (long)n26 + (long)n13 * (long)n27;
        long l37 = (long)n17 * (long)n31;
        long l38 = (long)n37 * (long)n40 + (long)n36 * (long)n41 + (long)n35 * (long)n42;
        long l39 = (long)n39 * (long)n46;
        int n57 = (int)(l8 += l34 + l36 + l39 - l35) & 0xFFFFFFF;
        l8 >>>= 28;
        int n58 = (int)(l9 += l37 + l38 - l34 + l39) & 0xFFFFFFF;
        l9 >>>= 28;
        long l40 = (long)n8 * (long)n18 + (long)n7 * (long)n19 + (long)n6 * (long)n20 + (long)n5 * (long)n5;
        long l41 = (long)n9 * (long)n9;
        long l42 = (long)n16 * (long)n25 + (long)n15 * (long)n26 + (long)n14 * (long)n27 + (long)n13 * (long)n13;
        long l43 = (long)n17 * (long)n17;
        long l44 = (long)n38 * (long)n40 + (long)n37 * (long)n41 + (long)n36 * (long)n42 + (long)n35 * (long)n35;
        long l45 = (long)n39 * (long)n39;
        int n59 = (int)(l8 += l40 + l42 + l45 - l41) & 0xFFFFFFF;
        l8 >>>= 28;
        int n60 = (int)(l9 += l43 + l44 - l40 + l45) & 0xFFFFFFF;
        l9 >>>= 28;
        long l46 = (long)n9 * (long)n18 + (long)n8 * (long)n19 + (long)n7 * (long)n20 + (long)n6 * (long)n21;
        long l47 = (long)n17 * (long)n25 + (long)n16 * (long)n26 + (long)n15 * (long)n27 + (long)n14 * (long)n28;
        long l48 = (long)n39 * (long)n40 + (long)n38 * (long)n41 + (long)n37 * (long)n42 + (long)n36 * (long)n43;
        int n61 = (int)(l8 += l46 + l47) & 0xFFFFFFF;
        l8 >>>= 28;
        int n62 = (int)(l9 += l48 - l46) & 0xFFFFFFF;
        l8 += (l9 >>>= 28);
        l8 += (long)n48;
        n48 = (int)l8 & 0xFFFFFFF;
        l9 += (long)n47;
        n47 = (int)l9 & 0xFFFFFFF;
        n50 += (int)(l8 >>>= 28);
        z2[0] = n47;
        z2[1] = n49 += (int)(l9 >>>= 28);
        z2[2] = n51;
        z2[3] = n53;
        z2[4] = n55;
        z2[5] = n57;
        z2[6] = n59;
        z2[7] = n61;
        z2[8] = n48;
        z2[9] = n50;
        z2[10] = n52;
        z2[11] = n54;
        z2[12] = n56;
        z2[13] = n58;
        z2[14] = n60;
        z2[15] = n62;
    }

    public static void sqr(int[] x2, int n2, int[] z2) {
        X448Field.sqr(x2, z2);
        while (--n2 > 0) {
            X448Field.sqr(z2, z2);
        }
    }

    public static boolean sqrtRatioVar(int[] u2, int[] v2, int[] z2) {
        int[] nArray = X448Field.create();
        int[] nArray2 = X448Field.create();
        X448Field.sqr(u2, nArray);
        X448Field.mul(nArray, v2, nArray);
        X448Field.sqr(nArray, nArray2);
        X448Field.mul(nArray, u2, nArray);
        X448Field.mul(nArray2, u2, nArray2);
        X448Field.mul(nArray2, v2, nArray2);
        int[] nArray3 = X448Field.create();
        X448Field.a(nArray2, nArray3);
        X448Field.mul(nArray3, nArray, nArray3);
        int[] nArray4 = X448Field.create();
        X448Field.sqr(nArray3, nArray4);
        X448Field.mul(nArray4, v2, nArray4);
        X448Field.sub(u2, nArray4, nArray4);
        X448Field.normalize(nArray4);
        if (X448Field.isZeroVar(nArray4)) {
            X448Field.copy(nArray3, 0, z2, 0);
            return true;
        }
        return false;
    }

    public static void sub(int[] x2, int[] y2, int[] z2) {
        int n2 = x2[0];
        int n3 = x2[1];
        int n4 = x2[2];
        int n5 = x2[3];
        int n6 = x2[4];
        int n7 = x2[5];
        int n8 = x2[6];
        int n9 = x2[7];
        int n10 = x2[8];
        int n11 = x2[9];
        int n12 = x2[10];
        int n13 = x2[11];
        int n14 = x2[12];
        int n15 = x2[13];
        int n16 = x2[14];
        int n17 = x2[15];
        int n18 = y2[0];
        int n19 = y2[1];
        int n20 = y2[2];
        int n21 = y2[3];
        int n22 = y2[4];
        int n23 = y2[5];
        int n24 = y2[6];
        int n25 = y2[7];
        int n26 = y2[8];
        int n27 = y2[9];
        int n28 = y2[10];
        int n29 = y2[11];
        int n30 = y2[12];
        int n31 = y2[13];
        int n32 = y2[14];
        int n33 = y2[15];
        int n34 = n2 + 0x1FFFFFFE - n18;
        int n35 = n3 + 0x1FFFFFFE - n19;
        int n36 = n4 + 0x1FFFFFFE - n20;
        int n37 = n5 + 0x1FFFFFFE - n21;
        int n38 = n6 + 0x1FFFFFFE - n22;
        int n39 = n7 + 0x1FFFFFFE - n23;
        int n40 = n8 + 0x1FFFFFFE - n24;
        int n41 = n9 + 0x1FFFFFFE - n25;
        int n42 = n10 + 0x1FFFFFFC - n26;
        int n43 = n11 + 0x1FFFFFFE - n27;
        int n44 = n12 + 0x1FFFFFFE - n28;
        int n45 = n13 + 0x1FFFFFFE - n29;
        int n46 = n14 + 0x1FFFFFFE - n30;
        int n47 = n15 + 0x1FFFFFFE - n31;
        int n48 = n16 + 0x1FFFFFFE - n32;
        int n49 = n17 + 0x1FFFFFFE - n33;
        n36 += n35 >>> 28;
        n35 &= 0xFFFFFFF;
        n40 += n39 >>> 28;
        n39 &= 0xFFFFFFF;
        n44 += n43 >>> 28;
        n43 &= 0xFFFFFFF;
        n48 += n47 >>> 28;
        n47 &= 0xFFFFFFF;
        n37 += n36 >>> 28;
        n36 &= 0xFFFFFFF;
        n41 += n40 >>> 28;
        n40 &= 0xFFFFFFF;
        n45 += n44 >>> 28;
        n44 &= 0xFFFFFFF;
        n49 += n48 >>> 28;
        n48 &= 0xFFFFFFF;
        int n50 = n49 >>> 28;
        n49 &= 0xFFFFFFF;
        n34 += n50;
        n42 += n50;
        n38 += n37 >>> 28;
        n37 &= 0xFFFFFFF;
        n42 += n41 >>> 28;
        n41 &= 0xFFFFFFF;
        n46 += n45 >>> 28;
        n45 &= 0xFFFFFFF;
        n35 += n34 >>> 28;
        n34 &= 0xFFFFFFF;
        n39 += n38 >>> 28;
        n38 &= 0xFFFFFFF;
        n43 += n42 >>> 28;
        n42 &= 0xFFFFFFF;
        n47 += n46 >>> 28;
        n46 &= 0xFFFFFFF;
        z2[0] = n34;
        z2[1] = n35;
        z2[2] = n36;
        z2[3] = n37;
        z2[4] = n38;
        z2[5] = n39;
        z2[6] = n40;
        z2[7] = n41;
        z2[8] = n42;
        z2[9] = n43;
        z2[10] = n44;
        z2[11] = n45;
        z2[12] = n46;
        z2[13] = n47;
        z2[14] = n48;
        z2[15] = n49;
    }

    public static void subOne(int[] z2) {
        int[] nArray = X448Field.create();
        nArray[0] = 1;
        X448Field.sub(z2, nArray, z2);
    }

    public static void zero(int[] z2) {
        for (int i2 = 0; i2 < 16; ++i2) {
            z2[i2] = 0;
        }
    }
}

