/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.rfc8032;

import com.enterprisedt.bouncycastle.crypto.digests.SHA512Digest;
import com.enterprisedt.bouncycastle.math.ec.rfc7748.X25519Field;
import com.enterprisedt.bouncycastle.math.raw.Interleave;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat256;
import com.enterprisedt.bouncycastle.util.Arrays;

public abstract class Ed25519 {
    public static final int PUBLIC_KEY_SIZE = 32;
    public static final int SECRET_KEY_SIZE = 32;
    public static final int SIGNATURE_SIZE = 64;
    private static final int[] a = new int[]{-19, -1, -1, -1, -1, -1, -1, Integer.MAX_VALUE};
    private static final int[] b = new int[]{1559614445, 1477600026, -1560830762, 350157278, 0, 0, 0, 0x10000000};
    private static final int[] c = new int[]{52811034, 25909283, 8072341, 50637101, 13785486, 30858332, 20483199, 20966410, 43936626, 4379245};
    private static final int[] d = new int[]{40265304, 0x1999999, 0x666666, 0x3333333, 0xCCCCCC, 0x2666666, 0x1999999, 0x666666, 0x3333333, 0xCCCCCC};
    private static final int[] e = new int[]{56195235, 47411844, 25868126, 40503822, 57364, 58321048, 30416477, 31930572, 57760639, 10749657};
    private static final int[] f = new int[]{45281625, 27714825, 18181821, 0xD4141D, 114729, 49533232, 60832955, 30306712, 48412415, 4722099};
    private static final int[] g = new int[]{23454386, 55429651, 2809210, 27797563, 229458, 31957600, 54557047, 27058993, 29715967, 9444199};
    private static a[] h = null;
    private static int[] i = null;

    private static byte[] a(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int[] nArray = new int[16];
        Ed25519.a(byArray, 0, nArray);
        int[] nArray2 = new int[8];
        Ed25519.a(byArray2, 0, nArray2);
        int[] nArray3 = new int[8];
        Ed25519.a(byArray3, 0, nArray3);
        Nat256.mulAddTo(nArray2, nArray3, nArray);
        byte[] byArray4 = new byte[64];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Ed25519.b(nArray[i2], byArray4, i2 * 4);
        }
        return Ed25519.c(byArray4);
    }

    private static boolean a(byte[] byArray) {
        int[] nArray = new int[8];
        Ed25519.a(byArray, 0, nArray, 0, 8);
        nArray[7] = nArray[7] & Integer.MAX_VALUE;
        return !Nat256.gte(nArray, a);
    }

    private static boolean b(byte[] byArray) {
        int[] nArray = new int[8];
        Ed25519.a(byArray, 0, nArray);
        return !Nat256.gte(nArray, b);
    }

    private static int a(byte[] byArray, int n2) {
        int n3 = byArray[n2] & 0xFF;
        n3 |= (byArray[++n2] & 0xFF) << 8;
        return n3 |= (byArray[++n2] & 0xFF) << 16;
    }

    private static int b(byte[] byArray, int n2) {
        int n3 = byArray[n2] & 0xFF;
        n3 |= (byArray[++n2] & 0xFF) << 8;
        n3 |= (byArray[++n2] & 0xFF) << 16;
        return n3 |= byArray[++n2] << 24;
    }

    private static void a(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray[n3 + i2] = Ed25519.b(byArray, n2 + i2 * 4);
        }
    }

    private static boolean a(byte[] byArray, int n2, boolean bl, a a2) {
        byte[] byArray2 = Arrays.copyOfRange(byArray, n2, n2 + 32);
        if (!Ed25519.a(byArray2)) {
            return false;
        }
        int n3 = (byArray2[31] & 0x80) >>> 7;
        byArray2[31] = (byte)(byArray2[31] & 0x7F);
        X25519Field.decode(byArray2, 0, a2.b);
        int[] nArray = X25519Field.create();
        int[] nArray2 = X25519Field.create();
        X25519Field.sqr(a2.b, nArray);
        X25519Field.mul(e, nArray, nArray2);
        X25519Field.subOne(nArray);
        X25519Field.addOne(nArray2);
        if (!X25519Field.sqrtRatioVar(nArray, nArray2, a2.a)) {
            return false;
        }
        X25519Field.normalize(a2.a);
        if (n3 == 1 && X25519Field.isZeroVar(a2.a)) {
            return false;
        }
        if (bl ^ n3 != (a2.a[0] & 1)) {
            X25519Field.negate(a2.a, a2.a);
        }
        Ed25519.c(a2);
        return true;
    }

    private static void a(byte[] byArray, int n2, int[] nArray) {
        Ed25519.a(byArray, n2, nArray, 0, 8);
    }

    private static void a(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)n2;
        byArray[++n3] = (byte)(n2 >>> 8);
        byArray[++n3] = (byte)(n2 >>> 16);
    }

    private static void b(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)n2;
        byArray[++n3] = (byte)(n2 >>> 8);
        byArray[++n3] = (byte)(n2 >>> 16);
        byArray[++n3] = (byte)(n2 >>> 24);
    }

    private static void a(long l2, byte[] byArray, int n2) {
        Ed25519.b((int)l2, byArray, n2);
        Ed25519.a((int)(l2 >>> 32), byArray, n2 + 4);
    }

    private static void a(a a2, byte[] byArray, int n2) {
        int[] nArray = X25519Field.create();
        int[] nArray2 = X25519Field.create();
        X25519Field.inv(a2.c, nArray2);
        X25519Field.mul(a2.a, nArray2, nArray);
        X25519Field.mul(a2.b, nArray2, nArray2);
        X25519Field.normalize(nArray);
        X25519Field.normalize(nArray2);
        X25519Field.encode(nArray2, byArray, n2);
        int n3 = n2 + 32 - 1;
        byArray[n3] = (byte)(byArray[n3] | (nArray[0] & 1) << 7);
    }

    public static void generatePublicKey(byte[] sk, int skOff, byte[] pk, int pkOff) {
        SHA512Digest sHA512Digest = new SHA512Digest();
        byte[] byArray = new byte[sHA512Digest.getDigestSize()];
        sHA512Digest.update(sk, skOff, 32);
        sHA512Digest.doFinal(byArray, 0);
        byte[] byArray2 = new byte[32];
        Ed25519.a(byArray, 0, byArray2);
        Ed25519.a(byArray2, pk, pkOff);
    }

    private static byte[] a(int[] nArray, int n2) {
        int n3;
        int[] nArray2 = new int[16];
        int n4 = nArray2.length;
        int n5 = 0;
        int n6 = 8;
        while (--n6 >= 0) {
            n3 = nArray[n6];
            nArray2[--n4] = n3 >>> 16 | n5 << 16;
            nArray2[--n4] = n5 = n3;
        }
        byte[] byArray = new byte[256];
        n5 = 1 << n2;
        n6 = n5 - 1;
        n3 = n5 >>> 1;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < nArray2.length) {
            int n10 = nArray2[n9];
            while (n7 < 16) {
                int n11 = n10 >>> n7;
                int n12 = n11 & 1;
                if (n12 == n8) {
                    ++n7;
                    continue;
                }
                int n13 = (n11 & n6) + n8;
                n8 = n13 & n3;
                n13 -= n8 << 1;
                n8 >>>= n2 - 1;
                byArray[(n9 << 4) + n7] = (byte)n13;
                n7 += n2;
            }
            ++n9;
            n7 -= 16;
        }
        return byArray;
    }

    private static void a(SHA512Digest sHA512Digest, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, byte[] byArray4, int n3, int n4, byte[] byArray5, int n5) {
        sHA512Digest.update(byArray, 32, 32);
        sHA512Digest.update(byArray4, n3, n4);
        sHA512Digest.doFinal(byArray, 0);
        byte[] byArray6 = Ed25519.c(byArray);
        byte[] byArray7 = new byte[32];
        Ed25519.a(byArray6, byArray7, 0);
        sHA512Digest.update(byArray7, 0, 32);
        sHA512Digest.update(byArray3, 0, 32);
        sHA512Digest.update(byArray4, n3, n4);
        sHA512Digest.doFinal(byArray, 0);
        byte[] byArray8 = Ed25519.c(byArray);
        byte[] byArray9 = Ed25519.a(byArray6, byArray8, byArray2);
        System.arraycopy(byArray7, 0, byArray5, n5, 32);
        System.arraycopy(byArray9, 0, byArray5, n5 + 32, 32);
    }

    private static void a(boolean bl, a a2, a a3) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        int[] nArray5 = X25519Field.create();
        int[] nArray6 = X25519Field.create();
        int[] nArray7 = X25519Field.create();
        int[] nArray8 = X25519Field.create();
        int[] nArray9 = X25519Field.create();
        int[] nArray10 = X25519Field.create();
        int[] nArray11 = X25519Field.create();
        int[] nArray12 = X25519Field.create();
        if (bl) {
            nArray4 = nArray8;
            nArray3 = nArray7;
            nArray2 = nArray11;
            nArray = nArray10;
        } else {
            nArray4 = nArray7;
            nArray3 = nArray8;
            nArray2 = nArray10;
            nArray = nArray11;
        }
        X25519Field.apm(a3.b, a3.a, nArray6, nArray5);
        X25519Field.apm(a2.b, a2.a, nArray3, nArray4);
        X25519Field.mul(nArray5, nArray7, nArray5);
        X25519Field.mul(nArray6, nArray8, nArray6);
        X25519Field.mul(a3.d, a2.d, nArray7);
        X25519Field.mul(nArray7, f, nArray7);
        X25519Field.mul(a3.c, a2.c, nArray8);
        X25519Field.add(nArray8, nArray8, nArray8);
        X25519Field.apm(nArray6, nArray5, nArray12, nArray9);
        X25519Field.apm(nArray8, nArray7, nArray, nArray2);
        X25519Field.carry(nArray);
        X25519Field.mul(nArray9, nArray10, a3.a);
        X25519Field.mul(nArray11, nArray12, a3.b);
        X25519Field.mul(nArray10, nArray11, a3.c);
        X25519Field.mul(nArray9, nArray12, a3.d);
    }

    private static void a(b b2, a a2) {
        int[] nArray = X25519Field.create();
        int[] nArray2 = X25519Field.create();
        int[] nArray3 = X25519Field.create();
        int[] nArray4 = X25519Field.create();
        int[] nArray5 = X25519Field.create();
        int[] nArray6 = X25519Field.create();
        int[] nArray7 = X25519Field.create();
        X25519Field.apm(a2.b, a2.a, nArray2, nArray);
        X25519Field.mul(nArray, b2.b, nArray);
        X25519Field.mul(nArray2, b2.a, nArray2);
        X25519Field.mul(a2.d, b2.c, nArray3);
        X25519Field.apm(nArray2, nArray, nArray7, nArray4);
        X25519Field.apm(a2.c, nArray3, nArray6, nArray5);
        X25519Field.carry(nArray6);
        X25519Field.mul(nArray4, nArray5, a2.a);
        X25519Field.mul(nArray6, nArray7, a2.b);
        X25519Field.mul(nArray5, nArray6, a2.c);
        X25519Field.mul(nArray4, nArray7, a2.d);
    }

    private static a a(a a2) {
        a a3 = new a();
        X25519Field.copy(a2.a, 0, a3.a, 0);
        X25519Field.copy(a2.b, 0, a3.b, 0);
        X25519Field.copy(a2.c, 0, a3.c, 0);
        X25519Field.copy(a2.d, 0, a3.d, 0);
        return a3;
    }

    private static void b(a a2) {
        int[] nArray = X25519Field.create();
        int[] nArray2 = X25519Field.create();
        int[] nArray3 = X25519Field.create();
        int[] nArray4 = X25519Field.create();
        int[] nArray5 = X25519Field.create();
        int[] nArray6 = X25519Field.create();
        int[] nArray7 = X25519Field.create();
        X25519Field.sqr(a2.a, nArray);
        X25519Field.sqr(a2.b, nArray2);
        X25519Field.sqr(a2.c, nArray3);
        X25519Field.add(nArray3, nArray3, nArray3);
        X25519Field.apm(nArray, nArray2, nArray7, nArray6);
        X25519Field.add(a2.a, a2.b, nArray4);
        X25519Field.sqr(nArray4, nArray4);
        X25519Field.sub(nArray7, nArray4, nArray4);
        X25519Field.add(nArray3, nArray6, nArray5);
        X25519Field.carry(nArray5);
        X25519Field.mul(nArray4, nArray5, a2.a);
        X25519Field.mul(nArray6, nArray7, a2.b);
        X25519Field.mul(nArray5, nArray6, a2.c);
        X25519Field.mul(nArray4, nArray7, a2.d);
    }

    private static void c(a a2) {
        X25519Field.one(a2.c);
        X25519Field.mul(a2.a, a2.b, a2.d);
    }

    private static void a(int n2, int n3, b b2) {
        int n4 = n2 * 8 * 3 * 10;
        for (int i2 = 0; i2 < 8; ++i2) {
            int n5 = (i2 ^ n3) - 1 >> 31;
            Nat.cmov(10, n5, i, n4, b2.a, 0);
            Nat.cmov(10, n5, i, n4 += 10, b2.b, 0);
            Nat.cmov(10, n5, i, n4 += 10, b2.c, 0);
            n4 += 10;
        }
    }

    private static a[] a(a a2, int n2) {
        a a3 = Ed25519.a(a2);
        Ed25519.b(a3);
        a[] aArray = new a[n2];
        aArray[0] = Ed25519.a(a2);
        for (int i2 = 1; i2 < n2; ++i2) {
            aArray[i2] = Ed25519.a(aArray[i2 - 1]);
            Ed25519.a(false, a3, aArray[i2]);
        }
        return aArray;
    }

    private static void d(a a2) {
        X25519Field.zero(a2.a);
        X25519Field.one(a2.b);
        X25519Field.one(a2.c);
        X25519Field.zero(a2.d);
    }

    public static synchronized void precompute() {
        if (i != null) {
            return;
        }
        a a2 = new a();
        X25519Field.copy(c, 0, a2.a, 0);
        X25519Field.copy(d, 0, a2.b, 0);
        Ed25519.c(a2);
        h = Ed25519.a(a2, 32);
        i = new int[1920];
        int n2 = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            int n3;
            int n4;
            a[] aArray = new a[4];
            a a3 = new a();
            Ed25519.d(a3);
            for (int i3 = 0; i3 < 4; ++i3) {
                Ed25519.a(true, a2, a3);
                Ed25519.b(a2);
                aArray[i3] = Ed25519.a(a2);
                for (n4 = 1; n4 < 8; ++n4) {
                    Ed25519.b(a2);
                }
            }
            a[] aArray2 = new a[8];
            n4 = 0;
            aArray2[n4++] = a3;
            for (n3 = 0; n3 < 3; ++n3) {
                int n5 = 1 << n3;
                for (int i4 = 0; i4 < n5; ++i4) {
                    aArray2[n4] = Ed25519.a(aArray2[n4 - n5]);
                    Ed25519.a(false, aArray[n3], aArray2[n4++]);
                }
            }
            for (n3 = 0; n3 < 8; ++n3) {
                a a4 = aArray2[n3];
                int[] nArray = X25519Field.create();
                int[] nArray2 = X25519Field.create();
                X25519Field.add(a4.c, a4.c, nArray);
                X25519Field.inv(nArray, nArray2);
                X25519Field.mul(a4.a, nArray2, nArray);
                X25519Field.mul(a4.b, nArray2, nArray2);
                b b2 = new b();
                X25519Field.apm(nArray2, nArray, b2.a, b2.b);
                X25519Field.mul(nArray, nArray2, b2.c);
                X25519Field.mul(b2.c, g, b2.c);
                X25519Field.normalize(b2.a);
                X25519Field.normalize(b2.b);
                X25519Field.copy(b2.a, 0, i, n2);
                X25519Field.copy(b2.b, 0, i, n2 += 10);
                X25519Field.copy(b2.c, 0, i, n2 += 10);
                n2 += 10;
            }
        }
    }

    private static void a(byte[] byArray, int n2, byte[] byArray2) {
        System.arraycopy(byArray, n2, byArray2, 0, 32);
        byArray2[0] = (byte)(byArray2[0] & 0xF8);
        byArray2[31] = (byte)(byArray2[31] & 0x7F);
        byArray2[31] = (byte)(byArray2[31] | 0x40);
    }

    private static byte[] c(byte[] byArray) {
        long l2 = (long)Ed25519.b(byArray, 0) & 0xFFFFFFFFL;
        long l3 = (long)(Ed25519.a(byArray, 4) << 4) & 0xFFFFFFFFL;
        long l4 = (long)Ed25519.b(byArray, 7) & 0xFFFFFFFFL;
        long l5 = (long)(Ed25519.a(byArray, 11) << 4) & 0xFFFFFFFFL;
        long l6 = (long)Ed25519.b(byArray, 14) & 0xFFFFFFFFL;
        long l7 = (long)(Ed25519.a(byArray, 18) << 4) & 0xFFFFFFFFL;
        long l8 = (long)Ed25519.b(byArray, 21) & 0xFFFFFFFFL;
        long l9 = (long)(Ed25519.a(byArray, 25) << 4) & 0xFFFFFFFFL;
        long l10 = (long)Ed25519.b(byArray, 28) & 0xFFFFFFFFL;
        long l11 = (long)(Ed25519.a(byArray, 32) << 4) & 0xFFFFFFFFL;
        long l12 = (long)Ed25519.b(byArray, 35) & 0xFFFFFFFFL;
        long l13 = (long)(Ed25519.a(byArray, 39) << 4) & 0xFFFFFFFFL;
        long l14 = (long)Ed25519.b(byArray, 42) & 0xFFFFFFFFL;
        long l15 = (long)(Ed25519.a(byArray, 46) << 4) & 0xFFFFFFFFL;
        long l16 = (long)Ed25519.b(byArray, 49) & 0xFFFFFFFFL;
        long l17 = (long)(Ed25519.a(byArray, 53) << 4) & 0xFFFFFFFFL;
        long l18 = (long)Ed25519.b(byArray, 56) & 0xFFFFFFFFL;
        long l19 = (long)(Ed25519.a(byArray, 60) << 4) & 0xFFFFFFFFL;
        long l20 = (long)byArray[63] & 0xFFL;
        l11 -= l20 * -50998291L;
        l12 -= l20 * 19280294L;
        l13 -= l20 * 127719000L;
        l14 -= l20 * -6428113L;
        l15 -= l20 * 5343L;
        l19 += l18 >> 28;
        l18 &= 0xFFFFFFFL;
        l10 -= l19 * -50998291L;
        l11 -= l19 * 19280294L;
        l12 -= l19 * 127719000L;
        l13 -= l19 * -6428113L;
        l14 -= l19 * 5343L;
        l9 -= l18 * -50998291L;
        l10 -= l18 * 19280294L;
        l11 -= l18 * 127719000L;
        l12 -= l18 * -6428113L;
        l13 -= l18 * 5343L;
        l17 += l16 >> 28;
        l16 &= 0xFFFFFFFL;
        l8 -= l17 * -50998291L;
        l9 -= l17 * 19280294L;
        l10 -= l17 * 127719000L;
        l11 -= l17 * -6428113L;
        l12 -= l17 * 5343L;
        l7 -= l16 * -50998291L;
        l8 -= l16 * 19280294L;
        l9 -= l16 * 127719000L;
        l10 -= l16 * -6428113L;
        l11 -= l16 * 5343L;
        l15 += l14 >> 28;
        l14 &= 0xFFFFFFFL;
        l6 -= l15 * -50998291L;
        l7 -= l15 * 19280294L;
        l8 -= l15 * 127719000L;
        l9 -= l15 * -6428113L;
        l10 -= l15 * 5343L;
        l14 += l13 >> 28;
        l13 &= 0xFFFFFFFL;
        l5 -= l14 * -50998291L;
        l6 -= l14 * 19280294L;
        l7 -= l14 * 127719000L;
        l8 -= l14 * -6428113L;
        l9 -= l14 * 5343L;
        l13 += l12 >> 28;
        l12 &= 0xFFFFFFFL;
        l4 -= l13 * -50998291L;
        l5 -= l13 * 19280294L;
        l6 -= l13 * 127719000L;
        l7 -= l13 * -6428113L;
        l8 -= l13 * 5343L;
        l12 += l11 >> 28;
        l11 &= 0xFFFFFFFL;
        l3 -= l12 * -50998291L;
        l4 -= l12 * 19280294L;
        l5 -= l12 * 127719000L;
        l6 -= l12 * -6428113L;
        l7 -= l12 * 5343L;
        l10 += l9 >> 28;
        l9 &= 0xFFFFFFFL;
        l11 += l10 >> 28;
        long l21 = (l10 &= 0xFFFFFFFL) >>> 27;
        l3 -= l11 * 19280294L;
        l4 -= l11 * 127719000L;
        l5 -= l11 * -6428113L;
        l6 -= l11 * 5343L;
        l2 &= 0xFFFFFFFL;
        l3 &= 0xFFFFFFFL;
        l4 &= 0xFFFFFFFL;
        l5 &= 0xFFFFFFFL;
        l6 &= 0xFFFFFFFL;
        l7 &= 0xFFFFFFFL;
        l8 &= 0xFFFFFFFL;
        l9 &= 0xFFFFFFFL;
        l11 = (l10 += (l9 += (l8 += (l7 += (l6 += (l5 += (l4 += (l3 += (l2 -= (l11 += l21) * -50998291L) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28;
        l10 &= 0xFFFFFFFL;
        l3 += l11 & 0x12631A6L;
        l4 += l11 & 0x79CD658L;
        l5 += l11 & 0xFFFFFFFFFF9DEA2FL;
        l6 += l11 & 0x14DFL;
        l2 &= 0xFFFFFFFL;
        l3 &= 0xFFFFFFFL;
        l4 &= 0xFFFFFFFL;
        l5 &= 0xFFFFFFFL;
        l6 &= 0xFFFFFFFL;
        l7 &= 0xFFFFFFFL;
        l8 &= 0xFFFFFFFL;
        l10 += (l9 += (l8 += (l7 += (l6 += (l5 += (l4 += (l3 += (l2 += (l11 -= l21) & 0xFFFFFFFFFCF5D3EDL) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28;
        byte[] byArray2 = new byte[32];
        Ed25519.a(l2 | l3 << 28, byArray2, 0);
        Ed25519.a(l4 | l5 << 28, byArray2, 7);
        Ed25519.a(l6 | l7 << 28, byArray2, 14);
        Ed25519.a(l8 | (l9 &= 0xFFFFFFFL) << 28, byArray2, 21);
        Ed25519.b((int)l10, byArray2, 28);
        return byArray2;
    }

    private static void a(byte[] byArray, a a2) {
        Ed25519.precompute();
        Ed25519.d(a2);
        int[] nArray = new int[8];
        Ed25519.a(byArray, 0, nArray);
        Nat.cadd(8, ~nArray[0] & 1, nArray, b, nArray);
        Nat.shiftDownBit(8, nArray, 1);
        for (int i2 = 0; i2 < 8; ++i2) {
            nArray[i2] = Interleave.shuffle2(nArray[i2]);
        }
        b b2 = new b();
        int n2 = 28;
        while (true) {
            for (int i3 = 0; i3 < 8; ++i3) {
                int n3 = nArray[i3] >>> n2;
                int n4 = n3 >>> 3 & 1;
                int n5 = (n3 ^ -n4) & 7;
                Ed25519.a(i3, n5, b2);
                X25519Field.cswap(n4, b2.a, b2.b);
                X25519Field.cnegate(n4, b2.c);
                Ed25519.a(b2, a2);
            }
            if ((n2 -= 4) < 0) break;
            Ed25519.b(a2);
        }
    }

    private static void a(byte[] byArray, byte[] byArray2, int n2) {
        a a2 = new a();
        Ed25519.a(byArray, a2);
        Ed25519.a(a2, byArray2, n2);
    }

    private static void a(int[] nArray, int[] nArray2, a a2, a a3) {
        int n2;
        Ed25519.precompute();
        int n3 = 5;
        byte[] byArray = Ed25519.a(nArray, 7);
        byte[] byArray2 = Ed25519.a(nArray2, 5);
        a[] aArray = Ed25519.a(a2, 8);
        Ed25519.d(a3);
        for (n2 = 255; n2 > 0 && (byArray[n2] | byArray2[n2]) == 0; --n2) {
        }
        while (true) {
            int n4;
            int n5;
            byte by;
            if ((by = byArray[n2]) != 0) {
                n5 = by >> 31;
                n4 = (by ^ n5) >>> 1;
                Ed25519.a(n5 != 0, h[n4], a3);
            }
            if ((n5 = byArray2[n2]) != 0) {
                n4 = n5 >> 31;
                int n6 = (n5 ^ n4) >>> 1;
                Ed25519.a(n4 != 0, aArray[n6], a3);
            }
            if (--n2 < 0) break;
            Ed25519.b(a3);
        }
    }

    public static void sign(byte[] sk, int skOff, byte[] m2, int mOff, int mLen, byte[] sig, int sigOff) {
        SHA512Digest sHA512Digest = new SHA512Digest();
        byte[] byArray = new byte[sHA512Digest.getDigestSize()];
        sHA512Digest.update(sk, skOff, 32);
        sHA512Digest.doFinal(byArray, 0);
        byte[] byArray2 = new byte[32];
        Ed25519.a(byArray, 0, byArray2);
        byte[] byArray3 = new byte[32];
        Ed25519.a(byArray2, byArray3, 0);
        Ed25519.a(sHA512Digest, byArray, byArray2, byArray3, 0, m2, mOff, mLen, sig, sigOff);
    }

    public static void sign(byte[] sk, int skOff, byte[] pk, int pkOff, byte[] m2, int mOff, int mLen, byte[] sig, int sigOff) {
        SHA512Digest sHA512Digest = new SHA512Digest();
        byte[] byArray = new byte[sHA512Digest.getDigestSize()];
        sHA512Digest.update(sk, skOff, 32);
        sHA512Digest.doFinal(byArray, 0);
        byte[] byArray2 = new byte[32];
        Ed25519.a(byArray, 0, byArray2);
        Ed25519.a(sHA512Digest, byArray, byArray2, pk, pkOff, m2, mOff, mLen, sig, sigOff);
    }

    public static boolean verify(byte[] sig, int sigOff, byte[] pk, int pkOff, byte[] m2, int mOff, int mLen) {
        byte[] byArray = Arrays.copyOfRange(sig, sigOff, sigOff + 32);
        byte[] byArray2 = Arrays.copyOfRange(sig, sigOff + 32, sigOff + 64);
        if (!Ed25519.a(byArray)) {
            return false;
        }
        if (!Ed25519.b(byArray2)) {
            return false;
        }
        a a2 = new a();
        if (!Ed25519.a(pk, pkOff, true, a2)) {
            return false;
        }
        SHA512Digest sHA512Digest = new SHA512Digest();
        byte[] byArray3 = new byte[sHA512Digest.getDigestSize()];
        sHA512Digest.update(byArray, 0, 32);
        sHA512Digest.update(pk, pkOff, 32);
        sHA512Digest.update(m2, mOff, mLen);
        sHA512Digest.doFinal(byArray3, 0);
        byte[] byArray4 = Ed25519.c(byArray3);
        int[] nArray = new int[8];
        Ed25519.a(byArray2, 0, nArray);
        int[] nArray2 = new int[8];
        Ed25519.a(byArray4, 0, nArray2);
        a a3 = new a();
        Ed25519.a(nArray, nArray2, a2, a3);
        byte[] byArray5 = new byte[32];
        Ed25519.a(a3, byArray5, 0);
        return Arrays.areEqual(byArray5, byArray);
    }

    private static class b {
        int[] a = X25519Field.create();
        int[] b = X25519Field.create();
        int[] c = X25519Field.create();

        private b() {
        }
    }

    private static class a {
        int[] a = X25519Field.create();
        int[] b = X25519Field.create();
        int[] c = X25519Field.create();
        int[] d = X25519Field.create();

        private a() {
        }
    }
}

