/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.rfc8032;

import com.enterprisedt.bouncycastle.crypto.digests.SHAKEDigest;
import com.enterprisedt.bouncycastle.math.ec.rfc7748.X448Field;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Strings;

public abstract class Ed448 {
    public static final int PUBLIC_KEY_SIZE = 57;
    public static final int SECRET_KEY_SIZE = 57;
    public static final int SIGNATURE_SIZE = 114;
    private static final byte[] a = Strings.toByteArray("SigEd448");
    private static final int[] b = new int[]{-1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1};
    private static final int[] c = new int[]{-1420278541, 595116690, -1916432555, 560775794, -1361693040, -1001465015, 2093622249, -1, -1, -1, -1, -1, -1, 0x3FFFFFFF};
    private static final int[] d = new int[]{118276190, 40534716, 9670182, 135141552, 85017403, 259173222, 68333082, 171784774, 174973732, 15824510, 73756743, 57518561, 94773951, 248652241, 107736333, 82941708};
    private static final int[] e = new int[]{36764180, 8885695, 130592152, 20104429, 163904957, 30304195, 121295871, 5901357, 125344798, 171541512, 175338348, 209069246, 3626697, 38307682, 24032956, 110359655};
    private static a[] f = null;
    private static int[] g = null;

    private static byte[] a(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int[] nArray = new int[28];
        Ed448.a(byArray, 0, nArray);
        int[] nArray2 = new int[14];
        Ed448.a(byArray2, 0, nArray2);
        int[] nArray3 = new int[14];
        Ed448.a(byArray3, 0, nArray3);
        Nat.mulAddTo(14, nArray2, nArray3, nArray);
        byte[] byArray4 = new byte[114];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Ed448.b(nArray[i2], byArray4, i2 * 4);
        }
        return Ed448.d(byArray4);
    }

    private static boolean a(byte[] byArray) {
        return byArray != null && byArray.length < 256;
    }

    private static boolean b(byte[] byArray) {
        if ((byArray[56] & 0x7F) != 0) {
            return false;
        }
        int[] nArray = new int[14];
        Ed448.a(byArray, 0, nArray, 0, 14);
        return !Nat.gte(14, nArray, b);
    }

    private static boolean c(byte[] byArray) {
        if (byArray[56] != 0) {
            return false;
        }
        int[] nArray = new int[14];
        Ed448.a(byArray, 0, nArray);
        return !Nat.gte(14, nArray, c);
    }

    private static int a(byte[] byArray, int n2) {
        int n3 = byArray[n2] & 0xFF;
        return n3 |= (byArray[++n2] & 0xFF) << 8;
    }

    private static int b(byte[] byArray, int n2) {
        int n3 = byArray[n2] & 0xFF;
        n3 |= (byArray[++n2] & 0xFF) << 8;
        return n3 |= (byArray[++n2] & 0xFF) << 16;
    }

    private static int c(byte[] byArray, int n2) {
        int n3 = byArray[n2] & 0xFF;
        n3 |= (byArray[++n2] & 0xFF) << 8;
        n3 |= (byArray[++n2] & 0xFF) << 16;
        return n3 |= byArray[++n2] << 24;
    }

    private static void a(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray[n3 + i2] = Ed448.c(byArray, n2 + i2 * 4);
        }
    }

    private static boolean a(byte[] byArray, int n2, boolean bl, a a2) {
        byte[] byArray2 = Arrays.copyOfRange(byArray, n2, n2 + 57);
        if (!Ed448.b(byArray2)) {
            return false;
        }
        int n3 = (byArray2[56] & 0x80) >>> 7;
        byArray2[56] = (byte)(byArray2[56] & 0x7F);
        X448Field.decode(byArray2, 0, a2.b);
        int[] nArray = X448Field.create();
        int[] nArray2 = X448Field.create();
        X448Field.sqr(a2.b, nArray);
        X448Field.mul(nArray, 39081, nArray2);
        X448Field.negate(nArray, nArray);
        X448Field.addOne(nArray);
        X448Field.addOne(nArray2);
        if (!X448Field.sqrtRatioVar(nArray, nArray2, a2.a)) {
            return false;
        }
        X448Field.normalize(a2.a);
        if (n3 == 1 && X448Field.isZeroVar(a2.a)) {
            return false;
        }
        if (bl ^ n3 != (a2.a[0] & 1)) {
            X448Field.negate(a2.a, a2.a);
        }
        Ed448.c(a2);
        return true;
    }

    private static void a(byte[] byArray, int n2, int[] nArray) {
        Ed448.a(byArray, n2, nArray, 0, 14);
    }

    private static void a(SHAKEDigest sHAKEDigest, byte by, byte[] byArray) {
        sHAKEDigest.update(a, 0, a.length);
        sHAKEDigest.update(by);
        sHAKEDigest.update((byte)byArray.length);
        sHAKEDigest.update(byArray, 0, byArray.length);
    }

    private static void a(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)n2;
        byArray[++n3] = (byte)(n2 >>> 8);
        byArray[++n3] = (byte)(n2 >>> 16);
    }

    private static void b(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)n2;
        byArray[++n3] = (byte)(n2 >>> 8);
        byArray[++n3] = (byte)(n2 >>> 16);
        byArray[++n3] = (byte)(n2 >>> 24);
    }

    private static void a(long l2, byte[] byArray, int n2) {
        Ed448.b((int)l2, byArray, n2);
        Ed448.a((int)(l2 >>> 32), byArray, n2 + 4);
    }

    private static void a(a a2, byte[] byArray, int n2) {
        int[] nArray = X448Field.create();
        int[] nArray2 = X448Field.create();
        X448Field.inv(a2.c, nArray2);
        X448Field.mul(a2.a, nArray2, nArray);
        X448Field.mul(a2.b, nArray2, nArray2);
        X448Field.normalize(nArray);
        X448Field.normalize(nArray2);
        X448Field.encode(nArray2, byArray, n2);
        byArray[n2 + 57 - 1] = (byte)((nArray[0] & 1) << 7);
    }

    public static void generatePublicKey(byte[] sk, int skOff, byte[] pk, int pkOff) {
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        byte[] byArray = new byte[114];
        sHAKEDigest.update(sk, skOff, 57);
        sHAKEDigest.doFinal(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[57];
        Ed448.a(byArray, 0, byArray2);
        Ed448.a(byArray2, pk, pkOff);
    }

    private static byte[] a(int[] nArray, int n2) {
        int n3;
        int[] nArray2 = new int[28];
        int n4 = nArray2.length;
        int n5 = 0;
        int n6 = 14;
        while (--n6 >= 0) {
            n3 = nArray[n6];
            nArray2[--n4] = n3 >>> 16 | n5 << 16;
            nArray2[--n4] = n5 = n3;
        }
        byte[] byArray = new byte[448];
        n5 = 1 << n2;
        n6 = n5 - 1;
        n3 = n5 >>> 1;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < nArray2.length) {
            int n10 = nArray2[n9];
            while (n7 < 16) {
                int n11 = n10 >>> n7;
                int n12 = n11 & 1;
                if (n12 == n8) {
                    ++n7;
                    continue;
                }
                int n13 = (n11 & n6) + n8;
                n8 = n13 & n3;
                n13 -= n8 << 1;
                n8 >>>= n2 - 1;
                byArray[(n9 << 4) + n7] = (byte)n13;
                n7 += n2;
            }
            ++n9;
            n7 -= 16;
        }
        return byArray;
    }

    private static void a(SHAKEDigest sHAKEDigest, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, byte[] byArray4, byte[] byArray5, int n3, int n4, byte[] byArray6, int n5) {
        byte by = 0;
        Ed448.a(sHAKEDigest, by, byArray4);
        sHAKEDigest.update(byArray, 57, 57);
        sHAKEDigest.update(byArray5, n3, n4);
        sHAKEDigest.doFinal(byArray, 0, byArray.length);
        byte[] byArray7 = Ed448.d(byArray);
        byte[] byArray8 = new byte[57];
        Ed448.a(byArray7, byArray8, 0);
        Ed448.a(sHAKEDigest, by, byArray4);
        sHAKEDigest.update(byArray8, 0, 57);
        sHAKEDigest.update(byArray3, n2, 57);
        sHAKEDigest.update(byArray5, n3, n4);
        sHAKEDigest.doFinal(byArray, 0, byArray.length);
        byte[] byArray9 = Ed448.d(byArray);
        byte[] byArray10 = Ed448.a(byArray7, byArray9, byArray2);
        System.arraycopy(byArray8, 0, byArray6, n5, 57);
        System.arraycopy(byArray10, 0, byArray6, n5 + 57, 57);
    }

    private static void a(boolean bl, a a2, a a3) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        int[] nArray5 = X448Field.create();
        int[] nArray6 = X448Field.create();
        int[] nArray7 = X448Field.create();
        int[] nArray8 = X448Field.create();
        int[] nArray9 = X448Field.create();
        int[] nArray10 = X448Field.create();
        int[] nArray11 = X448Field.create();
        int[] nArray12 = X448Field.create();
        if (bl) {
            nArray4 = nArray9;
            nArray3 = nArray6;
            nArray2 = nArray11;
            nArray = nArray10;
            X448Field.sub(a2.b, a2.a, nArray12);
        } else {
            nArray4 = nArray6;
            nArray3 = nArray9;
            nArray2 = nArray10;
            nArray = nArray11;
            X448Field.add(a2.b, a2.a, nArray12);
        }
        X448Field.mul(a2.c, a3.c, nArray5);
        X448Field.sqr(nArray5, nArray6);
        X448Field.mul(a2.a, a3.a, nArray7);
        X448Field.mul(a2.b, a3.b, nArray8);
        X448Field.mul(nArray7, nArray8, nArray9);
        X448Field.mul(nArray9, 39081, nArray9);
        X448Field.add(nArray6, nArray9, nArray2);
        X448Field.sub(nArray6, nArray9, nArray);
        X448Field.add(a3.a, a3.b, nArray9);
        X448Field.mul(nArray12, nArray9, nArray12);
        X448Field.add(nArray8, nArray7, nArray4);
        X448Field.sub(nArray8, nArray7, nArray3);
        X448Field.carry(nArray4);
        X448Field.sub(nArray12, nArray6, nArray12);
        X448Field.mul(nArray12, nArray5, nArray12);
        X448Field.mul(nArray9, nArray5, nArray9);
        X448Field.mul(nArray10, nArray12, a3.a);
        X448Field.mul(nArray9, nArray11, a3.b);
        X448Field.mul(nArray10, nArray11, a3.c);
    }

    private static void a(b b2, a a2) {
        int[] nArray = X448Field.create();
        int[] nArray2 = X448Field.create();
        int[] nArray3 = X448Field.create();
        int[] nArray4 = X448Field.create();
        int[] nArray5 = X448Field.create();
        int[] nArray6 = X448Field.create();
        int[] nArray7 = X448Field.create();
        X448Field.sqr(a2.c, nArray);
        X448Field.mul(b2.a, a2.a, nArray2);
        X448Field.mul(b2.b, a2.b, nArray3);
        X448Field.mul(nArray2, nArray3, nArray4);
        X448Field.mul(nArray4, 39081, nArray4);
        X448Field.add(nArray, nArray4, nArray5);
        X448Field.sub(nArray, nArray4, nArray6);
        X448Field.add(b2.a, b2.b, nArray);
        X448Field.add(a2.a, a2.b, nArray4);
        X448Field.mul(nArray, nArray4, nArray7);
        X448Field.add(nArray3, nArray2, nArray);
        X448Field.sub(nArray3, nArray2, nArray4);
        X448Field.carry(nArray);
        X448Field.sub(nArray7, nArray, nArray7);
        X448Field.mul(nArray7, a2.c, nArray7);
        X448Field.mul(nArray4, a2.c, nArray4);
        X448Field.mul(nArray5, nArray7, a2.a);
        X448Field.mul(nArray4, nArray6, a2.b);
        X448Field.mul(nArray5, nArray6, a2.c);
    }

    private static a a(a a2) {
        a a3 = new a();
        X448Field.copy(a2.a, 0, a3.a, 0);
        X448Field.copy(a2.b, 0, a3.b, 0);
        X448Field.copy(a2.c, 0, a3.c, 0);
        return a3;
    }

    private static void b(a a2) {
        int[] nArray = X448Field.create();
        int[] nArray2 = X448Field.create();
        int[] nArray3 = X448Field.create();
        int[] nArray4 = X448Field.create();
        int[] nArray5 = X448Field.create();
        int[] nArray6 = X448Field.create();
        X448Field.add(a2.a, a2.b, nArray);
        X448Field.sqr(nArray, nArray);
        X448Field.sqr(a2.a, nArray2);
        X448Field.sqr(a2.b, nArray3);
        X448Field.add(nArray2, nArray3, nArray4);
        X448Field.carry(nArray4);
        X448Field.sqr(a2.c, nArray5);
        X448Field.add(nArray5, nArray5, nArray5);
        X448Field.carry(nArray5);
        X448Field.sub(nArray4, nArray5, nArray6);
        X448Field.sub(nArray, nArray4, nArray);
        X448Field.sub(nArray2, nArray3, nArray2);
        X448Field.mul(nArray, nArray6, a2.a);
        X448Field.mul(nArray4, nArray2, a2.b);
        X448Field.mul(nArray4, nArray6, a2.c);
    }

    private static void c(a a2) {
        X448Field.one(a2.c);
    }

    private static void a(int n2, int n3, b b2) {
        int n4 = n2 * 16 * 2 * 16;
        for (int i2 = 0; i2 < 16; ++i2) {
            int n5 = (i2 ^ n3) - 1 >> 31;
            Nat.cmov(16, n5, g, n4, b2.a, 0);
            Nat.cmov(16, n5, g, n4 += 16, b2.b, 0);
            n4 += 16;
        }
    }

    private static a[] a(a a2, int n2) {
        a a3 = Ed448.a(a2);
        Ed448.b(a3);
        a[] aArray = new a[n2];
        aArray[0] = Ed448.a(a2);
        for (int i2 = 1; i2 < n2; ++i2) {
            aArray[i2] = Ed448.a(aArray[i2 - 1]);
            Ed448.a(false, a3, aArray[i2]);
        }
        return aArray;
    }

    private static void d(a a2) {
        X448Field.zero(a2.a);
        X448Field.one(a2.b);
        X448Field.one(a2.c);
    }

    public static synchronized void precompute() {
        if (g != null) {
            return;
        }
        a a2 = new a();
        X448Field.copy(d, 0, a2.a, 0);
        X448Field.copy(e, 0, a2.b, 0);
        Ed448.c(a2);
        f = Ed448.a(a2, 32);
        g = new int[2560];
        int n2 = 0;
        for (int i2 = 0; i2 < 5; ++i2) {
            int n3;
            int n4;
            a[] aArray = new a[5];
            a a3 = new a();
            Ed448.d(a3);
            for (int i3 = 0; i3 < 5; ++i3) {
                Ed448.a(true, a2, a3);
                Ed448.b(a2);
                aArray[i3] = Ed448.a(a2);
                for (n4 = 1; n4 < 18; ++n4) {
                    Ed448.b(a2);
                }
            }
            a[] aArray2 = new a[16];
            n4 = 0;
            aArray2[n4++] = a3;
            for (n3 = 0; n3 < 4; ++n3) {
                int n5 = 1 << n3;
                for (int i4 = 0; i4 < n5; ++i4) {
                    aArray2[n4] = Ed448.a(aArray2[n4 - n5]);
                    Ed448.a(false, aArray[n3], aArray2[n4++]);
                }
            }
            for (n3 = 0; n3 < 16; ++n3) {
                a a4 = aArray2[n3];
                X448Field.inv(a4.c, a4.c);
                X448Field.mul(a4.a, a4.c, a4.a);
                X448Field.mul(a4.b, a4.c, a4.b);
                X448Field.copy(a4.a, 0, g, n2);
                X448Field.copy(a4.b, 0, g, n2 += 16);
                n2 += 16;
            }
        }
    }

    private static void a(byte[] byArray, int n2, byte[] byArray2) {
        System.arraycopy(byArray, n2, byArray2, 0, 57);
        byArray2[0] = (byte)(byArray2[0] & 0xFC);
        byArray2[55] = (byte)(byArray2[55] | 0x80);
        byArray2[56] = (byte)(byArray2[56] & 0);
    }

    private static byte[] d(byte[] byArray) {
        long l2 = (long)Ed448.c(byArray, 0) & 0xFFFFFFFFL;
        long l3 = (long)(Ed448.b(byArray, 4) << 4) & 0xFFFFFFFFL;
        long l4 = (long)Ed448.c(byArray, 7) & 0xFFFFFFFFL;
        long l5 = (long)(Ed448.b(byArray, 11) << 4) & 0xFFFFFFFFL;
        long l6 = (long)Ed448.c(byArray, 14) & 0xFFFFFFFFL;
        long l7 = (long)(Ed448.b(byArray, 18) << 4) & 0xFFFFFFFFL;
        long l8 = (long)Ed448.c(byArray, 21) & 0xFFFFFFFFL;
        long l9 = (long)(Ed448.b(byArray, 25) << 4) & 0xFFFFFFFFL;
        long l10 = (long)Ed448.c(byArray, 28) & 0xFFFFFFFFL;
        long l11 = (long)(Ed448.b(byArray, 32) << 4) & 0xFFFFFFFFL;
        long l12 = (long)Ed448.c(byArray, 35) & 0xFFFFFFFFL;
        long l13 = (long)(Ed448.b(byArray, 39) << 4) & 0xFFFFFFFFL;
        long l14 = (long)Ed448.c(byArray, 42) & 0xFFFFFFFFL;
        long l15 = (long)(Ed448.b(byArray, 46) << 4) & 0xFFFFFFFFL;
        long l16 = (long)Ed448.c(byArray, 49) & 0xFFFFFFFFL;
        long l17 = (long)(Ed448.b(byArray, 53) << 4) & 0xFFFFFFFFL;
        long l18 = (long)Ed448.c(byArray, 56) & 0xFFFFFFFFL;
        long l19 = (long)(Ed448.b(byArray, 60) << 4) & 0xFFFFFFFFL;
        long l20 = (long)Ed448.c(byArray, 63) & 0xFFFFFFFFL;
        long l21 = (long)(Ed448.b(byArray, 67) << 4) & 0xFFFFFFFFL;
        long l22 = (long)Ed448.c(byArray, 70) & 0xFFFFFFFFL;
        long l23 = (long)(Ed448.b(byArray, 74) << 4) & 0xFFFFFFFFL;
        long l24 = (long)Ed448.c(byArray, 77) & 0xFFFFFFFFL;
        long l25 = (long)(Ed448.b(byArray, 81) << 4) & 0xFFFFFFFFL;
        long l26 = (long)Ed448.c(byArray, 84) & 0xFFFFFFFFL;
        long l27 = (long)(Ed448.b(byArray, 88) << 4) & 0xFFFFFFFFL;
        long l28 = (long)Ed448.c(byArray, 91) & 0xFFFFFFFFL;
        long l29 = (long)(Ed448.b(byArray, 95) << 4) & 0xFFFFFFFFL;
        long l30 = (long)Ed448.c(byArray, 98) & 0xFFFFFFFFL;
        long l31 = (long)(Ed448.b(byArray, 102) << 4) & 0xFFFFFFFFL;
        long l32 = (long)Ed448.c(byArray, 105) & 0xFFFFFFFFL;
        long l33 = (long)(Ed448.b(byArray, 109) << 4) & 0xFFFFFFFFL;
        long l34 = (long)Ed448.a(byArray, 112) & 0xFFFFFFFFL;
        l18 += l34 * 43969588L;
        l19 += l34 * 30366549L;
        l20 += l34 * 163752818L;
        l21 += l34 * 258169998L;
        l22 += l34 * 96434764L;
        l23 += l34 * 227822194L;
        l24 += l34 * 149865618L;
        l25 += l34 * 550336261L;
        l33 += l32 >>> 28;
        l32 &= 0xFFFFFFFL;
        l17 += l33 * 43969588L;
        l18 += l33 * 30366549L;
        l19 += l33 * 163752818L;
        l20 += l33 * 258169998L;
        l21 += l33 * 96434764L;
        l22 += l33 * 227822194L;
        l23 += l33 * 149865618L;
        l24 += l33 * 550336261L;
        l16 += l32 * 43969588L;
        l17 += l32 * 30366549L;
        l18 += l32 * 163752818L;
        l19 += l32 * 258169998L;
        l20 += l32 * 96434764L;
        l21 += l32 * 227822194L;
        l22 += l32 * 149865618L;
        l23 += l32 * 550336261L;
        l31 += l30 >>> 28;
        l30 &= 0xFFFFFFFL;
        l15 += l31 * 43969588L;
        l16 += l31 * 30366549L;
        l17 += l31 * 163752818L;
        l18 += l31 * 258169998L;
        l19 += l31 * 96434764L;
        l20 += l31 * 227822194L;
        l21 += l31 * 149865618L;
        l22 += l31 * 550336261L;
        l14 += l30 * 43969588L;
        l15 += l30 * 30366549L;
        l16 += l30 * 163752818L;
        l17 += l30 * 258169998L;
        l18 += l30 * 96434764L;
        l19 += l30 * 227822194L;
        l20 += l30 * 149865618L;
        l21 += l30 * 550336261L;
        l29 += l28 >>> 28;
        l28 &= 0xFFFFFFFL;
        l13 += l29 * 43969588L;
        l14 += l29 * 30366549L;
        l15 += l29 * 163752818L;
        l16 += l29 * 258169998L;
        l17 += l29 * 96434764L;
        l18 += l29 * 227822194L;
        l19 += l29 * 149865618L;
        l20 += l29 * 550336261L;
        l12 += l28 * 43969588L;
        l13 += l28 * 30366549L;
        l14 += l28 * 163752818L;
        l15 += l28 * 258169998L;
        l16 += l28 * 96434764L;
        l17 += l28 * 227822194L;
        l18 += l28 * 149865618L;
        l19 += l28 * 550336261L;
        l27 += l26 >>> 28;
        l26 &= 0xFFFFFFFL;
        l11 += l27 * 43969588L;
        l12 += l27 * 30366549L;
        l13 += l27 * 163752818L;
        l14 += l27 * 258169998L;
        l15 += l27 * 96434764L;
        l16 += l27 * 227822194L;
        l17 += l27 * 149865618L;
        l18 += l27 * 550336261L;
        l23 += l22 >>> 28;
        l22 &= 0xFFFFFFFL;
        l24 += l23 >>> 28;
        l23 &= 0xFFFFFFFL;
        l25 += l24 >>> 28;
        l24 &= 0xFFFFFFFL;
        l26 += l25 >>> 28;
        l25 &= 0xFFFFFFFL;
        l10 += l26 * 43969588L;
        l11 += l26 * 30366549L;
        l12 += l26 * 163752818L;
        l13 += l26 * 258169998L;
        l14 += l26 * 96434764L;
        l15 += l26 * 227822194L;
        l16 += l26 * 149865618L;
        l17 += l26 * 550336261L;
        l9 += l25 * 43969588L;
        l10 += l25 * 30366549L;
        l11 += l25 * 163752818L;
        l12 += l25 * 258169998L;
        l13 += l25 * 96434764L;
        l14 += l25 * 227822194L;
        l15 += l25 * 149865618L;
        l16 += l25 * 550336261L;
        l8 += l24 * 43969588L;
        l9 += l24 * 30366549L;
        l10 += l24 * 163752818L;
        l11 += l24 * 258169998L;
        l12 += l24 * 96434764L;
        l13 += l24 * 227822194L;
        l14 += l24 * 149865618L;
        l15 += l24 * 550336261L;
        l20 += l19 >>> 28;
        l19 &= 0xFFFFFFFL;
        l21 += l20 >>> 28;
        l20 &= 0xFFFFFFFL;
        l22 += l21 >>> 28;
        l21 &= 0xFFFFFFFL;
        l23 += l22 >>> 28;
        l22 &= 0xFFFFFFFL;
        l7 += l23 * 43969588L;
        l8 += l23 * 30366549L;
        l9 += l23 * 163752818L;
        l10 += l23 * 258169998L;
        l11 += l23 * 96434764L;
        l12 += l23 * 227822194L;
        l13 += l23 * 149865618L;
        l14 += l23 * 550336261L;
        l6 += l22 * 43969588L;
        l7 += l22 * 30366549L;
        l8 += l22 * 163752818L;
        l9 += l22 * 258169998L;
        l10 += l22 * 96434764L;
        l11 += l22 * 227822194L;
        l12 += l22 * 149865618L;
        l13 += l22 * 550336261L;
        l5 += l21 * 43969588L;
        l6 += l21 * 30366549L;
        l7 += l21 * 163752818L;
        l8 += l21 * 258169998L;
        l9 += l21 * 96434764L;
        l10 += l21 * 227822194L;
        l11 += l21 * 149865618L;
        l12 += l21 * 550336261L;
        l17 += l16 >>> 28;
        l16 &= 0xFFFFFFFL;
        l18 += l17 >>> 28;
        l17 &= 0xFFFFFFFL;
        l19 += l18 >>> 28;
        l18 &= 0xFFFFFFFL;
        l20 += l19 >>> 28;
        l19 &= 0xFFFFFFFL;
        l4 += l20 * 43969588L;
        l5 += l20 * 30366549L;
        l6 += l20 * 163752818L;
        l7 += l20 * 258169998L;
        l8 += l20 * 96434764L;
        l9 += l20 * 227822194L;
        l10 += l20 * 149865618L;
        l11 += l20 * 550336261L;
        l3 += l19 * 43969588L;
        l4 += l19 * 30366549L;
        l5 += l19 * 163752818L;
        l6 += l19 * 258169998L;
        l7 += l19 * 96434764L;
        l8 += l19 * 227822194L;
        l9 += l19 * 149865618L;
        l10 += l19 * 550336261L;
        l18 *= 4L;
        l18 += l17 >>> 26;
        l17 &= 0x3FFFFFFL;
        l2 += ++l18 * 78101261L;
        l3 += l18 * 141809365L;
        l4 += l18 * 175155932L;
        l5 += l18 * 64542499L;
        l6 += l18 * 158326419L;
        l7 += l18 * 191173276L;
        l8 += l18 * 104575268L;
        l9 += l18 * 137584065L;
        l3 += l2 >>> 28;
        l2 &= 0xFFFFFFFL;
        l4 += l3 >>> 28;
        l3 &= 0xFFFFFFFL;
        l5 += l4 >>> 28;
        l4 &= 0xFFFFFFFL;
        l6 += l5 >>> 28;
        l5 &= 0xFFFFFFFL;
        l7 += l6 >>> 28;
        l6 &= 0xFFFFFFFL;
        l8 += l7 >>> 28;
        l7 &= 0xFFFFFFFL;
        l9 += l8 >>> 28;
        l8 &= 0xFFFFFFFL;
        l10 += l9 >>> 28;
        l9 &= 0xFFFFFFFL;
        l11 += l10 >>> 28;
        l10 &= 0xFFFFFFFL;
        l12 += l11 >>> 28;
        l11 &= 0xFFFFFFFL;
        l13 += l12 >>> 28;
        l12 &= 0xFFFFFFFL;
        l14 += l13 >>> 28;
        l13 &= 0xFFFFFFFL;
        l15 += l14 >>> 28;
        l14 &= 0xFFFFFFFL;
        l16 += l15 >>> 28;
        l15 &= 0xFFFFFFFL;
        l17 += l16 >>> 28;
        l16 &= 0xFFFFFFFL;
        l18 = l17 >>> 26;
        l17 &= 0x3FFFFFFL;
        l2 -= --l18 & 0x4A7BB0DL;
        l3 -= l18 & 0x873D6D5L;
        l4 -= l18 & 0xA70AADCL;
        l5 -= l18 & 0x3D8D723L;
        l6 -= l18 & 0x96FDE93L;
        l7 -= l18 & 0xB65129CL;
        l8 -= l18 & 0x63BB124L;
        l9 -= l18 & 0x8335DC1L;
        l3 += l2 >> 28;
        l2 &= 0xFFFFFFFL;
        l4 += l3 >> 28;
        l3 &= 0xFFFFFFFL;
        l5 += l4 >> 28;
        l4 &= 0xFFFFFFFL;
        l6 += l5 >> 28;
        l5 &= 0xFFFFFFFL;
        l7 += l6 >> 28;
        l6 &= 0xFFFFFFFL;
        l8 += l7 >> 28;
        l7 &= 0xFFFFFFFL;
        l9 += l8 >> 28;
        l8 &= 0xFFFFFFFL;
        l10 += l9 >> 28;
        l9 &= 0xFFFFFFFL;
        l11 += l10 >> 28;
        l10 &= 0xFFFFFFFL;
        l12 += l11 >> 28;
        l11 &= 0xFFFFFFFL;
        l13 += l12 >> 28;
        l12 &= 0xFFFFFFFL;
        l14 += l13 >> 28;
        l13 &= 0xFFFFFFFL;
        l15 += l14 >> 28;
        l14 &= 0xFFFFFFFL;
        l16 += l15 >> 28;
        l15 &= 0xFFFFFFFL;
        l17 += l16 >> 28;
        l16 &= 0xFFFFFFFL;
        byte[] byArray2 = new byte[57];
        Ed448.a(l2 | l3 << 28, byArray2, 0);
        Ed448.a(l4 | l5 << 28, byArray2, 7);
        Ed448.a(l6 | l7 << 28, byArray2, 14);
        Ed448.a(l8 | l9 << 28, byArray2, 21);
        Ed448.a(l10 | l11 << 28, byArray2, 28);
        Ed448.a(l12 | l13 << 28, byArray2, 35);
        Ed448.a(l14 | l15 << 28, byArray2, 42);
        Ed448.a(l16 | l17 << 28, byArray2, 49);
        return byArray2;
    }

    private static void a(byte[] byArray, a a2) {
        Ed448.precompute();
        Ed448.d(a2);
        int[] nArray = new int[15];
        Ed448.a(byArray, 0, nArray);
        nArray[14] = 4 + Nat.cadd(14, ~nArray[0] & 1, nArray, c, nArray);
        Nat.shiftDownBit(nArray.length, nArray, 0);
        b b2 = new b();
        int n2 = 17;
        while (true) {
            int n3 = n2;
            for (int i2 = 0; i2 < 5; ++i2) {
                int n4;
                int n5;
                int n6 = 0;
                for (n5 = 0; n5 < 5; ++n5) {
                    n4 = nArray[n3 >>> 5] >>> (n3 & 0x1F) & 1;
                    n6 |= n4 << n5;
                    n3 += 18;
                }
                n5 = n6 >>> 4 & 1;
                n4 = (n6 ^ -n5) & 0xF;
                Ed448.a(i2, n4, b2);
                X448Field.cnegate(n5, b2.a);
                Ed448.a(b2, a2);
            }
            if (--n2 < 0) break;
            Ed448.b(a2);
        }
    }

    private static void a(byte[] byArray, byte[] byArray2, int n2) {
        a a2 = new a();
        Ed448.a(byArray, a2);
        Ed448.a(a2, byArray2, n2);
    }

    private static void a(int[] nArray, int[] nArray2, a a2, a a3) {
        int n2;
        Ed448.precompute();
        int n3 = 5;
        byte[] byArray = Ed448.a(nArray, 7);
        byte[] byArray2 = Ed448.a(nArray2, 5);
        a[] aArray = Ed448.a(a2, 8);
        Ed448.d(a3);
        for (n2 = 447; n2 > 0 && (byArray[n2] | byArray2[n2]) == 0; --n2) {
        }
        while (true) {
            int n4;
            int n5;
            byte by;
            if ((by = byArray[n2]) != 0) {
                n5 = by >> 31;
                n4 = (by ^ n5) >>> 1;
                Ed448.a(n5 != 0, f[n4], a3);
            }
            if ((n5 = byArray2[n2]) != 0) {
                n4 = n5 >> 31;
                int n6 = (n5 ^ n4) >>> 1;
                Ed448.a(n4 != 0, aArray[n6], a3);
            }
            if (--n2 < 0) break;
            Ed448.b(a3);
        }
    }

    public static void sign(byte[] sk, int skOff, byte[] ctx, byte[] m2, int mOff, int mLen, byte[] sig, int sigOff) {
        if (!Ed448.a(ctx)) {
            throw new IllegalArgumentException("ctx");
        }
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        byte[] byArray = new byte[114];
        sHAKEDigest.update(sk, skOff, 57);
        sHAKEDigest.doFinal(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[57];
        Ed448.a(byArray, 0, byArray2);
        byte[] byArray3 = new byte[57];
        Ed448.a(byArray2, byArray3, 0);
        Ed448.a(sHAKEDigest, byArray, byArray2, byArray3, 0, ctx, m2, mOff, mLen, sig, sigOff);
    }

    public static void sign(byte[] sk, int skOff, byte[] pk, int pkOff, byte[] ctx, byte[] m2, int mOff, int mLen, byte[] sig, int sigOff) {
        if (!Ed448.a(ctx)) {
            throw new IllegalArgumentException("ctx");
        }
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        byte[] byArray = new byte[114];
        sHAKEDigest.update(sk, skOff, 57);
        sHAKEDigest.doFinal(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[57];
        Ed448.a(byArray, 0, byArray2);
        Ed448.a(sHAKEDigest, byArray, byArray2, pk, pkOff, ctx, m2, mOff, mLen, sig, sigOff);
    }

    public static boolean verify(byte[] sig, int sigOff, byte[] pk, int pkOff, byte[] ctx, byte[] m2, int mOff, int mLen) {
        if (!Ed448.a(ctx)) {
            throw new IllegalArgumentException("ctx");
        }
        byte[] byArray = Arrays.copyOfRange(sig, sigOff, sigOff + 57);
        byte[] byArray2 = Arrays.copyOfRange(sig, sigOff + 57, sigOff + 114);
        if (!Ed448.b(byArray)) {
            return false;
        }
        if (!Ed448.c(byArray2)) {
            return false;
        }
        a a2 = new a();
        if (!Ed448.a(pk, pkOff, true, a2)) {
            return false;
        }
        byte by = 0;
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        byte[] byArray3 = new byte[114];
        Ed448.a(sHAKEDigest, by, ctx);
        sHAKEDigest.update(byArray, 0, 57);
        sHAKEDigest.update(pk, pkOff, 57);
        sHAKEDigest.update(m2, mOff, mLen);
        sHAKEDigest.doFinal(byArray3, 0, byArray3.length);
        byte[] byArray4 = Ed448.d(byArray3);
        int[] nArray = new int[14];
        Ed448.a(byArray2, 0, nArray);
        int[] nArray2 = new int[14];
        Ed448.a(byArray4, 0, nArray2);
        a a3 = new a();
        Ed448.a(nArray, nArray2, a2, a3);
        byte[] byArray5 = new byte[57];
        Ed448.a(a3, byArray5, 0);
        return Arrays.areEqual(byArray5, byArray);
    }

    private static class b {
        int[] a = X448Field.create();
        int[] b = X448Field.create();

        private b() {
        }
    }

    private static class a {
        int[] a = X448Field.create();
        int[] b = X448Field.create();
        int[] c = X448Field.create();

        private a() {
        }
    }
}

