/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.tools;

import com.enterprisedt.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;
import com.enterprisedt.bouncycastle.crypto.ec.CustomNamedCurves;
import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.util.Integers;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeSet;

public class TraceOptimizer {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private static final SecureRandom b = new SecureRandom();

    public static void main(String[] args) {
        TreeSet treeSet = new TreeSet(TraceOptimizer.a(ECNamedCurveTable.getNames()));
        treeSet.addAll(TraceOptimizer.a(CustomNamedCurves.getNames()));
        for (String string : treeSet) {
            X9ECParameters x9ECParameters = CustomNamedCurves.getByName(string);
            if (x9ECParameters == null) {
                x9ECParameters = ECNamedCurveTable.getByName(string);
            }
            if (x9ECParameters == null || !ECAlgorithms.isF2mCurve(x9ECParameters.getCurve())) continue;
            System.out.print(string + ":");
            TraceOptimizer.implPrintNonZeroTraceBits(x9ECParameters);
        }
    }

    public static void printNonZeroTraceBits(X9ECParameters x9) {
        if (!ECAlgorithms.isF2mCurve(x9.getCurve())) {
            throw new IllegalArgumentException("Trace only defined over characteristic-2 fields");
        }
        TraceOptimizer.implPrintNonZeroTraceBits(x9);
    }

    public static void implPrintNonZeroTraceBits(X9ECParameters x9) {
        int n2;
        ECFieldElement eCFieldElement;
        BigInteger bigInteger;
        int n3;
        ECCurve eCCurve = x9.getCurve();
        int n4 = eCCurve.getFieldSize();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n3 = 0; n3 < n4; ++n3) {
            bigInteger = a.shiftLeft(n3);
            eCFieldElement = eCCurve.fromBigInteger(bigInteger);
            n2 = TraceOptimizer.a(eCFieldElement);
            if (n2 == 0) continue;
            arrayList.add(Integers.valueOf(n3));
            System.out.print(" " + n3);
        }
        System.out.println();
        for (n3 = 0; n3 < 1000; ++n3) {
            bigInteger = new BigInteger(n4, b);
            eCFieldElement = eCCurve.fromBigInteger(bigInteger);
            n2 = TraceOptimizer.a(eCFieldElement);
            int n5 = 0;
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                int n6 = (Integer)arrayList.get(i2);
                if (!bigInteger.testBit(n6)) continue;
                n5 ^= 1;
            }
            if (n2 == n5) continue;
            throw new IllegalStateException("Optimized-trace sanity check failed");
        }
    }

    private static int a(ECFieldElement eCFieldElement) {
        int n2 = eCFieldElement.getFieldSize();
        ECFieldElement eCFieldElement2 = eCFieldElement;
        for (int i2 = 1; i2 < n2; ++i2) {
            eCFieldElement = eCFieldElement.square();
            eCFieldElement2 = eCFieldElement2.add(eCFieldElement);
        }
        BigInteger bigInteger = eCFieldElement2.toBigInteger();
        if (bigInteger.bitLength() > 1) {
            throw new IllegalStateException();
        }
        return bigInteger.intValue();
    }

    private static ArrayList a(Enumeration enumeration) {
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }
}

