/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.raw;

public class Interleave {
    public static int expand8to16(int x2) {
        x2 &= 0xFF;
        x2 = (x2 | x2 << 4) & 0xF0F;
        x2 = (x2 | x2 << 2) & 0x3333;
        x2 = (x2 | x2 << 1) & 0x5555;
        return x2;
    }

    public static int expand16to32(int x2) {
        x2 &= 0xFFFF;
        x2 = (x2 | x2 << 8) & 0xFF00FF;
        x2 = (x2 | x2 << 4) & 0xF0F0F0F;
        x2 = (x2 | x2 << 2) & 0x33333333;
        x2 = (x2 | x2 << 1) & 0x55555555;
        return x2;
    }

    public static long expand32to64(int x2) {
        int n2 = (x2 ^ x2 >>> 8) & 0xFF00;
        x2 ^= n2 ^ n2 << 8;
        n2 = (x2 ^ x2 >>> 4) & 0xF000F0;
        x2 ^= n2 ^ n2 << 4;
        n2 = (x2 ^ x2 >>> 2) & 0xC0C0C0C;
        x2 ^= n2 ^ n2 << 2;
        n2 = (x2 ^ x2 >>> 1) & 0x22222222;
        return ((long)((x2 ^= n2 ^ n2 << 1) >>> 1) & 0x55555555L) << 32 | (long)x2 & 0x55555555L;
    }

    public static void expand64To128(long x2, long[] z2, int zOff) {
        long l2 = (x2 ^ x2 >>> 16) & 0xFFFF0000L;
        x2 ^= l2 ^ l2 << 16;
        l2 = (x2 ^ x2 >>> 8) & 0xFF000000FF00L;
        x2 ^= l2 ^ l2 << 8;
        l2 = (x2 ^ x2 >>> 4) & 0xF000F000F000F0L;
        x2 ^= l2 ^ l2 << 4;
        l2 = (x2 ^ x2 >>> 2) & 0xC0C0C0C0C0C0C0CL;
        x2 ^= l2 ^ l2 << 2;
        l2 = (x2 ^ x2 >>> 1) & 0x2222222222222222L;
        z2[zOff] = (x2 ^= l2 ^ l2 << 1) & 0x5555555555555555L;
        z2[zOff + 1] = x2 >>> 1 & 0x5555555555555555L;
    }

    public static void expand64To128Rev(long x2, long[] z2, int zOff) {
        long l2 = (x2 ^ x2 >>> 16) & 0xFFFF0000L;
        x2 ^= l2 ^ l2 << 16;
        l2 = (x2 ^ x2 >>> 8) & 0xFF000000FF00L;
        x2 ^= l2 ^ l2 << 8;
        l2 = (x2 ^ x2 >>> 4) & 0xF000F000F000F0L;
        x2 ^= l2 ^ l2 << 4;
        l2 = (x2 ^ x2 >>> 2) & 0xC0C0C0C0C0C0C0CL;
        x2 ^= l2 ^ l2 << 2;
        l2 = (x2 ^ x2 >>> 1) & 0x2222222222222222L;
        z2[zOff] = (x2 ^= l2 ^ l2 << 1) & 0xAAAAAAAAAAAAAAAAL;
        z2[zOff + 1] = x2 << 1 & 0xAAAAAAAAAAAAAAAAL;
    }

    public static int shuffle(int x2) {
        int n2 = (x2 ^ x2 >>> 8) & 0xFF00;
        x2 ^= n2 ^ n2 << 8;
        n2 = (x2 ^ x2 >>> 4) & 0xF000F0;
        x2 ^= n2 ^ n2 << 4;
        n2 = (x2 ^ x2 >>> 2) & 0xC0C0C0C;
        x2 ^= n2 ^ n2 << 2;
        n2 = (x2 ^ x2 >>> 1) & 0x22222222;
        return x2 ^= n2 ^ n2 << 1;
    }

    public static long shuffle(long x2) {
        long l2 = (x2 ^ x2 >>> 16) & 0xFFFF0000L;
        x2 ^= l2 ^ l2 << 16;
        l2 = (x2 ^ x2 >>> 8) & 0xFF000000FF00L;
        x2 ^= l2 ^ l2 << 8;
        l2 = (x2 ^ x2 >>> 4) & 0xF000F000F000F0L;
        x2 ^= l2 ^ l2 << 4;
        l2 = (x2 ^ x2 >>> 2) & 0xC0C0C0C0C0C0C0CL;
        x2 ^= l2 ^ l2 << 2;
        l2 = (x2 ^ x2 >>> 1) & 0x2222222222222222L;
        return x2 ^= l2 ^ l2 << 1;
    }

    public static int shuffle2(int x2) {
        int n2 = (x2 ^ x2 >>> 7) & 0xAA00AA;
        x2 ^= n2 ^ n2 << 7;
        n2 = (x2 ^ x2 >>> 14) & 0xCCCC;
        x2 ^= n2 ^ n2 << 14;
        n2 = (x2 ^ x2 >>> 4) & 0xF000F0;
        x2 ^= n2 ^ n2 << 4;
        n2 = (x2 ^ x2 >>> 8) & 0xFF00;
        return x2 ^= n2 ^ n2 << 8;
    }

    public static int unshuffle(int x2) {
        int n2 = (x2 ^ x2 >>> 1) & 0x22222222;
        x2 ^= n2 ^ n2 << 1;
        n2 = (x2 ^ x2 >>> 2) & 0xC0C0C0C;
        x2 ^= n2 ^ n2 << 2;
        n2 = (x2 ^ x2 >>> 4) & 0xF000F0;
        x2 ^= n2 ^ n2 << 4;
        n2 = (x2 ^ x2 >>> 8) & 0xFF00;
        return x2 ^= n2 ^ n2 << 8;
    }

    public static long unshuffle(long x2) {
        long l2 = (x2 ^ x2 >>> 1) & 0x2222222222222222L;
        x2 ^= l2 ^ l2 << 1;
        l2 = (x2 ^ x2 >>> 2) & 0xC0C0C0C0C0C0C0CL;
        x2 ^= l2 ^ l2 << 2;
        l2 = (x2 ^ x2 >>> 4) & 0xF000F000F000F0L;
        x2 ^= l2 ^ l2 << 4;
        l2 = (x2 ^ x2 >>> 8) & 0xFF000000FF00L;
        x2 ^= l2 ^ l2 << 8;
        l2 = (x2 ^ x2 >>> 16) & 0xFFFF0000L;
        return x2 ^= l2 ^ l2 << 16;
    }

    public static int unshuffle2(int x2) {
        int n2 = (x2 ^ x2 >>> 8) & 0xFF00;
        x2 ^= n2 ^ n2 << 8;
        n2 = (x2 ^ x2 >>> 4) & 0xF000F0;
        x2 ^= n2 ^ n2 << 4;
        n2 = (x2 ^ x2 >>> 14) & 0xCCCC;
        x2 ^= n2 ^ n2 << 14;
        n2 = (x2 ^ x2 >>> 7) & 0xAA00AA;
        return x2 ^= n2 ^ n2 << 7;
    }
}

