/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.raw;

import com.enterprisedt.bouncycastle.math.raw.Nat;
import java.util.Random;

public abstract class Mod {
    public static int inverse32(int d2) {
        int n2 = d2;
        n2 *= 2 - d2 * n2;
        n2 *= 2 - d2 * n2;
        n2 *= 2 - d2 * n2;
        n2 *= 2 - d2 * n2;
        return n2;
    }

    public static void invert(int[] p2, int[] x2, int[] z2) {
        int n2 = p2.length;
        if (Nat.isZero(n2, x2)) {
            throw new IllegalArgumentException("'x' cannot be 0");
        }
        if (Nat.isOne(n2, x2)) {
            System.arraycopy(x2, 0, z2, 0, n2);
            return;
        }
        int[] nArray = Nat.copy(n2, x2);
        int[] nArray2 = Nat.create(n2);
        nArray2[0] = 1;
        int n3 = 0;
        if ((nArray[0] & 1) == 0) {
            n3 = Mod.a(p2, nArray, n2, nArray2, n3);
        }
        if (Nat.isOne(n2, nArray)) {
            Mod.a(p2, n3, nArray2, z2);
            return;
        }
        int[] nArray3 = Nat.copy(n2, p2);
        int[] nArray4 = Nat.create(n2);
        int n4 = 0;
        int n5 = n2;
        while (true) {
            if (nArray[n5 - 1] == 0 && nArray3[n5 - 1] == 0) {
                --n5;
                continue;
            }
            if (Nat.gte(n5, nArray, nArray3)) {
                Nat.subFrom(n5, nArray3, nArray);
                n3 += Nat.subFrom(n2, nArray4, nArray2) - n4;
                n3 = Mod.a(p2, nArray, n5, nArray2, n3);
                if (!Nat.isOne(n5, nArray)) continue;
                Mod.a(p2, n3, nArray2, z2);
                return;
            }
            Nat.subFrom(n5, nArray, nArray3);
            n4 += Nat.subFrom(n2, nArray2, nArray4) - n3;
            n4 = Mod.a(p2, nArray3, n5, nArray4, n4);
            if (Nat.isOne(n5, nArray3)) break;
        }
        Mod.a(p2, n4, nArray4, z2);
    }

    public static int[] random(int[] p2) {
        int n2 = p2.length;
        Random random = new Random();
        int[] nArray = Nat.create(n2);
        int n3 = p2[n2 - 1];
        n3 |= n3 >>> 1;
        n3 |= n3 >>> 2;
        n3 |= n3 >>> 4;
        n3 |= n3 >>> 8;
        n3 |= n3 >>> 16;
        do {
            for (int i2 = 0; i2 != n2; ++i2) {
                nArray[i2] = random.nextInt();
            }
            int n4 = n2 - 1;
            nArray[n4] = nArray[n4] & n3;
        } while (Nat.gte(n2, nArray, p2));
        return nArray;
    }

    public static void add(int[] p2, int[] x2, int[] y2, int[] z2) {
        int n2 = p2.length;
        int n3 = Nat.add(n2, x2, y2, z2);
        if (n3 != 0) {
            Nat.subFrom(n2, p2, z2);
        }
    }

    public static void subtract(int[] p2, int[] x2, int[] y2, int[] z2) {
        int n2 = p2.length;
        int n3 = Nat.sub(n2, x2, y2, z2);
        if (n3 != 0) {
            Nat.addTo(n2, p2, z2);
        }
    }

    private static void a(int[] nArray, int n2, int[] nArray2, int[] nArray3) {
        if (n2 < 0) {
            Nat.add(nArray.length, nArray2, nArray, nArray3);
        } else {
            System.arraycopy(nArray2, 0, nArray3, 0, nArray.length);
        }
    }

    private static int a(int[] nArray, int[] nArray2, int n2, int[] nArray3, int n3) {
        int n4 = nArray.length;
        int n5 = 0;
        while (nArray2[0] == 0) {
            Nat.shiftDownWord(n2, nArray2, 0);
            n5 += 32;
        }
        int n6 = Mod.a(nArray2[0]);
        if (n6 > 0) {
            Nat.shiftDownBits(n2, nArray2, n6, 0);
            n5 += n6;
        }
        for (n6 = 0; n6 < n5; ++n6) {
            if ((nArray3[0] & 1) != 0) {
                n3 = n3 < 0 ? (n3 += Nat.addTo(n4, nArray, nArray3)) : (n3 += Nat.subFrom(n4, nArray, nArray3));
            }
            Nat.shiftDownBit(n4, nArray3, n3);
        }
        return n3;
    }

    private static int a(int n2) {
        int n3 = 0;
        while ((n2 & 1) == 0) {
            n2 >>>= 1;
            ++n3;
        }
        return n3;
    }
}

