/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.raw;

import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;

public abstract class Nat {
    public static int add(int len, int[] x2, int[] y2, int[] z2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z2[i2] = (int)(l2 += ((long)x2[i2] & 0xFFFFFFFFL) + ((long)y2[i2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        }
        return (int)l2;
    }

    public static int add33At(int len, int x2, int[] z2, int zPos) {
        long l2 = ((long)z2[zPos + 0] & 0xFFFFFFFFL) + ((long)x2 & 0xFFFFFFFFL);
        z2[zPos + 0] = (int)l2;
        l2 >>>= 32;
        z2[zPos + 1] = (int)(l2 += ((long)z2[zPos + 1] & 0xFFFFFFFFL) + 1L);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z2, zPos + 2);
    }

    public static int add33At(int len, int x2, int[] z2, int zOff, int zPos) {
        long l2 = ((long)z2[zOff + zPos] & 0xFFFFFFFFL) + ((long)x2 & 0xFFFFFFFFL);
        z2[zOff + zPos] = (int)l2;
        l2 >>>= 32;
        z2[zOff + zPos + 1] = (int)(l2 += ((long)z2[zOff + zPos + 1] & 0xFFFFFFFFL) + 1L);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z2, zOff, zPos + 2);
    }

    public static int add33To(int len, int x2, int[] z2) {
        long l2 = ((long)z2[0] & 0xFFFFFFFFL) + ((long)x2 & 0xFFFFFFFFL);
        z2[0] = (int)l2;
        l2 >>>= 32;
        z2[1] = (int)(l2 += ((long)z2[1] & 0xFFFFFFFFL) + 1L);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z2, 2);
    }

    public static int add33To(int len, int x2, int[] z2, int zOff) {
        long l2 = ((long)z2[zOff + 0] & 0xFFFFFFFFL) + ((long)x2 & 0xFFFFFFFFL);
        z2[zOff + 0] = (int)l2;
        l2 >>>= 32;
        z2[zOff + 1] = (int)(l2 += ((long)z2[zOff + 1] & 0xFFFFFFFFL) + 1L);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z2, zOff, 2);
    }

    public static int addBothTo(int len, int[] x2, int[] y2, int[] z2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z2[i2] = (int)(l2 += ((long)x2[i2] & 0xFFFFFFFFL) + ((long)y2[i2] & 0xFFFFFFFFL) + ((long)z2[i2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        }
        return (int)l2;
    }

    public static int addBothTo(int len, int[] x2, int xOff, int[] y2, int yOff, int[] z2, int zOff) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z2[zOff + i2] = (int)(l2 += ((long)x2[xOff + i2] & 0xFFFFFFFFL) + ((long)y2[yOff + i2] & 0xFFFFFFFFL) + ((long)z2[zOff + i2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        }
        return (int)l2;
    }

    public static int addDWordAt(int len, long x2, int[] z2, int zPos) {
        long l2 = ((long)z2[zPos + 0] & 0xFFFFFFFFL) + (x2 & 0xFFFFFFFFL);
        z2[zPos + 0] = (int)l2;
        l2 >>>= 32;
        z2[zPos + 1] = (int)(l2 += ((long)z2[zPos + 1] & 0xFFFFFFFFL) + (x2 >>> 32));
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z2, zPos + 2);
    }

    public static int addDWordAt(int len, long x2, int[] z2, int zOff, int zPos) {
        long l2 = ((long)z2[zOff + zPos] & 0xFFFFFFFFL) + (x2 & 0xFFFFFFFFL);
        z2[zOff + zPos] = (int)l2;
        l2 >>>= 32;
        z2[zOff + zPos + 1] = (int)(l2 += ((long)z2[zOff + zPos + 1] & 0xFFFFFFFFL) + (x2 >>> 32));
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z2, zOff, zPos + 2);
    }

    public static int addDWordTo(int len, long x2, int[] z2) {
        long l2 = ((long)z2[0] & 0xFFFFFFFFL) + (x2 & 0xFFFFFFFFL);
        z2[0] = (int)l2;
        l2 >>>= 32;
        z2[1] = (int)(l2 += ((long)z2[1] & 0xFFFFFFFFL) + (x2 >>> 32));
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z2, 2);
    }

    public static int addDWordTo(int len, long x2, int[] z2, int zOff) {
        long l2 = ((long)z2[zOff + 0] & 0xFFFFFFFFL) + (x2 & 0xFFFFFFFFL);
        z2[zOff + 0] = (int)l2;
        l2 >>>= 32;
        z2[zOff + 1] = (int)(l2 += ((long)z2[zOff + 1] & 0xFFFFFFFFL) + (x2 >>> 32));
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z2, zOff, 2);
    }

    public static int addTo(int len, int[] x2, int[] z2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z2[i2] = (int)(l2 += ((long)x2[i2] & 0xFFFFFFFFL) + ((long)z2[i2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        }
        return (int)l2;
    }

    public static int addTo(int len, int[] x2, int xOff, int[] z2, int zOff) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z2[zOff + i2] = (int)(l2 += ((long)x2[xOff + i2] & 0xFFFFFFFFL) + ((long)z2[zOff + i2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        }
        return (int)l2;
    }

    public static int addWordAt(int len, int x2, int[] z2, int zPos) {
        long l2 = ((long)x2 & 0xFFFFFFFFL) + ((long)z2[zPos] & 0xFFFFFFFFL);
        z2[zPos] = (int)l2;
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z2, zPos + 1);
    }

    public static int addWordAt(int len, int x2, int[] z2, int zOff, int zPos) {
        long l2 = ((long)x2 & 0xFFFFFFFFL) + ((long)z2[zOff + zPos] & 0xFFFFFFFFL);
        z2[zOff + zPos] = (int)l2;
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z2, zOff, zPos + 1);
    }

    public static int addWordTo(int len, int x2, int[] z2) {
        long l2 = ((long)x2 & 0xFFFFFFFFL) + ((long)z2[0] & 0xFFFFFFFFL);
        z2[0] = (int)l2;
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z2, 1);
    }

    public static int addWordTo(int len, int x2, int[] z2, int zOff) {
        long l2 = ((long)x2 & 0xFFFFFFFFL) + ((long)z2[zOff] & 0xFFFFFFFFL);
        z2[zOff] = (int)l2;
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z2, zOff, 1);
    }

    public static int cadd(int len, int mask, int[] x2, int[] y2, int[] z2) {
        long l2 = (long)(-(mask & 1)) & 0xFFFFFFFFL;
        long l3 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z2[i2] = (int)(l3 += ((long)x2[i2] & 0xFFFFFFFFL) + ((long)y2[i2] & l2));
            l3 >>>= 32;
        }
        return (int)l3;
    }

    public static void cmov(int len, int mask, int[] x2, int xOff, int[] z2, int zOff) {
        mask = -(mask & 1);
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = z2[zOff + i2];
            int n3 = n2 ^ x2[xOff + i2];
            z2[zOff + i2] = n2 ^= n3 & mask;
        }
    }

    public static int[] copy(int len, int[] x2) {
        int[] nArray = new int[len];
        System.arraycopy(x2, 0, nArray, 0, len);
        return nArray;
    }

    public static void copy(int len, int[] x2, int[] z2) {
        System.arraycopy(x2, 0, z2, 0, len);
    }

    public static void copy(int len, int[] x2, int xOff, int[] z2, int zOff) {
        System.arraycopy(x2, xOff, z2, zOff, len);
    }

    public static int[] create(int len) {
        return new int[len];
    }

    public static long[] create64(int len) {
        return new long[len];
    }

    public static int csub(int len, int mask, int[] x2, int[] y2, int[] z2) {
        long l2 = (long)(-(mask & 1)) & 0xFFFFFFFFL;
        long l3 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z2[i2] = (int)(l3 += ((long)x2[i2] & 0xFFFFFFFFL) - ((long)y2[i2] & l2));
            l3 >>= 32;
        }
        return (int)l3;
    }

    public static int dec(int len, int[] z2) {
        int n2 = 0;
        while (n2 < len) {
            int n3 = n2++;
            z2[n3] = z2[n3] - 1;
            if (z2[n3] == -1) continue;
            return 0;
        }
        return -1;
    }

    public static int dec(int len, int[] x2, int[] z2) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2;
            z2[i2] = n2 = x2[i2] - 1;
            if (n2 == -1) continue;
            while (i2 < len) {
                z2[i2] = x2[i2];
                ++i2;
            }
            return 0;
        }
        return -1;
    }

    public static int decAt(int len, int[] z2, int zPos) {
        int n2 = zPos;
        while (n2 < len) {
            int n3 = n2++;
            z2[n3] = z2[n3] - 1;
            if (z2[n3] == -1) continue;
            return 0;
        }
        return -1;
    }

    public static int decAt(int len, int[] z2, int zOff, int zPos) {
        for (int i2 = zPos; i2 < len; ++i2) {
            int n2 = zOff + i2;
            z2[n2] = z2[n2] - 1;
            if (z2[n2] == -1) continue;
            return 0;
        }
        return -1;
    }

    public static boolean eq(int len, int[] x2, int[] y2) {
        for (int i2 = len - 1; i2 >= 0; --i2) {
            if (x2[i2] == y2[i2]) continue;
            return false;
        }
        return true;
    }

    public static int[] fromBigInteger(int bits, BigInteger x2) {
        if (x2.signum() < 0 || x2.bitLength() > bits) {
            throw new IllegalArgumentException();
        }
        int n2 = bits + 31 >> 5;
        int[] nArray = Nat.create(n2);
        int n3 = 0;
        while (x2.signum() != 0) {
            nArray[n3++] = x2.intValue();
            x2 = x2.shiftRight(32);
        }
        return nArray;
    }

    public static int getBit(int[] x2, int bit) {
        if (bit == 0) {
            return x2[0] & 1;
        }
        int n2 = bit >> 5;
        if (n2 < 0 || n2 >= x2.length) {
            return 0;
        }
        int n3 = bit & 0x1F;
        return x2[n2] >>> n3 & 1;
    }

    public static boolean gte(int len, int[] x2, int[] y2) {
        for (int i2 = len - 1; i2 >= 0; --i2) {
            int n2 = x2[i2] ^ Integer.MIN_VALUE;
            int n3 = y2[i2] ^ Integer.MIN_VALUE;
            if (n2 < n3) {
                return false;
            }
            if (n2 <= n3) continue;
            return true;
        }
        return true;
    }

    public static int inc(int len, int[] z2) {
        int n2 = 0;
        while (n2 < len) {
            int n3 = n2++;
            z2[n3] = z2[n3] + 1;
            if (z2[n3] == 0) continue;
            return 0;
        }
        return 1;
    }

    public static int inc(int len, int[] x2, int[] z2) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2;
            z2[i2] = n2 = x2[i2] + 1;
            if (n2 == 0) continue;
            while (i2 < len) {
                z2[i2] = x2[i2];
                ++i2;
            }
            return 0;
        }
        return 1;
    }

    public static int incAt(int len, int[] z2, int zPos) {
        int n2 = zPos;
        while (n2 < len) {
            int n3 = n2++;
            z2[n3] = z2[n3] + 1;
            if (z2[n3] == 0) continue;
            return 0;
        }
        return 1;
    }

    public static int incAt(int len, int[] z2, int zOff, int zPos) {
        for (int i2 = zPos; i2 < len; ++i2) {
            int n2 = zOff + i2;
            z2[n2] = z2[n2] + 1;
            if (z2[n2] == 0) continue;
            return 0;
        }
        return 1;
    }

    public static boolean isOne(int len, int[] x2) {
        if (x2[0] != 1) {
            return false;
        }
        for (int i2 = 1; i2 < len; ++i2) {
            if (x2[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int len, int[] x2) {
        for (int i2 = 0; i2 < len; ++i2) {
            if (x2[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public static void mul(int len, int[] x2, int[] y2, int[] zz) {
        zz[len] = Nat.mulWord(len, x2[0], y2, zz);
        for (int i2 = 1; i2 < len; ++i2) {
            zz[i2 + len] = Nat.mulWordAddTo(len, x2[i2], y2, 0, zz, i2);
        }
    }

    public static void mul(int len, int[] x2, int xOff, int[] y2, int yOff, int[] zz, int zzOff) {
        zz[zzOff + len] = Nat.mulWord(len, x2[xOff], y2, yOff, zz, zzOff);
        for (int i2 = 1; i2 < len; ++i2) {
            zz[zzOff + i2 + len] = Nat.mulWordAddTo(len, x2[xOff + i2], y2, yOff, zz, zzOff + i2);
        }
    }

    public static int mulAddTo(int len, int[] x2, int[] y2, int[] zz) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            long l3 = (long)Nat.mulWordAddTo(len, x2[i2], y2, 0, zz, i2) & 0xFFFFFFFFL;
            zz[i2 + len] = (int)(l3 += l2 + ((long)zz[i2 + len] & 0xFFFFFFFFL));
            l2 = l3 >>> 32;
        }
        return (int)l2;
    }

    public static int mulAddTo(int len, int[] x2, int xOff, int[] y2, int yOff, int[] zz, int zzOff) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            long l3 = (long)Nat.mulWordAddTo(len, x2[xOff + i2], y2, yOff, zz, zzOff) & 0xFFFFFFFFL;
            zz[zzOff + len] = (int)(l3 += l2 + ((long)zz[zzOff + len] & 0xFFFFFFFFL));
            l2 = l3 >>> 32;
            ++zzOff;
        }
        return (int)l2;
    }

    public static int mul31BothAdd(int len, int a2, int[] x2, int b2, int[] y2, int[] z2, int zOff) {
        long l2 = 0L;
        long l3 = (long)a2 & 0xFFFFFFFFL;
        long l4 = (long)b2 & 0xFFFFFFFFL;
        int n2 = 0;
        do {
            z2[zOff + n2] = (int)(l2 += l3 * ((long)x2[n2] & 0xFFFFFFFFL) + l4 * ((long)y2[n2] & 0xFFFFFFFFL) + ((long)z2[zOff + n2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        } while (++n2 < len);
        return (int)l2;
    }

    public static int mulWord(int len, int x2, int[] y2, int[] z2) {
        long l2 = 0L;
        long l3 = (long)x2 & 0xFFFFFFFFL;
        int n2 = 0;
        do {
            z2[n2] = (int)(l2 += l3 * ((long)y2[n2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        } while (++n2 < len);
        return (int)l2;
    }

    public static int mulWord(int len, int x2, int[] y2, int yOff, int[] z2, int zOff) {
        long l2 = 0L;
        long l3 = (long)x2 & 0xFFFFFFFFL;
        int n2 = 0;
        do {
            z2[zOff + n2] = (int)(l2 += l3 * ((long)y2[yOff + n2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        } while (++n2 < len);
        return (int)l2;
    }

    public static int mulWordAddTo(int len, int x2, int[] y2, int yOff, int[] z2, int zOff) {
        long l2 = 0L;
        long l3 = (long)x2 & 0xFFFFFFFFL;
        int n2 = 0;
        do {
            z2[zOff + n2] = (int)(l2 += l3 * ((long)y2[yOff + n2] & 0xFFFFFFFFL) + ((long)z2[zOff + n2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        } while (++n2 < len);
        return (int)l2;
    }

    public static int mulWordDwordAddAt(int len, int x2, long y2, int[] z2, int zPos) {
        long l2 = 0L;
        long l3 = (long)x2 & 0xFFFFFFFFL;
        z2[zPos + 0] = (int)(l2 += l3 * (y2 & 0xFFFFFFFFL) + ((long)z2[zPos + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zPos + 1] = (int)(l2 += l3 * (y2 >>> 32) + ((long)z2[zPos + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zPos + 2] = (int)(l2 += (long)z2[zPos + 2] & 0xFFFFFFFFL);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z2, zPos + 3);
    }

    public static int shiftDownBit(int len, int[] z2, int c2) {
        int n2 = len;
        while (--n2 >= 0) {
            int n3 = z2[n2];
            z2[n2] = n3 >>> 1 | c2 << 31;
            c2 = n3;
        }
        return c2 << 31;
    }

    public static int shiftDownBit(int len, int[] z2, int zOff, int c2) {
        int n2 = len;
        while (--n2 >= 0) {
            int n3 = z2[zOff + n2];
            z2[zOff + n2] = n3 >>> 1 | c2 << 31;
            c2 = n3;
        }
        return c2 << 31;
    }

    public static int shiftDownBit(int len, int[] x2, int c2, int[] z2) {
        int n2 = len;
        while (--n2 >= 0) {
            int n3 = x2[n2];
            z2[n2] = n3 >>> 1 | c2 << 31;
            c2 = n3;
        }
        return c2 << 31;
    }

    public static int shiftDownBit(int len, int[] x2, int xOff, int c2, int[] z2, int zOff) {
        int n2 = len;
        while (--n2 >= 0) {
            int n3 = x2[xOff + n2];
            z2[zOff + n2] = n3 >>> 1 | c2 << 31;
            c2 = n3;
        }
        return c2 << 31;
    }

    public static int shiftDownBits(int len, int[] z2, int bits, int c2) {
        int n2 = len;
        while (--n2 >= 0) {
            int n3 = z2[n2];
            z2[n2] = n3 >>> bits | c2 << -bits;
            c2 = n3;
        }
        return c2 << -bits;
    }

    public static int shiftDownBits(int len, int[] z2, int zOff, int bits, int c2) {
        int n2 = len;
        while (--n2 >= 0) {
            int n3 = z2[zOff + n2];
            z2[zOff + n2] = n3 >>> bits | c2 << -bits;
            c2 = n3;
        }
        return c2 << -bits;
    }

    public static int shiftDownBits(int len, int[] x2, int bits, int c2, int[] z2) {
        int n2 = len;
        while (--n2 >= 0) {
            int n3 = x2[n2];
            z2[n2] = n3 >>> bits | c2 << -bits;
            c2 = n3;
        }
        return c2 << -bits;
    }

    public static int shiftDownBits(int len, int[] x2, int xOff, int bits, int c2, int[] z2, int zOff) {
        int n2 = len;
        while (--n2 >= 0) {
            int n3 = x2[xOff + n2];
            z2[zOff + n2] = n3 >>> bits | c2 << -bits;
            c2 = n3;
        }
        return c2 << -bits;
    }

    public static int shiftDownWord(int len, int[] z2, int c2) {
        int n2 = len;
        while (--n2 >= 0) {
            int n3 = z2[n2];
            z2[n2] = c2;
            c2 = n3;
        }
        return c2;
    }

    public static int shiftUpBit(int len, int[] z2, int c2) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = z2[i2];
            z2[i2] = n2 << 1 | c2 >>> 31;
            c2 = n2;
        }
        return c2 >>> 31;
    }

    public static int shiftUpBit(int len, int[] z2, int zOff, int c2) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = z2[zOff + i2];
            z2[zOff + i2] = n2 << 1 | c2 >>> 31;
            c2 = n2;
        }
        return c2 >>> 31;
    }

    public static int shiftUpBit(int len, int[] x2, int c2, int[] z2) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = x2[i2];
            z2[i2] = n2 << 1 | c2 >>> 31;
            c2 = n2;
        }
        return c2 >>> 31;
    }

    public static int shiftUpBit(int len, int[] x2, int xOff, int c2, int[] z2, int zOff) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = x2[xOff + i2];
            z2[zOff + i2] = n2 << 1 | c2 >>> 31;
            c2 = n2;
        }
        return c2 >>> 31;
    }

    public static long shiftUpBit64(int len, long[] x2, int xOff, long c2, long[] z2, int zOff) {
        for (int i2 = 0; i2 < len; ++i2) {
            long l2 = x2[xOff + i2];
            z2[zOff + i2] = l2 << 1 | c2 >>> 63;
            c2 = l2;
        }
        return c2 >>> 63;
    }

    public static int shiftUpBits(int len, int[] z2, int bits, int c2) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = z2[i2];
            z2[i2] = n2 << bits | c2 >>> -bits;
            c2 = n2;
        }
        return c2 >>> -bits;
    }

    public static int shiftUpBits(int len, int[] z2, int zOff, int bits, int c2) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = z2[zOff + i2];
            z2[zOff + i2] = n2 << bits | c2 >>> -bits;
            c2 = n2;
        }
        return c2 >>> -bits;
    }

    public static long shiftUpBits64(int len, long[] z2, int zOff, int bits, long c2) {
        for (int i2 = 0; i2 < len; ++i2) {
            long l2 = z2[zOff + i2];
            z2[zOff + i2] = l2 << bits | c2 >>> -bits;
            c2 = l2;
        }
        return c2 >>> -bits;
    }

    public static int shiftUpBits(int len, int[] x2, int bits, int c2, int[] z2) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = x2[i2];
            z2[i2] = n2 << bits | c2 >>> -bits;
            c2 = n2;
        }
        return c2 >>> -bits;
    }

    public static int shiftUpBits(int len, int[] x2, int xOff, int bits, int c2, int[] z2, int zOff) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = x2[xOff + i2];
            z2[zOff + i2] = n2 << bits | c2 >>> -bits;
            c2 = n2;
        }
        return c2 >>> -bits;
    }

    public static long shiftUpBits64(int len, long[] x2, int xOff, int bits, long c2, long[] z2, int zOff) {
        for (int i2 = 0; i2 < len; ++i2) {
            long l2 = x2[xOff + i2];
            z2[zOff + i2] = l2 << bits | c2 >>> -bits;
            c2 = l2;
        }
        return c2 >>> -bits;
    }

    public static void square(int len, int[] x2, int[] zz) {
        int n2 = len << 1;
        int n3 = 0;
        int n4 = len;
        int n5 = n2;
        do {
            long l2 = (long)x2[--n4] & 0xFFFFFFFFL;
            long l3 = l2 * l2;
            zz[--n5] = n3 << 31 | (int)(l3 >>> 33);
            zz[--n5] = (int)(l3 >>> 1);
            n3 = (int)l3;
        } while (n4 > 0);
        for (int i2 = 1; i2 < len; ++i2) {
            n3 = Nat.squareWordAdd(x2, i2, zz);
            Nat.addWordAt(n2, n3, zz, i2 << 1);
        }
        Nat.shiftUpBit(n2, zz, x2[0] << 31);
    }

    public static void square(int len, int[] x2, int xOff, int[] zz, int zzOff) {
        int n2 = len << 1;
        int n3 = 0;
        int n4 = len;
        int n5 = n2;
        do {
            long l2 = (long)x2[xOff + --n4] & 0xFFFFFFFFL;
            long l3 = l2 * l2;
            zz[zzOff + --n5] = n3 << 31 | (int)(l3 >>> 33);
            zz[zzOff + --n5] = (int)(l3 >>> 1);
            n3 = (int)l3;
        } while (n4 > 0);
        for (int i2 = 1; i2 < len; ++i2) {
            n3 = Nat.squareWordAdd(x2, xOff, i2, zz, zzOff);
            Nat.addWordAt(n2, n3, zz, zzOff, i2 << 1);
        }
        Nat.shiftUpBit(n2, zz, zzOff, x2[xOff] << 31);
    }

    public static int squareWordAdd(int[] x2, int xPos, int[] z2) {
        long l2 = 0L;
        long l3 = (long)x2[xPos] & 0xFFFFFFFFL;
        int n2 = 0;
        do {
            z2[xPos + n2] = (int)(l2 += l3 * ((long)x2[n2] & 0xFFFFFFFFL) + ((long)z2[xPos + n2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        } while (++n2 < xPos);
        return (int)l2;
    }

    public static int squareWordAdd(int[] x2, int xOff, int xPos, int[] z2, int zOff) {
        long l2 = 0L;
        long l3 = (long)x2[xOff + xPos] & 0xFFFFFFFFL;
        int n2 = 0;
        do {
            z2[xPos + zOff] = (int)(l2 += l3 * ((long)x2[xOff + n2] & 0xFFFFFFFFL) + ((long)z2[xPos + zOff] & 0xFFFFFFFFL));
            l2 >>>= 32;
            ++zOff;
        } while (++n2 < xPos);
        return (int)l2;
    }

    public static int sub(int len, int[] x2, int[] y2, int[] z2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z2[i2] = (int)(l2 += ((long)x2[i2] & 0xFFFFFFFFL) - ((long)y2[i2] & 0xFFFFFFFFL));
            l2 >>= 32;
        }
        return (int)l2;
    }

    public static int sub(int len, int[] x2, int xOff, int[] y2, int yOff, int[] z2, int zOff) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z2[zOff + i2] = (int)(l2 += ((long)x2[xOff + i2] & 0xFFFFFFFFL) - ((long)y2[yOff + i2] & 0xFFFFFFFFL));
            l2 >>= 32;
        }
        return (int)l2;
    }

    public static int sub33At(int len, int x2, int[] z2, int zPos) {
        long l2 = ((long)z2[zPos + 0] & 0xFFFFFFFFL) - ((long)x2 & 0xFFFFFFFFL);
        z2[zPos + 0] = (int)l2;
        l2 >>= 32;
        z2[zPos + 1] = (int)(l2 += ((long)z2[zPos + 1] & 0xFFFFFFFFL) - 1L);
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z2, zPos + 2);
    }

    public static int sub33At(int len, int x2, int[] z2, int zOff, int zPos) {
        long l2 = ((long)z2[zOff + zPos] & 0xFFFFFFFFL) - ((long)x2 & 0xFFFFFFFFL);
        z2[zOff + zPos] = (int)l2;
        l2 >>= 32;
        z2[zOff + zPos + 1] = (int)(l2 += ((long)z2[zOff + zPos + 1] & 0xFFFFFFFFL) - 1L);
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z2, zOff, zPos + 2);
    }

    public static int sub33From(int len, int x2, int[] z2) {
        long l2 = ((long)z2[0] & 0xFFFFFFFFL) - ((long)x2 & 0xFFFFFFFFL);
        z2[0] = (int)l2;
        l2 >>= 32;
        z2[1] = (int)(l2 += ((long)z2[1] & 0xFFFFFFFFL) - 1L);
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z2, 2);
    }

    public static int sub33From(int len, int x2, int[] z2, int zOff) {
        long l2 = ((long)z2[zOff + 0] & 0xFFFFFFFFL) - ((long)x2 & 0xFFFFFFFFL);
        z2[zOff + 0] = (int)l2;
        l2 >>= 32;
        z2[zOff + 1] = (int)(l2 += ((long)z2[zOff + 1] & 0xFFFFFFFFL) - 1L);
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z2, zOff, 2);
    }

    public static int subBothFrom(int len, int[] x2, int[] y2, int[] z2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z2[i2] = (int)(l2 += ((long)z2[i2] & 0xFFFFFFFFL) - ((long)x2[i2] & 0xFFFFFFFFL) - ((long)y2[i2] & 0xFFFFFFFFL));
            l2 >>= 32;
        }
        return (int)l2;
    }

    public static int subBothFrom(int len, int[] x2, int xOff, int[] y2, int yOff, int[] z2, int zOff) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z2[zOff + i2] = (int)(l2 += ((long)z2[zOff + i2] & 0xFFFFFFFFL) - ((long)x2[xOff + i2] & 0xFFFFFFFFL) - ((long)y2[yOff + i2] & 0xFFFFFFFFL));
            l2 >>= 32;
        }
        return (int)l2;
    }

    public static int subDWordAt(int len, long x2, int[] z2, int zPos) {
        long l2 = ((long)z2[zPos + 0] & 0xFFFFFFFFL) - (x2 & 0xFFFFFFFFL);
        z2[zPos + 0] = (int)l2;
        l2 >>= 32;
        z2[zPos + 1] = (int)(l2 += ((long)z2[zPos + 1] & 0xFFFFFFFFL) - (x2 >>> 32));
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z2, zPos + 2);
    }

    public static int subDWordAt(int len, long x2, int[] z2, int zOff, int zPos) {
        long l2 = ((long)z2[zOff + zPos] & 0xFFFFFFFFL) - (x2 & 0xFFFFFFFFL);
        z2[zOff + zPos] = (int)l2;
        l2 >>= 32;
        z2[zOff + zPos + 1] = (int)(l2 += ((long)z2[zOff + zPos + 1] & 0xFFFFFFFFL) - (x2 >>> 32));
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z2, zOff, zPos + 2);
    }

    public static int subDWordFrom(int len, long x2, int[] z2) {
        long l2 = ((long)z2[0] & 0xFFFFFFFFL) - (x2 & 0xFFFFFFFFL);
        z2[0] = (int)l2;
        l2 >>= 32;
        z2[1] = (int)(l2 += ((long)z2[1] & 0xFFFFFFFFL) - (x2 >>> 32));
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z2, 2);
    }

    public static int subDWordFrom(int len, long x2, int[] z2, int zOff) {
        long l2 = ((long)z2[zOff + 0] & 0xFFFFFFFFL) - (x2 & 0xFFFFFFFFL);
        z2[zOff + 0] = (int)l2;
        l2 >>= 32;
        z2[zOff + 1] = (int)(l2 += ((long)z2[zOff + 1] & 0xFFFFFFFFL) - (x2 >>> 32));
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z2, zOff, 2);
    }

    public static int subFrom(int len, int[] x2, int[] z2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z2[i2] = (int)(l2 += ((long)z2[i2] & 0xFFFFFFFFL) - ((long)x2[i2] & 0xFFFFFFFFL));
            l2 >>= 32;
        }
        return (int)l2;
    }

    public static int subFrom(int len, int[] x2, int xOff, int[] z2, int zOff) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z2[zOff + i2] = (int)(l2 += ((long)z2[zOff + i2] & 0xFFFFFFFFL) - ((long)x2[xOff + i2] & 0xFFFFFFFFL));
            l2 >>= 32;
        }
        return (int)l2;
    }

    public static int subWordAt(int len, int x2, int[] z2, int zPos) {
        long l2 = ((long)z2[zPos] & 0xFFFFFFFFL) - ((long)x2 & 0xFFFFFFFFL);
        z2[zPos] = (int)l2;
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z2, zPos + 1);
    }

    public static int subWordAt(int len, int x2, int[] z2, int zOff, int zPos) {
        long l2 = ((long)z2[zOff + zPos] & 0xFFFFFFFFL) - ((long)x2 & 0xFFFFFFFFL);
        z2[zOff + zPos] = (int)l2;
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z2, zOff, zPos + 1);
    }

    public static int subWordFrom(int len, int x2, int[] z2) {
        long l2 = ((long)z2[0] & 0xFFFFFFFFL) - ((long)x2 & 0xFFFFFFFFL);
        z2[0] = (int)l2;
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z2, 1);
    }

    public static int subWordFrom(int len, int x2, int[] z2, int zOff) {
        long l2 = ((long)z2[zOff + 0] & 0xFFFFFFFFL) - ((long)x2 & 0xFFFFFFFFL);
        z2[zOff + 0] = (int)l2;
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z2, zOff, 1);
    }

    public static BigInteger toBigInteger(int len, int[] x2) {
        byte[] byArray = new byte[len << 2];
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = x2[i2];
            if (n2 == 0) continue;
            Pack.intToBigEndian(n2, byArray, len - 1 - i2 << 2);
        }
        return new BigInteger(1, byArray);
    }

    public static void zero(int len, int[] z2) {
        for (int i2 = 0; i2 < len; ++i2) {
            z2[i2] = 0;
        }
    }

    public static void zero64(int len, long[] z2) {
        for (int i2 = 0; i2 < len; ++i2) {
            z2[i2] = 0L;
        }
    }
}

