/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.raw;

import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;

public abstract class Nat160 {
    public static int add(int[] x2, int[] y2, int[] z2) {
        long l2 = 0L;
        z2[0] = (int)(l2 += ((long)x2[0] & 0xFFFFFFFFL) + ((long)y2[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[1] = (int)(l2 += ((long)x2[1] & 0xFFFFFFFFL) + ((long)y2[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[2] = (int)(l2 += ((long)x2[2] & 0xFFFFFFFFL) + ((long)y2[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[3] = (int)(l2 += ((long)x2[3] & 0xFFFFFFFFL) + ((long)y2[3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[4] = (int)(l2 += ((long)x2[4] & 0xFFFFFFFFL) + ((long)y2[4] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addBothTo(int[] x2, int[] y2, int[] z2) {
        long l2 = 0L;
        z2[0] = (int)(l2 += ((long)x2[0] & 0xFFFFFFFFL) + ((long)y2[0] & 0xFFFFFFFFL) + ((long)z2[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[1] = (int)(l2 += ((long)x2[1] & 0xFFFFFFFFL) + ((long)y2[1] & 0xFFFFFFFFL) + ((long)z2[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[2] = (int)(l2 += ((long)x2[2] & 0xFFFFFFFFL) + ((long)y2[2] & 0xFFFFFFFFL) + ((long)z2[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[3] = (int)(l2 += ((long)x2[3] & 0xFFFFFFFFL) + ((long)y2[3] & 0xFFFFFFFFL) + ((long)z2[3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[4] = (int)(l2 += ((long)x2[4] & 0xFFFFFFFFL) + ((long)y2[4] & 0xFFFFFFFFL) + ((long)z2[4] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addTo(int[] x2, int[] z2) {
        long l2 = 0L;
        z2[0] = (int)(l2 += ((long)x2[0] & 0xFFFFFFFFL) + ((long)z2[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[1] = (int)(l2 += ((long)x2[1] & 0xFFFFFFFFL) + ((long)z2[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[2] = (int)(l2 += ((long)x2[2] & 0xFFFFFFFFL) + ((long)z2[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[3] = (int)(l2 += ((long)x2[3] & 0xFFFFFFFFL) + ((long)z2[3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[4] = (int)(l2 += ((long)x2[4] & 0xFFFFFFFFL) + ((long)z2[4] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addTo(int[] x2, int xOff, int[] z2, int zOff, int cIn) {
        long l2 = (long)cIn & 0xFFFFFFFFL;
        z2[zOff + 0] = (int)(l2 += ((long)x2[xOff + 0] & 0xFFFFFFFFL) + ((long)z2[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 1] = (int)(l2 += ((long)x2[xOff + 1] & 0xFFFFFFFFL) + ((long)z2[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 2] = (int)(l2 += ((long)x2[xOff + 2] & 0xFFFFFFFFL) + ((long)z2[zOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 3] = (int)(l2 += ((long)x2[xOff + 3] & 0xFFFFFFFFL) + ((long)z2[zOff + 3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 4] = (int)(l2 += ((long)x2[xOff + 4] & 0xFFFFFFFFL) + ((long)z2[zOff + 4] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addToEachOther(int[] u2, int uOff, int[] v2, int vOff) {
        long l2 = 0L;
        u2[uOff + 0] = (int)(l2 += ((long)u2[uOff + 0] & 0xFFFFFFFFL) + ((long)v2[vOff + 0] & 0xFFFFFFFFL));
        v2[vOff + 0] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 1] = (int)(l2 += ((long)u2[uOff + 1] & 0xFFFFFFFFL) + ((long)v2[vOff + 1] & 0xFFFFFFFFL));
        v2[vOff + 1] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 2] = (int)(l2 += ((long)u2[uOff + 2] & 0xFFFFFFFFL) + ((long)v2[vOff + 2] & 0xFFFFFFFFL));
        v2[vOff + 2] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 3] = (int)(l2 += ((long)u2[uOff + 3] & 0xFFFFFFFFL) + ((long)v2[vOff + 3] & 0xFFFFFFFFL));
        v2[vOff + 3] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 4] = (int)(l2 += ((long)u2[uOff + 4] & 0xFFFFFFFFL) + ((long)v2[vOff + 4] & 0xFFFFFFFFL));
        v2[vOff + 4] = (int)l2;
        return (int)(l2 >>>= 32);
    }

    public static void copy(int[] x2, int[] z2) {
        z2[0] = x2[0];
        z2[1] = x2[1];
        z2[2] = x2[2];
        z2[3] = x2[3];
        z2[4] = x2[4];
    }

    public static void copy(int[] x2, int xOff, int[] z2, int zOff) {
        z2[zOff + 0] = x2[xOff + 0];
        z2[zOff + 1] = x2[xOff + 1];
        z2[zOff + 2] = x2[xOff + 2];
        z2[zOff + 3] = x2[xOff + 3];
        z2[zOff + 4] = x2[xOff + 4];
    }

    public static int[] create() {
        return new int[5];
    }

    public static int[] createExt() {
        return new int[10];
    }

    public static boolean diff(int[] x2, int xOff, int[] y2, int yOff, int[] z2, int zOff) {
        boolean bl = Nat160.gte(x2, xOff, y2, yOff);
        if (bl) {
            Nat160.sub(x2, xOff, y2, yOff, z2, zOff);
        } else {
            Nat160.sub(y2, yOff, x2, xOff, z2, zOff);
        }
        return bl;
    }

    public static boolean eq(int[] x2, int[] y2) {
        for (int i2 = 4; i2 >= 0; --i2) {
            if (x2[i2] == y2[i2]) continue;
            return false;
        }
        return true;
    }

    public static int[] fromBigInteger(BigInteger x2) {
        if (x2.signum() < 0 || x2.bitLength() > 160) {
            throw new IllegalArgumentException();
        }
        int[] nArray = Nat160.create();
        int n2 = 0;
        while (x2.signum() != 0) {
            nArray[n2++] = x2.intValue();
            x2 = x2.shiftRight(32);
        }
        return nArray;
    }

    public static int getBit(int[] x2, int bit) {
        if (bit == 0) {
            return x2[0] & 1;
        }
        int n2 = bit >> 5;
        if (n2 < 0 || n2 >= 5) {
            return 0;
        }
        int n3 = bit & 0x1F;
        return x2[n2] >>> n3 & 1;
    }

    public static boolean gte(int[] x2, int[] y2) {
        for (int i2 = 4; i2 >= 0; --i2) {
            int n2 = x2[i2] ^ Integer.MIN_VALUE;
            int n3 = y2[i2] ^ Integer.MIN_VALUE;
            if (n2 < n3) {
                return false;
            }
            if (n2 <= n3) continue;
            return true;
        }
        return true;
    }

    public static boolean gte(int[] x2, int xOff, int[] y2, int yOff) {
        for (int i2 = 4; i2 >= 0; --i2) {
            int n2 = x2[xOff + i2] ^ Integer.MIN_VALUE;
            int n3 = y2[yOff + i2] ^ Integer.MIN_VALUE;
            if (n2 < n3) {
                return false;
            }
            if (n2 <= n3) continue;
            return true;
        }
        return true;
    }

    public static boolean isOne(int[] x2) {
        if (x2[0] != 1) {
            return false;
        }
        for (int i2 = 1; i2 < 5; ++i2) {
            if (x2[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int[] x2) {
        for (int i2 = 0; i2 < 5; ++i2) {
            if (x2[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public static void mul(int[] x2, int[] y2, int[] zz) {
        long l2 = (long)y2[0] & 0xFFFFFFFFL;
        long l3 = (long)y2[1] & 0xFFFFFFFFL;
        long l4 = (long)y2[2] & 0xFFFFFFFFL;
        long l5 = (long)y2[3] & 0xFFFFFFFFL;
        long l6 = (long)y2[4] & 0xFFFFFFFFL;
        long l7 = 0L;
        long l8 = (long)x2[0] & 0xFFFFFFFFL;
        zz[0] = (int)(l7 += l8 * l2);
        l7 >>>= 32;
        zz[1] = (int)(l7 += l8 * l3);
        l7 >>>= 32;
        zz[2] = (int)(l7 += l8 * l4);
        l7 >>>= 32;
        zz[3] = (int)(l7 += l8 * l5);
        l7 >>>= 32;
        zz[4] = (int)(l7 += l8 * l6);
        zz[5] = (int)(l7 >>>= 32);
        for (int i2 = 1; i2 < 5; ++i2) {
            long l9 = 0L;
            long l10 = (long)x2[i2] & 0xFFFFFFFFL;
            zz[i2 + 0] = (int)(l9 += l10 * l2 + ((long)zz[i2 + 0] & 0xFFFFFFFFL));
            l9 >>>= 32;
            zz[i2 + 1] = (int)(l9 += l10 * l3 + ((long)zz[i2 + 1] & 0xFFFFFFFFL));
            l9 >>>= 32;
            zz[i2 + 2] = (int)(l9 += l10 * l4 + ((long)zz[i2 + 2] & 0xFFFFFFFFL));
            l9 >>>= 32;
            zz[i2 + 3] = (int)(l9 += l10 * l5 + ((long)zz[i2 + 3] & 0xFFFFFFFFL));
            l9 >>>= 32;
            zz[i2 + 4] = (int)(l9 += l10 * l6 + ((long)zz[i2 + 4] & 0xFFFFFFFFL));
            zz[i2 + 5] = (int)(l9 >>>= 32);
        }
    }

    public static void mul(int[] x2, int xOff, int[] y2, int yOff, int[] zz, int zzOff) {
        long l2 = (long)y2[yOff + 0] & 0xFFFFFFFFL;
        long l3 = (long)y2[yOff + 1] & 0xFFFFFFFFL;
        long l4 = (long)y2[yOff + 2] & 0xFFFFFFFFL;
        long l5 = (long)y2[yOff + 3] & 0xFFFFFFFFL;
        long l6 = (long)y2[yOff + 4] & 0xFFFFFFFFL;
        long l7 = 0L;
        long l8 = (long)x2[xOff + 0] & 0xFFFFFFFFL;
        zz[zzOff + 0] = (int)(l7 += l8 * l2);
        l7 >>>= 32;
        zz[zzOff + 1] = (int)(l7 += l8 * l3);
        l7 >>>= 32;
        zz[zzOff + 2] = (int)(l7 += l8 * l4);
        l7 >>>= 32;
        zz[zzOff + 3] = (int)(l7 += l8 * l5);
        l7 >>>= 32;
        zz[zzOff + 4] = (int)(l7 += l8 * l6);
        zz[zzOff + 5] = (int)(l7 >>>= 32);
        for (int i2 = 1; i2 < 5; ++i2) {
            long l9 = 0L;
            long l10 = (long)x2[xOff + i2] & 0xFFFFFFFFL;
            zz[zzOff + 0] = (int)(l9 += l10 * l2 + ((long)zz[++zzOff + 0] & 0xFFFFFFFFL));
            l9 >>>= 32;
            zz[zzOff + 1] = (int)(l9 += l10 * l3 + ((long)zz[zzOff + 1] & 0xFFFFFFFFL));
            l9 >>>= 32;
            zz[zzOff + 2] = (int)(l9 += l10 * l4 + ((long)zz[zzOff + 2] & 0xFFFFFFFFL));
            l9 >>>= 32;
            zz[zzOff + 3] = (int)(l9 += l10 * l5 + ((long)zz[zzOff + 3] & 0xFFFFFFFFL));
            l9 >>>= 32;
            zz[zzOff + 4] = (int)(l9 += l10 * l6 + ((long)zz[zzOff + 4] & 0xFFFFFFFFL));
            zz[zzOff + 5] = (int)(l9 >>>= 32);
        }
    }

    public static int mulAddTo(int[] x2, int[] y2, int[] zz) {
        long l2 = (long)y2[0] & 0xFFFFFFFFL;
        long l3 = (long)y2[1] & 0xFFFFFFFFL;
        long l4 = (long)y2[2] & 0xFFFFFFFFL;
        long l5 = (long)y2[3] & 0xFFFFFFFFL;
        long l6 = (long)y2[4] & 0xFFFFFFFFL;
        long l7 = 0L;
        for (int i2 = 0; i2 < 5; ++i2) {
            long l8 = 0L;
            long l9 = (long)x2[i2] & 0xFFFFFFFFL;
            zz[i2 + 0] = (int)(l8 += l9 * l2 + ((long)zz[i2 + 0] & 0xFFFFFFFFL));
            l8 >>>= 32;
            zz[i2 + 1] = (int)(l8 += l9 * l3 + ((long)zz[i2 + 1] & 0xFFFFFFFFL));
            l8 >>>= 32;
            zz[i2 + 2] = (int)(l8 += l9 * l4 + ((long)zz[i2 + 2] & 0xFFFFFFFFL));
            l8 >>>= 32;
            zz[i2 + 3] = (int)(l8 += l9 * l5 + ((long)zz[i2 + 3] & 0xFFFFFFFFL));
            l8 >>>= 32;
            zz[i2 + 4] = (int)(l8 += l9 * l6 + ((long)zz[i2 + 4] & 0xFFFFFFFFL));
            l8 >>>= 32;
            zz[i2 + 5] = (int)(l8 += l7 + ((long)zz[i2 + 5] & 0xFFFFFFFFL));
            l7 = l8 >>> 32;
        }
        return (int)l7;
    }

    public static int mulAddTo(int[] x2, int xOff, int[] y2, int yOff, int[] zz, int zzOff) {
        long l2 = (long)y2[yOff + 0] & 0xFFFFFFFFL;
        long l3 = (long)y2[yOff + 1] & 0xFFFFFFFFL;
        long l4 = (long)y2[yOff + 2] & 0xFFFFFFFFL;
        long l5 = (long)y2[yOff + 3] & 0xFFFFFFFFL;
        long l6 = (long)y2[yOff + 4] & 0xFFFFFFFFL;
        long l7 = 0L;
        for (int i2 = 0; i2 < 5; ++i2) {
            long l8 = 0L;
            long l9 = (long)x2[xOff + i2] & 0xFFFFFFFFL;
            zz[zzOff + 0] = (int)(l8 += l9 * l2 + ((long)zz[zzOff + 0] & 0xFFFFFFFFL));
            l8 >>>= 32;
            zz[zzOff + 1] = (int)(l8 += l9 * l3 + ((long)zz[zzOff + 1] & 0xFFFFFFFFL));
            l8 >>>= 32;
            zz[zzOff + 2] = (int)(l8 += l9 * l4 + ((long)zz[zzOff + 2] & 0xFFFFFFFFL));
            l8 >>>= 32;
            zz[zzOff + 3] = (int)(l8 += l9 * l5 + ((long)zz[zzOff + 3] & 0xFFFFFFFFL));
            l8 >>>= 32;
            zz[zzOff + 4] = (int)(l8 += l9 * l6 + ((long)zz[zzOff + 4] & 0xFFFFFFFFL));
            l8 >>>= 32;
            zz[zzOff + 5] = (int)(l8 += l7 + ((long)zz[zzOff + 5] & 0xFFFFFFFFL));
            l7 = l8 >>> 32;
            ++zzOff;
        }
        return (int)l7;
    }

    public static long mul33Add(int w2, int[] x2, int xOff, int[] y2, int yOff, int[] z2, int zOff) {
        long l2 = 0L;
        long l3 = (long)w2 & 0xFFFFFFFFL;
        long l4 = (long)x2[xOff + 0] & 0xFFFFFFFFL;
        z2[zOff + 0] = (int)(l2 += l3 * l4 + ((long)y2[yOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l5 = (long)x2[xOff + 1] & 0xFFFFFFFFL;
        z2[zOff + 1] = (int)(l2 += l3 * l5 + l4 + ((long)y2[yOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l6 = (long)x2[xOff + 2] & 0xFFFFFFFFL;
        z2[zOff + 2] = (int)(l2 += l3 * l6 + l5 + ((long)y2[yOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l7 = (long)x2[xOff + 3] & 0xFFFFFFFFL;
        z2[zOff + 3] = (int)(l2 += l3 * l7 + l6 + ((long)y2[yOff + 3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l8 = (long)x2[xOff + 4] & 0xFFFFFFFFL;
        z2[zOff + 4] = (int)(l2 += l3 * l8 + l7 + ((long)y2[yOff + 4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        return l2 += l8;
    }

    public static int mulWordAddExt(int x2, int[] yy, int yyOff, int[] zz, int zzOff) {
        long l2 = 0L;
        long l3 = (long)x2 & 0xFFFFFFFFL;
        zz[zzOff + 0] = (int)(l2 += l3 * ((long)yy[yyOff + 0] & 0xFFFFFFFFL) + ((long)zz[zzOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        zz[zzOff + 1] = (int)(l2 += l3 * ((long)yy[yyOff + 1] & 0xFFFFFFFFL) + ((long)zz[zzOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        zz[zzOff + 2] = (int)(l2 += l3 * ((long)yy[yyOff + 2] & 0xFFFFFFFFL) + ((long)zz[zzOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        zz[zzOff + 3] = (int)(l2 += l3 * ((long)yy[yyOff + 3] & 0xFFFFFFFFL) + ((long)zz[zzOff + 3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        zz[zzOff + 4] = (int)(l2 += l3 * ((long)yy[yyOff + 4] & 0xFFFFFFFFL) + ((long)zz[zzOff + 4] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int mul33DWordAdd(int x2, long y2, int[] z2, int zOff) {
        long l2 = 0L;
        long l3 = (long)x2 & 0xFFFFFFFFL;
        long l4 = y2 & 0xFFFFFFFFL;
        z2[zOff + 0] = (int)(l2 += l3 * l4 + ((long)z2[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l5 = y2 >>> 32;
        z2[zOff + 1] = (int)(l2 += l3 * l5 + l4 + ((long)z2[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 2] = (int)(l2 += l5 + ((long)z2[zOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 3] = (int)(l2 += (long)z2[zOff + 3] & 0xFFFFFFFFL);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(5, z2, zOff, 4);
    }

    public static int mul33WordAdd(int x2, int y2, int[] z2, int zOff) {
        long l2 = 0L;
        long l3 = (long)x2 & 0xFFFFFFFFL;
        long l4 = (long)y2 & 0xFFFFFFFFL;
        z2[zOff + 0] = (int)(l2 += l4 * l3 + ((long)z2[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 1] = (int)(l2 += l4 + ((long)z2[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 2] = (int)(l2 += (long)z2[zOff + 2] & 0xFFFFFFFFL);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(5, z2, zOff, 3);
    }

    public static int mulWordDwordAdd(int x2, long y2, int[] z2, int zOff) {
        long l2 = 0L;
        long l3 = (long)x2 & 0xFFFFFFFFL;
        z2[zOff + 0] = (int)(l2 += l3 * (y2 & 0xFFFFFFFFL) + ((long)z2[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 1] = (int)(l2 += l3 * (y2 >>> 32) + ((long)z2[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 2] = (int)(l2 += (long)z2[zOff + 2] & 0xFFFFFFFFL);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(5, z2, zOff, 3);
    }

    public static int mulWordsAdd(int x2, int y2, int[] z2, int zOff) {
        long l2 = 0L;
        long l3 = (long)x2 & 0xFFFFFFFFL;
        long l4 = (long)y2 & 0xFFFFFFFFL;
        z2[zOff + 0] = (int)(l2 += l4 * l3 + ((long)z2[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 1] = (int)(l2 += (long)z2[zOff + 1] & 0xFFFFFFFFL);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(5, z2, zOff, 2);
    }

    public static int mulWord(int x2, int[] y2, int[] z2, int zOff) {
        long l2 = 0L;
        long l3 = (long)x2 & 0xFFFFFFFFL;
        int n2 = 0;
        do {
            z2[zOff + n2] = (int)(l2 += l3 * ((long)y2[n2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        } while (++n2 < 5);
        return (int)l2;
    }

    public static void square(int[] x2, int[] zz) {
        long l2;
        long l3;
        long l4 = (long)x2[0] & 0xFFFFFFFFL;
        int n2 = 0;
        int n3 = 4;
        int n4 = 10;
        do {
            l3 = (long)x2[n3--] & 0xFFFFFFFFL;
            l2 = l3 * l3;
            zz[--n4] = n2 << 31 | (int)(l2 >>> 33);
            zz[--n4] = (int)(l2 >>> 1);
            n2 = (int)l2;
        } while (n3 > 0);
        l3 = l4 * l4;
        long l5 = (long)(n2 << 31) & 0xFFFFFFFFL | l3 >>> 33;
        zz[0] = (int)l3;
        n2 = (int)(l3 >>> 32) & 1;
        long l6 = (long)x2[1] & 0xFFFFFFFFL;
        l3 = (long)zz[2] & 0xFFFFFFFFL;
        int n5 = (int)(l5 += l6 * l4);
        zz[1] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l3 += l5 >>> 32;
        l2 = (long)x2[2] & 0xFFFFFFFFL;
        long l7 = (long)zz[3] & 0xFFFFFFFFL;
        long l8 = (long)zz[4] & 0xFFFFFFFFL;
        n5 = (int)(l3 += l2 * l4);
        zz[2] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l7 &= 0xFFFFFFFFL;
        long l9 = (long)x2[3] & 0xFFFFFFFFL;
        long l10 = ((long)zz[5] & 0xFFFFFFFFL) + ((l8 += (l7 += (l3 >>> 32) + l2 * l6) >>> 32) >>> 32);
        l8 &= 0xFFFFFFFFL;
        long l11 = ((long)zz[6] & 0xFFFFFFFFL) + (l10 >>> 32);
        l10 &= 0xFFFFFFFFL;
        n5 = (int)(l7 += l9 * l4);
        zz[3] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l8 &= 0xFFFFFFFFL;
        l10 &= 0xFFFFFFFFL;
        long l12 = (long)x2[4] & 0xFFFFFFFFL;
        long l13 = ((long)zz[7] & 0xFFFFFFFFL) + ((l11 += (l10 += ((l8 += (l7 >>> 32) + l9 * l6) >>> 32) + l9 * l2) >>> 32) >>> 32);
        l11 &= 0xFFFFFFFFL;
        long l14 = ((long)zz[8] & 0xFFFFFFFFL) + (l13 >>> 32);
        l13 &= 0xFFFFFFFFL;
        n5 = (int)(l8 += l12 * l4);
        zz[4] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l14 += (l13 += ((l11 += ((l10 += (l8 >>> 32) + l12 * l6) >>> 32) + l12 * l2) >>> 32) + l12 * l9) >>> 32;
        n5 = (int)l10;
        zz[5] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l11;
        zz[6] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l13;
        zz[7] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l14;
        zz[8] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = zz[9] + (int)(l14 >>> 32);
        zz[9] = n5 << 1 | n2;
    }

    public static void square(int[] x2, int xOff, int[] zz, int zzOff) {
        long l2;
        long l3;
        long l4 = (long)x2[xOff + 0] & 0xFFFFFFFFL;
        int n2 = 0;
        int n3 = 4;
        int n4 = 10;
        do {
            l3 = (long)x2[xOff + n3--] & 0xFFFFFFFFL;
            l2 = l3 * l3;
            zz[zzOff + --n4] = n2 << 31 | (int)(l2 >>> 33);
            zz[zzOff + --n4] = (int)(l2 >>> 1);
            n2 = (int)l2;
        } while (n3 > 0);
        l3 = l4 * l4;
        long l5 = (long)(n2 << 31) & 0xFFFFFFFFL | l3 >>> 33;
        zz[zzOff + 0] = (int)l3;
        n2 = (int)(l3 >>> 32) & 1;
        long l6 = (long)x2[xOff + 1] & 0xFFFFFFFFL;
        l3 = (long)zz[zzOff + 2] & 0xFFFFFFFFL;
        int n5 = (int)(l5 += l6 * l4);
        zz[zzOff + 1] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l3 += l5 >>> 32;
        l2 = (long)x2[xOff + 2] & 0xFFFFFFFFL;
        long l7 = (long)zz[zzOff + 3] & 0xFFFFFFFFL;
        long l8 = (long)zz[zzOff + 4] & 0xFFFFFFFFL;
        n5 = (int)(l3 += l2 * l4);
        zz[zzOff + 2] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l7 &= 0xFFFFFFFFL;
        long l9 = (long)x2[xOff + 3] & 0xFFFFFFFFL;
        long l10 = ((long)zz[zzOff + 5] & 0xFFFFFFFFL) + ((l8 += (l7 += (l3 >>> 32) + l2 * l6) >>> 32) >>> 32);
        l8 &= 0xFFFFFFFFL;
        long l11 = ((long)zz[zzOff + 6] & 0xFFFFFFFFL) + (l10 >>> 32);
        l10 &= 0xFFFFFFFFL;
        n5 = (int)(l7 += l9 * l4);
        zz[zzOff + 3] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l8 &= 0xFFFFFFFFL;
        l10 &= 0xFFFFFFFFL;
        long l12 = (long)x2[xOff + 4] & 0xFFFFFFFFL;
        long l13 = ((long)zz[zzOff + 7] & 0xFFFFFFFFL) + ((l11 += (l10 += ((l8 += (l7 >>> 32) + l9 * l6) >>> 32) + l9 * l2) >>> 32) >>> 32);
        l11 &= 0xFFFFFFFFL;
        long l14 = ((long)zz[zzOff + 8] & 0xFFFFFFFFL) + (l13 >>> 32);
        l13 &= 0xFFFFFFFFL;
        n5 = (int)(l8 += l12 * l4);
        zz[zzOff + 4] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l14 += (l13 += ((l11 += ((l10 += (l8 >>> 32) + l12 * l6) >>> 32) + l12 * l2) >>> 32) + l12 * l9) >>> 32;
        n5 = (int)l10;
        zz[zzOff + 5] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l11;
        zz[zzOff + 6] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l13;
        zz[zzOff + 7] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l14;
        zz[zzOff + 8] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = zz[zzOff + 9] + (int)(l14 >>> 32);
        zz[zzOff + 9] = n5 << 1 | n2;
    }

    public static int sub(int[] x2, int[] y2, int[] z2) {
        long l2 = 0L;
        z2[0] = (int)(l2 += ((long)x2[0] & 0xFFFFFFFFL) - ((long)y2[0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[1] = (int)(l2 += ((long)x2[1] & 0xFFFFFFFFL) - ((long)y2[1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[2] = (int)(l2 += ((long)x2[2] & 0xFFFFFFFFL) - ((long)y2[2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[3] = (int)(l2 += ((long)x2[3] & 0xFFFFFFFFL) - ((long)y2[3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[4] = (int)(l2 += ((long)x2[4] & 0xFFFFFFFFL) - ((long)y2[4] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int sub(int[] x2, int xOff, int[] y2, int yOff, int[] z2, int zOff) {
        long l2 = 0L;
        z2[zOff + 0] = (int)(l2 += ((long)x2[xOff + 0] & 0xFFFFFFFFL) - ((long)y2[yOff + 0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 1] = (int)(l2 += ((long)x2[xOff + 1] & 0xFFFFFFFFL) - ((long)y2[yOff + 1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 2] = (int)(l2 += ((long)x2[xOff + 2] & 0xFFFFFFFFL) - ((long)y2[yOff + 2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 3] = (int)(l2 += ((long)x2[xOff + 3] & 0xFFFFFFFFL) - ((long)y2[yOff + 3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 4] = (int)(l2 += ((long)x2[xOff + 4] & 0xFFFFFFFFL) - ((long)y2[yOff + 4] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int subBothFrom(int[] x2, int[] y2, int[] z2) {
        long l2 = 0L;
        z2[0] = (int)(l2 += ((long)z2[0] & 0xFFFFFFFFL) - ((long)x2[0] & 0xFFFFFFFFL) - ((long)y2[0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[1] = (int)(l2 += ((long)z2[1] & 0xFFFFFFFFL) - ((long)x2[1] & 0xFFFFFFFFL) - ((long)y2[1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[2] = (int)(l2 += ((long)z2[2] & 0xFFFFFFFFL) - ((long)x2[2] & 0xFFFFFFFFL) - ((long)y2[2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[3] = (int)(l2 += ((long)z2[3] & 0xFFFFFFFFL) - ((long)x2[3] & 0xFFFFFFFFL) - ((long)y2[3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[4] = (int)(l2 += ((long)z2[4] & 0xFFFFFFFFL) - ((long)x2[4] & 0xFFFFFFFFL) - ((long)y2[4] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int subFrom(int[] x2, int[] z2) {
        long l2 = 0L;
        z2[0] = (int)(l2 += ((long)z2[0] & 0xFFFFFFFFL) - ((long)x2[0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[1] = (int)(l2 += ((long)z2[1] & 0xFFFFFFFFL) - ((long)x2[1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[2] = (int)(l2 += ((long)z2[2] & 0xFFFFFFFFL) - ((long)x2[2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[3] = (int)(l2 += ((long)z2[3] & 0xFFFFFFFFL) - ((long)x2[3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[4] = (int)(l2 += ((long)z2[4] & 0xFFFFFFFFL) - ((long)x2[4] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int subFrom(int[] x2, int xOff, int[] z2, int zOff) {
        long l2 = 0L;
        z2[zOff + 0] = (int)(l2 += ((long)z2[zOff + 0] & 0xFFFFFFFFL) - ((long)x2[xOff + 0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 1] = (int)(l2 += ((long)z2[zOff + 1] & 0xFFFFFFFFL) - ((long)x2[xOff + 1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 2] = (int)(l2 += ((long)z2[zOff + 2] & 0xFFFFFFFFL) - ((long)x2[xOff + 2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 3] = (int)(l2 += ((long)z2[zOff + 3] & 0xFFFFFFFFL) - ((long)x2[xOff + 3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 4] = (int)(l2 += ((long)z2[zOff + 4] & 0xFFFFFFFFL) - ((long)x2[xOff + 4] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static BigInteger toBigInteger(int[] x2) {
        byte[] byArray = new byte[20];
        for (int i2 = 0; i2 < 5; ++i2) {
            int n2 = x2[i2];
            if (n2 == 0) continue;
            Pack.intToBigEndian(n2, byArray, 4 - i2 << 2);
        }
        return new BigInteger(1, byArray);
    }

    public static void zero(int[] z2) {
        z2[0] = 0;
        z2[1] = 0;
        z2[2] = 0;
        z2[3] = 0;
        z2[4] = 0;
    }
}

