/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.raw;

import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;

public abstract class Nat256 {
    public static int add(int[] x2, int[] y2, int[] z2) {
        long l2 = 0L;
        z2[0] = (int)(l2 += ((long)x2[0] & 0xFFFFFFFFL) + ((long)y2[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[1] = (int)(l2 += ((long)x2[1] & 0xFFFFFFFFL) + ((long)y2[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[2] = (int)(l2 += ((long)x2[2] & 0xFFFFFFFFL) + ((long)y2[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[3] = (int)(l2 += ((long)x2[3] & 0xFFFFFFFFL) + ((long)y2[3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[4] = (int)(l2 += ((long)x2[4] & 0xFFFFFFFFL) + ((long)y2[4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[5] = (int)(l2 += ((long)x2[5] & 0xFFFFFFFFL) + ((long)y2[5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[6] = (int)(l2 += ((long)x2[6] & 0xFFFFFFFFL) + ((long)y2[6] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[7] = (int)(l2 += ((long)x2[7] & 0xFFFFFFFFL) + ((long)y2[7] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int add(int[] x2, int xOff, int[] y2, int yOff, int[] z2, int zOff) {
        long l2 = 0L;
        z2[zOff + 0] = (int)(l2 += ((long)x2[xOff + 0] & 0xFFFFFFFFL) + ((long)y2[yOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 1] = (int)(l2 += ((long)x2[xOff + 1] & 0xFFFFFFFFL) + ((long)y2[yOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 2] = (int)(l2 += ((long)x2[xOff + 2] & 0xFFFFFFFFL) + ((long)y2[yOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 3] = (int)(l2 += ((long)x2[xOff + 3] & 0xFFFFFFFFL) + ((long)y2[yOff + 3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 4] = (int)(l2 += ((long)x2[xOff + 4] & 0xFFFFFFFFL) + ((long)y2[yOff + 4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 5] = (int)(l2 += ((long)x2[xOff + 5] & 0xFFFFFFFFL) + ((long)y2[yOff + 5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 6] = (int)(l2 += ((long)x2[xOff + 6] & 0xFFFFFFFFL) + ((long)y2[yOff + 6] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 7] = (int)(l2 += ((long)x2[xOff + 7] & 0xFFFFFFFFL) + ((long)y2[yOff + 7] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addBothTo(int[] x2, int[] y2, int[] z2) {
        long l2 = 0L;
        z2[0] = (int)(l2 += ((long)x2[0] & 0xFFFFFFFFL) + ((long)y2[0] & 0xFFFFFFFFL) + ((long)z2[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[1] = (int)(l2 += ((long)x2[1] & 0xFFFFFFFFL) + ((long)y2[1] & 0xFFFFFFFFL) + ((long)z2[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[2] = (int)(l2 += ((long)x2[2] & 0xFFFFFFFFL) + ((long)y2[2] & 0xFFFFFFFFL) + ((long)z2[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[3] = (int)(l2 += ((long)x2[3] & 0xFFFFFFFFL) + ((long)y2[3] & 0xFFFFFFFFL) + ((long)z2[3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[4] = (int)(l2 += ((long)x2[4] & 0xFFFFFFFFL) + ((long)y2[4] & 0xFFFFFFFFL) + ((long)z2[4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[5] = (int)(l2 += ((long)x2[5] & 0xFFFFFFFFL) + ((long)y2[5] & 0xFFFFFFFFL) + ((long)z2[5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[6] = (int)(l2 += ((long)x2[6] & 0xFFFFFFFFL) + ((long)y2[6] & 0xFFFFFFFFL) + ((long)z2[6] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[7] = (int)(l2 += ((long)x2[7] & 0xFFFFFFFFL) + ((long)y2[7] & 0xFFFFFFFFL) + ((long)z2[7] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addBothTo(int[] x2, int xOff, int[] y2, int yOff, int[] z2, int zOff) {
        long l2 = 0L;
        z2[zOff + 0] = (int)(l2 += ((long)x2[xOff + 0] & 0xFFFFFFFFL) + ((long)y2[yOff + 0] & 0xFFFFFFFFL) + ((long)z2[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 1] = (int)(l2 += ((long)x2[xOff + 1] & 0xFFFFFFFFL) + ((long)y2[yOff + 1] & 0xFFFFFFFFL) + ((long)z2[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 2] = (int)(l2 += ((long)x2[xOff + 2] & 0xFFFFFFFFL) + ((long)y2[yOff + 2] & 0xFFFFFFFFL) + ((long)z2[zOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 3] = (int)(l2 += ((long)x2[xOff + 3] & 0xFFFFFFFFL) + ((long)y2[yOff + 3] & 0xFFFFFFFFL) + ((long)z2[zOff + 3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 4] = (int)(l2 += ((long)x2[xOff + 4] & 0xFFFFFFFFL) + ((long)y2[yOff + 4] & 0xFFFFFFFFL) + ((long)z2[zOff + 4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 5] = (int)(l2 += ((long)x2[xOff + 5] & 0xFFFFFFFFL) + ((long)y2[yOff + 5] & 0xFFFFFFFFL) + ((long)z2[zOff + 5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 6] = (int)(l2 += ((long)x2[xOff + 6] & 0xFFFFFFFFL) + ((long)y2[yOff + 6] & 0xFFFFFFFFL) + ((long)z2[zOff + 6] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 7] = (int)(l2 += ((long)x2[xOff + 7] & 0xFFFFFFFFL) + ((long)y2[yOff + 7] & 0xFFFFFFFFL) + ((long)z2[zOff + 7] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addTo(int[] x2, int[] z2) {
        long l2 = 0L;
        z2[0] = (int)(l2 += ((long)x2[0] & 0xFFFFFFFFL) + ((long)z2[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[1] = (int)(l2 += ((long)x2[1] & 0xFFFFFFFFL) + ((long)z2[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[2] = (int)(l2 += ((long)x2[2] & 0xFFFFFFFFL) + ((long)z2[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[3] = (int)(l2 += ((long)x2[3] & 0xFFFFFFFFL) + ((long)z2[3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[4] = (int)(l2 += ((long)x2[4] & 0xFFFFFFFFL) + ((long)z2[4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[5] = (int)(l2 += ((long)x2[5] & 0xFFFFFFFFL) + ((long)z2[5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[6] = (int)(l2 += ((long)x2[6] & 0xFFFFFFFFL) + ((long)z2[6] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[7] = (int)(l2 += ((long)x2[7] & 0xFFFFFFFFL) + ((long)z2[7] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addTo(int[] x2, int xOff, int[] z2, int zOff, int cIn) {
        long l2 = (long)cIn & 0xFFFFFFFFL;
        z2[zOff + 0] = (int)(l2 += ((long)x2[xOff + 0] & 0xFFFFFFFFL) + ((long)z2[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 1] = (int)(l2 += ((long)x2[xOff + 1] & 0xFFFFFFFFL) + ((long)z2[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 2] = (int)(l2 += ((long)x2[xOff + 2] & 0xFFFFFFFFL) + ((long)z2[zOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 3] = (int)(l2 += ((long)x2[xOff + 3] & 0xFFFFFFFFL) + ((long)z2[zOff + 3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 4] = (int)(l2 += ((long)x2[xOff + 4] & 0xFFFFFFFFL) + ((long)z2[zOff + 4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 5] = (int)(l2 += ((long)x2[xOff + 5] & 0xFFFFFFFFL) + ((long)z2[zOff + 5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 6] = (int)(l2 += ((long)x2[xOff + 6] & 0xFFFFFFFFL) + ((long)z2[zOff + 6] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 7] = (int)(l2 += ((long)x2[xOff + 7] & 0xFFFFFFFFL) + ((long)z2[zOff + 7] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addToEachOther(int[] u2, int uOff, int[] v2, int vOff) {
        long l2 = 0L;
        u2[uOff + 0] = (int)(l2 += ((long)u2[uOff + 0] & 0xFFFFFFFFL) + ((long)v2[vOff + 0] & 0xFFFFFFFFL));
        v2[vOff + 0] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 1] = (int)(l2 += ((long)u2[uOff + 1] & 0xFFFFFFFFL) + ((long)v2[vOff + 1] & 0xFFFFFFFFL));
        v2[vOff + 1] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 2] = (int)(l2 += ((long)u2[uOff + 2] & 0xFFFFFFFFL) + ((long)v2[vOff + 2] & 0xFFFFFFFFL));
        v2[vOff + 2] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 3] = (int)(l2 += ((long)u2[uOff + 3] & 0xFFFFFFFFL) + ((long)v2[vOff + 3] & 0xFFFFFFFFL));
        v2[vOff + 3] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 4] = (int)(l2 += ((long)u2[uOff + 4] & 0xFFFFFFFFL) + ((long)v2[vOff + 4] & 0xFFFFFFFFL));
        v2[vOff + 4] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 5] = (int)(l2 += ((long)u2[uOff + 5] & 0xFFFFFFFFL) + ((long)v2[vOff + 5] & 0xFFFFFFFFL));
        v2[vOff + 5] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 6] = (int)(l2 += ((long)u2[uOff + 6] & 0xFFFFFFFFL) + ((long)v2[vOff + 6] & 0xFFFFFFFFL));
        v2[vOff + 6] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 7] = (int)(l2 += ((long)u2[uOff + 7] & 0xFFFFFFFFL) + ((long)v2[vOff + 7] & 0xFFFFFFFFL));
        v2[vOff + 7] = (int)l2;
        return (int)(l2 >>>= 32);
    }

    public static void copy(int[] x2, int[] z2) {
        z2[0] = x2[0];
        z2[1] = x2[1];
        z2[2] = x2[2];
        z2[3] = x2[3];
        z2[4] = x2[4];
        z2[5] = x2[5];
        z2[6] = x2[6];
        z2[7] = x2[7];
    }

    public static void copy(int[] x2, int xOff, int[] z2, int zOff) {
        z2[zOff + 0] = x2[xOff + 0];
        z2[zOff + 1] = x2[xOff + 1];
        z2[zOff + 2] = x2[xOff + 2];
        z2[zOff + 3] = x2[xOff + 3];
        z2[zOff + 4] = x2[xOff + 4];
        z2[zOff + 5] = x2[xOff + 5];
        z2[zOff + 6] = x2[xOff + 6];
        z2[zOff + 7] = x2[xOff + 7];
    }

    public static void copy64(long[] x2, long[] z2) {
        z2[0] = x2[0];
        z2[1] = x2[1];
        z2[2] = x2[2];
        z2[3] = x2[3];
    }

    public static void copy64(long[] x2, int xOff, long[] z2, int zOff) {
        z2[zOff + 0] = x2[xOff + 0];
        z2[zOff + 1] = x2[xOff + 1];
        z2[zOff + 2] = x2[xOff + 2];
        z2[zOff + 3] = x2[xOff + 3];
    }

    public static int[] create() {
        return new int[8];
    }

    public static long[] create64() {
        return new long[4];
    }

    public static int[] createExt() {
        return new int[16];
    }

    public static long[] createExt64() {
        return new long[8];
    }

    public static boolean diff(int[] x2, int xOff, int[] y2, int yOff, int[] z2, int zOff) {
        boolean bl = Nat256.gte(x2, xOff, y2, yOff);
        if (bl) {
            Nat256.sub(x2, xOff, y2, yOff, z2, zOff);
        } else {
            Nat256.sub(y2, yOff, x2, xOff, z2, zOff);
        }
        return bl;
    }

    public static boolean eq(int[] x2, int[] y2) {
        for (int i2 = 7; i2 >= 0; --i2) {
            if (x2[i2] == y2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean eq64(long[] x2, long[] y2) {
        for (int i2 = 3; i2 >= 0; --i2) {
            if (x2[i2] == y2[i2]) continue;
            return false;
        }
        return true;
    }

    public static int[] fromBigInteger(BigInteger x2) {
        if (x2.signum() < 0 || x2.bitLength() > 256) {
            throw new IllegalArgumentException();
        }
        int[] nArray = Nat256.create();
        int n2 = 0;
        while (x2.signum() != 0) {
            nArray[n2++] = x2.intValue();
            x2 = x2.shiftRight(32);
        }
        return nArray;
    }

    public static long[] fromBigInteger64(BigInteger x2) {
        if (x2.signum() < 0 || x2.bitLength() > 256) {
            throw new IllegalArgumentException();
        }
        long[] lArray = Nat256.create64();
        int n2 = 0;
        while (x2.signum() != 0) {
            lArray[n2++] = x2.longValue();
            x2 = x2.shiftRight(64);
        }
        return lArray;
    }

    public static int getBit(int[] x2, int bit) {
        if (bit == 0) {
            return x2[0] & 1;
        }
        if ((bit & 0xFF) != bit) {
            return 0;
        }
        int n2 = bit >>> 5;
        int n3 = bit & 0x1F;
        return x2[n2] >>> n3 & 1;
    }

    public static boolean gte(int[] x2, int[] y2) {
        for (int i2 = 7; i2 >= 0; --i2) {
            int n2 = x2[i2] ^ Integer.MIN_VALUE;
            int n3 = y2[i2] ^ Integer.MIN_VALUE;
            if (n2 < n3) {
                return false;
            }
            if (n2 <= n3) continue;
            return true;
        }
        return true;
    }

    public static boolean gte(int[] x2, int xOff, int[] y2, int yOff) {
        for (int i2 = 7; i2 >= 0; --i2) {
            int n2 = x2[xOff + i2] ^ Integer.MIN_VALUE;
            int n3 = y2[yOff + i2] ^ Integer.MIN_VALUE;
            if (n2 < n3) {
                return false;
            }
            if (n2 <= n3) continue;
            return true;
        }
        return true;
    }

    public static boolean isOne(int[] x2) {
        if (x2[0] != 1) {
            return false;
        }
        for (int i2 = 1; i2 < 8; ++i2) {
            if (x2[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isOne64(long[] x2) {
        if (x2[0] != 1L) {
            return false;
        }
        for (int i2 = 1; i2 < 4; ++i2) {
            if (x2[i2] == 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int[] x2) {
        for (int i2 = 0; i2 < 8; ++i2) {
            if (x2[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero64(long[] x2) {
        for (int i2 = 0; i2 < 4; ++i2) {
            if (x2[i2] == 0L) continue;
            return false;
        }
        return true;
    }

    public static void mul(int[] x2, int[] y2, int[] zz) {
        long l2 = (long)y2[0] & 0xFFFFFFFFL;
        long l3 = (long)y2[1] & 0xFFFFFFFFL;
        long l4 = (long)y2[2] & 0xFFFFFFFFL;
        long l5 = (long)y2[3] & 0xFFFFFFFFL;
        long l6 = (long)y2[4] & 0xFFFFFFFFL;
        long l7 = (long)y2[5] & 0xFFFFFFFFL;
        long l8 = (long)y2[6] & 0xFFFFFFFFL;
        long l9 = (long)y2[7] & 0xFFFFFFFFL;
        long l10 = 0L;
        long l11 = (long)x2[0] & 0xFFFFFFFFL;
        zz[0] = (int)(l10 += l11 * l2);
        l10 >>>= 32;
        zz[1] = (int)(l10 += l11 * l3);
        l10 >>>= 32;
        zz[2] = (int)(l10 += l11 * l4);
        l10 >>>= 32;
        zz[3] = (int)(l10 += l11 * l5);
        l10 >>>= 32;
        zz[4] = (int)(l10 += l11 * l6);
        l10 >>>= 32;
        zz[5] = (int)(l10 += l11 * l7);
        l10 >>>= 32;
        zz[6] = (int)(l10 += l11 * l8);
        l10 >>>= 32;
        zz[7] = (int)(l10 += l11 * l9);
        zz[8] = (int)(l10 >>>= 32);
        for (int i2 = 1; i2 < 8; ++i2) {
            long l12 = 0L;
            long l13 = (long)x2[i2] & 0xFFFFFFFFL;
            zz[i2 + 0] = (int)(l12 += l13 * l2 + ((long)zz[i2 + 0] & 0xFFFFFFFFL));
            l12 >>>= 32;
            zz[i2 + 1] = (int)(l12 += l13 * l3 + ((long)zz[i2 + 1] & 0xFFFFFFFFL));
            l12 >>>= 32;
            zz[i2 + 2] = (int)(l12 += l13 * l4 + ((long)zz[i2 + 2] & 0xFFFFFFFFL));
            l12 >>>= 32;
            zz[i2 + 3] = (int)(l12 += l13 * l5 + ((long)zz[i2 + 3] & 0xFFFFFFFFL));
            l12 >>>= 32;
            zz[i2 + 4] = (int)(l12 += l13 * l6 + ((long)zz[i2 + 4] & 0xFFFFFFFFL));
            l12 >>>= 32;
            zz[i2 + 5] = (int)(l12 += l13 * l7 + ((long)zz[i2 + 5] & 0xFFFFFFFFL));
            l12 >>>= 32;
            zz[i2 + 6] = (int)(l12 += l13 * l8 + ((long)zz[i2 + 6] & 0xFFFFFFFFL));
            l12 >>>= 32;
            zz[i2 + 7] = (int)(l12 += l13 * l9 + ((long)zz[i2 + 7] & 0xFFFFFFFFL));
            zz[i2 + 8] = (int)(l12 >>>= 32);
        }
    }

    public static void mul(int[] x2, int xOff, int[] y2, int yOff, int[] zz, int zzOff) {
        long l2 = (long)y2[yOff + 0] & 0xFFFFFFFFL;
        long l3 = (long)y2[yOff + 1] & 0xFFFFFFFFL;
        long l4 = (long)y2[yOff + 2] & 0xFFFFFFFFL;
        long l5 = (long)y2[yOff + 3] & 0xFFFFFFFFL;
        long l6 = (long)y2[yOff + 4] & 0xFFFFFFFFL;
        long l7 = (long)y2[yOff + 5] & 0xFFFFFFFFL;
        long l8 = (long)y2[yOff + 6] & 0xFFFFFFFFL;
        long l9 = (long)y2[yOff + 7] & 0xFFFFFFFFL;
        long l10 = 0L;
        long l11 = (long)x2[xOff + 0] & 0xFFFFFFFFL;
        zz[zzOff + 0] = (int)(l10 += l11 * l2);
        l10 >>>= 32;
        zz[zzOff + 1] = (int)(l10 += l11 * l3);
        l10 >>>= 32;
        zz[zzOff + 2] = (int)(l10 += l11 * l4);
        l10 >>>= 32;
        zz[zzOff + 3] = (int)(l10 += l11 * l5);
        l10 >>>= 32;
        zz[zzOff + 4] = (int)(l10 += l11 * l6);
        l10 >>>= 32;
        zz[zzOff + 5] = (int)(l10 += l11 * l7);
        l10 >>>= 32;
        zz[zzOff + 6] = (int)(l10 += l11 * l8);
        l10 >>>= 32;
        zz[zzOff + 7] = (int)(l10 += l11 * l9);
        zz[zzOff + 8] = (int)(l10 >>>= 32);
        for (int i2 = 1; i2 < 8; ++i2) {
            long l12 = 0L;
            long l13 = (long)x2[xOff + i2] & 0xFFFFFFFFL;
            zz[zzOff + 0] = (int)(l12 += l13 * l2 + ((long)zz[++zzOff + 0] & 0xFFFFFFFFL));
            l12 >>>= 32;
            zz[zzOff + 1] = (int)(l12 += l13 * l3 + ((long)zz[zzOff + 1] & 0xFFFFFFFFL));
            l12 >>>= 32;
            zz[zzOff + 2] = (int)(l12 += l13 * l4 + ((long)zz[zzOff + 2] & 0xFFFFFFFFL));
            l12 >>>= 32;
            zz[zzOff + 3] = (int)(l12 += l13 * l5 + ((long)zz[zzOff + 3] & 0xFFFFFFFFL));
            l12 >>>= 32;
            zz[zzOff + 4] = (int)(l12 += l13 * l6 + ((long)zz[zzOff + 4] & 0xFFFFFFFFL));
            l12 >>>= 32;
            zz[zzOff + 5] = (int)(l12 += l13 * l7 + ((long)zz[zzOff + 5] & 0xFFFFFFFFL));
            l12 >>>= 32;
            zz[zzOff + 6] = (int)(l12 += l13 * l8 + ((long)zz[zzOff + 6] & 0xFFFFFFFFL));
            l12 >>>= 32;
            zz[zzOff + 7] = (int)(l12 += l13 * l9 + ((long)zz[zzOff + 7] & 0xFFFFFFFFL));
            zz[zzOff + 8] = (int)(l12 >>>= 32);
        }
    }

    public static int mulAddTo(int[] x2, int[] y2, int[] zz) {
        long l2 = (long)y2[0] & 0xFFFFFFFFL;
        long l3 = (long)y2[1] & 0xFFFFFFFFL;
        long l4 = (long)y2[2] & 0xFFFFFFFFL;
        long l5 = (long)y2[3] & 0xFFFFFFFFL;
        long l6 = (long)y2[4] & 0xFFFFFFFFL;
        long l7 = (long)y2[5] & 0xFFFFFFFFL;
        long l8 = (long)y2[6] & 0xFFFFFFFFL;
        long l9 = (long)y2[7] & 0xFFFFFFFFL;
        long l10 = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            long l11 = 0L;
            long l12 = (long)x2[i2] & 0xFFFFFFFFL;
            zz[i2 + 0] = (int)(l11 += l12 * l2 + ((long)zz[i2 + 0] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[i2 + 1] = (int)(l11 += l12 * l3 + ((long)zz[i2 + 1] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[i2 + 2] = (int)(l11 += l12 * l4 + ((long)zz[i2 + 2] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[i2 + 3] = (int)(l11 += l12 * l5 + ((long)zz[i2 + 3] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[i2 + 4] = (int)(l11 += l12 * l6 + ((long)zz[i2 + 4] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[i2 + 5] = (int)(l11 += l12 * l7 + ((long)zz[i2 + 5] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[i2 + 6] = (int)(l11 += l12 * l8 + ((long)zz[i2 + 6] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[i2 + 7] = (int)(l11 += l12 * l9 + ((long)zz[i2 + 7] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[i2 + 8] = (int)(l11 += l10 + ((long)zz[i2 + 8] & 0xFFFFFFFFL));
            l10 = l11 >>> 32;
        }
        return (int)l10;
    }

    public static int mulAddTo(int[] x2, int xOff, int[] y2, int yOff, int[] zz, int zzOff) {
        long l2 = (long)y2[yOff + 0] & 0xFFFFFFFFL;
        long l3 = (long)y2[yOff + 1] & 0xFFFFFFFFL;
        long l4 = (long)y2[yOff + 2] & 0xFFFFFFFFL;
        long l5 = (long)y2[yOff + 3] & 0xFFFFFFFFL;
        long l6 = (long)y2[yOff + 4] & 0xFFFFFFFFL;
        long l7 = (long)y2[yOff + 5] & 0xFFFFFFFFL;
        long l8 = (long)y2[yOff + 6] & 0xFFFFFFFFL;
        long l9 = (long)y2[yOff + 7] & 0xFFFFFFFFL;
        long l10 = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            long l11 = 0L;
            long l12 = (long)x2[xOff + i2] & 0xFFFFFFFFL;
            zz[zzOff + 0] = (int)(l11 += l12 * l2 + ((long)zz[zzOff + 0] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[zzOff + 1] = (int)(l11 += l12 * l3 + ((long)zz[zzOff + 1] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[zzOff + 2] = (int)(l11 += l12 * l4 + ((long)zz[zzOff + 2] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[zzOff + 3] = (int)(l11 += l12 * l5 + ((long)zz[zzOff + 3] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[zzOff + 4] = (int)(l11 += l12 * l6 + ((long)zz[zzOff + 4] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[zzOff + 5] = (int)(l11 += l12 * l7 + ((long)zz[zzOff + 5] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[zzOff + 6] = (int)(l11 += l12 * l8 + ((long)zz[zzOff + 6] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[zzOff + 7] = (int)(l11 += l12 * l9 + ((long)zz[zzOff + 7] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[zzOff + 8] = (int)(l11 += l10 + ((long)zz[zzOff + 8] & 0xFFFFFFFFL));
            l10 = l11 >>> 32;
            ++zzOff;
        }
        return (int)l10;
    }

    public static long mul33Add(int w2, int[] x2, int xOff, int[] y2, int yOff, int[] z2, int zOff) {
        long l2 = 0L;
        long l3 = (long)w2 & 0xFFFFFFFFL;
        long l4 = (long)x2[xOff + 0] & 0xFFFFFFFFL;
        z2[zOff + 0] = (int)(l2 += l3 * l4 + ((long)y2[yOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l5 = (long)x2[xOff + 1] & 0xFFFFFFFFL;
        z2[zOff + 1] = (int)(l2 += l3 * l5 + l4 + ((long)y2[yOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l6 = (long)x2[xOff + 2] & 0xFFFFFFFFL;
        z2[zOff + 2] = (int)(l2 += l3 * l6 + l5 + ((long)y2[yOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l7 = (long)x2[xOff + 3] & 0xFFFFFFFFL;
        z2[zOff + 3] = (int)(l2 += l3 * l7 + l6 + ((long)y2[yOff + 3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l8 = (long)x2[xOff + 4] & 0xFFFFFFFFL;
        z2[zOff + 4] = (int)(l2 += l3 * l8 + l7 + ((long)y2[yOff + 4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l9 = (long)x2[xOff + 5] & 0xFFFFFFFFL;
        z2[zOff + 5] = (int)(l2 += l3 * l9 + l8 + ((long)y2[yOff + 5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l10 = (long)x2[xOff + 6] & 0xFFFFFFFFL;
        z2[zOff + 6] = (int)(l2 += l3 * l10 + l9 + ((long)y2[yOff + 6] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l11 = (long)x2[xOff + 7] & 0xFFFFFFFFL;
        z2[zOff + 7] = (int)(l2 += l3 * l11 + l10 + ((long)y2[yOff + 7] & 0xFFFFFFFFL));
        l2 >>>= 32;
        return l2 += l11;
    }

    public static int mulByWord(int x2, int[] z2) {
        long l2 = 0L;
        long l3 = (long)x2 & 0xFFFFFFFFL;
        z2[0] = (int)(l2 += l3 * ((long)z2[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[1] = (int)(l2 += l3 * ((long)z2[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[2] = (int)(l2 += l3 * ((long)z2[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[3] = (int)(l2 += l3 * ((long)z2[3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[4] = (int)(l2 += l3 * ((long)z2[4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[5] = (int)(l2 += l3 * ((long)z2[5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[6] = (int)(l2 += l3 * ((long)z2[6] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[7] = (int)(l2 += l3 * ((long)z2[7] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int mulByWordAddTo(int x2, int[] y2, int[] z2) {
        long l2 = 0L;
        long l3 = (long)x2 & 0xFFFFFFFFL;
        z2[0] = (int)(l2 += l3 * ((long)z2[0] & 0xFFFFFFFFL) + ((long)y2[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[1] = (int)(l2 += l3 * ((long)z2[1] & 0xFFFFFFFFL) + ((long)y2[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[2] = (int)(l2 += l3 * ((long)z2[2] & 0xFFFFFFFFL) + ((long)y2[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[3] = (int)(l2 += l3 * ((long)z2[3] & 0xFFFFFFFFL) + ((long)y2[3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[4] = (int)(l2 += l3 * ((long)z2[4] & 0xFFFFFFFFL) + ((long)y2[4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[5] = (int)(l2 += l3 * ((long)z2[5] & 0xFFFFFFFFL) + ((long)y2[5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[6] = (int)(l2 += l3 * ((long)z2[6] & 0xFFFFFFFFL) + ((long)y2[6] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[7] = (int)(l2 += l3 * ((long)z2[7] & 0xFFFFFFFFL) + ((long)y2[7] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int mulWordAddTo(int x2, int[] y2, int yOff, int[] z2, int zOff) {
        long l2 = 0L;
        long l3 = (long)x2 & 0xFFFFFFFFL;
        z2[zOff + 0] = (int)(l2 += l3 * ((long)y2[yOff + 0] & 0xFFFFFFFFL) + ((long)z2[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 1] = (int)(l2 += l3 * ((long)y2[yOff + 1] & 0xFFFFFFFFL) + ((long)z2[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 2] = (int)(l2 += l3 * ((long)y2[yOff + 2] & 0xFFFFFFFFL) + ((long)z2[zOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 3] = (int)(l2 += l3 * ((long)y2[yOff + 3] & 0xFFFFFFFFL) + ((long)z2[zOff + 3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 4] = (int)(l2 += l3 * ((long)y2[yOff + 4] & 0xFFFFFFFFL) + ((long)z2[zOff + 4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 5] = (int)(l2 += l3 * ((long)y2[yOff + 5] & 0xFFFFFFFFL) + ((long)z2[zOff + 5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 6] = (int)(l2 += l3 * ((long)y2[yOff + 6] & 0xFFFFFFFFL) + ((long)z2[zOff + 6] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 7] = (int)(l2 += l3 * ((long)y2[yOff + 7] & 0xFFFFFFFFL) + ((long)z2[zOff + 7] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int mul33DWordAdd(int x2, long y2, int[] z2, int zOff) {
        long l2 = 0L;
        long l3 = (long)x2 & 0xFFFFFFFFL;
        long l4 = y2 & 0xFFFFFFFFL;
        z2[zOff + 0] = (int)(l2 += l3 * l4 + ((long)z2[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l5 = y2 >>> 32;
        z2[zOff + 1] = (int)(l2 += l3 * l5 + l4 + ((long)z2[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 2] = (int)(l2 += l5 + ((long)z2[zOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 3] = (int)(l2 += (long)z2[zOff + 3] & 0xFFFFFFFFL);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(8, z2, zOff, 4);
    }

    public static int mul33WordAdd(int x2, int y2, int[] z2, int zOff) {
        long l2 = 0L;
        long l3 = (long)x2 & 0xFFFFFFFFL;
        long l4 = (long)y2 & 0xFFFFFFFFL;
        z2[zOff + 0] = (int)(l2 += l4 * l3 + ((long)z2[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 1] = (int)(l2 += l4 + ((long)z2[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 2] = (int)(l2 += (long)z2[zOff + 2] & 0xFFFFFFFFL);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(8, z2, zOff, 3);
    }

    public static int mulWordDwordAdd(int x2, long y2, int[] z2, int zOff) {
        long l2 = 0L;
        long l3 = (long)x2 & 0xFFFFFFFFL;
        z2[zOff + 0] = (int)(l2 += l3 * (y2 & 0xFFFFFFFFL) + ((long)z2[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 1] = (int)(l2 += l3 * (y2 >>> 32) + ((long)z2[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z2[zOff + 2] = (int)(l2 += (long)z2[zOff + 2] & 0xFFFFFFFFL);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(8, z2, zOff, 3);
    }

    public static int mulWord(int x2, int[] y2, int[] z2, int zOff) {
        long l2 = 0L;
        long l3 = (long)x2 & 0xFFFFFFFFL;
        int n2 = 0;
        do {
            z2[zOff + n2] = (int)(l2 += l3 * ((long)y2[n2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        } while (++n2 < 8);
        return (int)l2;
    }

    public static void square(int[] x2, int[] zz) {
        long l2;
        long l3;
        long l4 = (long)x2[0] & 0xFFFFFFFFL;
        int n2 = 0;
        int n3 = 7;
        int n4 = 16;
        do {
            l3 = (long)x2[n3--] & 0xFFFFFFFFL;
            l2 = l3 * l3;
            zz[--n4] = n2 << 31 | (int)(l2 >>> 33);
            zz[--n4] = (int)(l2 >>> 1);
            n2 = (int)l2;
        } while (n3 > 0);
        l3 = l4 * l4;
        long l5 = (long)(n2 << 31) & 0xFFFFFFFFL | l3 >>> 33;
        zz[0] = (int)l3;
        n2 = (int)(l3 >>> 32) & 1;
        long l6 = (long)x2[1] & 0xFFFFFFFFL;
        l3 = (long)zz[2] & 0xFFFFFFFFL;
        int n5 = (int)(l5 += l6 * l4);
        zz[1] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l3 += l5 >>> 32;
        l2 = (long)x2[2] & 0xFFFFFFFFL;
        long l7 = (long)zz[3] & 0xFFFFFFFFL;
        long l8 = (long)zz[4] & 0xFFFFFFFFL;
        n5 = (int)(l3 += l2 * l4);
        zz[2] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l7 &= 0xFFFFFFFFL;
        long l9 = (long)x2[3] & 0xFFFFFFFFL;
        long l10 = ((long)zz[5] & 0xFFFFFFFFL) + ((l8 += (l7 += (l3 >>> 32) + l2 * l6) >>> 32) >>> 32);
        l8 &= 0xFFFFFFFFL;
        long l11 = ((long)zz[6] & 0xFFFFFFFFL) + (l10 >>> 32);
        l10 &= 0xFFFFFFFFL;
        n5 = (int)(l7 += l9 * l4);
        zz[3] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l8 &= 0xFFFFFFFFL;
        l10 &= 0xFFFFFFFFL;
        long l12 = (long)x2[4] & 0xFFFFFFFFL;
        long l13 = ((long)zz[7] & 0xFFFFFFFFL) + ((l11 += (l10 += ((l8 += (l7 >>> 32) + l9 * l6) >>> 32) + l9 * l2) >>> 32) >>> 32);
        l11 &= 0xFFFFFFFFL;
        long l14 = ((long)zz[8] & 0xFFFFFFFFL) + (l13 >>> 32);
        l13 &= 0xFFFFFFFFL;
        n5 = (int)(l8 += l12 * l4);
        zz[4] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l10 &= 0xFFFFFFFFL;
        l11 &= 0xFFFFFFFFL;
        l13 &= 0xFFFFFFFFL;
        long l15 = (long)x2[5] & 0xFFFFFFFFL;
        long l16 = ((long)zz[9] & 0xFFFFFFFFL) + ((l14 += (l13 += ((l11 += ((l10 += (l8 >>> 32) + l12 * l6) >>> 32) + l12 * l2) >>> 32) + l12 * l9) >>> 32) >>> 32);
        l14 &= 0xFFFFFFFFL;
        long l17 = ((long)zz[10] & 0xFFFFFFFFL) + (l16 >>> 32);
        l16 &= 0xFFFFFFFFL;
        n5 = (int)(l10 += l15 * l4);
        zz[5] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l11 &= 0xFFFFFFFFL;
        l13 &= 0xFFFFFFFFL;
        l14 &= 0xFFFFFFFFL;
        l16 &= 0xFFFFFFFFL;
        long l18 = (long)x2[6] & 0xFFFFFFFFL;
        long l19 = ((long)zz[11] & 0xFFFFFFFFL) + ((l17 += (l16 += ((l14 += ((l13 += ((l11 += (l10 >>> 32) + l15 * l6) >>> 32) + l15 * l2) >>> 32) + l15 * l9) >>> 32) + l15 * l12) >>> 32) >>> 32);
        l17 &= 0xFFFFFFFFL;
        long l20 = ((long)zz[12] & 0xFFFFFFFFL) + (l19 >>> 32);
        l19 &= 0xFFFFFFFFL;
        n5 = (int)(l11 += l18 * l4);
        zz[6] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l13 &= 0xFFFFFFFFL;
        l14 &= 0xFFFFFFFFL;
        l16 &= 0xFFFFFFFFL;
        l17 &= 0xFFFFFFFFL;
        l19 &= 0xFFFFFFFFL;
        long l21 = (long)x2[7] & 0xFFFFFFFFL;
        long l22 = ((long)zz[13] & 0xFFFFFFFFL) + ((l20 += (l19 += ((l17 += ((l16 += ((l14 += ((l13 += (l11 >>> 32) + l18 * l6) >>> 32) + l18 * l2) >>> 32) + l18 * l9) >>> 32) + l18 * l12) >>> 32) + l18 * l15) >>> 32) >>> 32);
        l20 &= 0xFFFFFFFFL;
        long l23 = ((long)zz[14] & 0xFFFFFFFFL) + (l22 >>> 32);
        l22 &= 0xFFFFFFFFL;
        n5 = (int)(l13 += l21 * l4);
        zz[7] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l23 += (l22 += ((l20 += ((l19 += ((l17 += ((l16 += ((l14 += (l13 >>> 32) + l21 * l6) >>> 32) + l21 * l2) >>> 32) + l21 * l9) >>> 32) + l21 * l12) >>> 32) + l21 * l15) >>> 32) + l21 * l18) >>> 32;
        n5 = (int)l14;
        zz[8] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l16;
        zz[9] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l17;
        zz[10] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l19;
        zz[11] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l20;
        zz[12] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l22;
        zz[13] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l23;
        zz[14] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = zz[15] + (int)(l23 >>> 32);
        zz[15] = n5 << 1 | n2;
    }

    public static void square(int[] x2, int xOff, int[] zz, int zzOff) {
        long l2;
        long l3;
        long l4 = (long)x2[xOff + 0] & 0xFFFFFFFFL;
        int n2 = 0;
        int n3 = 7;
        int n4 = 16;
        do {
            l3 = (long)x2[xOff + n3--] & 0xFFFFFFFFL;
            l2 = l3 * l3;
            zz[zzOff + --n4] = n2 << 31 | (int)(l2 >>> 33);
            zz[zzOff + --n4] = (int)(l2 >>> 1);
            n2 = (int)l2;
        } while (n3 > 0);
        l3 = l4 * l4;
        long l5 = (long)(n2 << 31) & 0xFFFFFFFFL | l3 >>> 33;
        zz[zzOff + 0] = (int)l3;
        n2 = (int)(l3 >>> 32) & 1;
        long l6 = (long)x2[xOff + 1] & 0xFFFFFFFFL;
        l3 = (long)zz[zzOff + 2] & 0xFFFFFFFFL;
        int n5 = (int)(l5 += l6 * l4);
        zz[zzOff + 1] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l3 += l5 >>> 32;
        l2 = (long)x2[xOff + 2] & 0xFFFFFFFFL;
        long l7 = (long)zz[zzOff + 3] & 0xFFFFFFFFL;
        long l8 = (long)zz[zzOff + 4] & 0xFFFFFFFFL;
        n5 = (int)(l3 += l2 * l4);
        zz[zzOff + 2] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l7 &= 0xFFFFFFFFL;
        long l9 = (long)x2[xOff + 3] & 0xFFFFFFFFL;
        long l10 = ((long)zz[zzOff + 5] & 0xFFFFFFFFL) + ((l8 += (l7 += (l3 >>> 32) + l2 * l6) >>> 32) >>> 32);
        l8 &= 0xFFFFFFFFL;
        long l11 = ((long)zz[zzOff + 6] & 0xFFFFFFFFL) + (l10 >>> 32);
        l10 &= 0xFFFFFFFFL;
        n5 = (int)(l7 += l9 * l4);
        zz[zzOff + 3] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l8 &= 0xFFFFFFFFL;
        l10 &= 0xFFFFFFFFL;
        long l12 = (long)x2[xOff + 4] & 0xFFFFFFFFL;
        long l13 = ((long)zz[zzOff + 7] & 0xFFFFFFFFL) + ((l11 += (l10 += ((l8 += (l7 >>> 32) + l9 * l6) >>> 32) + l9 * l2) >>> 32) >>> 32);
        l11 &= 0xFFFFFFFFL;
        long l14 = ((long)zz[zzOff + 8] & 0xFFFFFFFFL) + (l13 >>> 32);
        l13 &= 0xFFFFFFFFL;
        n5 = (int)(l8 += l12 * l4);
        zz[zzOff + 4] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l10 &= 0xFFFFFFFFL;
        l11 &= 0xFFFFFFFFL;
        l13 &= 0xFFFFFFFFL;
        long l15 = (long)x2[xOff + 5] & 0xFFFFFFFFL;
        long l16 = ((long)zz[zzOff + 9] & 0xFFFFFFFFL) + ((l14 += (l13 += ((l11 += ((l10 += (l8 >>> 32) + l12 * l6) >>> 32) + l12 * l2) >>> 32) + l12 * l9) >>> 32) >>> 32);
        l14 &= 0xFFFFFFFFL;
        long l17 = ((long)zz[zzOff + 10] & 0xFFFFFFFFL) + (l16 >>> 32);
        l16 &= 0xFFFFFFFFL;
        n5 = (int)(l10 += l15 * l4);
        zz[zzOff + 5] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l11 &= 0xFFFFFFFFL;
        l13 &= 0xFFFFFFFFL;
        l14 &= 0xFFFFFFFFL;
        l16 &= 0xFFFFFFFFL;
        long l18 = (long)x2[xOff + 6] & 0xFFFFFFFFL;
        long l19 = ((long)zz[zzOff + 11] & 0xFFFFFFFFL) + ((l17 += (l16 += ((l14 += ((l13 += ((l11 += (l10 >>> 32) + l15 * l6) >>> 32) + l15 * l2) >>> 32) + l15 * l9) >>> 32) + l15 * l12) >>> 32) >>> 32);
        l17 &= 0xFFFFFFFFL;
        long l20 = ((long)zz[zzOff + 12] & 0xFFFFFFFFL) + (l19 >>> 32);
        l19 &= 0xFFFFFFFFL;
        n5 = (int)(l11 += l18 * l4);
        zz[zzOff + 6] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l13 &= 0xFFFFFFFFL;
        l14 &= 0xFFFFFFFFL;
        l16 &= 0xFFFFFFFFL;
        l17 &= 0xFFFFFFFFL;
        l19 &= 0xFFFFFFFFL;
        long l21 = (long)x2[xOff + 7] & 0xFFFFFFFFL;
        long l22 = ((long)zz[zzOff + 13] & 0xFFFFFFFFL) + ((l20 += (l19 += ((l17 += ((l16 += ((l14 += ((l13 += (l11 >>> 32) + l18 * l6) >>> 32) + l18 * l2) >>> 32) + l18 * l9) >>> 32) + l18 * l12) >>> 32) + l18 * l15) >>> 32) >>> 32);
        l20 &= 0xFFFFFFFFL;
        long l23 = ((long)zz[zzOff + 14] & 0xFFFFFFFFL) + (l22 >>> 32);
        l22 &= 0xFFFFFFFFL;
        n5 = (int)(l13 += l21 * l4);
        zz[zzOff + 7] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l23 += (l22 += ((l20 += ((l19 += ((l17 += ((l16 += ((l14 += (l13 >>> 32) + l21 * l6) >>> 32) + l21 * l2) >>> 32) + l21 * l9) >>> 32) + l21 * l12) >>> 32) + l21 * l15) >>> 32) + l21 * l18) >>> 32;
        n5 = (int)l14;
        zz[zzOff + 8] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l16;
        zz[zzOff + 9] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l17;
        zz[zzOff + 10] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l19;
        zz[zzOff + 11] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l20;
        zz[zzOff + 12] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l22;
        zz[zzOff + 13] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l23;
        zz[zzOff + 14] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = zz[zzOff + 15] + (int)(l23 >>> 32);
        zz[zzOff + 15] = n5 << 1 | n2;
    }

    public static int sub(int[] x2, int[] y2, int[] z2) {
        long l2 = 0L;
        z2[0] = (int)(l2 += ((long)x2[0] & 0xFFFFFFFFL) - ((long)y2[0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[1] = (int)(l2 += ((long)x2[1] & 0xFFFFFFFFL) - ((long)y2[1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[2] = (int)(l2 += ((long)x2[2] & 0xFFFFFFFFL) - ((long)y2[2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[3] = (int)(l2 += ((long)x2[3] & 0xFFFFFFFFL) - ((long)y2[3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[4] = (int)(l2 += ((long)x2[4] & 0xFFFFFFFFL) - ((long)y2[4] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[5] = (int)(l2 += ((long)x2[5] & 0xFFFFFFFFL) - ((long)y2[5] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[6] = (int)(l2 += ((long)x2[6] & 0xFFFFFFFFL) - ((long)y2[6] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[7] = (int)(l2 += ((long)x2[7] & 0xFFFFFFFFL) - ((long)y2[7] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int sub(int[] x2, int xOff, int[] y2, int yOff, int[] z2, int zOff) {
        long l2 = 0L;
        z2[zOff + 0] = (int)(l2 += ((long)x2[xOff + 0] & 0xFFFFFFFFL) - ((long)y2[yOff + 0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 1] = (int)(l2 += ((long)x2[xOff + 1] & 0xFFFFFFFFL) - ((long)y2[yOff + 1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 2] = (int)(l2 += ((long)x2[xOff + 2] & 0xFFFFFFFFL) - ((long)y2[yOff + 2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 3] = (int)(l2 += ((long)x2[xOff + 3] & 0xFFFFFFFFL) - ((long)y2[yOff + 3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 4] = (int)(l2 += ((long)x2[xOff + 4] & 0xFFFFFFFFL) - ((long)y2[yOff + 4] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 5] = (int)(l2 += ((long)x2[xOff + 5] & 0xFFFFFFFFL) - ((long)y2[yOff + 5] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 6] = (int)(l2 += ((long)x2[xOff + 6] & 0xFFFFFFFFL) - ((long)y2[yOff + 6] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 7] = (int)(l2 += ((long)x2[xOff + 7] & 0xFFFFFFFFL) - ((long)y2[yOff + 7] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int subBothFrom(int[] x2, int[] y2, int[] z2) {
        long l2 = 0L;
        z2[0] = (int)(l2 += ((long)z2[0] & 0xFFFFFFFFL) - ((long)x2[0] & 0xFFFFFFFFL) - ((long)y2[0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[1] = (int)(l2 += ((long)z2[1] & 0xFFFFFFFFL) - ((long)x2[1] & 0xFFFFFFFFL) - ((long)y2[1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[2] = (int)(l2 += ((long)z2[2] & 0xFFFFFFFFL) - ((long)x2[2] & 0xFFFFFFFFL) - ((long)y2[2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[3] = (int)(l2 += ((long)z2[3] & 0xFFFFFFFFL) - ((long)x2[3] & 0xFFFFFFFFL) - ((long)y2[3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[4] = (int)(l2 += ((long)z2[4] & 0xFFFFFFFFL) - ((long)x2[4] & 0xFFFFFFFFL) - ((long)y2[4] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[5] = (int)(l2 += ((long)z2[5] & 0xFFFFFFFFL) - ((long)x2[5] & 0xFFFFFFFFL) - ((long)y2[5] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[6] = (int)(l2 += ((long)z2[6] & 0xFFFFFFFFL) - ((long)x2[6] & 0xFFFFFFFFL) - ((long)y2[6] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[7] = (int)(l2 += ((long)z2[7] & 0xFFFFFFFFL) - ((long)x2[7] & 0xFFFFFFFFL) - ((long)y2[7] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int subFrom(int[] x2, int[] z2) {
        long l2 = 0L;
        z2[0] = (int)(l2 += ((long)z2[0] & 0xFFFFFFFFL) - ((long)x2[0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[1] = (int)(l2 += ((long)z2[1] & 0xFFFFFFFFL) - ((long)x2[1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[2] = (int)(l2 += ((long)z2[2] & 0xFFFFFFFFL) - ((long)x2[2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[3] = (int)(l2 += ((long)z2[3] & 0xFFFFFFFFL) - ((long)x2[3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[4] = (int)(l2 += ((long)z2[4] & 0xFFFFFFFFL) - ((long)x2[4] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[5] = (int)(l2 += ((long)z2[5] & 0xFFFFFFFFL) - ((long)x2[5] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[6] = (int)(l2 += ((long)z2[6] & 0xFFFFFFFFL) - ((long)x2[6] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[7] = (int)(l2 += ((long)z2[7] & 0xFFFFFFFFL) - ((long)x2[7] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int subFrom(int[] x2, int xOff, int[] z2, int zOff) {
        long l2 = 0L;
        z2[zOff + 0] = (int)(l2 += ((long)z2[zOff + 0] & 0xFFFFFFFFL) - ((long)x2[xOff + 0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 1] = (int)(l2 += ((long)z2[zOff + 1] & 0xFFFFFFFFL) - ((long)x2[xOff + 1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 2] = (int)(l2 += ((long)z2[zOff + 2] & 0xFFFFFFFFL) - ((long)x2[xOff + 2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 3] = (int)(l2 += ((long)z2[zOff + 3] & 0xFFFFFFFFL) - ((long)x2[xOff + 3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 4] = (int)(l2 += ((long)z2[zOff + 4] & 0xFFFFFFFFL) - ((long)x2[xOff + 4] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 5] = (int)(l2 += ((long)z2[zOff + 5] & 0xFFFFFFFFL) - ((long)x2[xOff + 5] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 6] = (int)(l2 += ((long)z2[zOff + 6] & 0xFFFFFFFFL) - ((long)x2[xOff + 6] & 0xFFFFFFFFL));
        l2 >>= 32;
        z2[zOff + 7] = (int)(l2 += ((long)z2[zOff + 7] & 0xFFFFFFFFL) - ((long)x2[xOff + 7] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static BigInteger toBigInteger(int[] x2) {
        byte[] byArray = new byte[32];
        for (int i2 = 0; i2 < 8; ++i2) {
            int n2 = x2[i2];
            if (n2 == 0) continue;
            Pack.intToBigEndian(n2, byArray, 7 - i2 << 2);
        }
        return new BigInteger(1, byArray);
    }

    public static BigInteger toBigInteger64(long[] x2) {
        byte[] byArray = new byte[32];
        for (int i2 = 0; i2 < 4; ++i2) {
            long l2 = x2[i2];
            if (l2 == 0L) continue;
            Pack.longToBigEndian(l2, byArray, 3 - i2 << 3);
        }
        return new BigInteger(1, byArray);
    }

    public static void zero(int[] z2) {
        z2[0] = 0;
        z2[1] = 0;
        z2[2] = 0;
        z2[3] = 0;
        z2[4] = 0;
        z2[5] = 0;
        z2[6] = 0;
        z2[7] = 0;
    }
}

