/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.raw;

import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;

public abstract class Nat576 {
    public static void copy64(long[] x2, long[] z2) {
        z2[0] = x2[0];
        z2[1] = x2[1];
        z2[2] = x2[2];
        z2[3] = x2[3];
        z2[4] = x2[4];
        z2[5] = x2[5];
        z2[6] = x2[6];
        z2[7] = x2[7];
        z2[8] = x2[8];
    }

    public static void copy64(long[] x2, int xOff, long[] z2, int zOff) {
        z2[zOff + 0] = x2[xOff + 0];
        z2[zOff + 1] = x2[xOff + 1];
        z2[zOff + 2] = x2[xOff + 2];
        z2[zOff + 3] = x2[xOff + 3];
        z2[zOff + 4] = x2[xOff + 4];
        z2[zOff + 5] = x2[xOff + 5];
        z2[zOff + 6] = x2[xOff + 6];
        z2[zOff + 7] = x2[xOff + 7];
        z2[zOff + 8] = x2[xOff + 8];
    }

    public static long[] create64() {
        return new long[9];
    }

    public static long[] createExt64() {
        return new long[18];
    }

    public static boolean eq64(long[] x2, long[] y2) {
        for (int i2 = 8; i2 >= 0; --i2) {
            if (x2[i2] == y2[i2]) continue;
            return false;
        }
        return true;
    }

    public static long[] fromBigInteger64(BigInteger x2) {
        if (x2.signum() < 0 || x2.bitLength() > 576) {
            throw new IllegalArgumentException();
        }
        long[] lArray = Nat576.create64();
        int n2 = 0;
        while (x2.signum() != 0) {
            lArray[n2++] = x2.longValue();
            x2 = x2.shiftRight(64);
        }
        return lArray;
    }

    public static boolean isOne64(long[] x2) {
        if (x2[0] != 1L) {
            return false;
        }
        for (int i2 = 1; i2 < 9; ++i2) {
            if (x2[i2] == 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero64(long[] x2) {
        for (int i2 = 0; i2 < 9; ++i2) {
            if (x2[i2] == 0L) continue;
            return false;
        }
        return true;
    }

    public static BigInteger toBigInteger64(long[] x2) {
        byte[] byArray = new byte[72];
        for (int i2 = 0; i2 < 9; ++i2) {
            long l2 = x2[i2];
            if (l2 == 0L) continue;
            Pack.longToBigEndian(l2, byArray, 8 - i2 << 3);
        }
        return new BigInteger(1, byArray);
    }
}

