/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.math.BigInteger;

public class McEliecePrivateKey
extends ASN1Object {
    private int a;
    private int b;
    private byte[] c;
    private byte[] d;
    private byte[] e;
    private byte[] f;
    private byte[] g;

    public McEliecePrivateKey(int n2, int k2, GF2mField field, PolynomialGF2mSmallM goppaPoly, Permutation p1, Permutation p2, GF2Matrix sInv) {
        this.a = n2;
        this.b = k2;
        this.c = field.getEncoded();
        this.d = goppaPoly.getEncoded();
        this.e = sInv.getEncoded();
        this.f = p1.getEncoded();
        this.g = p2.getEncoded();
    }

    public static McEliecePrivateKey getInstance(Object o2) {
        if (o2 instanceof McEliecePrivateKey) {
            return (McEliecePrivateKey)o2;
        }
        if (o2 != null) {
            return new McEliecePrivateKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private McEliecePrivateKey(ASN1Sequence seq) {
        BigInteger bigInteger = ((ASN1Integer)seq.getObjectAt(0)).getValue();
        this.a = bigInteger.intValue();
        BigInteger bigInteger2 = ((ASN1Integer)seq.getObjectAt(1)).getValue();
        this.b = bigInteger2.intValue();
        this.c = ((ASN1OctetString)seq.getObjectAt(2)).getOctets();
        this.d = ((ASN1OctetString)seq.getObjectAt(3)).getOctets();
        this.f = ((ASN1OctetString)seq.getObjectAt(4)).getOctets();
        this.g = ((ASN1OctetString)seq.getObjectAt(5)).getOctets();
        this.e = ((ASN1OctetString)seq.getObjectAt(6)).getOctets();
    }

    public int getN() {
        return this.a;
    }

    public int getK() {
        return this.b;
    }

    public GF2mField getField() {
        return new GF2mField(this.c);
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return new PolynomialGF2mSmallM(this.getField(), this.d);
    }

    public GF2Matrix getSInv() {
        return new GF2Matrix(this.e);
    }

    public Permutation getP1() {
        return new Permutation(this.f);
    }

    public Permutation getP2() {
        return new Permutation(this.g);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(new ASN1Integer(this.b));
        aSN1EncodableVector.add(new DEROctetString(this.c));
        aSN1EncodableVector.add(new DEROctetString(this.d));
        aSN1EncodableVector.add(new DEROctetString(this.f));
        aSN1EncodableVector.add(new DEROctetString(this.g));
        aSN1EncodableVector.add(new DEROctetString(this.e));
        return new DERSequence(aSN1EncodableVector);
    }
}

