/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import java.math.BigInteger;

public class McEliecePublicKey
extends ASN1Object {
    private final int a;
    private final int b;
    private final GF2Matrix c;

    public McEliecePublicKey(int n2, int t2, GF2Matrix g2) {
        this.a = n2;
        this.b = t2;
        this.c = new GF2Matrix(g2);
    }

    private McEliecePublicKey(ASN1Sequence seq) {
        BigInteger bigInteger = ((ASN1Integer)seq.getObjectAt(0)).getValue();
        this.a = bigInteger.intValue();
        BigInteger bigInteger2 = ((ASN1Integer)seq.getObjectAt(1)).getValue();
        this.b = bigInteger2.intValue();
        this.c = new GF2Matrix(((ASN1OctetString)seq.getObjectAt(2)).getOctets());
    }

    public int getN() {
        return this.a;
    }

    public int getT() {
        return this.b;
    }

    public GF2Matrix getG() {
        return new GF2Matrix(this.c);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(new ASN1Integer(this.b));
        aSN1EncodableVector.add(new DEROctetString(this.c.getEncoded()));
        return new DERSequence(aSN1EncodableVector);
    }

    public static McEliecePublicKey getInstance(Object o2) {
        if (o2 instanceof McEliecePublicKey) {
            return (McEliecePublicKey)o2;
        }
        if (o2 != null) {
            return new McEliecePublicKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }
}

