/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.pqc.crypto.rainbow.util.RainbowUtil;

public class RainbowPublicKey
extends ASN1Object {
    private ASN1Integer a;
    private ASN1ObjectIdentifier b;
    private ASN1Integer c;
    private byte[][] d;
    private byte[][] e;
    private byte[] f;

    private RainbowPublicKey(ASN1Sequence seq) {
        if (seq.getObjectAt(0) instanceof ASN1Integer) {
            this.a = ASN1Integer.getInstance(seq.getObjectAt(0));
        } else {
            this.b = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0));
        }
        this.c = ASN1Integer.getInstance(seq.getObjectAt(1));
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(seq.getObjectAt(2));
        this.d = new byte[aSN1Sequence.size()][];
        for (int i2 = 0; i2 < aSN1Sequence.size(); ++i2) {
            this.d[i2] = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(i2)).getOctets();
        }
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)seq.getObjectAt(3);
        this.e = new byte[aSN1Sequence2.size()][];
        for (int i3 = 0; i3 < aSN1Sequence2.size(); ++i3) {
            this.e[i3] = ASN1OctetString.getInstance(aSN1Sequence2.getObjectAt(i3)).getOctets();
        }
        ASN1Sequence aSN1Sequence3 = (ASN1Sequence)seq.getObjectAt(4);
        this.f = ASN1OctetString.getInstance(aSN1Sequence3.getObjectAt(0)).getOctets();
    }

    public RainbowPublicKey(int docLength, short[][] coeffQuadratic, short[][] coeffSingular, short[] coeffScalar) {
        this.a = new ASN1Integer(0L);
        this.c = new ASN1Integer(docLength);
        this.d = RainbowUtil.convertArray(coeffQuadratic);
        this.e = RainbowUtil.convertArray(coeffSingular);
        this.f = RainbowUtil.convertArray(coeffScalar);
    }

    public static RainbowPublicKey getInstance(Object o2) {
        if (o2 instanceof RainbowPublicKey) {
            return (RainbowPublicKey)o2;
        }
        if (o2 != null) {
            return new RainbowPublicKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public int getDocLength() {
        return this.c.getValue().intValue();
    }

    public short[][] getCoeffQuadratic() {
        return RainbowUtil.convertArray(this.d);
    }

    public short[][] getCoeffSingular() {
        return RainbowUtil.convertArray(this.e);
    }

    public short[] getCoeffScalar() {
        return RainbowUtil.convertArray(this.f);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(this.a);
        } else {
            aSN1EncodableVector.add(this.b);
        }
        aSN1EncodableVector.add(this.c);
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            aSN1EncodableVector2.add(new DEROctetString(this.d[i2]));
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        ASN1EncodableVector aSN1EncodableVector3 = new ASN1EncodableVector();
        for (int i3 = 0; i3 < this.e.length; ++i3) {
            aSN1EncodableVector3.add(new DEROctetString(this.e[i3]));
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector3));
        ASN1EncodableVector aSN1EncodableVector4 = new ASN1EncodableVector();
        aSN1EncodableVector4.add(new DEROctetString(this.f));
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector4));
        return new DERSequence(aSN1EncodableVector);
    }
}

