/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class XMSSKeyParams
extends ASN1Object {
    private final ASN1Integer a;
    private final int b;
    private final AlgorithmIdentifier c;

    public XMSSKeyParams(int height, AlgorithmIdentifier treeDigest) {
        this.a = new ASN1Integer(0L);
        this.b = height;
        this.c = treeDigest;
    }

    private XMSSKeyParams(ASN1Sequence sequence) {
        this.a = ASN1Integer.getInstance(sequence.getObjectAt(0));
        this.b = ASN1Integer.getInstance(sequence.getObjectAt(1)).getValue().intValue();
        this.c = AlgorithmIdentifier.getInstance(sequence.getObjectAt(2));
    }

    public static XMSSKeyParams getInstance(Object o2) {
        if (o2 instanceof XMSSKeyParams) {
            return (XMSSKeyParams)o2;
        }
        if (o2 != null) {
            return new XMSSKeyParams(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public int getHeight() {
        return this.b;
    }

    public AlgorithmIdentifier getTreeDigest() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(new ASN1Integer(this.b));
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }
}

