/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class XMSSMTPrivateKey
extends ASN1Object {
    private final int a;
    private final byte[] b;
    private final byte[] c;
    private final byte[] d;
    private final byte[] e;
    private final byte[] f;

    public XMSSMTPrivateKey(int index, byte[] secretKeySeed, byte[] secretKeyPRF, byte[] publicSeed, byte[] root, byte[] bdsState) {
        this.a = index;
        this.b = Arrays.clone(secretKeySeed);
        this.c = Arrays.clone(secretKeyPRF);
        this.d = Arrays.clone(publicSeed);
        this.e = Arrays.clone(root);
        this.f = Arrays.clone(bdsState);
    }

    private XMSSMTPrivateKey(ASN1Sequence seq) {
        if (!ASN1Integer.getInstance(seq.getObjectAt(0)).getValue().equals(BigInteger.valueOf(0L))) {
            throw new IllegalArgumentException("unknown version of sequence");
        }
        if (seq.size() != 2 && seq.size() != 3) {
            throw new IllegalArgumentException("key sequence wrong size");
        }
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(seq.getObjectAt(1));
        this.a = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).getValue().intValue();
        this.b = Arrays.clone(DEROctetString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets());
        this.c = Arrays.clone(DEROctetString.getInstance(aSN1Sequence.getObjectAt(2)).getOctets());
        this.d = Arrays.clone(DEROctetString.getInstance(aSN1Sequence.getObjectAt(3)).getOctets());
        this.e = Arrays.clone(DEROctetString.getInstance(aSN1Sequence.getObjectAt(4)).getOctets());
        this.f = (byte[])(seq.size() == 3 ? Arrays.clone(DEROctetString.getInstance(ASN1TaggedObject.getInstance(seq.getObjectAt(2)), true).getOctets()) : null);
    }

    public static XMSSMTPrivateKey getInstance(Object o2) {
        if (o2 instanceof XMSSMTPrivateKey) {
            return (XMSSMTPrivateKey)o2;
        }
        if (o2 != null) {
            return new XMSSMTPrivateKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public int getIndex() {
        return this.a;
    }

    public byte[] getSecretKeySeed() {
        return Arrays.clone(this.b);
    }

    public byte[] getSecretKeyPRF() {
        return Arrays.clone(this.c);
    }

    public byte[] getPublicSeed() {
        return Arrays.clone(this.d);
    }

    public byte[] getRoot() {
        return Arrays.clone(this.e);
    }

    public byte[] getBdsState() {
        return Arrays.clone(this.f);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(0L));
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(new ASN1Integer(this.a));
        aSN1EncodableVector2.add(new DEROctetString(this.b));
        aSN1EncodableVector2.add(new DEROctetString(this.c));
        aSN1EncodableVector2.add(new DEROctetString(this.d));
        aSN1EncodableVector2.add(new DEROctetString(this.e));
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        aSN1EncodableVector.add(new DERTaggedObject(true, 0, new DEROctetString(this.f)));
        return new DERSequence(aSN1EncodableVector);
    }
}

