/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.gmss;

import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.enterprisedt.bouncycastle.util.encoders.Hex;

public class GMSSRootSig {
    private Digest a;
    private int b;
    private int c;
    private byte[] d;
    private byte[] e;
    private byte[] f;
    private int g;
    private GMSSRandom h;
    private int i;
    private int j;
    private int k;
    private int l;
    private int m;
    private int n;
    private long o;
    private long p;
    private int q;
    private int r;
    private int s;
    private byte[] t;

    public GMSSRootSig(Digest digest, byte[][] statByte, int[] statInt) {
        this.a = digest;
        this.h = new GMSSRandom(this.a);
        this.m = statInt[0];
        this.l = statInt[1];
        this.n = statInt[2];
        this.k = statInt[3];
        this.q = statInt[4];
        this.c = statInt[5];
        this.s = statInt[6];
        this.g = statInt[7];
        this.r = statInt[8];
        this.b = this.a.getDigestSize();
        this.j = (1 << this.g) - 1;
        int n2 = this.b << 3;
        this.i = (int)Math.ceil((double)n2 / (double)this.g);
        this.d = statByte[0];
        this.t = statByte[1];
        this.e = statByte[2];
        this.f = statByte[3];
        this.o = (long)(statByte[4][0] & 0xFF) | (long)(statByte[4][1] & 0xFF) << 8 | (long)(statByte[4][2] & 0xFF) << 16 | (long)(statByte[4][3] & 0xFF) << 24 | (long)(statByte[4][4] & 0xFF) << 32 | (long)(statByte[4][5] & 0xFF) << 40 | (long)(statByte[4][6] & 0xFF) << 48 | (long)(statByte[4][7] & 0xFF) << 56;
        this.p = (long)(statByte[4][8] & 0xFF) | (long)(statByte[4][9] & 0xFF) << 8 | (long)(statByte[4][10] & 0xFF) << 16 | (long)(statByte[4][11] & 0xFF) << 24 | (long)(statByte[4][12] & 0xFF) << 32 | (long)(statByte[4][13] & 0xFF) << 40 | (long)(statByte[4][14] & 0xFF) << 48 | (long)(statByte[4][15] & 0xFF) << 56;
    }

    public GMSSRootSig(Digest digest, int w2, int height) {
        this.a = digest;
        this.h = new GMSSRandom(this.a);
        this.b = this.a.getDigestSize();
        this.g = w2;
        this.s = height;
        this.j = (1 << w2) - 1;
        int n2 = this.b << 3;
        this.i = (int)Math.ceil((double)n2 / (double)w2);
    }

    public void initSign(byte[] seed0, byte[] message) {
        this.e = new byte[this.b];
        this.a.update(message, 0, message.length);
        this.e = new byte[this.a.getDigestSize()];
        this.a.doFinal(this.e, 0);
        byte[] byArray = new byte[this.b];
        System.arraycopy(this.e, 0, byArray, 0, this.b);
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getLog((this.i << this.g) + 1);
        if (8 % this.g == 0) {
            int n5;
            int n6 = 8 / this.g;
            for (n5 = 0; n5 < this.b; ++n5) {
                for (int i2 = 0; i2 < n6; ++i2) {
                    n3 += byArray[n5] & this.j;
                    byArray[n5] = (byte)(byArray[n5] >>> this.g);
                }
            }
            n2 = this.r = (this.i << this.g) - n3;
            for (n5 = 0; n5 < n4; n5 += this.g) {
                n3 += n2 & this.j;
                n2 >>>= this.g;
            }
        } else if (this.g < 8) {
            long l2;
            int n7;
            int n8 = 0;
            int n9 = this.b / this.g;
            for (n7 = 0; n7 < n9; ++n7) {
                int n10;
                l2 = 0L;
                for (n10 = 0; n10 < this.g; ++n10) {
                    l2 ^= (long)((byArray[n8] & 0xFF) << (n10 << 3));
                    ++n8;
                }
                for (n10 = 0; n10 < 8; ++n10) {
                    n3 += (int)(l2 & (long)this.j);
                    l2 >>>= this.g;
                }
            }
            n9 = this.b % this.g;
            l2 = 0L;
            for (n7 = 0; n7 < n9; ++n7) {
                l2 ^= (long)((byArray[n8] & 0xFF) << (n7 << 3));
                ++n8;
            }
            n9 <<= 3;
            for (n7 = 0; n7 < n9; n7 += this.g) {
                n3 += (int)(l2 & (long)this.j);
                l2 >>>= this.g;
            }
            n2 = this.r = (this.i << this.g) - n3;
            for (n7 = 0; n7 < n4; n7 += this.g) {
                n3 += n2 & this.j;
                n2 >>>= this.g;
            }
        } else if (this.g < 57) {
            int n11;
            int n12;
            long l3;
            int n13;
            int n14;
            int n15 = 0;
            while (n15 <= (this.b << 3) - this.g) {
                n14 = n15 >>> 3;
                n13 = n15 % 8;
                int n16 = (n15 += this.g) + 7 >>> 3;
                l3 = 0L;
                n12 = 0;
                for (n11 = n14; n11 < n16; ++n11) {
                    l3 ^= (long)((byArray[n11] & 0xFF) << (n12 << 3));
                    ++n12;
                }
                n3 = (int)((long)n3 + ((l3 >>>= n13) & (long)this.j));
            }
            n14 = n15 >>> 3;
            if (n14 < this.b) {
                n13 = n15 % 8;
                l3 = 0L;
                n12 = 0;
                for (n11 = n14; n11 < this.b; ++n11) {
                    l3 ^= (long)((byArray[n11] & 0xFF) << (n12 << 3));
                    ++n12;
                }
                n3 = (int)((long)n3 + ((l3 >>>= n13) & (long)this.j));
            }
            n2 = this.r = (this.i << this.g) - n3;
            for (n11 = 0; n11 < n4; n11 += this.g) {
                n3 += n2 & this.j;
                n2 >>>= this.g;
            }
        }
        this.c = this.i + (int)Math.ceil((double)n4 / (double)this.g);
        this.q = (int)Math.ceil((double)(this.c + n3) / (double)(1 << this.s));
        this.f = new byte[this.c * this.b];
        this.m = 0;
        this.l = 0;
        this.n = 0;
        this.o = 0L;
        this.k = 0;
        this.d = new byte[this.b];
        this.t = new byte[this.b];
        System.arraycopy(seed0, 0, this.t, 0, this.b);
    }

    public boolean updateSign() {
        for (int i2 = 0; i2 < this.q; ++i2) {
            if (this.m < this.c) {
                this.a();
            }
            if (this.m != this.c) continue;
            return true;
        }
        return false;
    }

    public byte[] getSig() {
        return this.f;
    }

    private void a() {
        if (8 % this.g == 0) {
            if (this.l == 0) {
                this.d = this.h.nextSeed(this.t);
                if (this.n < this.b) {
                    this.l = this.e[this.n] & this.j;
                    this.e[this.n] = (byte)(this.e[this.n] >>> this.g);
                } else {
                    this.l = this.r & this.j;
                    this.r >>>= this.g;
                }
            } else if (this.l > 0) {
                this.a.update(this.d, 0, this.d.length);
                this.d = new byte[this.a.getDigestSize()];
                this.a.doFinal(this.d, 0);
                --this.l;
            }
            if (this.l == 0) {
                System.arraycopy(this.d, 0, this.f, this.m * this.b, this.b);
                ++this.m;
                if (this.m % (8 / this.g) == 0) {
                    ++this.n;
                }
            }
        } else if (this.g < 8) {
            if (this.l == 0) {
                if (this.m % 8 == 0 && this.n < this.b) {
                    this.p = 0L;
                    if (this.m < this.b / this.g << 3) {
                        for (int i2 = 0; i2 < this.g; ++i2) {
                            this.p ^= (long)((this.e[this.n] & 0xFF) << (i2 << 3));
                            ++this.n;
                        }
                    } else {
                        for (int i3 = 0; i3 < this.b % this.g; ++i3) {
                            this.p ^= (long)((this.e[this.n] & 0xFF) << (i3 << 3));
                            ++this.n;
                        }
                    }
                }
                if (this.m == this.i) {
                    this.p = this.r;
                }
                this.l = (int)(this.p & (long)this.j);
                this.d = this.h.nextSeed(this.t);
            } else if (this.l > 0) {
                this.a.update(this.d, 0, this.d.length);
                this.d = new byte[this.a.getDigestSize()];
                this.a.doFinal(this.d, 0);
                --this.l;
            }
            if (this.l == 0) {
                System.arraycopy(this.d, 0, this.f, this.m * this.b, this.b);
                this.p >>>= this.g;
                ++this.m;
            }
        } else if (this.g < 57) {
            if (this.o == 0L) {
                this.p = 0L;
                this.n = 0;
                int n2 = this.k % 8;
                int n3 = this.k >>> 3;
                if (n3 < this.b) {
                    int n4;
                    if (this.k <= (this.b << 3) - this.g) {
                        this.k += this.g;
                        n4 = this.k + 7 >>> 3;
                    } else {
                        n4 = this.b;
                        this.k += this.g;
                    }
                    for (int i4 = n3; i4 < n4; ++i4) {
                        this.p ^= (long)((this.e[i4] & 0xFF) << (this.n << 3));
                        ++this.n;
                    }
                    this.p >>>= n2;
                    this.o = this.p & (long)this.j;
                } else {
                    this.o = this.r & this.j;
                    this.r >>>= this.g;
                }
                this.d = this.h.nextSeed(this.t);
            } else if (this.o > 0L) {
                this.a.update(this.d, 0, this.d.length);
                this.d = new byte[this.a.getDigestSize()];
                this.a.doFinal(this.d, 0);
                --this.o;
            }
            if (this.o == 0L) {
                System.arraycopy(this.d, 0, this.f, this.m * this.b, this.b);
                ++this.m;
            }
        }
    }

    public int getLog(int intValue) {
        int n2 = 1;
        int n3 = 2;
        while (n3 < intValue) {
            n3 <<= 1;
            ++n2;
        }
        return n2;
    }

    public byte[][] getStatByte() {
        byte[][] byArray = new byte[5][this.b];
        byArray[0] = this.d;
        byArray[1] = this.t;
        byArray[2] = this.e;
        byArray[3] = this.f;
        byArray[4] = this.getStatLong();
        return byArray;
    }

    public int[] getStatInt() {
        int[] nArray = new int[]{this.m, this.l, this.n, this.k, this.q, this.c, this.s, this.g, this.r};
        return nArray;
    }

    public byte[] getStatLong() {
        byte[] byArray = new byte[]{(byte)(this.o & 0xFFL), (byte)(this.o >> 8 & 0xFFL), (byte)(this.o >> 16 & 0xFFL), (byte)(this.o >> 24 & 0xFFL), (byte)(this.o >> 32 & 0xFFL), (byte)(this.o >> 40 & 0xFFL), (byte)(this.o >> 48 & 0xFFL), (byte)(this.o >> 56 & 0xFFL), (byte)(this.p & 0xFFL), (byte)(this.p >> 8 & 0xFFL), (byte)(this.p >> 16 & 0xFFL), (byte)(this.p >> 24 & 0xFFL), (byte)(this.p >> 32 & 0xFFL), (byte)(this.p >> 40 & 0xFFL), (byte)(this.p >> 48 & 0xFFL), (byte)(this.p >> 56 & 0xFFL)};
        return byArray;
    }

    public String toString() {
        int n2;
        String string = "" + this.p + "  ";
        int[] nArray = new int[9];
        nArray = this.getStatInt();
        byte[][] byArray = new byte[5][this.b];
        byArray = this.getStatByte();
        for (n2 = 0; n2 < 9; ++n2) {
            string = string + nArray[n2] + " ";
        }
        for (n2 = 0; n2 < 5; ++n2) {
            string = string + new String(Hex.encode(byArray[n2])) + " ";
        }
        return string;
    }
}

